/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.qnixyz.jbson.JaxBsonException;
import org.qnixyz.jbson.annotations.JaxBsonIgnoreTransient;
import org.qnixyz.jbson.annotations.JaxBsonName;
import org.qnixyz.jbson.annotations.JaxBsonTransient;
import org.qnixyz.jbson.annotations.JaxBsonXmlAnyAttributeMapping;
import org.qnixyz.jbson.annotations.JaxBsonXmlAnyAttributeMappings;
import org.qnixyz.jbson.impl.FieldSubDescriptor;
import org.qnixyz.jbson.impl.JaxBsonContextImpl;
import org.qnixyz.jbson.impl.NamespaceMap;
import org.qnixyz.jbson.impl.Utils;
import org.qnixyz.jbson.impl.ValueContainerType;

class FieldDescriptor {
    private final SortedMap<String, FieldSubDescriptor> bsonFieldNameMap = new TreeMap<String, FieldSubDescriptor>();
    private final Map<Class<?>, FieldSubDescriptor> bsonFieldTypeMap = new HashMap();
    private final Constructor<Collection<Object>> collectionConstructor;
    private final JaxBsonContextImpl ctx;
    private Field field;
    private boolean ignore;
    private JaxBsonName jaxBsonName;
    private final Class<?> mainType;
    private boolean multiBsonFieldNames;
    private NamespaceMap namespaceMap;
    private boolean oneMainType;
    private final Set<Class<?>> referredTypes = new HashSet();
    private ValueContainerType valueContainerType;
    private XmlAnyAttribute xmlAnyAttribute;
    private JaxBsonXmlAnyAttributeMapping xmlAnyAttributeMapping;
    private JaxBsonXmlAnyAttributeMappings xmlAnyAttributeMappings;
    private XmlAnyElement xmlAnyElement;
    private XmlAttribute xmlAttribute;
    private XmlElement xmlElement;
    private XmlElementRef xmlElementRef;
    private XmlElementRefs xmlElementRefs;
    private XmlElements xmlElements;
    private XmlElementWrapper xmlElementWrapper;
    private XmlJavaTypeAdapter xmlJavaTypeAdapter;
    private XmlValue xmlValue;

    protected FieldDescriptor(JaxBsonContextImpl ctx, Field field) {
        this.ctx = Objects.requireNonNull(ctx, "Supplied parameter 'ctx' is null");
        this.field = Objects.requireNonNull(field, "Supplied parameter 'field' is null");
        this.field.setAccessible(true);
        this.checkAnnotations();
        this.setIgnore();
        if (this.ignore) {
            this.mainType = null;
            this.collectionConstructor = null;
            return;
        }
        this.setXmlAnnotations();
        this.checkXmlAnnotations();
        this.setValueContainerType();
        this.setOneMainType();
        this.mainType = this.makeMainType();
        this.setMultiBsonFieldNames();
        if (this.xmlAnyAttribute != null) {
            this.checkXmlAnyAttributeField();
            this.analyzeXmlAnyAttribute();
        } else if (this.multiBsonFieldNames) {
            this.analyzeMultiBsonFieldNames();
        } else {
            this.analyzeSingleBsonFieldName();
        }
        this.collectionConstructor = this.makeCollectionConstructor();
    }

    public String toString() {
        return this.field.getDeclaringClass().getName() + "." + this.field.getName();
    }

    private void addFieldSubDescriptor(FieldSubDescriptor fds) {
        this.checkDuplicateNames(fds);
        this.bsonFieldNameMap.put(fds.getName(), fds);
        this.bsonFieldTypeMap.put(fds.getMainType(), fds);
        this.referredTypes.addAll(fds.getReferredTypes());
    }

    private void analyzeMultiBsonFieldNames() {
        if (this.xmlElements != null) {
            this.analyzeMultiBsonFieldNamesXmlElements();
            return;
        }
        if (this.xmlElementRefs != null) {
            this.analyzeMultiBsonFieldNamesXmlElementRefs();
            return;
        }
        throw new UnsupportedOperationException("This is a bug");
    }

    private void analyzeMultiBsonFieldNamesXmlElementRefs() {
        for (XmlElementRef xer : this.xmlElementRefs.value()) {
            String name = this.makeName(xer);
            this.addFieldSubDescriptor(new FieldSubDescriptor(this.ctx, this, name, this.valueContainerType, xer.type(), null));
        }
    }

    private void analyzeMultiBsonFieldNamesXmlElements() {
        for (XmlElement xe : this.xmlElements.value()) {
            String name = this.makeName(xe);
            this.addFieldSubDescriptor(new FieldSubDescriptor(this.ctx, this, name, this.valueContainerType, xe.type(), null));
        }
    }

    private void analyzeSingleBsonFieldName() {
        String name = this.makeSingleName();
        if (this.xmlJavaTypeAdapter == null) {
            this.addFieldSubDescriptor(new FieldSubDescriptor(this.ctx, this, name, this.valueContainerType, this.mainType, null));
        } else {
            Class xmlAdapterClass = this.xmlJavaTypeAdapter.value();
            this.addFieldSubDescriptor(new FieldSubDescriptor(this.ctx, this, name, this.valueContainerType, this.mainType, xmlAdapterClass));
        }
    }

    private void analyzeXmlAnyAttribute() {
        this.namespaceMap = this.xmlAnyAttributeMapping != null ? new NamespaceMap(this, this.xmlAnyAttributeMapping) : (this.xmlAnyAttributeMappings != null ? new NamespaceMap(this, this.xmlAnyAttributeMappings) : new NamespaceMap(this));
    }

    private void checkAnnotations() {
        if (this.field.getAnnotation(JaxBsonTransient.class) != null && this.field.getAnnotation(JaxBsonIgnoreTransient.class) != null) {
            throw new IllegalStateException("Both annotations " + JaxBsonTransient.class.getName() + " and " + JaxBsonIgnoreTransient.class.getName() + " specified for field " + this.field);
        }
    }

    private void checkDuplicateNames(FieldSubDescriptor fds) {
        FieldSubDescriptor dup = (FieldSubDescriptor)this.bsonFieldNameMap.get(fds.getName());
        if (dup != null) {
            throw new IllegalStateException("Multiple fields of name '" + fds.getName() + "' in class " + this.field.getDeclaringClass().getName() + ". E.g. '" + dup + "' and '" + fds + "'");
        }
    }

    private void checkXmlAnnotations() {
        if (this.xmlAnyAttribute == null) {
            if (this.xmlAnyAttributeMapping != null) {
                throw new IllegalStateException("JaxBsonXmlAnyAttributeMapping annotation found in field " + this.field + " which hasn't got a XmlAnyAttribute annotation");
            }
            if (this.xmlAnyAttributeMappings != null) {
                throw new IllegalStateException("JaxBsonXmlAnyAttributeMappings annotation found in field " + this.field + " which hasn't got a XmlAnyAttribute annotation");
            }
        } else if (this.xmlAnyAttributeMapping != null && this.xmlAnyAttributeMappings != null) {
            throw new IllegalStateException("Both JaxBsonXmlAnyAttributeMappings and JaxBsonXmlAnyAttributeMappings annotations found in field " + this.field);
        }
        if (this.xmlAnyElement != null) {
            throw new IllegalStateException("XmlAnyElement annotation not supported. Found in field " + this.field);
        }
    }

    private void checkXmlAnyAttributeField() {
        if (this.field.getType().isArray()) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " is an array");
        }
        if (!Map.class.isAssignableFrom(this.field.getType())) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " is not of interface type " + Map.class.getName() + " but of type " + this.field.getType().getName());
        }
        if (!this.field.getType().isInterface() && !HashMap.class.isAssignableFrom(this.field.getType())) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " is neither of type " + Map.class.getName() + " nor of type " + HashMap.class.getName() + " but of type " + this.field.getType().getName());
        }
        Class<?> genericTypeKey = this.getGenericType(this.field.getGenericType(), 0);
        if (genericTypeKey == null) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " has no key-generic type");
        }
        if (!QName.class.isAssignableFrom(genericTypeKey)) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " has key-generic type of " + genericTypeKey.getName() + " instead of " + QName.class.getName());
        }
        Class<?> genericTypeValue = this.getGenericType(this.field.getGenericType(), 1);
        if (genericTypeValue == null) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " has no value-generic type");
        }
        if (!String.class.isAssignableFrom(genericTypeValue) && !genericTypeValue.equals(Object.class)) {
            throw new IllegalStateException("XmlAnyAttribute field " + this + " has value-generic type of " + genericTypeValue.getName() + " instead of " + String.class.getName() + " or " + Object.class.getName());
        }
    }

    private Class<?> getBoundTypeForXmlAdapterClass(Class<?> xmlAdapterClass) {
        try {
            Method method = xmlAdapterClass.getDeclaredMethod("marshal", this.field.getType());
            return method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("XML java type adapter class '" + xmlAdapterClass.getName() + "' doesn't have a 'marshal' method to convert '" + this.field.getType() + "', found in field " + this, e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Cannot access method 'marshal' through reflection for class '" + xmlAdapterClass.getName() + "' to convert '" + this + "'", e);
        }
    }

    private Class<?> getFieldMainType() {
        Class<?> type = this.field.getType();
        ValueContainerType vct = ValueContainerType.fromType(type);
        if (vct.isArray()) {
            return type.getComponentType();
        }
        if (vct.isCollection()) {
            return this.getGenericType(this.field.getGenericType(), 0);
        }
        return type;
    }

    private Class<?> getGenericType(Type genericFieldType, int i) {
        ParameterizedType aType;
        Type[] fieldArgTypes;
        if (genericFieldType instanceof ParameterizedType && (fieldArgTypes = (aType = (ParameterizedType)genericFieldType).getActualTypeArguments()).length > i) {
            return (Class)fieldArgTypes[i];
        }
        return null;
    }

    private Constructor<Collection<Object>> makeCollectionConstructor() {
        if (!this.valueContainerType.isCollection()) {
            return null;
        }
        if (this.field.getType().isInterface()) {
            return null;
        }
        try {
            Constructor<Collection<Object>> ret = this.field.getType().getDeclaredConstructor(new Class[0]);
            ret.setAccessible(true);
            return ret;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("No no-argument constructor for collection type " + this.field.getType().getName());
        }
    }

    private Class<?> makeMainType() {
        if (this.xmlAnyAttribute != null) {
            return null;
        }
        if (this.xmlJavaTypeAdapter == null) {
            return this.getFieldMainType();
        }
        Class xmlAdapterClass = this.xmlJavaTypeAdapter.value();
        return this.getBoundTypeForXmlAdapterClass(xmlAdapterClass);
    }

    private String makeName(XmlElement ann) {
        if (!StringUtils.isBlank((CharSequence)ann.name()) && !ann.name().equalsIgnoreCase("##default")) {
            return ann.name();
        }
        Class type = ann.type();
        XmlRootElement xre = type.getAnnotation(XmlRootElement.class);
        return this.makeName(xre, type);
    }

    private String makeName(XmlElementRef ann) {
        Class type = ann.type();
        XmlRootElement xre = type.getAnnotation(XmlRootElement.class);
        return this.makeName(xre, type);
    }

    private String makeName(XmlRootElement ann, Class<?> type) {
        if (ann == null || StringUtils.isBlank((CharSequence)ann.name()) || ann.name().equalsIgnoreCase("##default")) {
            return Utils.lcFirst(type.getSimpleName());
        }
        return ann.name();
    }

    private String makeSingleName() {
        if (this.jaxBsonName != null && !StringUtils.isBlank((CharSequence)this.jaxBsonName.name()) && !this.jaxBsonName.name().equalsIgnoreCase("##default")) {
            return this.jaxBsonName.name();
        }
        if (this.xmlElementWrapper != null && !StringUtils.isBlank((CharSequence)this.xmlElementWrapper.name()) && !this.xmlElementWrapper.name().equalsIgnoreCase("##default")) {
            return this.xmlElementWrapper.name();
        }
        if (this.xmlElement != null && !StringUtils.isBlank((CharSequence)this.xmlElement.name()) && !this.xmlElement.name().equalsIgnoreCase("##default")) {
            return this.xmlElement.name();
        }
        if (this.xmlElementRef != null) {
            return this.makeName(this.xmlElementRef);
        }
        if (this.xmlAttribute != null && !StringUtils.isBlank((CharSequence)this.xmlAttribute.name()) && !this.xmlAttribute.name().equalsIgnoreCase("##default")) {
            return this.xmlAttribute.name();
        }
        if (this.xmlValue != null) {
            return this.ctx.getConfiguration().getXmlValueFieldName();
        }
        return this.field.getName();
    }

    private void setIgnore() {
        if (Modifier.isStatic(this.field.getModifiers())) {
            this.ignore = true;
            return;
        }
        if (this.field.getAnnotation(JaxBsonTransient.class) != null) {
            this.ignore = true;
            return;
        }
        if (this.field.getAnnotation(JaxBsonIgnoreTransient.class) != null) {
            return;
        }
        if (this.field.getAnnotation(XmlTransient.class) != null) {
            this.ignore = true;
            return;
        }
        if (Modifier.isTransient(this.field.getModifiers())) {
            this.ignore = true;
            return;
        }
    }

    private void setMultiBsonFieldNames() {
        this.multiBsonFieldNames = !this.valueContainerType.isCollection() && !this.valueContainerType.isArray() && (this.xmlElementRefs != null || this.xmlElements != null);
    }

    private void setOneMainType() {
        this.oneMainType = this.xmlElementRefs == null && this.xmlElements == null;
    }

    private void setValueContainerType() {
        this.valueContainerType = this.xmlAnyAttribute != null ? ValueContainerType.ANY_ATTRIBUTE : (this.xmlJavaTypeAdapter == null ? ValueContainerType.fromType(this.field.getType()) : ValueContainerType.NONE);
    }

    private void setXmlAnnotations() {
        this.jaxBsonName = this.field.getAnnotation(JaxBsonName.class);
        this.xmlAnyAttribute = this.field.getAnnotation(XmlAnyAttribute.class);
        this.xmlAnyAttributeMapping = this.field.getAnnotation(JaxBsonXmlAnyAttributeMapping.class);
        this.xmlAnyAttributeMappings = this.field.getAnnotation(JaxBsonXmlAnyAttributeMappings.class);
        this.xmlAnyElement = this.field.getAnnotation(XmlAnyElement.class);
        this.xmlAttribute = this.field.getAnnotation(XmlAttribute.class);
        this.xmlElement = this.field.getAnnotation(XmlElement.class);
        this.xmlElements = this.field.getAnnotation(XmlElements.class);
        this.xmlElementRef = this.field.getAnnotation(XmlElementRef.class);
        this.xmlElementRefs = this.field.getAnnotation(XmlElementRefs.class);
        this.xmlElementWrapper = this.field.getAnnotation(XmlElementWrapper.class);
        this.xmlJavaTypeAdapter = this.field.getAnnotation(XmlJavaTypeAdapter.class);
        this.xmlValue = this.field.getAnnotation(XmlValue.class);
    }

    protected void addXmlAnyAttributes(Document bson, Object o) {
        if (this.xmlAnyAttribute == null) {
            throw new IllegalStateException("This is a bug. Field has no XmlAnyAttribute annotation.");
        }
        try {
            Map map = (Map)this.field.get(o);
            if (map == null) {
                return;
            }
            map.forEach((qName, value) -> {
                String bsonFieldName = this.namespaceMap.getBsonFieldName((QName)qName);
                if (bson.containsKey((Object)bsonFieldName)) {
                    throw new JaxBsonException.JaxBsonNameClashException("Json field name '" + bsonFieldName + "' results multiple time through field " + this + ". Bson so far: " + bson.toJson());
                }
                bson.put(bsonFieldName, (Object)value.toString());
            });
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected void addXmlAnyAttributes(SortedMap<String, String> xmlAttributeMap, Object o) {
        HashMap map = new HashMap();
        xmlAttributeMap.forEach((bsonFieldName, bsonValue) -> {
            QName qName = this.namespaceMap.getQName((String)bsonFieldName);
            map.put(qName, bsonValue);
        });
        try {
            this.field.set(o, map);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Collection<Object> collectionInstance() {
        if (!this.valueContainerType.isCollection()) {
            throw new IllegalStateException("This is a bug. Field is not a collection.");
        }
        if (this.collectionConstructor == null) {
            return this.valueContainerType.collectionInstance();
        }
        try {
            return this.collectionConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate object of collection class '" + this.field.getType().getName() + "'.", e);
        }
    }

    protected Field getField() {
        return this.field;
    }

    protected FieldSubDescriptor getFieldSubDescriptor() {
        if (this.bsonFieldNameMap.size() != 1) {
            throw new IllegalStateException("Not exactly one sub-field (" + this.bsonFieldNameMap.size() + ") in field descriptor " + this);
        }
        return (FieldSubDescriptor)this.bsonFieldNameMap.get(this.bsonFieldNameMap.firstKey());
    }

    protected FieldSubDescriptor getFieldSubDescriptor(Class<?> type) {
        return this.getFieldSubDescriptor(type, true);
    }

    protected FieldSubDescriptor getFieldSubDescriptor(Class<?> type, boolean checkRet) {
        FieldSubDescriptor ret = this.bsonFieldTypeMap.get(type);
        if (checkRet && ret == null) {
            throw new IllegalStateException("No sub-field for type '" + type.getName() + "' in field descriptor " + this);
        }
        return ret;
    }

    protected FieldSubDescriptor getFieldSubDescriptor(String name) {
        return this.getFieldSubDescriptor(name, true);
    }

    protected FieldSubDescriptor getFieldSubDescriptor(String name, boolean checkRet) {
        FieldSubDescriptor ret = (FieldSubDescriptor)this.bsonFieldNameMap.get(name);
        if (checkRet && ret == null) {
            throw new IllegalStateException("No sub-field for name '" + name + "' in field descriptor " + this);
        }
        return ret;
    }

    protected Collection<FieldSubDescriptor> getFieldSubDescriptors() {
        return this.bsonFieldNameMap.values();
    }

    protected Collection<Class<?>> getReferredTypes() {
        return this.referredTypes;
    }

    protected boolean isIgnore() {
        return this.ignore;
    }

    protected boolean isOneMainType() {
        return this.oneMainType;
    }

    protected boolean isXmlAnyAttribute() {
        return this.xmlAnyAttribute != null;
    }

    protected void toBson(Document bson, Object o) {
        this.toBson(bson, o, false);
    }

    protected void toBson(Document bson, Object o, boolean omitType) {
        try {
            Object value = this.field.get(o);
            if (value == null) {
                return;
            }
            if (this.multiBsonFieldNames) {
                FieldSubDescriptor fds = this.getFieldSubDescriptor(value.getClass());
                fds.toBson(bson, value, false);
            } else {
                omitType = omitType && this.oneMainType;
                FieldSubDescriptor fds = this.getFieldSubDescriptor();
                fds.toBson(bson, value, omitType);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected void toObject(Object o, String bsonFieldName, Object bsonValue) {
        FieldSubDescriptor fds = (FieldSubDescriptor)this.bsonFieldNameMap.get(bsonFieldName);
        if (fds == null) {
            throw new IllegalStateException("This may be a bug. Failed to process Bson field name '" + bsonFieldName + "' in " + this);
        }
        fds.toObject(o, bsonValue);
    }
}

