/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.bson.Document;
import org.qnixyz.jbson.JaxBsonConfiguration;
import org.qnixyz.jbson.JaxBsonContext;
import org.qnixyz.jbson.impl.ClassDescriptor;
import org.qnixyz.jbson.impl.SimpleTypes;

public class JaxBsonContextImpl
implements JaxBsonContext {
    private final JaxBsonConfiguration configuration;
    private final SimpleTypes simpleTypes;
    private final Map<Class<?>, ClassDescriptor> typeMap = new HashMap();
    private final SortedMap<String, ClassDescriptor> typeNameMap = new TreeMap<String, ClassDescriptor>();
    private final Class<?>[] types;
    private final Map<Class<?>, XmlAdapter<Object, Object>> xmlAdapterMap = new HashMap();

    public JaxBsonContextImpl(Class<?> ... types) {
        this(new JaxBsonConfiguration(), types);
    }

    public JaxBsonContextImpl(JaxBsonConfiguration configuration, Class<?> ... types) {
        this.configuration = Objects.requireNonNull(configuration, "Supplied parameter 'configuration' is null");
        this.types = Objects.requireNonNull(types, "Supplied parameter 'types' is null");
        if (types.length < 1) {
            throw new IllegalArgumentException("Supplied parameter 'types' is empty");
        }
        this.simpleTypes = new SimpleTypes(this);
        this.index();
    }

    @Override
    public JaxBsonConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Document toBson(Object o) {
        Objects.requireNonNull(o, "Supplied parameter 'o' is null");
        return this.toBson(o, false);
    }

    @Override
    public Document toBson(Object o, boolean omitType) {
        Objects.requireNonNull(o, "Supplied parameter 'o' is null");
        Class<?> type = o.getClass();
        ClassDescriptor cd = this.typeMap.get(type);
        if (cd == null) {
            throw new IllegalStateException("Type '" + o.getClass().getName() + "' not in context");
        }
        return cd.toBson(o, omitType);
    }

    @Override
    public Object toObject(Document bson) {
        Objects.requireNonNull(bson, "Supplied parameter 'bson' is null");
        String typeName = bson.getString((Object)this.configuration.getTypeFieldName());
        if (typeName == null) {
            throw new IllegalStateException("No type field in Bson object: " + bson);
        }
        return this.toObject(bson, typeName);
    }

    @Override
    public Object toObject(Document bson, Class<?> type) {
        Objects.requireNonNull(bson, "Supplied parameter 'bson' is null");
        Objects.requireNonNull(type, "Supplied parameter 'type' is null");
        ClassDescriptor cd = this.typeMap.get(type);
        if (cd == null) {
            throw new IllegalStateException("Type '" + type.getSimpleName() + "' not in context");
        }
        return cd.toObject(bson);
    }

    @Override
    public Object toObject(Document bson, String typeName) {
        Objects.requireNonNull(bson, "Supplied parameter 'bson' is null");
        Objects.requireNonNull(typeName, "Supplied parameter 'typeName' is null");
        ClassDescriptor cd = (ClassDescriptor)this.typeNameMap.get(typeName);
        if (cd == null) {
            throw new IllegalStateException("Type name '" + typeName + "' not in context. Type names in context: " + this.typeNameMap.keySet());
        }
        return cd.toObject(bson);
    }

    private void index() {
        Set<Class<?>> types = new HashSet(Arrays.asList(this.types));
        while (!types.isEmpty()) {
            types = this.index(types);
        }
    }

    private Set<Class<?>> index(Class<?> type) {
        HashSet ret = new HashSet();
        if (this.typeMap.containsKey(type)) {
            return ret;
        }
        ClassDescriptor cd = new ClassDescriptor(this, type);
        if (this.typeNameMap.containsKey(cd.getTypeName())) {
            throw new IllegalStateException("Both types " + type.getName() + " and " + ((ClassDescriptor)this.typeNameMap.get(cd.getTypeName())).getType() + " have the same type name '" + cd.getTypeName() + "'");
        }
        this.typeMap.put(type, cd);
        this.typeNameMap.put(cd.getTypeName(), cd);
        ret.addAll(cd.getReferredTypes());
        return ret;
    }

    private Set<Class<?>> index(Set<Class<?>> types) {
        HashSet ret = new HashSet();
        types.forEach(e -> ret.addAll(this.index((Class<?>)e)));
        ret.removeAll(this.typeMap.keySet());
        return ret;
    }

    protected SimpleTypes getSimpleTypes() {
        return this.simpleTypes;
    }

    protected XmlAdapter<Object, Object> getXmlAdapterInstance(Class<?> xmlAdapterClass) {
        XmlAdapter ret = this.xmlAdapterMap.get(xmlAdapterClass);
        if (ret == null) {
            try {
                ret = (XmlAdapter)xmlAdapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.xmlAdapterMap.put(xmlAdapterClass, (XmlAdapter<Object, Object>)ret);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException("Unexpected exception");
            }
        }
        return ret;
    }
}

