/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.util.Objects;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.qnixyz.jbson.annotations.JaxBsonXmlAnyAttributeMapping;
import org.qnixyz.jbson.annotations.JaxBsonXmlAnyAttributeMappings;
import org.qnixyz.jbson.impl.FieldDescriptor;

class NamespaceMap {
    private final FieldDescriptor fd;
    private final TreeMap<String, String> toBsonMap = new TreeMap();
    private final TreeMap<String, String> toObjectMap = new TreeMap();

    protected NamespaceMap(FieldDescriptor fd) {
        this.fd = Objects.requireNonNull(fd, "Supplied parameter 'fd' is null");
        this.add("", "");
    }

    protected NamespaceMap(FieldDescriptor fd, JaxBsonXmlAnyAttributeMapping mapping) {
        this.fd = Objects.requireNonNull(fd, "Supplied parameter 'fd' is null");
        Objects.requireNonNull(mapping, "Supplied parameter 'mapping' is null");
        this.add(mapping);
    }

    protected NamespaceMap(FieldDescriptor fd, JaxBsonXmlAnyAttributeMappings mappings) {
        this.fd = Objects.requireNonNull(fd, "Supplied parameter 'fd' is null");
        Objects.requireNonNull(mappings, "Supplied parameter 'mappings' is null");
        if (mappings.mappings() != null) {
            for (JaxBsonXmlAnyAttributeMapping mapping : mappings.mappings()) {
                this.add(mapping);
            }
        }
    }

    private void add(JaxBsonXmlAnyAttributeMapping mapping) {
        this.add(mapping.namespaceURI(), mapping.bsonPrefix());
    }

    private void add(String namespaceURI, String bsonPrefix) {
        Objects.requireNonNull(namespaceURI, "Supplied parameter 'namespaceURI' is null");
        Objects.requireNonNull(bsonPrefix, "Supplied parameter 'bsonPrefix' is null");
        if (this.toBsonMap.containsKey(namespaceURI)) {
            throw new IllegalStateException("Multiple definitions for namespaceURI '" + namespaceURI + "' in field " + this.fd);
        }
        if (this.toObjectMap.containsKey(bsonPrefix)) {
            throw new IllegalStateException("Multiple definitions for bsonPrefix '" + bsonPrefix + "' in field " + this.fd);
        }
        this.toBsonMap.put(namespaceURI, bsonPrefix);
        this.toObjectMap.put(bsonPrefix, namespaceURI);
    }

    protected String getBsonFieldName(QName qName) {
        Objects.requireNonNull(qName, "Supplied parameter 'qName' is null");
        String bsonPrefix = this.toBsonMap.get(qName.getNamespaceURI());
        if (bsonPrefix == null) {
            throw new IllegalStateException("Failed to map namespaceURI '" + qName.getNamespaceURI() + "' to Bson field prefix for field " + this.fd);
        }
        return bsonPrefix + qName.getLocalPart();
    }

    protected QName getQName(String bsonFieldName) {
        Objects.requireNonNull(this.fd, "Supplied parameter 'fd' is null");
        Objects.requireNonNull(bsonFieldName, "Supplied parameter 'bsonFieldName' is null");
        for (String bsonPrefix : this.toObjectMap.descendingKeySet()) {
            if (!bsonFieldName.startsWith(bsonPrefix)) continue;
            String namespaceURI = this.toObjectMap.get(bsonPrefix);
            String localPart = bsonFieldName.substring(bsonPrefix.length());
            return new QName(namespaceURI, localPart);
        }
        throw new IllegalStateException("Failed to map BSIN field name '" + bsonFieldName + "' to namespaceURI+localPart for field " + this.fd);
    }
}

