/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.qnixyz.jbson.JaxBsonConfiguration;
import org.qnixyz.jbson.JaxBsonContext;
import org.qnixyz.jbson.JaxBsonToBson;
import org.qnixyz.jbson.JaxBsonToObject;
import org.qnixyz.jbson.impl.FieldSubDescriptor;

class SimpleTypes {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Boolean.TYPE, Binary.class, Byte.class, Byte.TYPE, Character.class, Character.TYPE, ObjectId.class));
    private final JaxBsonConfiguration cfg;
    private final JaxBsonContext ctx;

    protected static boolean isSimpleType(JaxBsonConfiguration cfg, Class<?> type) {
        return SIMPLE_TYPES.contains(type) || Enum.class.isAssignableFrom(type) || cfg.getDateBased().getChecker().check(type) || cfg.getNumberBased().getChecker().check(type) || cfg.getStringBased().getChecker().check(type);
    }

    protected SimpleTypes(JaxBsonContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.cfg = ctx.getConfiguration();
    }

    private String classInfo(Object o) {
        String array = o.getClass().isArray() ? "[]" : "";
        String collectionPre = Collection.class.isAssignableFrom(o.getClass()) ? "Collection<" : "";
        String collectionPost = Collection.class.isAssignableFrom(o.getClass()) ? ">" : "";
        Class<?> elementType = this.elementType(o);
        return collectionPre + elementType.getSimpleName() + collectionPost + array;
    }

    private Collection<?> createToObjectCollection(FieldSubDescriptor fds) {
        return fds.getFd().collectionInstance();
    }

    private Class<?> elementType(Object o) {
        Class<?> ret = o.getClass();
        if (ret.isArray()) {
            return ret.getComponentType();
        }
        if (Collection.class.isAssignableFrom(ret)) {
            for (Object e : (Collection)o) {
                if (e == null) continue;
                return e.getClass();
            }
            return null;
        }
        return ret;
    }

    private Class<?> getGenericType(Collection<?> o) {
        for (Object e : o) {
            if (e == null) continue;
            return e.getClass();
        }
        return null;
    }

    private Collection<Object> toFieldCollection(FieldSubDescriptor fds, Collection<?> convert) {
        if (fds.isList()) {
            return new ArrayList<Object>(convert);
        }
        if (fds.isSet()) {
            return new HashSet<Object>(convert);
        }
        if (fds.isSortedSet()) {
            return new TreeSet<Object>(convert);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectBinary(FieldSubDescriptor fds, Binary o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBinaryToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBinaryToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBinaryToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBinaryToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBinaryToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBinaryToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getBinaryToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBinaryToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBinaryToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBinaryToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBinaryToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBinaryToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBinaryToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBinaryToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBinaryToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getBinaryToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBinaryToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBinaryToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getBinaryToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getBinaryToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getBinaryToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getBinaryToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getBinaryToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getBinaryToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getBinaryToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getBinaryToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getBinaryToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getBinaryToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getBinaryToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getBinaryToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectBinary(FieldSubDescriptor fds, Collection<Binary> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBinaryCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getBinaryCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getBinaryCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBinaryCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBinaryCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getBinaryCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBinaryCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getBinaryCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getBinaryCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getBinaryCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getBinaryCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getBinaryCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectBoolean(FieldSubDescriptor fds, Boolean o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBooleanToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBooleanToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBooleanToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBooleanToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBooleanToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBooleanToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getBooleanToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBooleanToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBooleanToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBooleanToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBooleanToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBooleanToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBooleanToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBooleanToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBooleanToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getBooleanToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanToObjectIdCollection().convert(cfg, field, o));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBooleanToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getBooleanToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getBooleanToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getBooleanToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getBooleanToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getBooleanToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getBooleanToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getBooleanToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getBooleanToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getBooleanToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getBooleanToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getBooleanToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getBooleanToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectBoolean(FieldSubDescriptor fds, Collection<Boolean> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBooleanCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getBooleanCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getBooleanCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBooleanCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanCollectionToBooleanCollection().convert(cfg, field, o));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanCollectionToBinaryCollection().convert(cfg, field, o));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanCollectionToByteCollection().convert(cfg, field, o));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanCollectionToCharacterCollection().convert(cfg, field, o));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getBooleanCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getBooleanCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return this.toFieldCollection(fds, c.getBooleanCollectionToObjectIdCollection().convert(cfg, field, o));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getBooleanCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getBooleanCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getBooleanCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getBooleanCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getBooleanCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getBooleanCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectDate(FieldSubDescriptor fds, Collection<Date> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getDateCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getDateCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getDateCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getDateCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getDateCollectionToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getDateCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getDateCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getDateCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getDateCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getDateCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getDateCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getDateCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getDateCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectDate(FieldSubDescriptor fds, Date o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getDateToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getDateToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getDateToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getDateToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getDateToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getDateToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getDateToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getDateToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getDateToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getDateToShortPrimArray().convert(cfg, field, o);
                }
                if (cfg.getStringBased().getChecker().check(mainType)) {
                    return c.getDateToStringBasedArray().convert(cfg, field, mainType, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getDateToObjectIdArray().convert(cfg, field, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getDateToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getDateToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getDateToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getDateToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getDateToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getDateToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getDateToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getDateToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getDateToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getDateToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getDateToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getDateToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getDateToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getDateToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getDateToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getDateToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getDateToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getDateToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getDateToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getDateToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectNumber(FieldSubDescriptor fds, Collection<Number> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getNumberCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getNumberCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getNumberCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getNumberCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getNumberCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getNumberCollectionToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getNumberCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getNumberCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getNumberCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getNumberCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getNumberCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getNumberCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectNumber(FieldSubDescriptor fds, Number o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getNumberToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getNumberToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getNumberToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getNumberToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getNumberToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getNumberToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getNumberToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getNumberToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getNumberToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getNumberToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getNumberToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getNumberToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getNumberToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getNumberToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getNumberToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getNumberToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getNumberToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getNumberToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getNumberToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getNumberToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getNumberToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getNumberToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getNumberToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getNumberToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getNumberToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getNumberToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getNumberToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getNumberToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getNumberToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getNumberToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getNumberToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getNumberToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectObjectId(FieldSubDescriptor fds, Collection<ObjectId> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getObjectIdCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getObjectIdCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getObjectIdCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getObjectIdCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getObjectIdCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getObjectIdCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getObjectIdCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getObjectIdCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getObjectIdCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getObjectIdCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getObjectIdCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectObjectId(FieldSubDescriptor fds, ObjectId o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getObjectIdToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getObjectIdToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getObjectIdToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getObjectIdToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getObjectIdToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getObjectIdToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getObjectIdToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getObjectIdToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getObjectIdToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getObjectIdToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getObjectIdToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getObjectIdToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getObjectIdToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getObjectIdToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectString(FieldSubDescriptor fds, Collection<String> o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getStringCollectionToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getStringCollectionToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getStringCollectionToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringCollectionToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringCollectionToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringCollectionToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringCollectionToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringCollectionToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringCollectionToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getStringCollectionToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getStringCollectionToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getStringCollectionToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringCollectionToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getStringCollectionToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getStringCollectionToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getStringCollectionToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getStringCollectionToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getStringCollectionToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getStringCollectionToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getStringCollectionToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    private Object toObjectString(FieldSubDescriptor fds, String o) {
        Class<?> mainType = fds.getMainType();
        Field field = fds.getField();
        JaxBsonConfiguration cfg = this.ctx.getConfiguration();
        JaxBsonToObject c = cfg.getToObject();
        if (fds.isArray()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getStringToBooleanArray().convert(cfg, field, o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getStringToBooleanPrimArray().convert(cfg, field, o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getStringToBinaryArray().convert(cfg, field, o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getStringToByteArray().convert(cfg, field, o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getStringToBytePrimArray().convert(cfg, field, o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getStringToCharacterArray().convert(cfg, field, o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getStringToCharacterPrimArray().convert(cfg, field, o);
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getStringToDateBasedArray().convert(cfg, field, mainType, o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getStringToEnumArray().convert(cfg, field, mainType, o);
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getStringToNumberBasedArray().convert(cfg, field, mainType, o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringToDoublePrimArray().convert(cfg, field, o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringToFloatPrimArray().convert(cfg, field, o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringToIntegerPrimArray().convert(cfg, field, o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringToLongPrimArray().convert(cfg, field, o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getStringToShortPrimArray().convert(cfg, field, o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getStringToObjectIdArray().convert(cfg, field, o);
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringToStringBasedArray().convert(cfg, field, mainType, o);
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (fds.isCollection()) {
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getStringToBooleanCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getStringToBinaryCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getStringToByteCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getStringToCharacterCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getDateBased().getChecker().check(mainType)) {
                return c.getStringToDateBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getStringToEnumCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getStringToNumberBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getStringToObjectIdCollection().convert(cfg, field, o, this.createToObjectCollection(fds));
            }
            if (cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringToStringBasedCollection().convert(cfg, field, mainType, o, this.createToObjectCollection(fds));
            }
            throw new IllegalStateException("This is a bug.");
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getStringToBoolean().convert(cfg, field, o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getStringToBooleanPrim().convert(cfg, field, o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getStringToBinary().convert(cfg, field, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getStringToByte().convert(cfg, field, o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getStringToBytePrim().convert(cfg, field, o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getStringToCharacter().convert(cfg, field, o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return Character.valueOf(c.getStringToCharacterPrim().convert(cfg, field, o));
        }
        if (cfg.getDateBased().getChecker().check(mainType)) {
            return c.getStringToDateBased().convert(cfg, field, mainType, o);
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getStringToEnum().convert(cfg, field, mainType, o);
        }
        if (cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getStringToNumberBased().convert(cfg, field, mainType, o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getStringToObjectId().convert(cfg, field, o);
        }
        if (cfg.getStringBased().getChecker().check(mainType)) {
            return c.getStringToStringBased().convert(cfg, field, mainType, o);
        }
        throw new IllegalStateException("This is a bug.");
    }

    protected Object toBson(Field destField, Object o) {
        if (o == null) {
            return null;
        }
        Class<?> cls = o.getClass();
        JaxBsonToBson c = this.cfg.getToBson();
        if (cls.isArray()) {
            Class<?> mainType = cls.getComponentType();
            if (this.cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringBasedArrayToBson().convert(this.cfg, destField, (Object[])o);
            }
            if (this.cfg.getNumberBased().getChecker().check(mainType)) {
                if (!mainType.isPrimitive()) {
                    return c.getNumberBasedArrayToBson().convert(this.cfg, destField, (Object[])o);
                }
                if (Double.TYPE.isAssignableFrom(mainType)) {
                    return c.getDoublePrimArrayToBson().convert(this.cfg, destField, (double[])o);
                }
                if (Float.TYPE.isAssignableFrom(mainType)) {
                    return c.getFloatPrimArrayToBson().convert(this.cfg, destField, (float[])o);
                }
                if (Integer.TYPE.isAssignableFrom(mainType)) {
                    return c.getIntegerPrimArrayToBson().convert(this.cfg, destField, (int[])o);
                }
                if (Long.TYPE.isAssignableFrom(mainType)) {
                    return c.getLongPrimArrayToBson().convert(this.cfg, destField, (long[])o);
                }
                if (Short.TYPE.isAssignableFrom(mainType)) {
                    return c.getShortPrimArrayToBson().convert(this.cfg, destField, (short[])o);
                }
                throw new IllegalStateException("This is a bug.");
            }
            if (this.cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateBasedArrayToBson().convert(this.cfg, destField, (Object[])o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getByteArrayToBson().convert(this.cfg, destField, (Byte[])o);
            }
            if (Byte.TYPE.isAssignableFrom(mainType)) {
                return c.getBytePrimArrayToBson().convert(this.cfg, destField, (byte[])o);
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdArrayToBson().convert(this.cfg, destField, (ObjectId[])o);
            }
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBooleanArrayToBson().convert(this.cfg, destField, (Boolean[])o);
            }
            if (Boolean.TYPE.isAssignableFrom(mainType)) {
                return c.getBooleanPrimArrayToBson().convert(this.cfg, destField, (boolean[])o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getCharacterArrayToBson().convert(this.cfg, destField, (Character[])o);
            }
            if (Character.TYPE.isAssignableFrom(mainType)) {
                return c.getCharacterPrimArrayToBson().convert(this.cfg, destField, (char[])o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getEnumArrayToBson().convert(this.cfg, destField, mainType, (Enum[])o);
            }
            throw new IllegalStateException("Failed to convert array of " + cls.getName() + " to Bson: " + o);
        }
        if (Collection.class.isAssignableFrom(cls)) {
            Class<?> mainType = this.getGenericType((Collection)o);
            if (mainType == null) {
                return Collections.EMPTY_LIST;
            }
            if (this.cfg.getStringBased().getChecker().check(mainType)) {
                return c.getStringBasedCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (this.cfg.getNumberBased().getChecker().check(mainType)) {
                return c.getNumberBasedCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (this.cfg.getDateBased().getChecker().check(mainType)) {
                return c.getDateBasedCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (Byte.class.isAssignableFrom(mainType)) {
                return c.getByteCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (ObjectId.class.isAssignableFrom(mainType)) {
                return c.getObjectIdCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (Binary.class.isAssignableFrom(mainType)) {
                return c.getBinaryCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (Boolean.class.isAssignableFrom(mainType)) {
                return c.getBooleanCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (Character.class.isAssignableFrom(mainType)) {
                return c.getCharacterCollectionToBson().convert(this.cfg, destField, (Collection)o);
            }
            if (Enum.class.isAssignableFrom(mainType)) {
                return c.getEnumCollectionToBson().convert(this.cfg, destField, mainType, (Collection)o);
            }
            throw new IllegalStateException("Failed to convert collection of " + cls.getName() + " to Bson.");
        }
        Class<?> mainType = cls;
        if (this.cfg.getStringBased().getChecker().check(mainType)) {
            return c.getStringBasedToBson().convert(this.cfg, destField, o);
        }
        if (this.cfg.getNumberBased().getChecker().check(mainType)) {
            return c.getNumberBasedToBson().convert(this.cfg, destField, o);
        }
        if (this.cfg.getDateBased().getChecker().check(mainType)) {
            return c.getDateBasedToBson().convert(this.cfg, destField, o);
        }
        if (Byte.class.isAssignableFrom(mainType)) {
            return c.getByteToBson().convert(this.cfg, destField, (Byte)o);
        }
        if (Byte.TYPE.isAssignableFrom(mainType)) {
            return c.getBytePrimToBson().convert(this.cfg, destField, (Byte)o);
        }
        if (ObjectId.class.isAssignableFrom(mainType)) {
            return c.getObjectIdToBson().convert(this.cfg, destField, (ObjectId)o);
        }
        if (Binary.class.isAssignableFrom(mainType)) {
            return c.getBinaryToBson().convert(this.cfg, destField, (Binary)o);
        }
        if (Boolean.class.isAssignableFrom(mainType)) {
            return c.getBooleanToBson().convert(this.cfg, destField, (Boolean)o);
        }
        if (Boolean.TYPE.isAssignableFrom(mainType)) {
            return c.getBooleanPrimToBson().convert(this.cfg, destField, (Boolean)o);
        }
        if (Character.class.isAssignableFrom(mainType)) {
            return c.getCharacterToBson().convert(this.cfg, destField, (Character)o);
        }
        if (Character.TYPE.isAssignableFrom(mainType)) {
            return c.getCharacterPrimToBson().convert(this.cfg, destField, ((Character)o).charValue());
        }
        if (Enum.class.isAssignableFrom(mainType)) {
            return c.getEnumToBson().convert(this.cfg, destField, mainType, (Enum)o);
        }
        throw new IllegalStateException("Failed to convert object of " + mainType.getName() + " to Bson.");
    }

    protected Object toObject(FieldSubDescriptor fds, Object o) {
        Objects.requireNonNull(fds, "Supplied parameter 'fds' is null");
        if (o == null) {
            return null;
        }
        if (!fds.isSimpleType()) {
            throw new IllegalArgumentException("Supplied parameter 'fds' is not of a simple type: " + fds);
        }
        Class<?> srcClass = o.getClass();
        Class<?> elementType = this.elementType(o);
        if (elementType == null) {
            return null;
        }
        if (Binary.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectBinary(fds, (Collection)o);
            }
            return this.toObjectBinary(fds, (Binary)o);
        }
        if (Boolean.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectBoolean(fds, (Collection)o);
            }
            return this.toObjectBoolean(fds, (Boolean)o);
        }
        if (Date.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectDate(fds, (Collection)o);
            }
            return this.toObjectDate(fds, (Date)o);
        }
        if (!Byte.class.isAssignableFrom(elementType) && Number.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectNumber(fds, (Collection)o);
            }
            return this.toObjectNumber(fds, (Number)o);
        }
        if (ObjectId.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectObjectId(fds, (Collection)o);
            }
            return this.toObjectObjectId(fds, (ObjectId)o);
        }
        if (String.class.isAssignableFrom(elementType)) {
            if (Collection.class.isAssignableFrom(srcClass)) {
                return this.toObjectString(fds, (Collection)o);
            }
            return this.toObjectString(fds, (String)o);
        }
        throw new IllegalStateException("Unsupperted conversion from " + this.classInfo(o) + " to field " + fds);
    }
}

