// Copyright (C) 2024 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

package org.qtproject.qt.gradleplugin

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.InputDirectory
import org.gradle.api.tasks.TaskAction

class QtAddDependencyTask extends DefaultTask {
    @InputDirectory
    File buildDirectory

    QtAddDependencyTask() {
        group = 'QtProject'
        description = 'Add Qt ARR dependency'
    }

    @TaskAction
    def addDependency() {
        def targetName = Utils.getAndroidBuildTargetName(buildDirectory)
        if (targetName) {
            project.dependencies.add('implementation',
                    project.fileTree(dir: "${buildDirectory}/android-build-${targetName}",
                            include: ["${targetName}.aar"]))
        } else if (QtGradlePlugin.isIdeaSync())
            return null
        else
            Utils.logAndThrowException("Target path not found in build directory.")
    }
}
