// Copyright (C) 2024 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

package org.qtproject.qt.gradleplugin

import org.gradle.api.GradleException

@Singleton
class Utils {
    static def getAndroidBuildTargetName(File buildDir) {
        def deploymentSettingFile = buildDir.listFiles()
                .findAll { it.name.contains('-deployment-settings.json') }
                .max { it.lastModified() }

        if (!deploymentSettingFile) {
            if (QtGradlePlugin.isIdeaSync())
                return null
            else
                logAndThrowException("Deployment file not found in '$buildDir'")
        }

        def pattern = ~/android-(.*?)-deployment-settings\.json/
        def matcher = deploymentSettingFile.name =~ pattern
        if (!matcher)
            logAndThrowException("File name does not match the expected pattern: ${deploymentSettingFile.name}")

        return matcher.group(1)
    }

    static logAndThrowException(String errorMessage) {
        throw new GradleException(errorMessage)
    }
}

