/*
 * Decompiled with CFR 0.152.
 */
package quasar.std;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import quasar.Data;
import quasar.Func$;
import quasar.Mapping$;
import quasar.NullaryFunc;
import quasar.SemanticError;
import quasar.Type;
import quasar.Type$;
import quasar.Type$Date$;
import quasar.Type$Int$;
import quasar.Type$Interval$;
import quasar.Type$Str$;
import quasar.Type$Time$;
import quasar.Type$Timestamp$;
import quasar.UnaryFunc;
import quasar.fp.ski.package$;
import quasar.std.DateLib;
import quasar.std.TemporalPart;
import quasar.std.TemporalPart$Century$;
import quasar.std.TemporalPart$Day$;
import quasar.std.TemporalPart$Decade$;
import quasar.std.TemporalPart$Hour$;
import quasar.std.TemporalPart$Microsecond$;
import quasar.std.TemporalPart$Millennium$;
import quasar.std.TemporalPart$Millisecond$;
import quasar.std.TemporalPart$Minute$;
import quasar.std.TemporalPart$Month$;
import quasar.std.TemporalPart$Quarter$;
import quasar.std.TemporalPart$Second$;
import quasar.std.TemporalPart$Week$;
import quasar.std.TemporalPart$Year$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.compat.java8.runtime.LambdaDeserializer$;
import scala.math.BigInt;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Bind;
import scalaz.Functor;
import scalaz.Validation;
import scalaz.Validation$;
import shapeless.Sized;
import shapeless.Sized$;
import shapeless.Succ;
import shapeless._0;
import slamdata.Predef$;

public abstract class DateLib$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static .bslash.div parseTimestamp(DateLib $this, String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Instant.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>($this.Timestamp(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1)(JFunction1 & Serializable & scala.Serializable)value -> new Data.Timestamp((Instant)value));
    }

    public static .bslash.div parseDate(DateLib $this, String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> LocalDate.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>($this.Date(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1)(JFunction1 & Serializable & scala.Serializable)value -> new Data.Date((LocalDate)value));
    }

    public static .bslash.div parseTime(DateLib $this, String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> LocalTime.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>($this.Time(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1)(JFunction1 & Serializable & scala.Serializable)value -> new Data.Time((LocalTime)value));
    }

    public static .bslash.div parseInterval(DateLib $this, String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Duration.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>($this.Interval(), str2, (Option<String>)Predef$.MODULE$.Some().apply((Object)"expected, e.g. P3DT12H30M15.0S; note: year/month not currently supported"))), (Function1)(JFunction1 & Serializable & scala.Serializable)value -> new Data.Interval((Duration)value));
    }

    public static Instant startOfDayInstant(DateLib $this, LocalDate date) {
        return date.atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    }

    public static Data.Timestamp startOfDay(DateLib $this, Data.Date date) {
        return new Data.Timestamp($this.startOfDayInstant(date.value()));
    }

    public static Data.Timestamp startOfNextDay(DateLib $this, Data.Date date) {
        return new Data.Timestamp($this.startOfDayInstant(date.value().plus(Period.ofDays(1))));
    }

    public static .bslash.div truncLocalTime(DateLib $this, TemporalPart part, LocalTime t) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> {
            LocalTime localTime;
            TemporalPart temporalPart = part;
            boolean bl = TemporalPart$Century$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Day$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Decade$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Millennium$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Month$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Quarter$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Week$.MODULE$.equals(temporalPart) ? true : TemporalPart$Year$.MODULE$.equals(temporalPart)))))));
            if (bl) {
                localTime = t.truncatedTo(ChronoUnit.DAYS);
            } else if (TemporalPart$Hour$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.HOURS);
            } else if (TemporalPart$Microsecond$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MICROS);
            } else if (TemporalPart$Millisecond$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MILLIS);
            } else if (TemporalPart$Minute$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MINUTES);
            } else if (TemporalPart$Second$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.SECONDS);
            } else {
                throw new MatchError((Object)temporalPart);
            }
            return localTime;
        }).leftMap((Function1)(JFunction1 & Serializable & scala.Serializable)err -> new SemanticError.GenericError(Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncLocalTime: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{err}))));
    }

    public static .bslash.div truncZonedDateTime(DateLib $this, TemporalPart part, ZonedDateTime zdt) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToBindOps($this.truncLocalTime(part, zdt.toLocalTime()), (Bind)$bslash$div$.MODULE$.DisjunctionInstances1()).$greater$greater$eq((Function1)(JFunction1 & Serializable & scala.Serializable)t -> $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> {
            ZonedDateTime zonedDateTime;
            ZonedDateTime truncTime = ZonedDateTime.of(zdt.toLocalDate(), t, zdt.getZone());
            TemporalPart temporalPart = part;
            if (TemporalPart$Century$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 100 * 100);
            } else if (TemporalPart$Day$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Decade$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 10 * 10);
            } else if (TemporalPart$Hour$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Microsecond$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Millennium$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 1000 * 1000);
            } else if (TemporalPart$Millisecond$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Minute$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Month$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1);
            } else if (TemporalPart$Quarter$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(zdt.getMonth().firstMonthOfQuarter().getValue());
            } else if (TemporalPart$Second$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Week$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.with(DayOfWeek.MONDAY);
            } else if (TemporalPart$Year$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1);
            } else {
                throw new MatchError((Object)temporalPart);
            }
            return zonedDateTime;
        }).leftMap((Function1)(JFunction1 & Serializable & scala.Serializable)err -> new SemanticError.GenericError(Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncZonedDateTime: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})))));
    }

    public static .bslash.div truncDate(DateLib $this, TemporalPart part, Data.Date d) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps($this.truncZonedDateTime(part, d.value().atStartOfDay(ZoneOffset.UTC)), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1)(JFunction1 & Serializable & scala.Serializable)t -> new Data.Date(t.toLocalDate()));
    }

    public static .bslash.div truncTime(DateLib $this, TemporalPart part, Data.Time t) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps($this.truncLocalTime(part, t.value()), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> new Data.Time((LocalTime)x$1));
    }

    public static .bslash.div truncTimestamp(DateLib $this, TemporalPart part, Data.Timestamp ts) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps($this.truncZonedDateTime(part, ts.value().atZone(ZoneOffset.UTC)), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1)(JFunction1 & Serializable & scala.Serializable)t -> new Data.Timestamp(t.toInstant()));
    }

    private static UnaryFunc extract(DateLib $this, String help) {
        return new UnaryFunc(Mapping$.MODULE$, help, Type$.MODULE$.Numeric(), Func$.MODULE$.Input1(Type$.MODULE$.Temporal()), $this.noSimplification(), $this.constTyper(Type$.MODULE$.Numeric()), $this.basicUntyper());
    }

    public static void $init$(DateLib $this) {
        $this.quasar$std$DateLib$_setter_$ExtractCentury_$eq(DateLib$class.extract($this, "Pulls out the century subfield from a date/time value (currently year/100)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfMonth_$eq(DateLib$class.extract($this, "Pulls out the day of month (`day`) subfield from a date/time value (1-31)."));
        $this.quasar$std$DateLib$_setter_$ExtractDecade_$eq(DateLib$class.extract($this, "Pulls out the decade subfield from a date/time value (year/10)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfWeek_$eq(DateLib$class.extract($this, "Pulls out the day of week (`dow`) subfield from a date/time value (Sunday: 0 to Saturday: 7)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfYear_$eq(DateLib$class.extract($this, "Pulls out the day of year (`doy`) subfield from a date/time value (1-365 or -366)."));
        $this.quasar$std$DateLib$_setter_$ExtractEpoch_$eq(DateLib$class.extract($this, "Pulls out the epoch subfield from a date/time value. For dates and timestamps, this is the number of seconds since midnight, 1970-01-01. For intervals, the number of seconds in the interval."));
        $this.quasar$std$DateLib$_setter_$ExtractHour_$eq(DateLib$class.extract($this, "Pulls out the hour subfield from a date/time value (0-23)."));
        $this.quasar$std$DateLib$_setter_$ExtractIsoDayOfWeek_$eq(DateLib$class.extract($this, "Pulls out the ISO day of week (`isodow`) subfield from a date/time value (Monday: 1 to Sunday: 7)."));
        $this.quasar$std$DateLib$_setter_$ExtractIsoYear_$eq(DateLib$class.extract($this, "Pulls out the ISO year (`isoyear`) subfield from a date/time value (based on the first week containing Jan. 4)."));
        $this.quasar$std$DateLib$_setter_$ExtractMicroseconds_$eq(DateLib$class.extract($this, "Pulls out the microseconds subfield from a date/time value (including seconds)."));
        $this.quasar$std$DateLib$_setter_$ExtractMillennium_$eq(DateLib$class.extract($this, "Pulls out the millennium subfield from a date/time value (currently year/1000)."));
        $this.quasar$std$DateLib$_setter_$ExtractMilliseconds_$eq(DateLib$class.extract($this, "Pulls out the milliseconds subfield from a date/time value (including seconds)."));
        $this.quasar$std$DateLib$_setter_$ExtractMinute_$eq(DateLib$class.extract($this, "Pulls out the minute subfield from a date/time value (0-59)."));
        $this.quasar$std$DateLib$_setter_$ExtractMonth_$eq(DateLib$class.extract($this, "Pulls out the month subfield from a date/time value (1-12)."));
        $this.quasar$std$DateLib$_setter_$ExtractQuarter_$eq(DateLib$class.extract($this, "Pulls out the quarter subfield from a date/time value (1-4)."));
        $this.quasar$std$DateLib$_setter_$ExtractSecond_$eq(DateLib$class.extract($this, "Pulls out the second subfield from a date/time value (0-59, with fractional parts)."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezone_$eq(DateLib$class.extract($this, "Pulls out the timezone subfield from a date/time value (in seconds east of UTC)."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezoneHour_$eq(DateLib$class.extract($this, "Pulls out the hour component of the timezone subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezoneMinute_$eq(DateLib$class.extract($this, "Pulls out the minute component of the timezone subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$ExtractWeek_$eq(DateLib$class.extract($this, "Pulls out the week subfield from a date/time value (1-53)."));
        $this.quasar$std$DateLib$_setter_$ExtractYear_$eq(DateLib$class.extract($this, "Pulls out the year subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$Date_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (YYYY-MM-DD) to a date value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Date$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x1;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseDate(str3).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> new Type.Const((Data)x$2)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Date$.MODULE$) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x1) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x1;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Now_$eq(new NullaryFunc(Mapping$.MODULE$, "Returns the current timestamp \u2013 this must always return the same value within the same execution of a query.", Type$Timestamp$.MODULE$, $this.noSimplification()));
        $this.quasar$std$DateLib$_setter_$Time_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (HH:MM:SS[.SSS]) to a time value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Time$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x2;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseTime(str3).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$3 -> new Type.Const((Data)x$3)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Time$.MODULE$) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x2) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x2;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Timestamp_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (ISO 8601, UTC, e.g. 2015-05-12T12:22:00Z) to a timestamp value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x3;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseTimestamp(str3).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$4 -> new Type.Const((Data)x$4)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$) : function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x3) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x3;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Interval_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (ISO 8601, e.g. P3DT12H30M15.0S) to an interval value. Note: year/month not currently supported. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Interval$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x4;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseInterval(str3).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$5 -> new Type.Const((Data)x$5)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Interval$.MODULE$) : function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x4) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x4;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$StartOfDay_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a Date or Timestamp to a Timestamp at the start of that day.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Date$.MODULE$.$u2A3F(Type$Timestamp$.MODULE$)), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x5;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Date) {
                    Data.Date date = (Data.Date)data;
                    LocalDate v = date.value();
                    object = Validation$.MODULE$.success().apply((Object)new Type.Const(new Data.Timestamp(this.$outer.startOfDayInstant(v))));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Date$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0))) {
                        object = Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$);
                    } else {
                        Type.Const const_2;
                        Data data2;
                        Type type3;
                        Some some3 = Sized$.MODULE$.unapplySeq(A1);
                        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (type3 = (Type)((LinearSeqOptimized)some3.get()).apply(0)) instanceof Type.Const && (data2 = (const_2 = (Type.Const)type3).value()) instanceof Data.Timestamp) {
                            Data.Timestamp timestamp = (Data.Timestamp)data2;
                            Instant v = timestamp.value();
                            object = this.$outer.truncZonedDateTime(TemporalPart$Day$.MODULE$, v.atZone(ZoneOffset.UTC)).map((Function1)(JFunction1 & Serializable & scala.Serializable)t -> new Type.Const(new Data.Timestamp(t.toInstant()))).validation().toValidationNel();
                        } else {
                            Type type4;
                            Some some4 = Sized$.MODULE$.unapplySeq(A1);
                            object = !some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type4 = (Type)((LinearSeqOptimized)some4.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$) : function1.apply(x5);
                        }
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x5) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Some some2;
                Type type3;
                Some some3;
                Type.Const const_2;
                Data data2;
                Type type4;
                Sized<List<Type>, Succ<_0>> sized = x5;
                Some some4 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && (type4 = (Type)((LinearSeqOptimized)some4.get()).apply(0)) instanceof Type.Const && (data2 = (const_2 = (Type.Const)type4).value()) instanceof Data.Date ? true : (!(some3 = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && Type$Date$.MODULE$.equals(type3 = (Type)((LinearSeqOptimized)some3.get()).apply(0)) ? true : (!(some2 = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Timestamp ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        }), $this.untyper((Function1)(JFunction1 & Serializable & scala.Serializable)x0$1 -> {
            Type type = x0$1;
            Validation validation = Type$Timestamp$.MODULE$.equals(type) ? (Validation)Validation$.MODULE$.success().apply(Func$.MODULE$.Input1(Type$Date$.MODULE$)) : (Validation)Validation$.MODULE$.success().apply(Func$.MODULE$.Input1(type));
            return validation;
        })));
        $this.quasar$std$DateLib$_setter_$TimeOfDay_$eq(new UnaryFunc(Mapping$.MODULE$, "Extracts the time of day from a (UTC) timestamp value.", Type$Time$.MODULE$, Func$.MODULE$.Input1(Type$Timestamp$.MODULE$), $this.noSimplification(), $this.partialTyper(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x6;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Timestamp) {
                    Data.Timestamp timestamp = (Data.Timestamp)data;
                    Instant value = timestamp.value();
                    object = new Type.Const(new Data.Time(value.atZone(ZoneOffset.UTC).toLocalTime()));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Type$Time$.MODULE$ : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x6) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x6;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Timestamp ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$ToTimestamp_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts an integer epoch time value (i.e. milliseconds since 1 Jan. 1970, UTC) to a timestamp constant.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Int$.MODULE$), $this.noSimplification(), $this.partialTyper(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x7;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Int) {
                    Data.Int intVal = (Data.Int)data;
                    BigInt millis = intVal.value();
                    object = new Type.Const(new Data.Timestamp(Instant.ofEpochMilli(millis.toLong())));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Int$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Type$Timestamp$.MODULE$ : function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x7) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x7;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Int ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Int$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
        }), $this.basicUntyper()));
    }
}

