/*
 * Decompiled with CFR 0.152.
 */
package quasar.physical.mongodb;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import quasar.common.SortDir;
import quasar.contrib.scalaz.optionT$;
import quasar.physical.mongodb.Bson;
import quasar.physical.mongodb.BsonField;
import quasar.physical.mongodb.Collection;
import quasar.physical.mongodb.Collection$;
import quasar.physical.mongodb.CollectionName;
import quasar.physical.mongodb.CollectionName$;
import quasar.physical.mongodb.CollectionStatistics;
import quasar.physical.mongodb.DatabaseName;
import quasar.physical.mongodb.Index;
import quasar.physical.mongodb.IndexType;
import quasar.physical.mongodb.IndexType$Ascending$;
import quasar.physical.mongodb.IndexType$Descending$;
import quasar.physical.mongodb.IndexType$Hashed$;
import quasar.physical.mongodb.MapReduce;
import quasar.physical.mongodb.MapReduce$Action$Replace$;
import quasar.physical.mongodb.MongoDbIO;
import quasar.physical.mongodb.RenameSemantics;
import quasar.physical.mongodb.RenameSemantics$FailIfExists$;
import quasar.physical.mongodb.RenameSemantics$Overwrite$;
import quasar.physical.mongodb.ServerVersion;
import quasar.physical.mongodb.ServerVersion$;
import quasar.physical.mongodb.package$;
import scala.Function0;
import scala.Function1;
import scala.Function10;
import scala.Function11;
import scala.Function12;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Function6;
import scala.Function7;
import scala.Function8;
import scala.Function9;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.compat.java8.JFunction2;
import scala.compat.java8.runtime.LambdaDeserializer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Applicative;
import scalaz.Apply;
import scalaz.Bifoldable;
import scalaz.Bifunctor;
import scalaz.BijectionT;
import scalaz.Bind;
import scalaz.Catchable;
import scalaz.Contravariant;
import scalaz.Equal;
import scalaz.Foldable;
import scalaz.Foldable$;
import scalaz.Functor;
import scalaz.IndexedStateT;
import scalaz.IndexedStateT$;
import scalaz.InvariantFunctor;
import scalaz.Isomorphisms;
import scalaz.Kleisli;
import scalaz.Leibniz$;
import scalaz.Liskov;
import scalaz.Monad;
import scalaz.MonadPlus;
import scalaz.MonadState;
import scalaz.MonadState$;
import scalaz.MonadTrans;
import scalaz.NaturalTransformation;
import scalaz.NonEmptyList;
import scalaz.NonEmptyList$;
import scalaz.OptionT;
import scalaz.OptionT$;
import scalaz.Scalaz$;
import scalaz.Traverse;
import scalaz.Traverse1;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.stream.Process;
import scalaz.stream.Process$;
import scalaz.syntax.ApplicativeSyntax;
import scalaz.syntax.ApplySyntax;
import scalaz.syntax.BindSyntax;
import scalaz.syntax.CatchableSyntax;
import scalaz.syntax.EitherOps$;
import scalaz.syntax.FunctorSyntax;
import scalaz.syntax.InvariantFunctorSyntax;
import scalaz.syntax.MonadSyntax;
import scalaz.syntax.std.ListOps$;
import scalaz.syntax.std.OptionIdOps$;
import slamdata.Predef$;

public final class MongoDbIO$ {
    public static final MongoDbIO$ MODULE$;
    private final Object liftTask;
    private final Monad<MongoDbIO> mongoDbInstance;
    private final MongoDbIO<List<MongoCredential>> credentials;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new MongoDbIO$();
    }

    public Process<MongoDbIO, BsonDocument> aggregated(Collection src, List<Bson.Doc> pipeline, boolean allowDiskUse) {
        return ((Process)Scalaz$.MODULE$.ToMonadOps(this.aggregateIterable(src, pipeline, allowDiskUse), this.mongoDbInstance()).liftM((MonadTrans)Process$.MODULE$.processHoist())).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)it -> this.iterableToProcess((MongoIterable)it));
    }

    public MongoDbIO<BoxedUnit> aggregate(Collection src, List<Bson.Doc> pipeline, boolean allowDiskUse) {
        return (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.aggregateIterable(src, pipeline, allowDiskUse).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> {
            c.toCollection(x$2);
            return BoxedUnit.UNIT;
        })), this.mongoDbInstance()).void();
    }

    public MongoDbIO<Object> collectionExists(Collection c) {
        return (MongoDbIO)this.collectionsIn(c.database()).exists((Function1)(JFunction1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$10(c, x$3))).runLastOr((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, this.mongoDbInstance(), (Catchable)this.mongoDbInstance());
    }

    public Process<MongoDbIO, Collection> collections() {
        return this.databaseNames().flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)dbName -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$12(((DatabaseName)dbName).value()));
    }

    public Process<MongoDbIO, Collection> collectionsIn(String dbName) {
        return ((Process)Scalaz$.MODULE$.ToMonadOps(this.database(dbName), this.mongoDbInstance()).liftM((MonadTrans)Process$.MODULE$.processHoist())).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)db -> this.iterableToProcess(db.listCollectionNames()).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$4 -> new CollectionName(x$4))).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$5 -> MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$15(dbName, ((CollectionName)x$5).value()));
    }

    public MongoDbIO<BoxedUnit> createCollection(Collection c) {
        return this.database(c.database()).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)db -> (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$6 -> {
            db.createCollection(c.collection(), x$6);
            return BoxedUnit.UNIT;
        }), this.mongoDbInstance()).void());
    }

    public Process<MongoDbIO, String> databaseNames() {
        return ((Process)Scalaz$.MODULE$.ToMonadOps(this.client(), this.mongoDbInstance()).liftM((MonadTrans)Process$.MODULE$.processHoist())).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.iterableToProcess(c.listDatabaseNames()).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$7 -> new DatabaseName(x$7))).onFailure((Function1)(JFunction1 & Serializable & scala.Serializable)x0$2 -> {
            Throwable throwable = x0$2;
            Process process = throwable instanceof MongoCommandException ? ((Process)Scalaz$.MODULE$.ToMonadOps(this.credentials(), this.mongoDbInstance()).liftM((MonadTrans)Process$.MODULE$.processHoist())).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)ys -> Process$.MODULE$.emitAll((Seq)((SeqLike)ys.map((Function1)(JFunction1 & Serializable & scala.Serializable)y -> new DatabaseName(y.getSource()), List$.MODULE$.canBuildFrom())).distinct())) : Process$.MODULE$.fail(throwable);
            return process;
        });
    }

    public MongoDbIO<BoxedUnit> dropCollection(Collection c) {
        return this.collection(c).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)mc -> (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            mc.drop(x$1);
            return BoxedUnit.UNIT;
        }), this.mongoDbInstance()).void());
    }

    public MongoDbIO<BoxedUnit> dropDatabase(String named) {
        return this.database(named).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)d -> (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            d.drop(x$1);
            return BoxedUnit.UNIT;
        }), this.mongoDbInstance()).void());
    }

    public MongoDbIO<BoxedUnit> dropAllDatabases() {
        return (MongoDbIO)Process.EvalProcess$.MODULE$.eval$extension(Process$.MODULE$.EvalProcess(this.databaseNames().map((Function1)(JFunction1 & Serializable & scala.Serializable)named -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$27(((DatabaseName)named).value())))).run(this.mongoDbInstance(), (Catchable)this.mongoDbInstance());
    }

    public MongoDbIO<BoxedUnit> ensureCollection(Collection c) {
        return (MongoDbIO)Scalaz$.MODULE$.ToBindOps(this.collectionExists(c), this.mongoDbInstance()).ifM((Function0)(JFunction0 & Serializable & scala.Serializable)() -> (MongoDbIO)Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}).point(this.mongoDbInstance()), (Function0)(JFunction0 & Serializable & scala.Serializable)() -> this.createCollection(c), Leibniz$.MODULE$.refl());
    }

    public OptionT<MongoDbIO, String> firstWritableDb(String collName) {
        Bson.Doc testDoc = new Bson.Doc((ListMap<String, Bson>)((ListMap)Predef$.MODULE$.ListMap().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.extensionOps((Object)"a").$minus$greater((Object)new Bson.Int32(1))}))));
        return ((OptionT)this.databaseNames().translate(quasar.fp.package$.MODULE$.liftMT(this.mongoDbInstance(), (MonadTrans)OptionT$.MODULE$.optionTMonadTrans())).evalMap((Function1)(JFunction1 & Serializable & scala.Serializable)n -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$35(collName, testDoc, ((DatabaseName)n).value())).take(1).runLast((Monad)OptionT$.MODULE$.optionTMonadPlus(this.mongoDbInstance()), optionT$.MODULE$.optionTCatchable((Catchable)this.mongoDbInstance(), this.mongoDbInstance()))).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)n -> new OptionT(Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0 & Serializable & scala.Serializable)() -> n).point(this.mongoDbInstance())), this.mongoDbInstance());
    }

    public <F> MongoDbIO<BoxedUnit> insert(Collection coll, F docs, Foldable<F> evidence$1) {
        LinkedList docList = new LinkedList();
        InsertManyOptions insertOpts = new InsertManyOptions().ordered(false);
        Foldable$.MODULE$.apply(evidence$1).traverse_(docs, (Function1)(JFunction1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)docList.add(d)), (Applicative)scalaz.package$.MODULE$.idInstance());
        return docList.isEmpty() ? (MongoDbIO)Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}).point(this.mongoDbInstance()) : (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.collection(coll).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$9 -> {
            c.insertMany((java.util.List)docList, insertOpts, x$9);
            return BoxedUnit.UNIT;
        })), this.mongoDbInstance()).void();
    }

    public <F> OptionT<MongoDbIO, Object> insertAny(Collection coll, F docs, Foldable<F> evidence$2) {
        LinkedList docList = new LinkedList();
        BulkWriteOptions writeOpts = new BulkWriteOptions().ordered(false);
        Foldable$.MODULE$.apply(evidence$2).traverse_(docs, (Function1)(JFunction1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)docList.add(new InsertOneModel((Object)d))), (Applicative)scalaz.package$.MODULE$.idInstance());
        return docList.isEmpty() ? OptionT$.MODULE$.none(this.mongoDbInstance()) : new OptionT(this.collection(coll).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$10 -> {
            c.bulkWrite((java.util.List)docList, writeOpts, x$10);
            return BoxedUnit.UNIT;
        })).map((Function1)(JFunction1 & Serializable & scala.Serializable)r -> Scalaz$.MODULE$.ToBooleanOpsFromBoolean(r.wasAcknowledged()).option((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> r.getInsertedCount())));
    }

    public MongoDbIO<BoxedUnit> mapReduce(Collection src, MapReduce.OutputCollection dst, MapReduce cfg) {
        MonadState ms = MonadState$.MODULE$.apply(IndexedStateT$.MODULE$.stateMonad());
        return this.mapReduceIterable(src, cfg).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)it -> {
            MapReduceIterable itWithOutput = (MapReduceIterable)((IndexedStateT)Scalaz$.MODULE$.ToFoldableOps(dst.withAction(), (Foldable)Scalaz$.MODULE$.optionInstance()).traverse_((Function1)(JFunction1 & Serializable & scala.Serializable)actOut -> this.withAction$1((MapReduce.ActionedOutput)actOut, ms), (Applicative)IndexedStateT$.MODULE$.stateMonad())).exec((Object)it.collectionName(dst.collection()), (Monad)scalaz.package$.MODULE$.idInstance());
            return (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
                itWithOutput.toCollection(x$1);
                return BoxedUnit.UNIT;
            }), this.mongoDbInstance()).void();
        });
    }

    public MongoDbIO<BoxedUnit> rename(Collection src, Collection dst, RenameSemantics semantics) {
        boolean bl;
        RenameSemantics renameSemantics = semantics;
        if (RenameSemantics$Overwrite$.MODULE$.equals(renameSemantics)) {
            bl = true;
        } else if (RenameSemantics$FailIfExists$.MODULE$.equals(renameSemantics)) {
            bl = false;
        } else {
            throw new MatchError((Object)renameSemantics);
        }
        boolean dropDst = bl;
        return Scalaz$.MODULE$.ToEqualOps((Object)src, Collection$.MODULE$.order()).$eq$eq$eq((Object)dst) ? (MongoDbIO)Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}).point(this.mongoDbInstance()) : (MongoDbIO)Scalaz$.MODULE$.ToFunctorOps(this.collection(src).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$15 -> {
            c.renameCollection(dst.asNamespace(), new RenameCollectionOptions().dropTarget(dropDst), x$15);
            return BoxedUnit.UNIT;
        })), this.mongoDbInstance()).void();
    }

    public MongoDbIO<ServerVersion> serverVersion() {
        Function1 finalize = (Function1)(JFunction1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector errs = (Vector)tuple2._1();
            Vector vers = (Vector)tuple2._2();
            MongoDbIO mongoDbIO = (MongoDbIO)vers.headOption().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$18 -> (MongoDbIO)Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0 & Serializable & scala.Serializable)() -> x$18).point(this.mongoDbInstance())).orElse((Function0)(JFunction0 & Serializable & scala.Serializable)() -> errs.headOption().map((Function1)(JFunction1 & Serializable & scala.Serializable)msg -> this.fail((Throwable)new MongoException(msg)))).getOrElse((Function0)(JFunction0 & Serializable & scala.Serializable)() -> this.fail((Throwable)new MongoException("No database found.")));
            return mongoDbIO;
        };
        return ((MongoDbIO)this.databaseNames().$plus$plus((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Process$.MODULE$.emit((Object)new DatabaseName("admin"))).evalMap((Function1)(JFunction1 & Serializable & scala.Serializable)dbName -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$72(((DatabaseName)dbName).value())).takeThrough((Function1)(JFunction1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isLeft())).runLog(this.mongoDbInstance(), (Catchable)this.mongoDbInstance())).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$20 -> Scalaz$.MODULE$.ToMonadPlusOps((Object)x$20.toVector(), (MonadPlus)Scalaz$.MODULE$.vectorInstance()).separate(Leibniz$.MODULE$.refl(), (Bifoldable)$bslash$div$.MODULE$.DisjunctionInstances2())).flatMap(finalize);
    }

    public MongoDbIO<CollectionStatistics> collectionStatistics(Collection coll) {
        Bson.Doc cmd = new Bson.Doc((ListMap<String, Bson>)((ListMap)Predef$.MODULE$.ListMap().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.extensionOps((Object)"collStats").$minus$greater((Object)CollectionName$.MODULE$.bson$extension(coll.collection()))}))));
        return this.runCommand(coll.database(), cmd).map((Function1)(JFunction1 & Serializable & scala.Serializable)doc -> this.longValue$1((BsonDocument)doc, "count").flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)count -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$80((BsonDocument)doc, BoxesRunTime.unboxToLong((Object)count)))).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$24 -> (MongoDbIO)x$24.fold((Function1)(JFunction1 & Serializable & scala.Serializable)err -> this.fail((Throwable)new MongoException(new StringBuilder().append((Object)"could not read collection statistics: ").append(err).toString())), (Function1)(JFunction1 & Serializable & scala.Serializable)x$25 -> (MongoDbIO)Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0 & Serializable & scala.Serializable)() -> x$25).point(this.mongoDbInstance())));
    }

    private <A> MongoDbIO<List<A>> collect(MongoIterable<A> iter) {
        return this.async((Function1)(JFunction1 & Serializable & scala.Serializable)cb -> {
            iter.into(new ArrayList(), cb);
            return BoxedUnit.UNIT;
        }).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$26 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)x$26).asScala()).toList());
    }

    public MongoDbIO<Set<Index>> indexes(Collection coll) {
        scala.Serializable decodeType = new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                boolean bl = false;
                Number number = null;
                A1 A1 = x1;
                if (A1 instanceof Number) {
                    bl = true;
                    number = (Number)A1;
                    if (Scalaz$.MODULE$.ToEqualOps((Object)BoxesRunTime.boxToInteger((int)number.intValue()), (Equal)Scalaz$.MODULE$.intInstance()).$u225F((Object)BoxesRunTime.boxToInteger((int)1))) {
                        object = IndexType$Ascending$.MODULE$;
                        return (B1)object;
                    }
                }
                if (bl && Scalaz$.MODULE$.ToEqualOps((Object)BoxesRunTime.boxToInteger((int)number.intValue()), (Equal)Scalaz$.MODULE$.intInstance()).$u225F((Object)BoxesRunTime.boxToInteger((int)-1))) {
                    object = IndexType$Descending$.MODULE$;
                    return (B1)object;
                }
                if (!"hashed".equals(A1)) {
                    object = function1.apply(x1);
                    return (B1)object;
                }
                object = IndexType$Hashed$.MODULE$;
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x1) {
                boolean bl = false;
                Number number = null;
                Object object = x1;
                if (object instanceof Number) {
                    bl = true;
                    number = (Number)object;
                    if (Scalaz$.MODULE$.ToEqualOps((Object)BoxesRunTime.boxToInteger((int)number.intValue()), (Equal)Scalaz$.MODULE$.intInstance()).$u225F((Object)BoxesRunTime.boxToInteger((int)1))) return true;
                }
                if (bl) {
                    if (Scalaz$.MODULE$.ToEqualOps((Object)BoxesRunTime.boxToInteger((int)number.intValue()), (Equal)Scalaz$.MODULE$.intInstance()).$u225F((Object)BoxesRunTime.boxToInteger((int)-1))) return true;
                }
                if ("hashed".equals(object)) return true;
                return false;
            }
        };
        return this.collection(coll).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)c -> this.collect((MongoIterable)c.listIndexes())).map((Function1)((JFunction1 & Serializable & scala.Serializable)arg_0 -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$97((PartialFunction)decodeType, arg_0)));
    }

    public <A> MongoDbIO<A> fail(Throwable t) {
        return (MongoDbIO)this.liftTask().apply((Object)Task$.MODULE$.fail(t));
    }

    public Object runNT(MongoClient client) {
        return new NaturalTransformation<MongoDbIO, Task>(client){
            private final MongoClient client$1;

            public <E> NaturalTransformation<E, Task> compose(NaturalTransformation<E, MongoDbIO> f) {
                return NaturalTransformation.class.compose((NaturalTransformation)this, f);
            }

            public <H> NaturalTransformation<MongoDbIO, H> andThen(NaturalTransformation<Task, H> f) {
                return NaturalTransformation.class.andThen((NaturalTransformation)this, f);
            }

            public <A0$> Task<A0$> apply(MongoDbIO<A0$> x$32) {
                return x$32.run(this.client$1);
            }
            {
                this.client$1 = client$1;
                NaturalTransformation.class.$init$((NaturalTransformation)this);
            }
        };
    }

    public Object liftTask() {
        return this.liftTask;
    }

    public MongoDbIO<AggregateIterable<BsonDocument>> aggregateIterable(Collection src, List<Bson.Doc> pipeline, boolean allowDiskUse) {
        return this.collection(src).map((Function1)(JFunction1 & Serializable & scala.Serializable)c -> c.aggregate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pipeline).asJava()).allowDiskUse(new Boolean(allowDiskUse)));
    }

    public MongoDbIO<MapReduceIterable<BsonDocument>> mapReduceIterable(Collection src, MapReduce cfg) {
        MonadState ms = MonadState$.MODULE$.apply(IndexedStateT$.MODULE$.stateMonad());
        Option nonEmptyScope = Scalaz$.MODULE$.ToBooleanOpsFromBoolean(cfg.scope().nonEmpty()).option((Function0)(JFunction0 & Serializable & scala.Serializable)() -> cfg.scope());
        Option sortRepr = cfg.inputSort().map((Function1)(JFunction1 & Serializable & scala.Serializable)ts -> new Bson.Doc((ListMap<String, Bson>)((ListMap)Predef$.MODULE$.ListMap().apply((Seq)ts.list().toList().map((Function1)(JFunction1 & Serializable & scala.Serializable)x$35 -> (Tuple2)Scalaz$.MODULE$.ToBifunctorOps(x$35, (Bifunctor)Scalaz$.MODULE$.tuple2Bitraverse()).bimap((Function1)(JFunction1 & Serializable & scala.Serializable)x$36 -> x$36.asText(), (Function1)(JFunction1 & Serializable & scala.Serializable)x$37 -> package$.MODULE$.sortDirToBson((SortDir)x$37)), List$.MODULE$.canBuildFrom())))).repr());
        IndexedStateT configuredIt = (IndexedStateT)Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps((Object)this.foldIt$1(cfg.selection(), (Function2)(JFunction2 & Serializable & scala.Serializable)(i, s) -> i.filter((org.bson.conversions.Bson)s.bson().repr()), ms), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(sortRepr, (Function2)(JFunction2 & Serializable & scala.Serializable)(x$38, x$39) -> x$38.sort((org.bson.conversions.Bson)x$39), ms)), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(cfg.limit(), (Function2)(JFunction2 & Serializable & scala.Serializable)(x$40, x$41) -> x$40.limit((int)BoxesRunTime.unboxToLong((Object)x$41)), ms)), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(cfg.finalizer(), (Function2)(JFunction2 & Serializable & scala.Serializable)(i, f) -> i.finalizeFunction(f.pprint(0)), ms)), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(nonEmptyScope, (Function2)(JFunction2 & Serializable & scala.Serializable)(i, s) -> i.scope((org.bson.conversions.Bson)new Bson.Doc((ListMap<String, Bson>)s).repr()), ms)), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(cfg.jsMode(), (Function2)(JFunction2 & Serializable & scala.Serializable)(x$42, x$43) -> x$42.jsMode(BoxesRunTime.unboxToBoolean((Object)x$43)), ms)), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater((Object)this.foldIt$1(cfg.verbose(), (Function2)(JFunction2 & Serializable & scala.Serializable)(x$44, x$45) -> x$44.verbose(BoxesRunTime.unboxToBoolean((Object)x$45)), ms));
        return this.collection(src).map((Function1)(JFunction1 & Serializable & scala.Serializable)c -> (MapReduceIterable)configuredIt.exec((Object)c.mapReduce(cfg.map().pprint(0), cfg.reduce().pprint(0)), (Monad)scalaz.package$.MODULE$.idInstance()));
    }

    public MongoDbIO<FindIterable<BsonDocument>> find(Collection c) {
        return this.collection(c).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$46 -> x$46.find());
    }

    public <A> MongoDbIO<A> async(Function1<SingleResultCallback<A>, BoxedUnit> f) {
        return (MongoDbIO)this.liftTask().apply((Object)Task$.MODULE$.async((Function1)(JFunction1 & Serializable & scala.Serializable)cb -> {
            f.apply(new MongoDbIO.DisjunctionCallback(cb));
            return BoxedUnit.UNIT;
        }));
    }

    public Monad<MongoDbIO> mongoDbInstance() {
        return this.mongoDbInstance;
    }

    private <A> MongoDbIO<A> apply(Function1<MongoClient, A> f) {
        return this.quasar$physical$mongodb$MongoDbIO$$lift((Function1)(JFunction1 & Serializable & scala.Serializable)c -> Task$.MODULE$.delay((Function0)(JFunction0 & Serializable & scala.Serializable)() -> f.apply(c)));
    }

    public <A> MongoDbIO<A> quasar$physical$mongodb$MongoDbIO$$lift(Function1<MongoClient, Task<A>> f) {
        return new MongoDbIO(new Kleisli(f));
    }

    private MongoDbIO<MongoClient> client() {
        return this.apply(quasar.fp.ski.package$.MODULE$.\u03b9());
    }

    private MongoDbIO<List<MongoCredential>> credentials() {
        return this.credentials;
    }

    public MongoDbIO<MongoCollection<BsonDocument>> collection(Collection c) {
        return this.database(c.database()).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$49 -> x$49.getCollection(c.collection(), BsonDocument.class));
    }

    private MongoDbIO<MongoDatabase> database(String named) {
        return this.apply((Function1)(JFunction1 & Serializable & scala.Serializable)x$50 -> x$50.getDatabase(named));
    }

    private MongoDbIO<BsonDocument> runCommand(String dbName, Bson.Doc cmd) {
        return this.database(dbName).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)db -> this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$51 -> {
            db.runCommand((org.bson.conversions.Bson)cmd, BsonDocument.class, x$51);
            return BoxedUnit.UNIT;
        }));
    }

    private <A> Process<MongoDbIO, A> iterableToProcess(MongoIterable<A> it) {
        return Process$.MODULE$.eval(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            it.batchCursor(x$1);
            return BoxedUnit.UNIT;
        })).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)cur -> this.go$1((AsyncBatchCursor)cur).onComplete((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Process$.MODULE$.eval_(MODULE$.apply((Function1)(JFunction1 & Serializable & scala.Serializable)x$52 -> {
            cur.close();
            return BoxedUnit.UNIT;
        }))));
    }

    public static final /* synthetic */ boolean quasar$physical$mongodb$MongoDbIO$$$anonfun$10(Collection c$1, Collection x$3) {
        String string = x$3.collection();
        String string2 = c$1.collection();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    public final /* synthetic */ Process quasar$physical$mongodb$MongoDbIO$$$anonfun$12(String dbName) {
        return this.collectionsIn(dbName);
    }

    public static final /* synthetic */ Collection quasar$physical$mongodb$MongoDbIO$$$anonfun$15(String dbName$1, String x$5) {
        return new Collection(dbName$1, x$5);
    }

    public final /* synthetic */ MongoDbIO quasar$physical$mongodb$MongoDbIO$$$anonfun$27(String named) {
        return this.dropDatabase(named);
    }

    private final OptionT canWriteToCol$1(Collection coll, Bson.Doc testDoc$1) {
        return ((OptionT)Scalaz$.MODULE$.ToCatchableOps(Scalaz$.MODULE$.ToFunctorOps((Object)this.insertAny(coll, (Object)testDoc$1.repr(), (Foldable)scalaz.package$.MODULE$.idInstance()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 == 1, this.mongoDbInstance()), (Functor)OptionT$.MODULE$.optionTMonadPlus(this.mongoDbInstance())).as((Function0)(JFunction0 & Serializable & scala.Serializable)() -> new DatabaseName(coll.database())), optionT$.MODULE$.optionTCatchable((Catchable)this.mongoDbInstance(), this.mongoDbInstance())).attempt()).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)r -> new OptionT(Scalaz$.MODULE$.ApplicativeIdV((Function0)(JFunction0 & Serializable & scala.Serializable)() -> r.toOption()).point(this.mongoDbInstance())), this.mongoDbInstance());
    }

    public final /* synthetic */ OptionT quasar$physical$mongodb$MongoDbIO$$$anonfun$35(String collName$1, Bson.Doc testDoc$1, String n) {
        return this.canWriteToCol$1(new Collection(n, collName$1), testDoc$1);
    }

    public static final /* synthetic */ IndexedStateT quasar$physical$mongodb$MongoDbIO$$$anonfun$47(MonadState ms$1, String n) {
        return (IndexedStateT)ms$1.modify((Function1)(JFunction1 & Serializable & scala.Serializable)x$11 -> x$11.databaseName(n));
    }

    public static final /* synthetic */ IndexedStateT quasar$physical$mongodb$MongoDbIO$$$anonfun$49(MonadState ms$1, boolean s) {
        return (IndexedStateT)ms$1.modify((Function1)(JFunction1 & Serializable & scala.Serializable)x$12 -> x$12.sharded(s));
    }

    public static final /* synthetic */ IndexedStateT quasar$physical$mongodb$MongoDbIO$$$anonfun$51(MonadState ms$1, boolean s) {
        return (IndexedStateT)ms$1.modify((Function1)(JFunction1 & Serializable & scala.Serializable)x$13 -> x$13.nonAtomic(s));
    }

    private final IndexedStateT withAction$1(MapReduce.ActionedOutput actOut, MonadState ms$1) {
        return (IndexedStateT)Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToApplyOps(Scalaz$.MODULE$.ToFoldableOps(actOut.database(), (Foldable)Scalaz$.MODULE$.optionInstance()).traverse_((Function1)(JFunction1 & Serializable & scala.Serializable)n -> MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$47(ms$1, ((DatabaseName)n).value()), (Applicative)IndexedStateT$.MODULE$.stateMonad()), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater(Scalaz$.MODULE$.ToFoldableOps(actOut.shardOutputCollection(), (Foldable)Scalaz$.MODULE$.optionInstance()).traverse_((Function1)(JFunction1 & Serializable & scala.Serializable)s -> MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$49(ms$1, BoxesRunTime.unboxToBoolean((Object)s)), (Applicative)IndexedStateT$.MODULE$.stateMonad())), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater(Scalaz$.MODULE$.ToFoldableOps(actOut.action().nonAtomic(), (Foldable)Scalaz$.MODULE$.optionInstance()).traverse_((Function1)(JFunction1 & Serializable & scala.Serializable)s -> MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$51(ms$1, BoxesRunTime.unboxToBoolean((Object)s)), (Applicative)IndexedStateT$.MODULE$.stateMonad())), (Apply)IndexedStateT$.MODULE$.stateMonad()).$times$greater(ms$1.modify((Function1)(JFunction1 & Serializable & scala.Serializable)x$14 -> {
            MapReduceAction mapReduceAction;
            MapReduce.Action action = actOut.action();
            if (MapReduce$Action$Replace$.MODULE$.equals(action)) {
                mapReduceAction = MapReduceAction.REPLACE;
            } else if (action instanceof MapReduce.Action.Merge) {
                mapReduceAction = MapReduceAction.MERGE;
            } else if (action instanceof MapReduce.Action.Reduce) {
                mapReduceAction = MapReduceAction.REDUCE;
            } else {
                throw new MatchError((Object)action);
            }
            return x$14.action(mapReduceAction);
        }));
    }

    private final MongoDbIO lookupVersion$1(String dbName) {
        Bson.Doc cmd = new Bson.Doc((ListMap<String, Bson>)((ListMap)Predef$.MODULE$.ListMap().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.extensionOps((Object)"buildinfo").$minus$greater((Object)new Bson.Int32(1))}))));
        return ((MongoDbIO)this.runCommand(dbName, cmd).attemptMongo().run()).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$16 -> x$16.leftMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$17 -> x$17.cause().getMessage()).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)doc -> Scalaz$.MODULE$.ToOptionOpsFromOption(Predef$.MODULE$.Option().apply((Object)doc.getString((Object)"version"))).toRightDisjunction((Function0)(JFunction0 & Serializable & scala.Serializable)() -> "Unable to determine server version, buildInfo response is missing the 'version' field").flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)v -> ServerVersion$.MODULE$.fromString(v.getValue()))));
    }

    public final /* synthetic */ MongoDbIO quasar$physical$mongodb$MongoDbIO$$$anonfun$72(String dbName) {
        return this.lookupVersion$1(dbName);
    }

    private final .bslash.div longValue$1(BsonDocument doc, String field) {
        return (.bslash.div)$bslash$div$.MODULE$.fromTryCatchNonFatal((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Scalaz$.MODULE$.ToOptionOpsFromOption(Predef$.MODULE$.Option().apply((Object)doc.getNumber((Object)field)).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)x$21.longValue()))).$bslash$div$greater((Function0)(JFunction0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected field: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{field})))).fold((Function1)(JFunction1 & Serializable & scala.Serializable)x$22 -> EitherOps$.MODULE$.left$extension(Scalaz$.MODULE$.ToEitherOps((Object)x$22.getMessage())), quasar.fp.ski.package$.MODULE$.\u03b9());
    }

    private final boolean booleanValue$1(BsonDocument doc, String field) {
        BsonValue bsonValue = doc.get((Object)field, (BsonValue)BsonBoolean.FALSE);
        BsonBoolean bsonBoolean = BsonBoolean.FALSE;
        return bsonValue == null ? bsonBoolean != null : !bsonValue.equals(bsonBoolean);
    }

    public final /* synthetic */ Tuple2 quasar$physical$mongodb$MongoDbIO$$$anonfun$81(BsonDocument doc$3, long dataSize) {
        boolean sharded = this.booleanValue$1(doc$3, "sharded");
        return new Tuple2.mcJZ.sp(dataSize, sharded);
    }

    public final /* synthetic */ .bslash.div quasar$physical$mongodb$MongoDbIO$$$anonfun$80(BsonDocument doc$3, long count) {
        return this.longValue$1(doc$3, "size").map((Function1)(JFunction1 & Serializable & scala.Serializable)dataSize -> this.quasar$physical$mongodb$MongoDbIO$$$anonfun$81(doc$3, BoxesRunTime.unboxToLong((Object)dataSize))).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$23 -> {
            Tuple2 tuple2 = x$23;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long dataSize = tuple2._1$mcJ$sp();
            boolean sharded = tuple2._2$mcZ$sp();
            CollectionStatistics collectionStatistics = new CollectionStatistics(count, dataSize, sharded);
            return collectionStatistics;
        });
    }

    private final BsonField decodeField$1(String s) {
        return new BsonField.Name(s);
    }

    public static final /* synthetic */ boolean quasar$physical$mongodb$MongoDbIO$$$anonfun$95(Object x0$7) {
        Object object = x0$7;
        boolean bl = BoxesRunTime.equals((Object)Boolean.TRUE, (Object)object);
        return bl;
    }

    private final Option decodeIndex$1(Document doc, PartialFunction decodeType$1) {
        return (Option)Scalaz$.MODULE$.ToApplyOps((Object)Predef$.MODULE$.Option().apply(doc.get((Object)"name")).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x0$4 -> {
            None$ none$;
            Object object = x0$4;
            if (object instanceof String) {
                String string = (String)object;
                none$ = OptionIdOps$.MODULE$.some$extension(Scalaz$.MODULE$.ToOptionIdOps((Object)string));
            } else {
                none$ = Predef$.MODULE$.None();
            }
            return none$;
        }), (Apply)Scalaz$.MODULE$.optionInstance()).$u229B((Object)Predef$.MODULE$.Option().apply(doc.get((Object)"key")).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x0$5 -> {
            None$ none$;
            Object object = x0$5;
            if (object instanceof Document) {
                Document document = (Document)object;
                none$ = ListOps$.MODULE$.toNel$extension(Scalaz$.MODULE$.ToListOpsFromList(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)document).asScala()).toList())).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$27 -> (Option)Scalaz$.MODULE$.ToTraverseOps(x$27, (Traverse)NonEmptyList$.MODULE$.nonEmptyList()).traverse((Function1)(JFunction1 & Serializable & scala.Serializable)x0$6 -> {
                    Tuple2 tuple2 = x0$6;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    Option option = (Option)Scalaz$.MODULE$.ToFunctorOps(decodeType$1.lift().apply(v), (Functor)Scalaz$.MODULE$.optionInstance()).strengthL((Object)this.decodeField$1(k));
                    return option;
                }, (Applicative)Scalaz$.MODULE$.optionInstance()));
            } else {
                none$ = Predef$.MODULE$.None();
            }
            return none$;
        })).apply((Function2)(JFunction2 & Serializable & scala.Serializable)(x$28, x$29) -> new Index((String)x$28, (NonEmptyList<Tuple2<BsonField, IndexType>>)x$29, BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.Option().apply(doc.get((Object)"unique")).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToBoolean((boolean)MongoDbIO$.quasar$physical$mongodb$MongoDbIO$$$anonfun$95(x0$7))))), (Apply)Scalaz$.MODULE$.optionInstance());
    }

    public final /* synthetic */ Set quasar$physical$mongodb$MongoDbIO$$$anonfun$97(PartialFunction decodeType$1, List x$30) {
        return ((TraversableOnce)x$30.flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$31 -> this.decodeIndex$1((Document)x$31, decodeType$1).toList(), List$.MODULE$.canBuildFrom())).toSet();
    }

    private final IndexedStateT foldIt$1(Option a, Function2 f, MonadState ms$2) {
        return (IndexedStateT)ms$2.modify((Function1)(JFunction1 & Serializable & scala.Serializable)x$34 -> (MapReduceIterable)Scalaz$.MODULE$.ToFoldableOps((Object)a, (Foldable)Scalaz$.MODULE$.optionInstance()).foldLeft(x$34, f));
    }

    private final Process go$1(AsyncBatchCursor c) {
        return Process$.MODULE$.eval(this.async((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> {
            c.next(x$1);
            return BoxedUnit.UNIT;
        })).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)r -> (Process)Scalaz$.MODULE$.ToOptionOpsFromOption(Predef$.MODULE$.Option().apply(r)).cata((Function1)(JFunction1 & Serializable & scala.Serializable)as -> Process$.MODULE$.emitAll((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(as).asScala()).toVector()).$plus$plus((Function0)(JFunction0 & Serializable & scala.Serializable)() -> this.go$1(c)), (Function0)(JFunction0 & Serializable & scala.Serializable)() -> Process$.MODULE$.halt()));
    }

    private MongoDbIO$() {
        MODULE$ = this;
        this.liftTask = new NaturalTransformation<Task, MongoDbIO>(){
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public <E> NaturalTransformation<E, MongoDbIO> compose(NaturalTransformation<E, Task> f) {
                return NaturalTransformation.class.compose((NaturalTransformation)this, f);
            }

            public <H> NaturalTransformation<Task, H> andThen(NaturalTransformation<MongoDbIO, H> f) {
                return NaturalTransformation.class.andThen((NaturalTransformation)this, f);
            }

            public <A1$> MongoDbIO<A1$> apply(Task<A1$> t) {
                return MongoDbIO$.MODULE$.quasar$physical$mongodb$MongoDbIO$$lift((Function1)(JFunction1 & Serializable & scala.Serializable)x$33 -> t);
            }
            {
                NaturalTransformation.class.$init$((NaturalTransformation)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        };
        this.mongoDbInstance = new Monad<MongoDbIO>(){
            private final Object catchableSyntax;
            private final Object monadSyntax;
            private final Object bindSyntax;
            private final Object applicativeSyntax;
            private final Object applySyntax;
            private final Object functorSyntax;
            private final Object invariantFunctorSyntax;
            private static /* synthetic */ Map $deserializeLambdaCache$;

            public Object catchableSyntax() {
                return this.catchableSyntax;
            }

            public void scalaz$Catchable$_setter_$catchableSyntax_$eq(CatchableSyntax x$1) {
                this.catchableSyntax = x$1;
            }

            public Object monadSyntax() {
                return this.monadSyntax;
            }

            public void scalaz$Monad$_setter_$monadSyntax_$eq(MonadSyntax x$1) {
                this.monadSyntax = x$1;
            }

            public Object whileM(Object p, Function0 body, MonadPlus G) {
                return Monad.class.whileM((Monad)this, (Object)p, (Function0)body, (MonadPlus)G);
            }

            public Object whileM_(Object p, Function0 body) {
                return Monad.class.whileM_((Monad)this, (Object)p, (Function0)body);
            }

            public Object untilM(Object f, Function0 cond, MonadPlus G) {
                return Monad.class.untilM((Monad)this, (Object)f, (Function0)cond, (MonadPlus)G);
            }

            public Object untilM_(Object f, Function0 cond) {
                return Monad.class.untilM_((Monad)this, (Object)f, (Function0)cond);
            }

            public Object iterateWhile(Object f, Function1 p) {
                return Monad.class.iterateWhile((Monad)this, (Object)f, (Function1)p);
            }

            public Object iterateUntil(Object f, Function1 p) {
                return Monad.class.iterateUntil((Monad)this, (Object)f, (Function1)p);
            }

            public <G> Monad<?> product(Monad<G> G0) {
                return Monad.class.product((Monad)this, G0);
            }

            public Object monadLaw() {
                return Monad.class.monadLaw((Monad)this);
            }

            public Object bindSyntax() {
                return this.bindSyntax;
            }

            public void scalaz$Bind$_setter_$bindSyntax_$eq(BindSyntax x$1) {
                this.bindSyntax = x$1;
            }

            public Object ap(Function0 fa, Function0 f) {
                return Bind.class.ap((Bind)this, (Function0)fa, (Function0)f);
            }

            public Object join(Object ffa) {
                return Bind.class.join((Bind)this, (Object)ffa);
            }

            public Object ifM(Object value, Function0 ifTrue, Function0 ifFalse) {
                return Bind.class.ifM((Bind)this, (Object)value, (Function0)ifTrue, (Function0)ifFalse);
            }

            public Object forever(Object fa) {
                return Bind.class.forever((Bind)this, (Object)fa);
            }

            public Object mproduct(Object fa, Function1 f) {
                return Bind.class.mproduct((Bind)this, (Object)fa, (Function1)f);
            }

            public <G> Bind<?> product(Bind<G> G0) {
                return Bind.class.product((Bind)this, G0);
            }

            public Object bindLaw() {
                return Bind.class.bindLaw((Bind)this);
            }

            public Object applicativeSyntax() {
                return this.applicativeSyntax;
            }

            public void scalaz$Applicative$_setter_$applicativeSyntax_$eq(ApplicativeSyntax x$1) {
                this.applicativeSyntax = x$1;
            }

            public final Object pure(Function0 a) {
                return Applicative.class.pure((Applicative)this, (Function0)a);
            }

            public Object apply2(Function0 fa, Function0 fb, Function2 f) {
                return Applicative.class.apply2((Applicative)this, (Function0)fa, (Function0)fb, (Function2)f);
            }

            public Object traverse(Object value, Function1 f, Traverse G) {
                return Applicative.class.traverse((Applicative)this, (Object)value, (Function1)f, (Traverse)G);
            }

            public Object sequence(Object as, Traverse evidence$1) {
                return Applicative.class.sequence((Applicative)this, (Object)as, (Traverse)evidence$1);
            }

            public Object replicateM(int n, Object fa) {
                return Applicative.class.replicateM((Applicative)this, (int)n, (Object)fa);
            }

            public Object replicateM_(int n, Object fa) {
                return Applicative.class.replicateM_((Applicative)this, (int)n, (Object)fa);
            }

            public Object filterM(List l, Function1 f) {
                return Applicative.class.filterM((Applicative)this, (List)l, (Function1)f);
            }

            public Object unlessM(boolean cond, Function0 f) {
                return Applicative.class.unlessM((Applicative)this, (boolean)cond, (Function0)f);
            }

            public Object whenM(boolean cond, Function0 f) {
                return Applicative.class.whenM((Applicative)this, (boolean)cond, (Function0)f);
            }

            public <G> Applicative<?> compose(Applicative<G> G0) {
                return Applicative.class.compose((Applicative)this, G0);
            }

            public <G> Applicative<?> product(Applicative<G> G0) {
                return Applicative.class.product((Applicative)this, G0);
            }

            public Applicative<MongoDbIO> flip() {
                return Applicative.class.flip((Applicative)this);
            }

            public Object applicativeLaw() {
                return Applicative.class.applicativeLaw((Applicative)this);
            }

            public Object applySyntax() {
                return this.applySyntax;
            }

            public void scalaz$Apply$_setter_$applySyntax_$eq(ApplySyntax x$1) {
                this.applySyntax = x$1;
            }

            public Object traverse1(Object value, Function1 f, Traverse1 G) {
                return Apply.class.traverse1((Apply)this, (Object)value, (Function1)f, (Traverse1)G);
            }

            public Object sequence1(Object as, Traverse1 evidence$1) {
                return Apply.class.sequence1((Apply)this, (Object)as, (Traverse1)evidence$1);
            }

            public <G> Apply<?> compose(Apply<G> G0) {
                return Apply.class.compose((Apply)this, G0);
            }

            public <G> Apply<?> product(Apply<G> G0) {
                return Apply.class.product((Apply)this, G0);
            }

            public <A, B> Function1<MongoDbIO<A>, MongoDbIO<B>> apF(Function0<MongoDbIO<Function1<A, B>>> f) {
                return Apply.class.apF((Apply)this, f);
            }

            public Object ap2(Function0 fa, Function0 fb, Object f) {
                return Apply.class.ap2((Apply)this, (Function0)fa, (Function0)fb, (Object)f);
            }

            public Object ap3(Function0 fa, Function0 fb, Function0 fc, Object f) {
                return Apply.class.ap3((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Object)f);
            }

            public Object ap4(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Object f) {
                return Apply.class.ap4((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Object)f);
            }

            public Object ap5(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Object f) {
                return Apply.class.ap5((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Object)f);
            }

            public Object ap6(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Object f) {
                return Apply.class.ap6((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Object)f);
            }

            public Object ap7(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Object f) {
                return Apply.class.ap7((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Object)f);
            }

            public Object ap8(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Object f) {
                return Apply.class.ap8((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Object)f);
            }

            public Object apply3(Function0 fa, Function0 fb, Function0 fc, Function3 f) {
                return Apply.class.apply3((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function3)f);
            }

            public Object apply4(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function4 f) {
                return Apply.class.apply4((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function4)f);
            }

            public Object apply5(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function5 f) {
                return Apply.class.apply5((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function5)f);
            }

            public Object apply6(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function6 f) {
                return Apply.class.apply6((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function6)f);
            }

            public Object apply7(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function7 f) {
                return Apply.class.apply7((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function7)f);
            }

            public Object apply8(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Function8 f) {
                return Apply.class.apply8((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Function8)f);
            }

            public Object apply9(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Function0 fi, Function9 f) {
                return Apply.class.apply9((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Function0)fi, (Function9)f);
            }

            public Object apply10(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Function0 fi, Function0 fj, Function10 f) {
                return Apply.class.apply10((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Function0)fi, (Function0)fj, (Function10)f);
            }

            public Object apply11(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Function0 fi, Function0 fj, Function0 fk, Function11 f) {
                return Apply.class.apply11((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Function0)fi, (Function0)fj, (Function0)fk, (Function11)f);
            }

            public Object apply12(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe, Function0 ff, Function0 fg, Function0 fh, Function0 fi, Function0 fj, Function0 fk, Function0 fl, Function12 f) {
                return Apply.class.apply12((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe, (Function0)ff, (Function0)fg, (Function0)fh, (Function0)fi, (Function0)fj, (Function0)fk, (Function0)fl, (Function12)f);
            }

            public Object tuple2(Function0 fa, Function0 fb) {
                return Apply.class.tuple2((Apply)this, (Function0)fa, (Function0)fb);
            }

            public Object tuple3(Function0 fa, Function0 fb, Function0 fc) {
                return Apply.class.tuple3((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc);
            }

            public Object tuple4(Function0 fa, Function0 fb, Function0 fc, Function0 fd) {
                return Apply.class.tuple4((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd);
            }

            public Object tuple5(Function0 fa, Function0 fb, Function0 fc, Function0 fd, Function0 fe) {
                return Apply.class.tuple5((Apply)this, (Function0)fa, (Function0)fb, (Function0)fc, (Function0)fd, (Function0)fe);
            }

            public <A, B, C> Function2<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>> lift2(Function2<A, B, C> f) {
                return Apply.class.lift2((Apply)this, f);
            }

            public <A, B, C, D> Function3<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>> lift3(Function3<A, B, C, D> f) {
                return Apply.class.lift3((Apply)this, f);
            }

            public <A, B, C, D, E> Function4<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>> lift4(Function4<A, B, C, D, E> f) {
                return Apply.class.lift4((Apply)this, f);
            }

            public <A, B, C, D, E, R> Function5<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<R>> lift5(Function5<A, B, C, D, E, R> f) {
                return Apply.class.lift5((Apply)this, f);
            }

            public <A, B, C, D, E, FF, R> Function6<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<R>> lift6(Function6<A, B, C, D, E, FF, R> f) {
                return Apply.class.lift6((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, R> Function7<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<R>> lift7(Function7<A, B, C, D, E, FF, G, R> f) {
                return Apply.class.lift7((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, H, R> Function8<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<H>, MongoDbIO<R>> lift8(Function8<A, B, C, D, E, FF, G, H, R> f) {
                return Apply.class.lift8((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, H, I, R> Function9<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<H>, MongoDbIO<I>, MongoDbIO<R>> lift9(Function9<A, B, C, D, E, FF, G, H, I, R> f) {
                return Apply.class.lift9((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, H, I, J, R> Function10<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<H>, MongoDbIO<I>, MongoDbIO<J>, MongoDbIO<R>> lift10(Function10<A, B, C, D, E, FF, G, H, I, J, R> f) {
                return Apply.class.lift10((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, H, I, J, K, R> Function11<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<H>, MongoDbIO<I>, MongoDbIO<J>, MongoDbIO<K>, MongoDbIO<R>> lift11(Function11<A, B, C, D, E, FF, G, H, I, J, K, R> f) {
                return Apply.class.lift11((Apply)this, f);
            }

            public <A, B, C, D, E, FF, G, H, I, J, K, L, R> Function12<MongoDbIO<A>, MongoDbIO<B>, MongoDbIO<C>, MongoDbIO<D>, MongoDbIO<E>, MongoDbIO<FF>, MongoDbIO<G>, MongoDbIO<H>, MongoDbIO<I>, MongoDbIO<J>, MongoDbIO<K>, MongoDbIO<L>, MongoDbIO<R>> lift12(Function12<A, B, C, D, E, FF, G, H, I, J, K, L, R> f) {
                return Apply.class.lift12((Apply)this, f);
            }

            public Applicative<?> applyApplicative() {
                return Apply.class.applyApplicative((Apply)this);
            }

            public Object applyLaw() {
                return Apply.class.applyLaw((Apply)this);
            }

            public Object functorSyntax() {
                return this.functorSyntax;
            }

            public void scalaz$Functor$_setter_$functorSyntax_$eq(FunctorSyntax x$1) {
                this.functorSyntax = x$1;
            }

            public Object xmap(Object fa, Function1 f, Function1 g) {
                return Functor.class.xmap((Functor)this, (Object)fa, (Function1)f, (Function1)g);
            }

            public Object apply(Object fa, Function1 f) {
                return Functor.class.apply((Functor)this, (Object)fa, (Function1)f);
            }

            public <A, B> Function1<MongoDbIO<A>, MongoDbIO<B>> lift(Function1<A, B> f) {
                return Functor.class.lift((Functor)this, f);
            }

            public Object strengthL(Object a, Object f) {
                return Functor.class.strengthL((Functor)this, (Object)a, (Object)f);
            }

            public Object strengthR(Object f, Object b) {
                return Functor.class.strengthR((Functor)this, (Object)f, (Object)b);
            }

            public Object mapply(Object a, Object f) {
                return Functor.class.mapply((Functor)this, (Object)a, (Object)f);
            }

            public Object fpair(Object fa) {
                return Functor.class.fpair((Functor)this, (Object)fa);
            }

            public Object fproduct(Object fa, Function1 f) {
                return Functor.class.fproduct((Functor)this, (Object)fa, (Function1)f);
            }

            public Object void(Object fa) {
                return Functor.class.void((Functor)this, (Object)fa);
            }

            public Object counzip(.bslash.div a) {
                return Functor.class.counzip((Functor)this, (.bslash.div)a);
            }

            public <G> Functor<?> compose(Functor<G> G0) {
                return Functor.class.compose((Functor)this, G0);
            }

            public <G> Contravariant<?> icompose(Contravariant<G> G0) {
                return Functor.class.icompose((Functor)this, G0);
            }

            public <G> Bifunctor<?> bicompose(Bifunctor<G> evidence$1) {
                return Functor.class.bicompose((Functor)this, evidence$1);
            }

            public <G> Functor<?> product(Functor<G> G0) {
                return Functor.class.product((Functor)this, G0);
            }

            public Object widen(Object fa, Liskov ev) {
                return Functor.class.widen((Functor)this, (Object)fa, (Liskov)ev);
            }

            public Object functorLaw() {
                return Functor.class.functorLaw((Functor)this);
            }

            public Object invariantFunctorSyntax() {
                return this.invariantFunctorSyntax;
            }

            public void scalaz$InvariantFunctor$_setter_$invariantFunctorSyntax_$eq(InvariantFunctorSyntax x$1) {
                this.invariantFunctorSyntax = x$1;
            }

            public Object xmapb(Object ma, BijectionT b) {
                return InvariantFunctor.class.xmapb((InvariantFunctor)this, (Object)ma, (BijectionT)b);
            }

            public Object xmapi(Object ma, Isomorphisms.Iso iso) {
                return InvariantFunctor.class.xmapi((InvariantFunctor)this, (Object)ma, (Isomorphisms.Iso)iso);
            }

            public Object invariantFunctorLaw() {
                return InvariantFunctor.class.invariantFunctorLaw((InvariantFunctor)this);
            }

            public <A, B> MongoDbIO<B> map(MongoDbIO<A> fa, Function1<A, B> f) {
                return fa.map(f);
            }

            public <A> MongoDbIO<A> point(Function0<A> a) {
                return new MongoDbIO<A>(new Kleisli((Function1)(JFunction1 & Serializable & scala.Serializable)x$47 -> Task$.MODULE$.now(a.apply())));
            }

            public <A, B> MongoDbIO<B> bind(MongoDbIO<A> fa, Function1<A, MongoDbIO<B>> f) {
                return fa.flatMap(f);
            }

            public <A> MongoDbIO<A> fail(Throwable t) {
                return MongoDbIO$.MODULE$.fail(t);
            }

            public <A> MongoDbIO<.bslash.div<Throwable, A>> attempt(MongoDbIO<A> fa) {
                return fa.attempt();
            }
            {
                InvariantFunctor.class.$init$((InvariantFunctor)this);
                Functor.class.$init$((Functor)this);
                Apply.class.$init$((Apply)this);
                Applicative.class.$init$((Applicative)this);
                Bind.class.$init$((Bind)this);
                Monad.class.$init$((Monad)this);
                Catchable.class.$init$((Catchable)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                HashMap<K, V> hashMap = $deserializeLambdaCache$;
                if (hashMap == null) {
                    $deserializeLambdaCache$ = hashMap = new HashMap<K, V>();
                }
                return LambdaDeserializer$.MODULE$.deserializeLambda(MethodHandles.lookup(), hashMap, serializedLambda);
            }
        };
        this.credentials = this.apply((Function1)(JFunction1 & Serializable & scala.Serializable)x$48 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$48.getSettings().getCredentialList()).asScala()).toList());
    }
}

