/*
 * Decompiled with CFR 0.152.
 */
package quasar.physical.mongodb;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactoryFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import quasar.config.ConfigError$;
import quasar.connector.EnvironmentError$;
import quasar.console$;
import quasar.effect.Failure;
import quasar.fp.free.lift$;
import quasar.physical.mongodb.MongoDbIO$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scalaz.;
import scalaz.Applicative;
import scalaz.Apply;
import scalaz.Free;
import scalaz.Free$;
import scalaz.Inject;
import scalaz.Liskov$;
import scalaz.concurrent.Strategy$;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scalaz.syntax.package$;
import slamdata.Predef$;

public final class util$ {
    public static final util$ MODULE$;
    private final int defaultTimeoutMillis;
    private static /* synthetic */ Map $deserializeLambdaCache$;

    static {
        new util$();
    }

    public <S> Free<S, MongoClient> createAsyncMongoClient(String uri, Inject<Task, S> S0, Inject<?, S> S1, Inject<?, S> S2) {
        Failure.Ops cfgErr = Failure.Ops$.MODULE$.apply(S2);
        Failure.Ops envErr = Failure.Ops$.MODULE$.apply(S1);
        Free disableLogging = lift$.MODULE$.apply(this.disableMongoLogging()).into(S0);
        Free connString = this.liftAndHandle(Task$.MODULE$.delay((Function0)(JFunction0 & Serializable & scala.Serializable)() -> new ConnectionString(uri)), (Function1)(JFunction1 & Serializable & scala.Serializable)t -> cfgErr.fail(ConfigError$.MODULE$.malformedConfig().apply((Object)uri, (Object)t.getMessage(), Liskov$.MODULE$.refl())), S0);
        String InvalidHostNameAllowedProp = "invalidHostNameAllowed";
        return ((Free)package$.MODULE$.applicative().ToApplyOps((Object)disableLogging, (Apply)Free$.MODULE$.freeMonad()).$times$greater(connString)).$greater$greater$eq((Function1)(JFunction1 & Serializable & scala.Serializable)cs -> this.createClient$1((ConnectionString)cs, S0, envErr, InvalidHostNameAllowedProp));
    }

    private int defaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    private Task<BoxedUnit> disableMongoLogging() {
        return Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Logger.getLogger("org.mongodb").setLevel(Level.WARNING));
    }

    private <S, A> Free<S, A> liftAndHandle(Task<A> ta, Function1<Throwable, Free<S, A>> f, Inject<Task, S> S0) {
        return lift$.MODULE$.apply((Object)ta.attempt()).into(S0).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> (Free)x$1.fold(f, (Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> (Free)package$.MODULE$.applicative().ApplicativeIdV((Function0)(JFunction0 & Serializable & scala.Serializable)() -> x$2).point((Applicative)Free$.MODULE$.freeMonad())));
    }

    private final Task testConnection$1(MongoClient aclient) {
        return MongoDbIO$.MODULE$.serverVersion().run(aclient).timed((long)this.defaultTimeoutMillis(), Strategy$.MODULE$.DefaultTimeoutScheduler()).attempt().flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)x0$1 -> {
            boolean bl = false;
            .minus.bslash.div div2 = null;
            .bslash.div div3 = x0$1;
            if (div3 instanceof .minus.bslash.div) {
                bl = true;
                div2 = (.minus.bslash.div)div3;
                Throwable tout = (Throwable)div2.a();
                if (tout instanceof TimeoutException) {
                    String hosts = aclient.getSettings().getClusterSettings().getHosts().toString();
                    return Task$.MODULE$.fail((Throwable)new TimeoutException(Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out attempting to connect to: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{hosts}))));
                }
            }
            if (bl) {
                Throwable t = (Throwable)div2.a();
                return Task$.MODULE$.fail(t);
            }
            if (div3 instanceof .bslash.div.minus) return Task$.MODULE$.now((Object)BoxedUnit.UNIT);
            throw new MatchError((Object)div3);
        });
    }

    private final Task settings$1(ConnectionString cs, boolean invalidHostNameAllowed) {
        return Task$.MODULE$.delay((Function0)(JFunction0 & Serializable & scala.Serializable)() -> {
            MongoClientSettings.Builder settings = MongoClientSettings.builder();
            settings.clusterSettings(ClusterSettings.builder().applyConnectionString(cs).build());
            settings.connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(cs).build());
            settings.credentialList(cs.getCredentialList());
            settings.serverSettings(ServerSettings.builder().build());
            settings.socketSettings(SocketSettings.builder().applyConnectionString(cs).build());
            SslSettings sslSettings = SslSettings.builder().applyConnectionString(cs).invalidHostNameAllowed(invalidHostNameAllowed).build();
            settings.sslSettings(sslSettings);
            Object object = sslSettings.isEnabled() ? settings.streamFactoryFactory((StreamFactoryFactory)NettyStreamFactoryFactory.builder().build()) : BoxedUnit.UNIT;
            return settings.build();
        });
    }

    public final /* synthetic */ Task quasar$physical$mongodb$util$$$anonfun$5(ConnectionString cs$2, boolean invalidHostNameAllowed) {
        return this.settings$1(cs$2, invalidHostNameAllowed).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)stngs -> Task$.MODULE$.delay((Function0)(JFunction0 & Serializable & scala.Serializable)() -> MongoClients.create((MongoClientSettings)stngs)).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)client -> this.testConnection$1((MongoClient)client).onFinish((Function1)(JFunction1 & Serializable & scala.Serializable)x0$2 -> {
            Task task;
            Option option = x0$2;
            if (option instanceof Some) {
                task = Task$.MODULE$.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> client.close());
            } else {
                None$ none$ = Predef$.MODULE$.None();
                Option option2 = option;
                if (!(none$ == null ? option2 != null : !none$.equals(option2))) {
                    task = Task$.MODULE$.now((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError((Object)option);
                }
            }
            return task;
        }).map((Function1)(JFunction1 & Serializable & scala.Serializable)_ -> client)));
    }

    private final Free createClient$1(ConnectionString cs, Inject S0$1, Failure.Ops envErr$1, String InvalidHostNameAllowedProp$1) {
        return this.liftAndHandle(console$.MODULE$.booleanProp(InvalidHostNameAllowedProp$1).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)invalidHostNameAllowed -> this.quasar$physical$mongodb$util$$$anonfun$5(cs, BoxesRunTime.unboxToBoolean((Object)invalidHostNameAllowed))), (Function1)(JFunction1 & Serializable & scala.Serializable)t -> envErr$1.fail(EnvironmentError$.MODULE$.connectionFailed().apply(t)), S0$1);
    }

    private util$() {
        MODULE$ = this;
        this.defaultTimeoutMillis = 10000;
    }
}

