/*
 * Copyright 2014–2017 SlamData Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package quasar.api.services

import java.lang.String
import quasar.api._
import quasar.effect.{Execution, ExecutionTimings, TimingRepository}

import org.http4s.dsl._
import scalaz.{Zip => _, _}, Scalaz._
import scalaz.concurrent.Task
import argonaut.Json

object timings {

  def service[S[_]](repo: TimingRepository)(
    implicit
    S0: Task :<: S
  ): QHttpService[S] = QHttpService {
      case req @ GET -> _ =>
        respond(Free.liftF(S0(for {
          executions <- repo.under.read
          json = Json.jObjectFields(executions.map {
            case Execution(id, timings) =>
              (String.valueOf(id.identifier), ExecutionTimings.asJson(timings))
          }: _*)
        } yield json.left[ApiError])))
  }

}
