/*
 * Copyright 2014–2017 SlamData Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package quasar.config

import slamdata.Predef._

import argonaut._, Argonaut._
import monocle._, macros.Lenses
import scalaz._, Scalaz._

@Lenses final case class WebConfig(server: ServerConfig, metastore: Option[MetaStoreConfig])

object WebConfig {
  implicit val configOps: ConfigOps[WebConfig] = new ConfigOps[WebConfig] {
    val name = "web"
    def metaStoreConfig = WebConfig.metastore
    val default = MetaStoreConfig.default ∘ (ms => WebConfig(ServerConfig(ServerConfig.DefaultPort), ms.some))
  }

  implicit val codecJson: CodecJson[WebConfig] =
    casecodec2(WebConfig.apply, WebConfig.unapply)("server", "metastore")
}
