/**
 * 
 */
package querqy.rewrite;

import java.util.Set;

import querqy.model.ExpandedQuery;
import querqy.model.Term;

/**
 * @author René Kriegler, @renekrie
 *
 */
public abstract class RewriterFactory {

    private final String rewriterId;

    protected RewriterFactory(final String rewriterId) {
        this.rewriterId = rewriterId;
    }

    public abstract QueryRewriter createRewriter(ExpandedQuery input,
                                                 SearchEngineRequestAdapter searchEngineRequestAdapter);

    /**
     * <p>Get all {@link querqy.model.Term}s that will be generated by Rewriters that will be created by this class.</p>
     * <p>This only includes terms that are known when the factory is created. The terms returned from this method might
     * be used to optimise caching.</p>
     * <p>This method must return an empty set if no such term exists.</p>
     *
     * @return The set of {@link Term}s to be generated.
     */
    public abstract Set<Term> getGenerableTerms();

    public String getRewriterId() {
        return rewriterId;
    }


}
