package querqy.rewrite.commonrules.model;

import java.util.Set;
import java.util.stream.Collectors;

import querqy.model.InputSequenceElement;
import querqy.rewrite.commonrules.select.TopRewritingActionCollector;

public interface RulesCollection {

    /** 
     * Find and return all rewrite actions for an input sequence
     * @param sequence The input sequence
     * @param collector The collector of rewriting actions
     */
    void collectRewriteActions(PositionSequence<InputSequenceElement> sequence, TopRewritingActionCollector collector);
    
    /**
     * 
     * Get a collection of all instructions from the rules of this RulesCollection
     * 
     * @return The set of instructions
     */
    Set<Instruction> getInstructions();

    /**
     * <p>Get all {@link querqy.model.Term}s that will be generated by this RulesCollection. This only includes terms
     * that are known from the configuration. The terms returned from this method might be used to optimise caching.</p>
     *
     * @return The terms generated by the right-hand sides of the instructions.
     */
    default Set<querqy.model.Term> getGenerableTerms() {

        return getInstructions().stream()
                .flatMap(instruction -> instruction.getGenerableTerms().stream())
                .collect(Collectors.toSet());

    }
    

}