/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.VectorAggregateTask;

public class MessageBusImpl
implements MessageBus {
    private final RingQueue<ColumnIndexerTask> indexerQueue = new RingQueue<ColumnIndexerTask>(ColumnIndexerTask::new, 1024);
    private final MPSequence indexerPubSeq = new MPSequence(this.indexerQueue.getCapacity());
    private final MCSequence indexerSubSeq = new MCSequence(this.indexerQueue.getCapacity());
    private final RingQueue<VectorAggregateTask> vectorAggregaterQueue = new RingQueue<VectorAggregateTask>(VectorAggregateTask::new, 1024);
    private final MPSequence vectorAggregatePubSeq = new MPSequence(this.vectorAggregaterQueue.getCapacity());
    private final MCSequence vectorAggregateSubSeq = new MCSequence(this.vectorAggregaterQueue.getCapacity());

    public MessageBusImpl() {
        this.indexerPubSeq.then(this.indexerSubSeq).then(this.indexerPubSeq);
        this.vectorAggregatePubSeq.then(this.vectorAggregateSubSeq).then(this.vectorAggregatePubSeq);
    }

    @Override
    public Sequence getIndexerPubSequence() {
        return this.indexerPubSeq;
    }

    @Override
    public RingQueue<ColumnIndexerTask> getIndexerQueue() {
        return this.indexerQueue;
    }

    @Override
    public Sequence getIndexerSubSequence() {
        return this.indexerSubSeq;
    }

    @Override
    public RingQueue<VectorAggregateTask> getVectorAggregateQueue() {
        return this.vectorAggregaterQueue;
    }

    @Override
    public Sequence getVectorAggregatePubSequence() {
        return this.vectorAggregatePubSeq;
    }

    @Override
    public Sequence getVectorAggregateSubSequence() {
        return this.vectorAggregateSubSeq;
    }
}

