/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.line.LineProtoHourTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMicroTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMilliTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMinuteTimestampAdapter;
import io.questdb.cutlass.line.LineProtoNanoTimestampAdapter;
import io.questdb.cutlass.line.LineProtoSecondTimestampAdapter;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.DefaultPGWireConfiguration;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.network.EpollFacade;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.network.SelectFacade;
import io.questdb.network.SelectFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.StationaryMillisClock;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.microtime.MicrosecondClockImpl;
import io.questdb.std.microtime.TimestampFormatFactory;
import io.questdb.std.microtime.TimestampLocaleFactory;
import io.questdb.std.str.Path;
import io.questdb.std.time.DateFormatFactory;
import io.questdb.std.time.DateLocaleFactory;
import io.questdb.std.time.MillisecondClock;
import io.questdb.std.time.MillisecondClockImpl;
import java.io.File;
import java.util.Arrays;
import java.util.Properties;

public class PropServerConfiguration
implements ServerConfiguration {
    public static final String CONFIG_DIRECTORY = "conf";
    private final IODispatcherConfiguration httpIODispatcherConfiguration = new HttpIODispatcherConfiguration();
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new PropStaticContentProcessorConfiguration();
    private final HttpServerConfiguration httpServerConfiguration = new PropHttpServerConfiguration();
    private final TextConfiguration textConfiguration = new PropTextConfiguration();
    private final CairoConfiguration cairoConfiguration = new PropCairoConfiguration();
    private final LineUdpReceiverConfiguration lineUdpReceiverConfiguration = new PropLineUdpReceiverConfiguration();
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new PropJsonQueryProcessorConfiguration();
    private final int commitMode;
    private final boolean httpServerEnabled;
    private final int createAsSelectRetryCount;
    private final CharSequence defaultMapType;
    private final boolean defaultSymbolCacheFlag;
    private final int defaultSymbolCapacity;
    private final int fileOperationRetryCount;
    private final long idleCheckInterval;
    private final long inactiveReaderTTL;
    private final long inactiveWriterTTL;
    private final int indexValueBlockSize;
    private final int maxSwapFileCount;
    private final int mkdirMode;
    private final int parallelIndexThreshold;
    private final int readerPoolMaxSegments;
    private final long spinLockTimeoutUs;
    private final int sqlCacheRows;
    private final int sqlCacheBlocks;
    private final int sqlCharacterStoreCapacity;
    private final int sqlCharacterStoreSequencePoolCapacity;
    private final int sqlColumnPoolCapacity;
    private final int sqlCopyModelPoolCapacity;
    private final double sqlCompactMapLoadFactor;
    private final int sqlExpressionPoolCapacity;
    private final double sqlFastMapLoadFactor;
    private final int sqlJoinContextPoolCapacity;
    private final int sqlLexerPoolCapacity;
    private final int sqlMapKeyCapacity;
    private final int sqlMapPageSize;
    private final int sqlModelPoolCapacity;
    private final long sqlSortKeyPageSize;
    private final long sqlSortLightValuePageSize;
    private final int sqlHashJoinValuePageSize;
    private final long sqlLatestByRowCount;
    private final int sqlHashJoinLightValuePageSize;
    private final int sqlSortValuePageSize;
    private final long workStealTimeoutNanos;
    private final boolean parallelIndexingEnabled;
    private final int sqlJoinMetadataPageSize;
    private final int lineUdpCommitRate;
    private final int lineUdpGroupIPv4Address;
    private final int lineUdpMsgBufferSize;
    private final int lineUdpMsgCount;
    private final int lineUdpReceiveBufferSize;
    private final int lineUdpCommitMode;
    private final int[] sharedWorkerAffinity;
    private final int sharedWorkerCount;
    private final boolean sharedWorkerHaltOnError;
    private final WorkerPoolConfiguration workerPoolConfiguration = new PropWorkerPoolConfiguration();
    private final PGWireConfiguration pgWireConfiguration = new DefaultPGWireConfiguration(){

        @Override
        public int getWorkerCount() {
            return 0;
        }
    };
    private final InputFormatConfiguration inputFormatConfiguration;
    private final LineProtoTimestampAdapter lineUdpTimestampAdapter;
    private final String inputRoot;
    private boolean httpAllowDeflateBeforeSend;
    private int[] httpWorkerAffinity;
    private int connectionPoolInitialCapacity;
    private int connectionStringPoolCapacity;
    private int multipartHeaderBufferSize;
    private long multipartIdleSpinCount;
    private int recvBufferSize;
    private int requestHeaderBufferSize;
    private int responseHeaderBufferSize;
    private int httpWorkerCount;
    private boolean httpWorkerHaltOnError;
    private int sendBufferSize;
    private CharSequence indexFileName;
    private String publicDirectory;
    private int activeConnectionLimit;
    private int eventCapacity;
    private int ioQueueCapacity;
    private long idleConnectionTimeout;
    private int interestQueueCapacity;
    private int listenBacklog;
    private int sndBufSize;
    private int rcvBufSize;
    private int dateAdapterPoolCapacity;
    private int jsonCacheLimit;
    private int jsonCacheSize;
    private double maxRequiredDelimiterStdDev;
    private double maxRequiredLineLengthStdDev;
    private int metadataStringPoolCapacity;
    private int rollBufferLimit;
    private int rollBufferSize;
    private int textAnalysisMaxLines;
    private int textLexerStringPoolCapacity;
    private int timestampAdapterPoolCapacity;
    private int utf8SinkSize;
    private MimeTypesCache mimeTypesCache;
    private String databaseRoot;
    private String keepAliveHeader;
    private int bindIPv4Address;
    private int bindPort;
    private int lineUdpBindIPV4Address;
    private int lineUdpPort;
    private boolean lineUdpEnabled;
    private int lineUdpOwnThreadAffinity;
    private boolean lineUdpUnicast;
    private boolean lineUdpOwnThread;
    private int jsonQueryFloatScale;
    private int sqlCopyBufferSize;
    private int jsonQueryConnectionCheckFrequency;
    private boolean httpFrozenClock;
    private int sqlAnalyticColumnPoolCapacity;
    private int sqlCreateTableModelPoolCapacity;
    private int sqlColumnCastModelPoolCapacity;
    private int sqlRenameTableModelPoolCapacity;
    private int sqlWithClauseModelPoolCapacity;
    private int sqlInsertModelPoolCapacity;

    public PropServerConfiguration(String root, Properties properties) throws ServerConfigurationException, JsonException {
        this.sharedWorkerCount = this.getInt(properties, "shared.worker.count", 2);
        this.sharedWorkerAffinity = this.getAffinity(properties, "shared.worker.affinity", this.sharedWorkerCount);
        this.sharedWorkerHaltOnError = this.getBoolean(properties, "shared.worker.haltOnError", false);
        this.httpServerEnabled = this.getBoolean(properties, "http.enabled", true);
        if (this.httpServerEnabled) {
            this.connectionPoolInitialCapacity = this.getInt(properties, "http.connection.pool.initial.capacity", 16);
            this.connectionStringPoolCapacity = this.getInt(properties, "http.connection.string.pool.capacity", 128);
            this.multipartHeaderBufferSize = this.getIntSize(properties, "http.multipart.header.buffer.size", 512);
            this.multipartIdleSpinCount = this.getLong(properties, "http.multipart.idle.spin.count", 10000L);
            this.recvBufferSize = this.getIntSize(properties, "http.receive.buffer.size", 0x100000);
            this.requestHeaderBufferSize = this.getIntSize(properties, "http.request.header.buffer.size", 64448);
            this.responseHeaderBufferSize = this.getIntSize(properties, "http.response.header.buffer.size", 32768);
            this.httpWorkerCount = this.getInt(properties, "http.worker.count", 0);
            this.httpWorkerAffinity = this.getAffinity(properties, "http.worker.affinity", this.httpWorkerCount);
            this.httpWorkerHaltOnError = this.getBoolean(properties, "http.worker.haltOnError", false);
            this.sendBufferSize = this.getIntSize(properties, "http.send.buffer.size", 0x200000);
            this.indexFileName = this.getString(properties, "http.static.index.file.name", "index.html");
            this.httpFrozenClock = this.getBoolean(properties, "http.frozen.clock", false);
            this.httpAllowDeflateBeforeSend = this.getBoolean(properties, "http.allow.deflate.before.send", false);
            int keepAliveTimeout = this.getInt(properties, "http.keep-alive.timeout", 5);
            int keepAliveMax = this.getInt(properties, "http.keep-alive.max", 10000);
            this.keepAliveHeader = keepAliveTimeout > 0 && keepAliveMax > 0 ? "Keep-Alive: timeout=" + keepAliveTimeout + ", max=" + keepAliveMax + "\r\n" : null;
            String publicDirectory = this.getString(properties, "http.static.pubic.directory", "public");
            this.publicDirectory = new File(publicDirectory).isAbsolute() ? publicDirectory : new File(root, publicDirectory).getAbsolutePath();
            String databaseRoot = this.getString(properties, "cairo.root", "db");
            this.databaseRoot = new File(databaseRoot).isAbsolute() ? databaseRoot : new File(root, databaseRoot).getAbsolutePath();
            this.activeConnectionLimit = this.getInt(properties, "http.net.active.connection.limit", 256);
            this.eventCapacity = this.getInt(properties, "http.net.event.capacity", 1024);
            this.ioQueueCapacity = this.getInt(properties, "http.net.io.queue.capacity", 1024);
            this.idleConnectionTimeout = this.getLong(properties, "http.net.idle.connection.timeout", 300000L);
            this.interestQueueCapacity = this.getInt(properties, "http.net.interest.queue.capacity", 1024);
            this.listenBacklog = this.getInt(properties, "http.net.listen.backlog", 256);
            this.sndBufSize = this.getIntSize(properties, "http.net.snd.buf.size", 0x200000);
            this.rcvBufSize = this.getIntSize(properties, "http.net.rcv.buf.size", 0x200000);
            this.dateAdapterPoolCapacity = this.getInt(properties, "http.text.date.adapter.pool.capacity", 16);
            this.jsonCacheLimit = this.getIntSize(properties, "http.text.json.cache.limit", 16384);
            this.jsonCacheSize = this.getIntSize(properties, "http.text.json.cache.size", 8192);
            this.maxRequiredDelimiterStdDev = this.getDouble(properties, "http.text.max.required.delimiter.stddev", 0.1222);
            this.maxRequiredLineLengthStdDev = this.getDouble(properties, "http.text.max.required.line.length.stddev", 0.8);
            this.metadataStringPoolCapacity = this.getInt(properties, "http.text.metadata.string.pool.capacity", 128);
            this.rollBufferLimit = this.getIntSize(properties, "http.text.roll.buffer.limit", 0x400000);
            this.rollBufferSize = this.getIntSize(properties, "http.text.roll.buffer.size", 1024);
            this.textAnalysisMaxLines = this.getInt(properties, "http.text.analysis.max.lines", 1000);
            this.textLexerStringPoolCapacity = this.getInt(properties, "http.text.lexer.string.pool.capacity", 64);
            this.timestampAdapterPoolCapacity = this.getInt(properties, "http.text.timestamp.adapter.pool.capacity", 64);
            this.utf8SinkSize = this.getIntSize(properties, "http.text.utf8.sink.size", 4096);
            this.jsonQueryConnectionCheckFrequency = this.getInt(properties, "http.json.query.connection.check.frequency", 1000000);
            this.jsonQueryFloatScale = this.getInt(properties, "http.json.query.float.scale", 10);
            this.parseBindTo(properties, "http.bind.to", "0.0.0.0:9000", (a, p) -> {
                this.bindIPv4Address = a;
                this.bindPort = p;
            });
            try (Path path = new Path().of(new File(new File(root, CONFIG_DIRECTORY), "mime.types").getAbsolutePath()).$();){
                this.mimeTypesCache = new MimeTypesCache(FilesFacadeImpl.INSTANCE, path);
            }
        }
        this.commitMode = this.getCommitMode(properties, "cairo.commit.mode");
        this.createAsSelectRetryCount = this.getInt(properties, "cairo.create.as.select.retry.count", 5);
        this.defaultMapType = this.getString(properties, "cairo.default.map.type", "fast");
        this.defaultSymbolCacheFlag = this.getBoolean(properties, "cairo.default.symbol.cache.flag", false);
        this.defaultSymbolCapacity = this.getInt(properties, "cairo.default.symbol.capacity", 256);
        this.fileOperationRetryCount = this.getInt(properties, "cairo.file.operation.retry.count", 30);
        this.idleCheckInterval = this.getLong(properties, "cairo.idle.check.interval", 300000L);
        this.inactiveReaderTTL = this.getLong(properties, "cairo.inactive.reader.ttl", -10000L);
        this.inactiveWriterTTL = this.getLong(properties, "cairo.inactive.writer.ttl", -10000L);
        this.indexValueBlockSize = Numbers.ceilPow2(this.getIntSize(properties, "cairo.index.value.block.size", 256));
        this.maxSwapFileCount = this.getInt(properties, "cairo.max.swap.file.count", 30);
        this.mkdirMode = this.getInt(properties, "cairo.mkdir.mode", 509);
        this.parallelIndexThreshold = this.getInt(properties, "cairo.parallel.index.threshold", 100000);
        this.readerPoolMaxSegments = this.getInt(properties, "cairo.reader.pool.max.segments", 5);
        this.spinLockTimeoutUs = this.getLong(properties, "cairo.spin.lock.timeout", 1000000L);
        this.sqlCacheRows = this.getInt(properties, "cairo.cache.rows", 16);
        this.sqlCacheBlocks = this.getIntSize(properties, "cairo.cache.blocks", 4);
        this.sqlCharacterStoreCapacity = this.getInt(properties, "cairo.character.store.capacity", 1024);
        this.sqlCharacterStoreSequencePoolCapacity = this.getInt(properties, "cairo.character.store.sequence.pool.capacity", 64);
        this.sqlColumnPoolCapacity = this.getInt(properties, "cairo.column.pool.capacity", 4096);
        this.sqlCompactMapLoadFactor = this.getDouble(properties, "cairo.compact.map.load.factor", 0.7);
        this.sqlExpressionPoolCapacity = this.getInt(properties, "cairo.expression.pool.capacity", 8192);
        this.sqlFastMapLoadFactor = this.getDouble(properties, "cairo.fast.map.load.factor", 0.5);
        this.sqlJoinContextPoolCapacity = this.getInt(properties, "cairo.sql.join.context.pool.capacity", 64);
        this.sqlLexerPoolCapacity = this.getInt(properties, "cairo.lexer.pool.capacity", 2048);
        this.sqlMapKeyCapacity = this.getInt(properties, "cairo.sql.map.key.capacity", 0x200000);
        this.sqlMapPageSize = this.getIntSize(properties, "cairo.sql.map.page.size", 0x400000);
        this.sqlModelPoolCapacity = this.getInt(properties, "cairo.model.pool.capacity", 1024);
        this.sqlSortKeyPageSize = this.getLongSize(properties, "cairo.sql.sort.key.page.size", 0x400000L);
        this.sqlSortLightValuePageSize = this.getLongSize(properties, "cairo.sql.sort.light.value.page.size", 0x100000L);
        this.sqlHashJoinValuePageSize = this.getIntSize(properties, "cairo.sql.hash.join.value.page.size", 0x1000000);
        this.sqlLatestByRowCount = this.getInt(properties, "cairo.sql.latest.by.row.count", 1000);
        this.sqlHashJoinLightValuePageSize = this.getIntSize(properties, "cairo.sql.hash.join.light.value.page.size", 0x100000);
        this.sqlSortValuePageSize = this.getIntSize(properties, "cairo.sql.sort.value.page.size", 0x1000000);
        this.workStealTimeoutNanos = this.getLong(properties, "cairo.work.steal.timeout.nanos", 10000L);
        this.parallelIndexingEnabled = this.getBoolean(properties, "cairo.parallel.indexing.enabled", true);
        this.sqlJoinMetadataPageSize = this.getIntSize(properties, "cairo.sql.join.metadata.page.size", 16384);
        this.sqlAnalyticColumnPoolCapacity = this.getInt(properties, "cairo.sql.analytic.column.pool.capacity", 64);
        this.sqlCreateTableModelPoolCapacity = this.getInt(properties, "cairo.sql.create.table.model.pool.capacity", 16);
        this.sqlColumnCastModelPoolCapacity = this.getInt(properties, "cairo.sql.column.cast.model.pool.capacity", 16);
        this.sqlRenameTableModelPoolCapacity = this.getInt(properties, "cairo.sql.rename.table.model.pool.capacity", 16);
        this.sqlWithClauseModelPoolCapacity = this.getInt(properties, "cairo.sql.with.clause.model.pool.capacity", 128);
        this.sqlInsertModelPoolCapacity = this.getInt(properties, "cairo.sql.insert.model.pool.capacity", 64);
        this.sqlCopyModelPoolCapacity = this.getInt(properties, "cairo.sql.copy.model.pool.capacity", 32);
        this.sqlCopyBufferSize = this.getIntSize(properties, "cairo.sql.copy.buffer.size", 0x200000);
        String sqlCopyFormatsFile = this.getString(properties, "cairo.sql.copy.formats.file", "/text_loader.json");
        this.inputFormatConfiguration = new InputFormatConfiguration(new DateFormatFactory(), DateLocaleFactory.INSTANCE, new TimestampFormatFactory(), TimestampLocaleFactory.INSTANCE);
        JsonLexer lexer = new JsonLexer(1024, 1024);
        Object object = null;
        try {
            this.inputFormatConfiguration.parseConfiguration(lexer, sqlCopyFormatsFile);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (lexer != null) {
                if (object != null) {
                    try {
                        lexer.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    lexer.close();
                }
            }
        }
        this.inputRoot = this.getString(properties, "cairo.sql.copy.root", null);
        this.parseBindTo(properties, "line.udp.bind.to", "0.0.0.0:9009", (a, p) -> {
            this.lineUdpBindIPV4Address = a;
            this.lineUdpPort = p;
        });
        this.lineUdpGroupIPv4Address = this.getIPv4Address(properties, "line.udp.join", "232.1.2.3");
        this.lineUdpCommitRate = this.getInt(properties, "line.udp.commit.rate", 1000000);
        this.lineUdpMsgBufferSize = this.getIntSize(properties, "line.udp.msg.buffer.size", 2048);
        this.lineUdpMsgCount = this.getInt(properties, "line.udp.msg.count", 10000);
        this.lineUdpReceiveBufferSize = this.getIntSize(properties, "line.udp.receive.buffer.size", 0x800000);
        this.lineUdpEnabled = this.getBoolean(properties, "line.udp.enabled", true);
        this.lineUdpOwnThreadAffinity = this.getInt(properties, "line.udp.own.thread.affinity", -1);
        this.lineUdpOwnThread = this.getBoolean(properties, "line.udp.own.thread", false);
        this.lineUdpUnicast = this.getBoolean(properties, "line.udp.unicast", false);
        this.lineUdpCommitMode = this.getCommitMode(properties, "line.udp.commit.mode");
        String lineUdpTimestampSwitch = this.getString(properties, "line.udp.timestamp", "n");
        switch (lineUdpTimestampSwitch) {
            case "u": {
                this.lineUdpTimestampAdapter = LineProtoMicroTimestampAdapter.INSTANCE;
                break;
            }
            case "ms": {
                this.lineUdpTimestampAdapter = LineProtoMilliTimestampAdapter.INSTANCE;
                break;
            }
            case "s": {
                this.lineUdpTimestampAdapter = LineProtoSecondTimestampAdapter.INSTANCE;
                break;
            }
            case "m": {
                this.lineUdpTimestampAdapter = LineProtoMinuteTimestampAdapter.INSTANCE;
                break;
            }
            case "h": {
                this.lineUdpTimestampAdapter = LineProtoHourTimestampAdapter.INSTANCE;
                break;
            }
            default: {
                this.lineUdpTimestampAdapter = LineProtoNanoTimestampAdapter.INSTANCE;
            }
        }
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfiguration;
    }

    @Override
    public HttpServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfiguration;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.lineUdpReceiverConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWorkerPoolConfiguration() {
        return this.workerPoolConfiguration;
    }

    @Override
    public PGWireConfiguration getPGWireConfiguration() {
        return this.pgWireConfiguration;
    }

    private int[] getAffinity(Properties properties, String key, int httpWorkerCount) throws ServerConfigurationException {
        int[] result = new int[httpWorkerCount];
        String value = properties.getProperty(key);
        if (value == null) {
            Arrays.fill(result, -1);
        } else {
            String[] affinity = value.split(",");
            if (affinity.length != httpWorkerCount) {
                throw new ServerConfigurationException(key, "wrong number of affinity values");
            }
            for (int i = 0; i < httpWorkerCount; ++i) {
                try {
                    result[i] = Numbers.parseInt(affinity[i]);
                    continue;
                }
                catch (NumericException e) {
                    throw new ServerConfigurationException(key, "Invalid affinity value: " + affinity[i]);
                }
            }
        }
        return result;
    }

    private boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        String value = properties.getProperty(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private int getCommitMode(Properties properties, String property) {
        String commitMode = properties.getProperty(property);
        if (commitMode == null) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "nosync")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "async")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "sync")) {
            return 1;
        }
        return 2;
    }

    private double getDouble(Properties properties, String key, double defaultValue) throws ServerConfigurationException {
        String value = properties.getProperty(key);
        try {
            return value != null ? Numbers.parseDouble(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private int getIPv4Address(Properties properties, String key, String defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, key, defaultValue);
        try {
            return Net.parseIPv4(value);
        }
        catch (NetworkError e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private int getInt(Properties properties, String key, int defaultValue) throws ServerConfigurationException {
        String value = properties.getProperty(key);
        try {
            return value != null ? Numbers.parseInt(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private int getIntSize(Properties properties, String key, int defaultValue) throws ServerConfigurationException {
        String value = properties.getProperty(key);
        try {
            return value != null ? Numbers.parseIntSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private long getLong(Properties properties, String key, long defaultValue) throws ServerConfigurationException {
        String value = properties.getProperty(key);
        try {
            return value != null ? Numbers.parseLong(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private long getLongSize(Properties properties, String key, long defaultValue) throws ServerConfigurationException {
        String value = properties.getProperty(key);
        try {
            return value != null ? Numbers.parseLongSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private String getString(Properties properties, String key, String defaultValue) {
        String value = properties.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private void parseBindTo(Properties properties, String key, String defaultValue, BindToParser parser) throws ServerConfigurationException {
        int port;
        int ipv4;
        String bindTo = this.getString(properties, key, defaultValue);
        int colonIndex = bindTo.indexOf(58);
        if (colonIndex == -1) {
            throw new ServerConfigurationException(key, bindTo);
        }
        String ipv4Str = bindTo.substring(0, colonIndex);
        try {
            ipv4 = Net.parseIPv4(ipv4Str);
        }
        catch (NetworkError e) {
            throw new ServerConfigurationException(key, ipv4Str);
        }
        String portStr = bindTo.substring(colonIndex + 1);
        try {
            port = Numbers.parseInt(portStr);
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, portStr);
        }
        parser.onReady(ipv4, port);
    }

    private class PropWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.sharedWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.sharedWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.sharedWorkerHaltOnError;
        }
    }

    private class PropJsonQueryProcessorConfiguration
    implements JsonQueryProcessorConfiguration {
        private PropJsonQueryProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getConnectionCheckFrequency() {
            return PropServerConfiguration.this.jsonQueryConnectionCheckFrequency;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatScale() {
            return PropServerConfiguration.this.jsonQueryFloatScale;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }
    }

    private class PropLineUdpReceiverConfiguration
    implements LineUdpReceiverConfiguration {
        private PropLineUdpReceiverConfiguration() {
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.lineUdpCommitMode;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineUdpBindIPV4Address;
        }

        @Override
        public int getCommitRate() {
            return PropServerConfiguration.this.lineUdpCommitRate;
        }

        @Override
        public int getGroupIPv4Address() {
            return PropServerConfiguration.this.lineUdpGroupIPv4Address;
        }

        @Override
        public int getMsgBufferSize() {
            return PropServerConfiguration.this.lineUdpMsgBufferSize;
        }

        @Override
        public int getMsgCount() {
            return PropServerConfiguration.this.lineUdpMsgCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPort() {
            return PropServerConfiguration.this.lineUdpPort;
        }

        @Override
        public int getReceiveBufferSize() {
            return PropServerConfiguration.this.lineUdpReceiveBufferSize;
        }

        @Override
        public CairoSecurityContext getCairoSecurityContext() {
            return AllowAllCairoSecurityContext.INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineUdpEnabled;
        }

        @Override
        public boolean isUnicast() {
            return PropServerConfiguration.this.lineUdpUnicast;
        }

        @Override
        public boolean ownThread() {
            return PropServerConfiguration.this.lineUdpOwnThread;
        }

        @Override
        public int ownThreadAffinity() {
            return PropServerConfiguration.this.lineUdpOwnThreadAffinity;
        }

        @Override
        public LineProtoTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineUdpTimestampAdapter;
        }
    }

    private class PropCairoConfiguration
    implements CairoConfiguration {
        private PropCairoConfiguration() {
        }

        @Override
        public int getSqlCopyBufferSize() {
            return PropServerConfiguration.this.sqlCopyBufferSize;
        }

        @Override
        public int getCopyPoolCapacity() {
            return PropServerConfiguration.this.sqlCopyModelPoolCapacity;
        }

        @Override
        public int getCreateAsSelectRetryCount() {
            return PropServerConfiguration.this.createAsSelectRetryCount;
        }

        @Override
        public CharSequence getDefaultMapType() {
            return PropServerConfiguration.this.defaultMapType;
        }

        @Override
        public boolean getDefaultSymbolCacheFlag() {
            return PropServerConfiguration.this.defaultSymbolCacheFlag;
        }

        @Override
        public int getDefaultSymbolCapacity() {
            return PropServerConfiguration.this.defaultSymbolCapacity;
        }

        @Override
        public int getFileOperationRetryCount() {
            return PropServerConfiguration.this.fileOperationRetryCount;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public long getIdleCheckInterval() {
            return PropServerConfiguration.this.idleCheckInterval;
        }

        @Override
        public long getInactiveReaderTTL() {
            return PropServerConfiguration.this.inactiveReaderTTL;
        }

        @Override
        public long getInactiveWriterTTL() {
            return PropServerConfiguration.this.inactiveWriterTTL;
        }

        @Override
        public int getIndexValueBlockSize() {
            return PropServerConfiguration.this.indexValueBlockSize;
        }

        @Override
        public int getMaxSwapFileCount() {
            return PropServerConfiguration.this.maxSwapFileCount;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getMkDirMode() {
            return PropServerConfiguration.this.mkdirMode;
        }

        @Override
        public int getParallelIndexThreshold() {
            return PropServerConfiguration.this.parallelIndexThreshold;
        }

        @Override
        public int getReaderPoolMaxSegments() {
            return PropServerConfiguration.this.readerPoolMaxSegments;
        }

        @Override
        public CharSequence getRoot() {
            return PropServerConfiguration.this.databaseRoot;
        }

        @Override
        public CharSequence getInputRoot() {
            return PropServerConfiguration.this.inputRoot;
        }

        @Override
        public long getSpinLockTimeoutUs() {
            return PropServerConfiguration.this.spinLockTimeoutUs;
        }

        @Override
        public int getSqlCharacterStoreCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreCapacity;
        }

        @Override
        public int getSqlCharacterStoreSequencePoolCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreSequencePoolCapacity;
        }

        @Override
        public int getSqlColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnPoolCapacity;
        }

        @Override
        public double getSqlCompactMapLoadFactor() {
            return PropServerConfiguration.this.sqlCompactMapLoadFactor;
        }

        @Override
        public int getSqlExpressionPoolCapacity() {
            return PropServerConfiguration.this.sqlExpressionPoolCapacity;
        }

        @Override
        public double getSqlFastMapLoadFactor() {
            return PropServerConfiguration.this.sqlFastMapLoadFactor;
        }

        @Override
        public int getSqlJoinContextPoolCapacity() {
            return PropServerConfiguration.this.sqlJoinContextPoolCapacity;
        }

        @Override
        public int getSqlLexerPoolCapacity() {
            return PropServerConfiguration.this.sqlLexerPoolCapacity;
        }

        @Override
        public int getSqlMapKeyCapacity() {
            return PropServerConfiguration.this.sqlMapKeyCapacity;
        }

        @Override
        public int getSqlMapPageSize() {
            return PropServerConfiguration.this.sqlMapPageSize;
        }

        @Override
        public int getSqlModelPoolCapacity() {
            return PropServerConfiguration.this.sqlModelPoolCapacity;
        }

        @Override
        public long getSqlSortKeyPageSize() {
            return PropServerConfiguration.this.sqlSortKeyPageSize;
        }

        @Override
        public long getSqlSortLightValuePageSize() {
            return PropServerConfiguration.this.sqlSortLightValuePageSize;
        }

        @Override
        public int getSqlHashJoinValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinValuePageSize;
        }

        @Override
        public long getSqlLatestByRowCount() {
            return PropServerConfiguration.this.sqlLatestByRowCount;
        }

        @Override
        public int getSqlHashJoinLightValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinLightValuePageSize;
        }

        @Override
        public int getSqlSortValuePageSize() {
            return PropServerConfiguration.this.sqlSortValuePageSize;
        }

        @Override
        public TextConfiguration getTextConfiguration() {
            return PropServerConfiguration.this.textConfiguration;
        }

        @Override
        public long getWorkStealTimeoutNanos() {
            return PropServerConfiguration.this.workStealTimeoutNanos;
        }

        @Override
        public boolean isParallelIndexingEnabled() {
            return PropServerConfiguration.this.parallelIndexingEnabled;
        }

        @Override
        public int getSqlJoinMetadataPageSize() {
            return PropServerConfiguration.this.sqlJoinMetadataPageSize;
        }

        @Override
        public int getAnalyticColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlAnalyticColumnPoolCapacity;
        }

        @Override
        public int getCreateTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlCreateTableModelPoolCapacity;
        }

        @Override
        public int getColumnCastModelPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnCastModelPoolCapacity;
        }

        @Override
        public int getRenameTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlRenameTableModelPoolCapacity;
        }

        @Override
        public int getWithClauseModelPoolCapacity() {
            return PropServerConfiguration.this.sqlWithClauseModelPoolCapacity;
        }

        @Override
        public int getInsertPoolCapacity() {
            return PropServerConfiguration.this.sqlInsertModelPoolCapacity;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.commitMode;
        }
    }

    private class PropHttpServerConfiguration
    implements HttpServerConfiguration {
        private PropHttpServerConfiguration() {
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.connectionPoolInitialCapacity;
        }

        @Override
        public int getConnectionStringPoolCapacity() {
            return PropServerConfiguration.this.connectionStringPoolCapacity;
        }

        @Override
        public int getMultipartHeaderBufferSize() {
            return PropServerConfiguration.this.multipartHeaderBufferSize;
        }

        @Override
        public long getMultipartIdleSpinCount() {
            return PropServerConfiguration.this.multipartIdleSpinCount;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.recvBufferSize;
        }

        @Override
        public int getRequestHeaderBufferSize() {
            return PropServerConfiguration.this.requestHeaderBufferSize;
        }

        @Override
        public int getResponseHeaderBufferSize() {
            return PropServerConfiguration.this.responseHeaderBufferSize;
        }

        @Override
        public int getQueryCacheBlocks() {
            return PropServerConfiguration.this.sqlCacheBlocks;
        }

        @Override
        public int getQueryCacheRows() {
            return PropServerConfiguration.this.sqlCacheRows;
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.httpIODispatcherConfiguration;
        }

        @Override
        public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
            return PropServerConfiguration.this.staticContentProcessorConfiguration;
        }

        @Override
        public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
            return PropServerConfiguration.this.jsonQueryProcessorConfiguration;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.sendBufferSize;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpServerEnabled;
        }

        @Override
        public boolean getDumpNetworkTraffic() {
            return false;
        }

        @Override
        public boolean allowDeflateBeforeSend() {
            return PropServerConfiguration.this.httpAllowDeflateBeforeSend;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpWorkerHaltOnError;
        }
    }

    private class PropTextConfiguration
    implements TextConfiguration {
        private PropTextConfiguration() {
        }

        @Override
        public int getDateAdapterPoolCapacity() {
            return PropServerConfiguration.this.dateAdapterPoolCapacity;
        }

        @Override
        public int getJsonCacheLimit() {
            return PropServerConfiguration.this.jsonCacheLimit;
        }

        @Override
        public int getJsonCacheSize() {
            return PropServerConfiguration.this.jsonCacheSize;
        }

        @Override
        public double getMaxRequiredDelimiterStdDev() {
            return PropServerConfiguration.this.maxRequiredDelimiterStdDev;
        }

        @Override
        public double getMaxRequiredLineLengthStdDev() {
            return PropServerConfiguration.this.maxRequiredLineLengthStdDev;
        }

        @Override
        public int getMetadataStringPoolCapacity() {
            return PropServerConfiguration.this.metadataStringPoolCapacity;
        }

        @Override
        public int getRollBufferLimit() {
            return PropServerConfiguration.this.rollBufferLimit;
        }

        @Override
        public int getRollBufferSize() {
            return PropServerConfiguration.this.rollBufferSize;
        }

        @Override
        public int getTextAnalysisMaxLines() {
            return PropServerConfiguration.this.textAnalysisMaxLines;
        }

        @Override
        public int getTextLexerStringPoolCapacity() {
            return PropServerConfiguration.this.textLexerStringPoolCapacity;
        }

        @Override
        public int getTimestampAdapterPoolCapacity() {
            return PropServerConfiguration.this.timestampAdapterPoolCapacity;
        }

        @Override
        public int getUtf8SinkSize() {
            return PropServerConfiguration.this.utf8SinkSize;
        }

        @Override
        public InputFormatConfiguration getInputFormatConfiguration() {
            return PropServerConfiguration.this.inputFormatConfiguration;
        }
    }

    private class HttpIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private HttpIODispatcherConfiguration() {
        }

        @Override
        public int getActiveConnectionLimit() {
            return PropServerConfiguration.this.activeConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.bindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.bindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public int getEventCapacity() {
            return PropServerConfiguration.this.eventCapacity;
        }

        @Override
        public int getIOQueueCapacity() {
            return PropServerConfiguration.this.ioQueueCapacity;
        }

        @Override
        public long getIdleConnectionTimeout() {
            return PropServerConfiguration.this.idleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public int getInterestQueueCapacity() {
            return PropServerConfiguration.this.interestQueueCapacity;
        }

        @Override
        public int getListenBacklog() {
            return PropServerConfiguration.this.listenBacklog;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.rcvBufSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.sndBufSize;
        }
    }

    private class PropStaticContentProcessorConfiguration
    implements StaticContentProcessorConfiguration {
        private PropStaticContentProcessorConfiguration() {
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getIndexFileName() {
            return PropServerConfiguration.this.indexFileName;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return PropServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return PropServerConfiguration.this.publicDirectory;
        }

        @Override
        public String getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }
    }

    @FunctionalInterface
    private static interface BindToParser {
        public void onReady(int var1, int var2);
    }
}

