/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBusImpl;
import io.questdb.PropServerConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.line.udp.AbstractLineProtoReceiver;
import io.questdb.cutlass.line.udp.LineProtoReceiver;
import io.questdb.cutlass.line.udp.LinuxMMLineProtoReceiver;
import io.questdb.cutlass.pgwire.PGWireServer;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.WorkerPool;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Vect;
import io.questdb.std.str.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import sun.misc.Signal;

public class ServerMain {
    public ServerMain(String[] args) throws Exception {
        System.err.printf("QuestDB server %s%nCopyright (C) 2014-2019, all rights reserved.%n%n", this.getVersion());
        if (args.length < 1) {
            System.err.println("Root directory name expected");
            return;
        }
        if (Os.type == -2) {
            System.err.println("QuestDB requires 64-bit JVM");
            return;
        }
        CharSequenceObjHashMap<String> optHash = ServerMain.hashArgs(args);
        String rootDirectory = optHash.get("-d");
        ServerMain.extractSite(rootDirectory, optHash.get("-f") != null);
        Properties properties = new Properties();
        String configurationFileName = "/server.conf";
        File configurationFile = new File(new File(rootDirectory, "conf"), "/server.conf");
        try (FileInputStream is = new FileInputStream(configurationFile);){
            properties.load(is);
        }
        PropServerConfiguration configuration = new PropServerConfiguration(rootDirectory, properties);
        try (Path path = new Path();){
            path.of(configuration.getCairoConfiguration().getRoot());
            if (!Chars.endsWith((CharSequence)path, Files.SEPARATOR)) {
                path.concat("");
            }
            path.$();
            if (Files.mkdirs(path, configuration.getCairoConfiguration().getMkDirMode()) != 0) {
                System.err.println("Could not create database root directory: " + path.toString());
                System.exit(30);
            } else {
                System.out.println("Database root is '" + path + "'");
            }
        }
        switch (Os.type) {
            case 3: {
                System.out.println("OS: windows-amd64 " + Vect.getSupportedInstructionSetName());
                break;
            }
            case 2: {
                System.out.println("OS: linux-amd64" + Vect.getSupportedInstructionSetName());
                break;
            }
            case 1: {
                System.out.println("OS: apple-amd64" + Vect.getSupportedInstructionSetName());
                break;
            }
            case 4: {
                System.out.println("OS: linux-arm64" + Vect.getSupportedInstructionSetName());
                break;
            }
            case 5: {
                System.out.println("OS: freebsd-amd64" + Vect.getSupportedInstructionSetName());
                break;
            }
            default: {
                System.err.println("Unsupported OS");
            }
        }
        WorkerPool workerPool = new WorkerPool(configuration.getWorkerPoolConfiguration());
        MessageBusImpl messageBus = new MessageBusImpl();
        LogFactory.configureFromSystemProperties(workerPool);
        Log log = LogFactory.getLog("server-main");
        CairoEngine cairoEngine = new CairoEngine(configuration.getCairoConfiguration(), messageBus);
        workerPool.assign(cairoEngine.getWriterMaintenanceJob());
        HttpServer httpServer = HttpServer.create(configuration.getHttpServerConfiguration(), workerPool, log, cairoEngine, messageBus);
        PGWireServer pgWireServer = PGWireServer.create(configuration.getPGWireConfiguration(), workerPool, log, cairoEngine, messageBus);
        AbstractLineProtoReceiver lineProtocolReceiver = Os.type == 2 || Os.type == 4 ? new LinuxMMLineProtoReceiver(configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool) : new LineProtoReceiver(configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool);
        this.startQuestDb(workerPool, lineProtocolReceiver, log);
        if (Os.type != 3 && optHash.get("-n") == null) {
            Signal.handle(new Signal("HUP"), signal -> {});
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println(new Date() + " QuestDB is shutting down");
            this.shutdownQuestDb(workerPool, cairoEngine, httpServer, pgWireServer, lineProtocolReceiver);
            System.err.println(new Date() + " QuestDB is down");
        }));
    }

    public static void deleteOrException(File file) {
        if (!file.exists()) {
            return;
        }
        ServerMain.deleteDirContentsOrException(file);
        boolean deleted = false;
        for (int retryCount = 3; retryCount > 0 && !(deleted = file.delete()); --retryCount) {
            Thread.yield();
        }
        if (!deleted) {
            throw new RuntimeException("Cannot delete file " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        new ServerMain(args);
    }

    private static CharSequenceObjHashMap<String> hashArgs(String[] args) {
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        String flag = null;
        for (String s : args) {
            if (s.startsWith("-")) {
                if (flag != null) {
                    optHash.put(flag, "");
                }
                flag = s;
                continue;
            }
            if (flag != null) {
                optHash.put(flag, s);
                flag = null;
                continue;
            }
            System.err.println("Unknown arg: " + s);
            System.exit(55);
        }
        if (flag != null) {
            optHash.put(flag, "");
        }
        return optHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractSite(String dir, boolean force) throws URISyntaxException, IOException {
        int sourceLen;
        java.nio.file.Path source;
        System.out.println("Preparing site content...");
        URL url = ServerMain.class.getResource("/site/");
        String[] components = url.toURI().toString().split("!");
        FileSystem fs = null;
        if (components.length > 1) {
            fs = FileSystems.newFileSystem(URI.create(components[0]), new HashMap());
            source = fs.getPath(components[1], new String[0]);
            sourceLen = source.toAbsolutePath().toString().length();
        } else {
            source = Paths.get(url.toURI());
            sourceLen = source.toAbsolutePath().toString().length() + 1;
        }
        try {
            File pub;
            final java.nio.file.Path target = Paths.get(dir, new String[0]);
            EnumSet<FileVisitOption> walkOptions = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
            final CopyOption[] copyOptions = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            if (force && (pub = new File(dir, "public")).exists()) {
                ServerMain.delete(pub);
            }
            java.nio.file.Files.walkFileTree(source, walkOptions, Integer.MAX_VALUE, (FileVisitor<? super java.nio.file.Path>)new FileVisitor<java.nio.file.Path>(){
                private boolean skip = true;

                @Override
                public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) {
                    if (this.skip) {
                        this.skip = false;
                    } else {
                        try {
                            this.doCopy(dir);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                        }
                        catch (IOException x) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    this.doCopy(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                private void doCopy(java.nio.file.Path dir) throws IOException {
                    java.nio.file.Path to = this.toDestination(dir);
                    java.nio.file.Files.copy(dir, to, copyOptions);
                    System.out.println("Extracted " + dir + " -> " + to);
                }

                private java.nio.file.Path toDestination(java.nio.file.Path path) {
                    java.nio.file.Path tmp = path.toAbsolutePath();
                    return target.resolve(tmp.toString().substring(sourceLen));
                }
            });
        }
        finally {
            System.out.println("Site content is ready");
            if (fs != null) {
                fs.close();
            }
        }
    }

    private static void deleteDirContentsOrException(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            File[] files;
            if (ServerMain.notSymlink(file) && (files = file.listFiles()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    ServerMain.deleteOrException(files[i]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete dir contents: " + file, e);
        }
    }

    private static boolean notSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (File.separatorChar == '\\') {
            return true;
        }
        if (file.getParentFile() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    static void delete(File file) {
        ServerMain.deleteOrException(file);
    }

    private String getVersion() throws IOException {
        Enumeration<URL> resources = ServerMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream is = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                if (!"org.questdb".equals(attributes.getValue("Implementation-Vendor-Id"))) continue;
                String string = manifest.getMainAttributes().getValue("Implementation-Version");
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return "[DEVELOPMENT]";
    }

    protected void shutdownQuestDb(WorkerPool workerPool, CairoEngine cairoEngine, HttpServer httpServer, PGWireServer pgWireServer, AbstractLineProtoReceiver lineProtocolReceiver) {
        lineProtocolReceiver.halt();
        workerPool.halt();
        Misc.free(pgWireServer);
        Misc.free(httpServer);
        Misc.free(cairoEngine);
        Misc.free(lineProtocolReceiver);
    }

    protected void startQuestDb(WorkerPool workerPool, AbstractLineProtoReceiver lineProtocolReceiver, Log log) {
        workerPool.start(log);
        lineProtocolReceiver.start();
    }
}

