/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.cairo.CairoEngine;
import io.questdb.log.Log;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public interface WorkerPoolAwareConfiguration
extends WorkerPoolConfiguration {
    public static WorkerPool configureWorkerPool(WorkerPoolAwareConfiguration configuration, WorkerPool sharedPool) {
        WorkerPool localPool = configuration.getWorkerCount() > 0 ? new WorkerPool(configuration) : sharedPool;
        return localPool;
    }

    @Nullable
    public static <T extends Closeable, C extends WorkerPoolAwareConfiguration> T create(C configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, ServerFactory<T, C> factory, MessageBus messageBus) {
        if (configuration.isEnabled()) {
            WorkerPool localPool = WorkerPoolAwareConfiguration.configureWorkerPool(configuration, sharedWorkerPool);
            boolean local = localPool != sharedWorkerPool;
            MessageBus bus = local ? new MessageBusImpl() : messageBus;
            T server = factory.create(configuration, cairoEngine, localPool, local, bus);
            if (local) {
                localPool.start(log);
            }
            return server;
        }
        return null;
    }

    public boolean isEnabled();

    @FunctionalInterface
    public static interface ServerFactory<T extends Closeable, C> {
        public T create(C var1, CairoEngine var2, WorkerPool var3, boolean var4, @Nullable MessageBus var5);
    }
}

