/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.std.LongList;

public abstract class AbstractIntervalDataFrameCursor
implements DataFrameCursor {
    protected final LongList intervals;
    protected final IntervalDataFrame dataFrame = new IntervalDataFrame();
    protected final int timestampIndex;
    protected TableReader reader;
    protected int intervalsLo;
    protected int intervalsHi;
    protected int partitionLo;
    protected int partitionHi;
    protected long partitionLimit;
    private int initialIntervalsLo;
    private int initialIntervalsHi;
    private int initialPartitionLo;
    private int initialPartitionHi;

    public AbstractIntervalDataFrameCursor(LongList intervals, int timestampIndex) {
        assert (timestampIndex > -1);
        this.intervals = new LongList(intervals);
        this.timestampIndex = timestampIndex;
    }

    protected static long search(ReadOnlyColumn column, long value, long low, long high) {
        while (low < high) {
            long mid = low + high - 1L >>> 1;
            long midVal = column.getLong(mid * 8L);
            if (midVal < value) {
                low = mid + 1L;
                continue;
            }
            if (midVal > value) {
                high = mid;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public StaticSymbolTable getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    @Override
    public boolean reload() {
        if (this.reader != null && this.reader.reload()) {
            this.calculateRanges();
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.intervalsLo = this.initialIntervalsLo;
        this.intervalsHi = this.initialIntervalsHi;
        this.partitionLo = this.initialPartitionLo;
        this.partitionHi = this.initialPartitionHi;
    }

    public void of(TableReader reader) {
        this.reader = reader;
        this.calculateRanges();
    }

    private void calculateRanges() {
        if (this.intervals.size() > 0) {
            if (this.reader.getPartitionedBy() == 3) {
                this.initialIntervalsLo = 0;
                this.initialIntervalsHi = this.intervals.size() / 2;
                this.initialPartitionLo = 0;
                this.initialPartitionHi = this.reader.getPartitionCount();
            } else {
                this.cullIntervals();
                if (this.initialIntervalsLo < this.initialIntervalsHi) {
                    this.cullPartitions();
                }
            }
            this.toTop();
        }
    }

    private void cullIntervals() {
        int intervalsLo = this.intervals.binarySearch(this.reader.getMinTimestamp());
        if (intervalsLo < 0) {
            intervalsLo = -intervalsLo - 1;
        }
        this.initialIntervalsLo = intervalsLo / 2;
        int intervalsHi = this.intervals.binarySearch(this.reader.getMaxTimestamp());
        if (intervalsHi < 0) {
            this.initialIntervalsHi = (intervalsHi = -intervalsHi - 1) % 2 == 0 ? intervalsHi / 2 : intervalsHi / 2 + 1;
        }
    }

    private void cullPartitions() {
        long intervalLo = this.reader.floorToPartitionTimestamp(this.intervals.getQuick(this.initialIntervalsLo * 2));
        this.initialPartitionLo = this.reader.getPartitionCountBetweenTimestamps(this.reader.getMinTimestamp(), intervalLo);
        long intervalHi = this.reader.floorToPartitionTimestamp(this.intervals.getQuick((this.initialIntervalsHi - 1) * 2 + 1));
        this.initialPartitionHi = Math.min(this.reader.getPartitionCount(), this.reader.getPartitionCountBetweenTimestamps(this.reader.getMinTimestamp(), intervalHi) + 1);
    }

    protected class IntervalDataFrame
    implements DataFrame {
        protected long rowLo = 0L;
        protected long rowHi;
        protected int partitionIndex;

        protected IntervalDataFrame() {
        }

        @Override
        public BitmapIndexReader getBitmapIndexReader(int columnIndex, int direction) {
            return AbstractIntervalDataFrameCursor.this.reader.getBitmapIndexReader(AbstractIntervalDataFrameCursor.this.reader.getColumnBase(this.partitionIndex), columnIndex, direction);
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return this.rowLo;
        }

        @Override
        public long getPageAddress(int columnIndex) {
            return AbstractIntervalDataFrameCursor.this.reader.getPageAddressAt(this.partitionIndex, this.rowLo, columnIndex);
        }

        @Override
        public long getPageValueCount(int columnIndex) {
            return AbstractIntervalDataFrameCursor.this.reader.getPageValueCount(this.partitionIndex, this.rowLo, this.rowHi, columnIndex);
        }
    }
}

