/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.VirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class AppendMemory
extends VirtualMemory {
    private static final Log LOG = LogFactory.getLog(AppendMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long pageAddress = 0L;

    public AppendMemory(FilesFacade ff, LPSZ name, long pageSize) {
        this.of(ff, name, pageSize);
    }

    public AppendMemory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void bestEffortClose(FilesFacade ff, Log log, long fd, boolean truncate, long size, long mapPageSize) {
        try {
            if (truncate) {
                if (ff.truncate(fd, size)) {
                    log.info().$("truncated and closed [fd=").$(fd).$(']').$();
                } else {
                    long n;
                    if (ff.isRestrictedFileSystem() && ff.truncate(fd, ((n = size / mapPageSize) + 1L) * mapPageSize)) {
                        log.info().$("truncated and closed, second attempt [fd=").$(fd).$(']').$();
                        return;
                    }
                    log.info().$("closed without truncate [fd=").$(fd).$(", errno=").$(ff.errno()).$(']').$();
                }
            } else {
                log.info().$("closed [fd=").$(fd).$(']').$();
            }
        }
        finally {
            ff.close(fd);
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    public final void setSize(long size) {
        this.jumpTo(size);
    }

    public void truncate() {
        if (this.fd == -1L) {
            return;
        }
        this.releaseCurrentPage();
        if (!this.ff.truncate(this.fd, this.getMapPageSize())) {
            throw CairoException.instance(this.ff.errno()).put("Cannot truncate fd=").put(this.fd).put(" to ").put(this.getMapPageSize()).put(" bytes");
        }
        this.pageAddress = this.mapPage(0);
        this.updateLimits(0, this.pageAddress);
        LOG.info().$("truncated [fd=").$(this.fd).$(']').$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(boolean truncate) {
        long sz = this.getAppendOffset();
        this.releaseCurrentPage();
        super.close();
        if (this.fd != -1L) {
            try {
                AppendMemory.bestEffortClose(this.ff, LOG, this.fd, truncate, sz, this.getMapPageSize());
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    public long getFd() {
        return this.fd;
    }

    public final void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.close();
        this.ff = ff;
        this.setPageSize(pageSize);
        this.fd = ff.openRW(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open ").put(name);
        }
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(", pageSize=").$(pageSize).$(']').$();
    }

    FilesFacade getFilesFacade() {
        return this.ff;
    }

    @Override
    protected long mapWritePage(int page) {
        this.releaseCurrentPage();
        this.pageAddress = this.mapPage(page);
        return this.pageAddress;
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    public void sync(boolean async) {
        if (this.pageAddress != 0L && this.ff.msync(this.pageAddress, this.getMapPageSize(), async) != 0) {
            LOG.error().$("could not msync [fd=").$(this.fd).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    private void releaseCurrentPage() {
        if (this.pageAddress != 0L) {
            this.release(0, this.pageAddress);
            this.pageAddress = 0L;
        }
    }

    private long mapPage(int page) {
        long target = this.pageOffset(page + 1);
        if (this.ff.length(this.fd) < target && !this.ff.truncate(this.fd, target)) {
            throw CairoException.instance(this.ff.errno()).put("Appender resize failed fd=").put(this.fd).put(", size=").put(target);
        }
        long offset = this.pageOffset(page);
        long address = this.ff.mmap(this.fd, this.getMapPageSize(), offset, 2);
        if (address == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Could not mmap append fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.getMapPageSize());
        }
        return address;
    }
}

