/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.ReadWriteMemory;
import io.questdb.cairo.VirtualMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class BitmapIndexWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(BitmapIndexWriter.class);
    private final ReadWriteMemory keyMem = new ReadWriteMemory();
    private final ReadWriteMemory valueMem = new ReadWriteMemory();
    private final Cursor cursor = new Cursor();
    private int blockCapacity;
    private int blockValueCountMod;
    private long valueMemSize = -1L;
    private int keyCount = -1;
    private long seekValueCount;
    private long seekValueBlockOffset;
    private final BitmapIndexUtils.ValueBlockSeeker SEEKER = this::seek;

    public BitmapIndexWriter(CairoConfiguration configuration, Path path, CharSequence name) {
        this.of(configuration, path, name);
    }

    public BitmapIndexWriter() {
    }

    public static void initKeyMemory(VirtualMemory keyMem, int blockValueCount) {
        assert (blockValueCount == Numbers.ceilPow2(blockValueCount));
        keyMem.putByte((byte)-6);
        keyMem.putLong(1L);
        Unsafe.getUnsafe().storeFence();
        keyMem.putLong(0L);
        keyMem.putInt(blockValueCount);
        keyMem.putLong(0L);
        Unsafe.getUnsafe().storeFence();
        keyMem.putLong(1L);
        keyMem.skip(64L - keyMem.getAppendOffset());
    }

    public void add(int key, long value) {
        assert (key > -1) : "key must be positive integer: " + key;
        long offset = BitmapIndexUtils.getKeyEntryOffset(key);
        if (key < this.keyCount) {
            long valueBlockOffset = this.keyMem.getLong(offset + 16L);
            long valueCount = this.keyMem.getLong(offset + 0L);
            int valueCellIndex = (int)(valueCount & (long)this.blockValueCountMod);
            if (valueCellIndex > 0) {
                assert (valueBlockOffset + (long)this.blockCapacity <= this.valueMemSize);
                this.appendValue(offset, valueBlockOffset, valueCount, valueCellIndex, value);
            } else if (valueCount == 0L) {
                this.initValueBlockAndStoreValue(offset, value);
            } else {
                assert (valueBlockOffset + (long)this.blockCapacity <= this.valueMemSize);
                this.addValueBlockAndStoreValue(offset, valueBlockOffset, valueCount, value);
            }
        } else {
            this.initValueBlockAndStoreValue(offset, value);
            this.updateKeyCount(key);
        }
    }

    @Override
    public void close() {
        if (this.keyMem.isOpen() && this.keyCount > -1) {
            this.keyMem.jumpTo(this.keyMemSize());
        }
        Misc.free(this.keyMem);
        if (this.valueMem.isOpen() && this.valueMemSize > -1L) {
            this.valueMem.jumpTo(this.valueMemSize);
        }
        Misc.free(this.valueMem);
    }

    public RowCursor getCursor(int key) {
        if (key < this.keyCount) {
            this.cursor.of(key);
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    public final void of(CairoConfiguration configuration, Path path, CharSequence name) {
        this.close();
        long pageSize = configuration.getFilesFacade().getMapPageSize();
        int plen = path.length();
        try {
            boolean exists = configuration.getFilesFacade().exists(BitmapIndexUtils.keyFileName(path, name));
            this.keyMem.of(configuration.getFilesFacade(), path, pageSize);
            if (!exists) {
                LOG.error().$(path).$(" not found").$();
                throw CairoException.instance(0).put("Index does not exist: ").put(path);
            }
            long keyMemSize = this.keyMem.getAppendOffset();
            if (keyMemSize < 64L) {
                LOG.error().$("file too short [corrupt] ").$(path).$();
                throw CairoException.instance(0).put("Index file too short (w): ").put(path);
            }
            if (this.keyMem.getByte(0L) != -6) {
                LOG.error().$("unknown format [corrupt] ").$(path).$();
                throw CairoException.instance(0).put("Unknown format: ").put(path);
            }
            this.keyCount = this.keyMem.getInt(21L);
            if (keyMemSize < this.keyMemSize()) {
                LOG.error().$("key count does not match file length [corrupt] of ").$(path).$(" [keyCount=").$(this.keyCount).$(']').$();
                throw CairoException.instance(0).put("Key count does not match file length of ").put(path);
            }
            if (this.keyMem.getLong(29L) != this.keyMem.getLong(1L)) {
                LOG.error().$("sequence mismatch [corrupt] at ").$(path).$();
                throw CairoException.instance(0).put("Sequence mismatch on ").put(path);
            }
            this.valueMem.of(configuration.getFilesFacade(), BitmapIndexUtils.valueFileName(path.trimTo(plen), name), pageSize);
            this.valueMemSize = this.keyMem.getLong(9L);
            if (this.valueMem.getAppendOffset() < this.valueMemSize) {
                LOG.error().$("incorrect file size [corrupt] of ").$(path).$(" [expected=").$(this.valueMemSize).$(']').$();
                throw CairoException.instance(0).put("Incorrect file size of ").put(path);
            }
            this.blockValueCountMod = this.keyMem.getInt(17L) - 1;
            assert (this.blockValueCountMod > 0);
            this.blockCapacity = (this.blockValueCountMod + 1) * 8 + 16;
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public void rollbackValues(long maxValue) {
        long maxValueBlockOffset = 0L;
        for (int k = 0; k < this.keyCount; ++k) {
            long offset = BitmapIndexUtils.getKeyEntryOffset(k);
            long valueCount = this.keyMem.getLong(offset + 0L);
            if (valueCount <= 0L) continue;
            long blockOffset = this.keyMem.getLong(offset + 16L);
            BitmapIndexUtils.seekValueBlockRTL(valueCount, blockOffset, this.valueMem, maxValue, this.blockValueCountMod, this.SEEKER);
            if (valueCount != this.seekValueCount || blockOffset != this.seekValueBlockOffset) {
                this.keyMem.putLong(offset + 0L, this.seekValueCount);
                if (blockOffset != this.seekValueBlockOffset) {
                    Unsafe.getUnsafe().storeFence();
                    this.keyMem.putLong(offset + 0L + 16L, this.seekValueBlockOffset);
                    Unsafe.getUnsafe().storeFence();
                }
                this.keyMem.putLong(offset + 24L, this.seekValueCount);
            }
            if (this.seekValueBlockOffset <= maxValueBlockOffset) continue;
            maxValueBlockOffset = this.seekValueBlockOffset;
        }
        this.valueMemSize = maxValueBlockOffset + (long)this.blockCapacity;
        this.updateValueMemSize();
    }

    private void addValueBlockAndStoreValue(long offset, long valueBlockOffset, long valueCount, long value) {
        long newValueBlockOffset = this.allocateValueBlockAndStore(value);
        this.valueMem.putLong(this.valueMemSize - 16L, valueBlockOffset);
        this.valueMem.putLong(valueBlockOffset + (long)this.blockCapacity - 16L + 8L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, valueCount + 1L);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 16L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 24L, valueCount + 1L);
        Unsafe.getUnsafe().storeFence();
    }

    private long allocateValueBlockAndStore(long value) {
        long newValueBlockOffset = this.valueMemSize;
        this.valueMem.putLong(newValueBlockOffset, value);
        this.valueMem.jumpTo(this.valueMemSize + (long)this.blockCapacity);
        this.valueMemSize += (long)this.blockCapacity;
        this.updateValueMemSize();
        return newValueBlockOffset;
    }

    private void appendValue(long offset, long valueBlockOffset, long valueCount, int valueCellIndex, long value) {
        this.valueMem.putLong(valueBlockOffset + (long)valueCellIndex * 8L, value);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, valueCount + 1L);
        this.keyMem.putLong(offset + 24L, valueCount + 1L);
    }

    private void initValueBlockAndStoreValue(long offset, long value) {
        long newValueBlockOffset = this.allocateValueBlockAndStore(value);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset, 1L);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 8L, newValueBlockOffset);
        this.keyMem.putLong(offset + 16L, newValueBlockOffset);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(offset + 24L, 1L);
        Unsafe.getUnsafe().storeFence();
    }

    private long keyMemSize() {
        return this.keyCount * 32 + 64;
    }

    private void seek(long count, long offset) {
        this.seekValueCount = count;
        this.seekValueBlockOffset = offset;
    }

    private void updateKeyCount(int key) {
        this.keyCount = key + 1;
        long seq = this.keyMem.getLong(1L) + 1L;
        this.keyMem.putLong(1L, seq);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putInt(21L, this.keyCount);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(29L, seq);
    }

    private void updateValueMemSize() {
        long seq = this.keyMem.getLong(1L) + 1L;
        this.keyMem.putLong(1L, seq);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(9L, this.valueMemSize);
        Unsafe.getUnsafe().storeFence();
        this.keyMem.putLong(29L, seq);
    }

    private class Cursor
    implements RowCursor {
        private long valueBlockOffset;
        private long valueCount;

        private Cursor() {
        }

        @Override
        public boolean hasNext() {
            return this.valueCount > 0L;
        }

        @Override
        public long next() {
            long cellIndex = this.getValueCellIndex(--this.valueCount);
            long result = BitmapIndexWriter.this.valueMem.getLong(this.valueBlockOffset + cellIndex * 8L);
            if (cellIndex == 0L && this.valueCount > 0L) {
                this.jumpToPreviousValueBlock();
            }
            return result;
        }

        private long getPreviousBlock(long currentValueBlockOffset) {
            return BitmapIndexWriter.this.valueMem.getLong(currentValueBlockOffset + (long)BitmapIndexWriter.this.blockCapacity - 16L);
        }

        private long getValueCellIndex(long absoluteValueIndex) {
            return absoluteValueIndex & (long)BitmapIndexWriter.this.blockValueCountMod;
        }

        private void jumpToPreviousValueBlock() {
            this.valueBlockOffset = this.getPreviousBlock(this.valueBlockOffset);
        }

        void of(int key) {
            assert (key > -1) : "key must be positive integer: " + key;
            long offset = BitmapIndexUtils.getKeyEntryOffset(key);
            this.valueCount = BitmapIndexWriter.this.keyMem.getLong(offset + 0L);
            assert (this.valueCount > -1L);
            this.valueBlockOffset = BitmapIndexWriter.this.keyMem.getLong(offset + 16L);
        }
    }
}

