/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.cairo.pool.ReaderPool;
import io.questdb.cairo.pool.WriterPool;
import io.questdb.cairo.sql.ReaderOutOfDateException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class CairoEngine
implements Closeable {
    private static final Log LOG = LogFactory.getLog(CairoEngine.class);
    private final WriterPool writerPool;
    private final ReaderPool readerPool;
    private final CairoConfiguration configuration;
    private final WriterMaintenanceJob writerMaintenanceJob;

    public CairoEngine(CairoConfiguration configuration) {
        this(configuration, null);
    }

    public CairoEngine(CairoConfiguration configuration, @Nullable MessageBus messageBus) {
        this.configuration = configuration;
        this.writerPool = new WriterPool(configuration, messageBus);
        this.readerPool = new ReaderPool(configuration);
        this.writerMaintenanceJob = new WriterMaintenanceJob(configuration);
    }

    @Override
    public void close() {
        Misc.free(this.writerPool);
        Misc.free(this.readerPool);
    }

    public void creatTable(CairoSecurityContext securityContext, AppendMemory mem, Path path, TableStructure struct) {
        TableUtils.createTable(this.configuration.getFilesFacade(), mem, path, this.configuration.getRoot(), struct, this.configuration.getMkDirMode());
    }

    public int getBusyReaderCount() {
        return this.readerPool.getBusyCount();
    }

    public int getBusyWriterCount() {
        return this.writerPool.getBusyCount();
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public PoolListener getPoolListener() {
        return this.writerPool.getPoolListener();
    }

    public void setPoolListener(PoolListener poolListener) {
        this.writerPool.setPoolListener(poolListener);
        this.readerPool.setPoolListener(poolListener);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName) {
        return this.getReader(securityContext, tableName, -1L);
    }

    public TableReader getReader(CairoSecurityContext securityContext, CharSequence tableName, long version) {
        TableReader reader = this.readerPool.get(tableName);
        if (version > -1L && reader.getVersion() != version) {
            reader.close();
            throw ReaderOutOfDateException.INSTANCE;
        }
        return reader;
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName, int lo, int hi) {
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableName, lo, hi);
    }

    public int getStatus(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        return this.getStatus(securityContext, path, tableName, 0, tableName.length());
    }

    public TableWriter getWriter(CairoSecurityContext securityContext, CharSequence tableName) {
        return this.writerPool.get(tableName);
    }

    public WriterMaintenanceJob getWriterMaintenanceJob() {
        return this.writerMaintenanceJob;
    }

    public boolean lock(CairoSecurityContext securityContext, CharSequence tableName) {
        if (this.writerPool.lock(tableName)) {
            boolean locked = this.readerPool.lock(tableName);
            if (locked) {
                return true;
            }
            this.writerPool.unlock(tableName);
        }
        return false;
    }

    public boolean lockReaders(CharSequence tableName) {
        return this.readerPool.lock(tableName);
    }

    public boolean migrateNullFlag(CairoSecurityContext cairoSecurityContext, CharSequence tableName) {
        try (TableWriter writer = this.getWriter(cairoSecurityContext, tableName);
             TableReader reader = this.getReader(cairoSecurityContext, tableName);){
            TableReaderMetadata readerMetadata = (TableReaderMetadata)reader.getMetadata();
            if (readerMetadata.getVersion() < 416) {
                LOG.info().$("migrating null flag for symbols [table=").utf8(tableName).$(']').$();
                int count = reader.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    if (readerMetadata.getColumnType(i) != 11) continue;
                    LOG.info().$("updating null flag [column=").utf8(readerMetadata.getColumnName(i)).$(']').$();
                    writer.getSymbolMapWriter(i).updateNullFlag(reader.hasNull(i));
                }
                writer.updateMetadataVersion();
                LOG.info().$("migrated null flag for symbols [table=").utf8(tableName).$(", tableVersion=").$(416).$(']').$();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean releaseAllReaders() {
        return this.readerPool.releaseAll();
    }

    public boolean releaseAllWriters() {
        return this.writerPool.releaseAll();
    }

    public void releaseInactive() {
        this.writerPool.releaseInactive();
        this.readerPool.releaseInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CairoSecurityContext securityContext, Path path, CharSequence tableName) {
        if (this.lock(securityContext, tableName)) {
            try {
                path.of(this.configuration.getRoot()).concat(tableName).$();
                if (!this.configuration.getFilesFacade().rmdir(path)) {
                    int error = this.configuration.getFilesFacade().errno();
                    LOG.error().$("remove failed [tableName='").utf8(tableName).$("', error=").$(error).$(']').$();
                    throw CairoException.instance(error).put("Table remove failed");
                }
                return;
            }
            finally {
                this.unlock(securityContext, tableName, null);
            }
        }
        throw CairoException.instance(this.configuration.getFilesFacade().errno()).put("Could not lock '").put(tableName).put('\'');
    }

    public boolean removeDirectory(Path path, CharSequence dir) {
        path.of(this.configuration.getRoot()).concat(dir);
        FilesFacade ff = this.configuration.getFilesFacade();
        return ff.rmdir(path.put(Files.SEPARATOR).$());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(CairoSecurityContext securityContext, Path path, CharSequence tableName, Path otherPath, CharSequence newName) {
        if (this.lock(securityContext, tableName)) {
            try {
                this.rename0(path, tableName, otherPath, newName);
            }
            finally {
                this.unlock(securityContext, tableName, null);
            }
        } else {
            LOG.error().$("cannot lock and rename [from='").$(tableName).$("', to='").$(newName).$("']").$();
            throw CairoException.instance(0).put("Cannot lock [table=").put(tableName).put(']');
        }
    }

    public void unlock(CairoSecurityContext securityContext, CharSequence tableName, @Nullable TableWriter writer) {
        this.readerPool.unlock(tableName);
        this.writerPool.unlock(tableName, writer);
    }

    public void unlockReaders(CharSequence tableName) {
        this.readerPool.unlock(tableName);
    }

    private void rename0(Path path, CharSequence tableName, Path otherPath, CharSequence to) {
        CharSequence root;
        FilesFacade ff = this.configuration.getFilesFacade();
        if (TableUtils.exists(ff, path, root = this.configuration.getRoot(), tableName) != 0) {
            LOG.error().$('\'').utf8(tableName).$("' does not exist. Rename failed.").$();
            throw CairoException.instance(0).put("Rename failed. Table '").put(tableName).put("' does not exist");
        }
        path.of(root).concat(tableName).$();
        otherPath.of(root).concat(to).$();
        if (ff.exists(otherPath)) {
            LOG.error().$("rename target exists [from='").$(tableName).$("', to='").$(otherPath).$("']").$();
            throw CairoException.instance(0).put("Rename target exists");
        }
        if (!ff.rename(path, otherPath)) {
            int error = ff.errno();
            LOG.error().$("rename failed [from='").$(path).$("', to='").$(otherPath).$("', error=").$(error).$(']').$();
            throw CairoException.instance(error).put("Rename failed");
        }
    }

    private class WriterMaintenanceJob
    extends SynchronizedJob {
        private final MicrosecondClock clock;
        private final long checkInterval;
        private long last = 0L;

        public WriterMaintenanceJob(CairoConfiguration configuration) {
            this.clock = configuration.getMicrosecondClock();
            this.checkInterval = configuration.getIdleCheckInterval() * 1000L;
        }

        protected boolean doRun() {
            boolean w = CairoEngine.this.writerPool.releaseInactive();
            boolean r = CairoEngine.this.readerPool.releaseInactive();
            return w || r;
        }

        @Override
        protected boolean runSerially() {
            long t = this.clock.getTicks();
            if (this.last + this.checkInterval < t) {
                this.last = t;
                return this.doRun();
            }
            return false;
        }
    }
}

