/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class CairoException
extends RuntimeException
implements Sinkable {
    private static final ThreadLocal<CairoException> tlException = new ThreadLocal<CairoException>(CairoException::new);
    private final StringSink message = new StringSink();
    private int errno;

    public static CairoException instance(int errno) {
        CairoException ex = (CairoException)tlException.get();
        ex.message.clear();
        ex.errno = errno;
        return ex;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message.toString();
    }

    public CairoException put(long value) {
        this.message.put(value);
        return this;
    }

    public CairoException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public CairoException put(char c) {
        this.message.put(c);
        return this;
    }

    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put('[').put(this.errno).put("]: ").put(this.message);
    }
}

