/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.TableWriter;
import io.questdb.mp.Job;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.tasks.ColumnIndexerTask;

public class ColumnIndexerJob
implements Job {
    private final RingQueue<ColumnIndexerTask> queue;
    private final Sequence subSeq;

    public ColumnIndexerJob(MessageBus messageBus) {
        this.queue = messageBus.getIndexerQueue();
        this.subSeq = messageBus.getIndexerSubSequence();
    }

    @Override
    public boolean run() {
        long cursor = this.subSeq.next();
        if (cursor < 0L) {
            return false;
        }
        ColumnIndexerTask queueItem = this.queue.get(cursor);
        ColumnIndexer indexer = queueItem.indexer;
        long lo = queueItem.lo;
        long hi = queueItem.hi;
        long indexSequence = queueItem.sequence;
        SOCountDownLatch latch = queueItem.countDownLatch;
        this.subSeq.done(cursor);
        if (indexer.tryLock(indexSequence)) {
            TableWriter.indexAndCountDown(indexer, lo, hi, latch);
            return true;
        }
        return false;
    }
}

