/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.std.IntObjHashMap;
import io.questdb.std.LowerCaseAsciiCharSequenceIntHashMap;

public final class ColumnType {
    public static final int VERSION = 416;
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int CHAR = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int DATE = 6;
    public static final int TIMESTAMP = 7;
    public static final int FLOAT = 8;
    public static final int DOUBLE = 9;
    public static final int STRING = 10;
    public static final int SYMBOL = 11;
    public static final int LONG256 = 12;
    public static final int BINARY = 13;
    public static final int PARAMETER = 14;
    public static final int MAX = 14;
    private static final IntObjHashMap<String> typeNameMap = new IntObjHashMap();
    private static final LowerCaseAsciiCharSequenceIntHashMap nameTypeMap = new LowerCaseAsciiCharSequenceIntHashMap();
    private static final int[] TYPE_SIZE_POW2 = new int[15];
    private static final int[] TYPE_SIZE = new int[15];

    private ColumnType() {
    }

    public static int columnTypeOf(CharSequence name) {
        return nameTypeMap.get(name);
    }

    public static String nameOf(int columnType) {
        int index = typeNameMap.keyIndex(columnType);
        if (index > -1) {
            return "unknown";
        }
        return typeNameMap.valueAtQuick(index);
    }

    public static int pow2SizeOf(int columnType) {
        return TYPE_SIZE_POW2[columnType];
    }

    public static int sizeOf(int columnType) {
        if (columnType < 0 || columnType > 14) {
            return -1;
        }
        return TYPE_SIZE[columnType];
    }

    static {
        typeNameMap.put(0, "BOOLEAN");
        typeNameMap.put(1, "BYTE");
        typeNameMap.put(9, "DOUBLE");
        typeNameMap.put(8, "FLOAT");
        typeNameMap.put(4, "INT");
        typeNameMap.put(5, "LONG");
        typeNameMap.put(2, "SHORT");
        typeNameMap.put(3, "CHAR");
        typeNameMap.put(10, "STRING");
        typeNameMap.put(11, "SYMBOL");
        typeNameMap.put(13, "BINARY");
        typeNameMap.put(6, "DATE");
        typeNameMap.put(14, "PARAMETER");
        typeNameMap.put(7, "TIMESTAMP");
        typeNameMap.put(101, "CURSOR");
        typeNameMap.put(12, "LONG256");
        nameTypeMap.put("boolean", 0);
        nameTypeMap.put("byte", 1);
        nameTypeMap.put("double", 9);
        nameTypeMap.put("float", 8);
        nameTypeMap.put("int", 4);
        nameTypeMap.put("long", 5);
        nameTypeMap.put("short", 2);
        nameTypeMap.put("char", 3);
        nameTypeMap.put("string", 10);
        nameTypeMap.put("symbol", 11);
        nameTypeMap.put("binary", 13);
        nameTypeMap.put("date", 6);
        nameTypeMap.put("parameter", 14);
        nameTypeMap.put("timestamp", 7);
        nameTypeMap.put("cursor", 101);
        nameTypeMap.put("long256", 12);
        ColumnType.TYPE_SIZE_POW2[0] = 0;
        ColumnType.TYPE_SIZE_POW2[1] = 0;
        ColumnType.TYPE_SIZE_POW2[2] = 1;
        ColumnType.TYPE_SIZE_POW2[3] = 1;
        ColumnType.TYPE_SIZE_POW2[8] = 2;
        ColumnType.TYPE_SIZE_POW2[4] = 2;
        ColumnType.TYPE_SIZE_POW2[11] = 2;
        ColumnType.TYPE_SIZE_POW2[9] = 3;
        ColumnType.TYPE_SIZE_POW2[5] = 3;
        ColumnType.TYPE_SIZE_POW2[6] = 3;
        ColumnType.TYPE_SIZE_POW2[7] = 3;
        ColumnType.TYPE_SIZE_POW2[12] = 8;
        ColumnType.TYPE_SIZE[0] = 1;
        ColumnType.TYPE_SIZE[1] = 1;
        ColumnType.TYPE_SIZE[2] = 2;
        ColumnType.TYPE_SIZE[3] = 2;
        ColumnType.TYPE_SIZE[8] = 4;
        ColumnType.TYPE_SIZE[4] = 4;
        ColumnType.TYPE_SIZE[11] = 4;
        ColumnType.TYPE_SIZE[9] = 8;
        ColumnType.TYPE_SIZE[5] = 8;
        ColumnType.TYPE_SIZE[6] = 8;
        ColumnType.TYPE_SIZE[7] = 8;
        ColumnType.TYPE_SIZE[12] = 32;
    }
}

