/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cutlass.text.DefaultTextConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.microtime.MicrosecondClockImpl;
import io.questdb.std.time.MillisecondClock;
import io.questdb.std.time.MillisecondClockImpl;

public class DefaultCairoConfiguration
implements CairoConfiguration {
    private final CharSequence root;
    private final TextConfiguration textConfiguration = new DefaultTextConfiguration();

    public DefaultCairoConfiguration(CharSequence root) {
        this.root = Chars.toString(root);
    }

    @Override
    public int getCreateAsSelectRetryCount() {
        return 5;
    }

    @Override
    public CharSequence getDefaultMapType() {
        return "fast";
    }

    @Override
    public boolean getDefaultSymbolCacheFlag() {
        return true;
    }

    @Override
    public int getDefaultSymbolCapacity() {
        return 128;
    }

    @Override
    public int getFileOperationRetryCount() {
        return 30;
    }

    @Override
    public FilesFacade getFilesFacade() {
        return FilesFacadeImpl.INSTANCE;
    }

    @Override
    public long getIdleCheckInterval() {
        return 100L;
    }

    @Override
    public long getInactiveReaderTTL() {
        return -10000L;
    }

    @Override
    public long getInactiveWriterTTL() {
        return -10000L;
    }

    @Override
    public int getIndexValueBlockSize() {
        return 256;
    }

    @Override
    public int getMaxSwapFileCount() {
        return 30;
    }

    @Override
    public MicrosecondClock getMicrosecondClock() {
        return MicrosecondClockImpl.INSTANCE;
    }

    @Override
    public MillisecondClock getMillisecondClock() {
        return MillisecondClockImpl.INSTANCE;
    }

    @Override
    public int getMkDirMode() {
        return 509;
    }

    @Override
    public int getParallelIndexThreshold() {
        return 100000;
    }

    @Override
    public int getReaderPoolMaxSegments() {
        return 5;
    }

    @Override
    public CharSequence getRoot() {
        return this.root;
    }

    @Override
    public long getSpinLockTimeoutUs() {
        return 1000000L;
    }

    @Override
    public int getSqlCharacterStoreCapacity() {
        return 64;
    }

    @Override
    public int getCommitMode() {
        return 2;
    }

    @Override
    public int getSqlCharacterStoreSequencePoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlColumnPoolCapacity() {
        return 4096;
    }

    @Override
    public double getSqlCompactMapLoadFactor() {
        return 0.8;
    }

    @Override
    public int getSqlExpressionPoolCapacity() {
        return 8192;
    }

    @Override
    public double getSqlFastMapLoadFactor() {
        return 0.5;
    }

    @Override
    public int getSqlJoinContextPoolCapacity() {
        return 64;
    }

    @Override
    public int getSqlLexerPoolCapacity() {
        return 2048;
    }

    @Override
    public int getSqlMapKeyCapacity() {
        return 128;
    }

    @Override
    public int getSqlMapPageSize() {
        return 0x1000000;
    }

    @Override
    public int getSqlModelPoolCapacity() {
        return 1024;
    }

    @Override
    public long getSqlSortKeyPageSize() {
        return 0x400000L;
    }

    @Override
    public long getSqlSortLightValuePageSize() {
        return 0x100000L;
    }

    @Override
    public int getSqlHashJoinValuePageSize() {
        return 0x1000000;
    }

    @Override
    public long getSqlLatestByRowCount() {
        return 1000L;
    }

    @Override
    public int getSqlHashJoinLightValuePageSize() {
        return 0x100000;
    }

    @Override
    public int getSqlSortValuePageSize() {
        return 0x1000000;
    }

    @Override
    public long getWorkStealTimeoutNanos() {
        return 10000L;
    }

    @Override
    public boolean isParallelIndexingEnabled() {
        return true;
    }

    @Override
    public int getSqlJoinMetadataPageSize() {
        return 16384;
    }

    @Override
    public int getAnalyticColumnPoolCapacity() {
        return 64;
    }

    @Override
    public int getCreateTableModelPoolCapacity() {
        return 32;
    }

    @Override
    public int getColumnCastModelPoolCapacity() {
        return 32;
    }

    @Override
    public int getRenameTableModelPoolCapacity() {
        return 8;
    }

    @Override
    public int getWithClauseModelPoolCapacity() {
        return 128;
    }

    @Override
    public int getInsertPoolCapacity() {
        return 8;
    }

    @Override
    public int getCopyPoolCapacity() {
        return 16;
    }

    @Override
    public int getSqlCopyBufferSize() {
        return 0x100000;
    }

    @Override
    public TextConfiguration getTextConfiguration() {
        return this.textConfiguration;
    }

    @Override
    public CharSequence getInputRoot() {
        return null;
    }
}

