/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.ObjList;

public class GenericRecordMetadata
extends BaseRecordMetadata {
    public static final GenericRecordMetadata EMPTY = new GenericRecordMetadata();

    public GenericRecordMetadata() {
        this.columnMetadata = new ObjList();
        this.columnNameIndexMap = new CharSequenceIntHashMap();
        this.timestampIndex = -1;
    }

    public static void copyColumns(RecordMetadata from, GenericRecordMetadata to) {
        int n = from.getColumnCount();
        for (int i = 0; i < n; ++i) {
            to.add(new TableColumnMetadata(from.getColumnName(i), from.getColumnType(i), from.isColumnIndexed(i), from.getIndexValueBlockCapacity(i), from.isSymbolTableStatic(i)));
        }
    }

    public static GenericRecordMetadata copyOf(RecordMetadata that) {
        GenericRecordMetadata metadata = GenericRecordMetadata.copyOfSansTimestamp(that);
        metadata.setTimestampIndex(that.getTimestampIndex());
        return metadata;
    }

    public static GenericRecordMetadata copyOfSansTimestamp(RecordMetadata that) {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        GenericRecordMetadata.copyColumns(that, metadata);
        return metadata;
    }

    public GenericRecordMetadata add(TableColumnMetadata meta) {
        int index = this.columnNameIndexMap.keyIndex(meta.getName());
        if (index > -1) {
            this.columnNameIndexMap.putAt(index, meta.getName(), this.columnCount);
            this.columnMetadata.add(meta);
            ++this.columnCount;
            return this;
        }
        throw CairoException.instance(0).put("Duplicate column [name=").put(meta.getName()).put(']');
    }

    public void clear() {
        this.columnMetadata.clear();
        this.columnNameIndexMap.clear();
        this.columnCount = 0;
        this.timestampIndex = -1;
    }

    public void setTimestampIndex(int index) {
        this.timestampIndex = index;
    }
}

