/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalDataFrameCursor;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.std.LongList;

public class IntervalBwdDataFrameCursor
extends AbstractIntervalDataFrameCursor {
    public IntervalBwdDataFrameCursor(LongList intervals, int timestampIndex) {
        super(intervals, timestampIndex);
    }

    @Override
    public DataFrame next() {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            int currentInterval = this.intervalsHi - 1;
            int currentPartition = this.partitionHi - 1;
            long rowCount = this.reader.openPartition(currentPartition);
            if (rowCount > 0L) {
                long hi;
                ReadOnlyColumn column = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.reader.getColumnBase(currentPartition), this.timestampIndex));
                long intervalLo = this.intervals.getQuick(currentInterval * 2);
                long intervalHi = this.intervals.getQuick(currentInterval * 2 + 1);
                if (column.getLong(0L) > intervalHi) {
                    this.partitionHi = currentPartition;
                    this.partitionLimit = -1L;
                    continue;
                }
                if (column.getLong((rowCount - 1L) * 8L) < intervalLo) {
                    this.partitionLimit = -1L;
                    this.intervalsHi = currentInterval;
                    continue;
                }
                long lo = IntervalBwdDataFrameCursor.search(column, intervalLo, 0L, this.partitionLimit == -1L ? rowCount : this.partitionLimit);
                if (lo < 0L) {
                    lo = -lo - 1L;
                }
                hi = (hi = IntervalBwdDataFrameCursor.search(column, intervalHi, lo, rowCount)) < 0L ? -hi - 1L : ++hi;
                if (lo < hi) {
                    this.dataFrame.partitionIndex = currentPartition;
                    this.dataFrame.rowLo = lo;
                    this.dataFrame.rowHi = hi;
                    if (lo == 0L) {
                        this.partitionLimit = -1L;
                        this.partitionHi = currentPartition;
                    } else {
                        this.partitionLimit = lo;
                        this.intervalsHi = currentInterval;
                    }
                    return this.dataFrame;
                }
                this.partitionLimit = lo;
                this.intervalsHi = currentInterval;
                continue;
            }
            this.partitionHi = currentPartition;
        }
        return null;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = -1L;
    }
}

