/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractIntervalDataFrameCursor;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.std.LongList;

public class IntervalFwdDataFrameCursor
extends AbstractIntervalDataFrameCursor {
    public IntervalFwdDataFrameCursor(LongList intervals, int timestampIndex) {
        super(intervals, timestampIndex);
    }

    @Override
    public DataFrame next() {
        while (this.intervalsLo < this.intervalsHi && this.partitionLo < this.partitionHi) {
            long rowCount = this.reader.openPartition(this.partitionLo);
            if (rowCount > 0L) {
                long lo;
                ReadOnlyColumn column = this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.reader.getColumnBase(this.partitionLo), this.timestampIndex));
                long intervalLo = this.intervals.getQuick(this.intervalsLo * 2);
                long intervalHi = this.intervals.getQuick(this.intervalsLo * 2 + 1);
                long partitionTimestampLo = column.getLong(0L);
                if (partitionTimestampLo > intervalHi) {
                    ++this.intervalsLo;
                    continue;
                }
                long partitionTimestampHi = column.getLong((rowCount - 1L) * 8L);
                if (partitionTimestampHi < intervalLo) {
                    this.partitionLimit = 0L;
                    ++this.partitionLo;
                    continue;
                }
                if (partitionTimestampLo == intervalLo) {
                    lo = 0L;
                } else {
                    lo = IntervalFwdDataFrameCursor.search(column, intervalLo, this.partitionLimit, rowCount);
                    if (lo < 0L) {
                        lo = -lo - 1L;
                    }
                }
                long hi = IntervalFwdDataFrameCursor.search(column, intervalHi, lo, rowCount);
                hi = hi < 0L ? -hi - 1L : ++hi;
                if (lo < hi) {
                    this.dataFrame.partitionIndex = this.partitionLo++;
                    this.dataFrame.rowLo = lo;
                    this.dataFrame.rowHi = hi;
                    if (hi == rowCount) {
                        this.partitionLimit = 0L;
                    } else {
                        this.partitionLimit = hi;
                        ++this.intervalsLo;
                    }
                    return this.dataFrame;
                }
                this.partitionLimit = hi;
                ++this.intervalsLo;
                continue;
            }
            ++this.partitionLo;
        }
        return null;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.partitionLimit = 0L;
    }
}

