/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.FilesFacade;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Sink;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.LPSZ;
import java.io.Closeable;

public class OnePageMemory
implements ReadOnlyColumn,
Closeable {
    private static final Log LOG = LogFactory.getLog(OnePageMemory.class);
    private final ByteSequenceView bsview = new ByteSequenceView();
    private final CharSequenceView csview = new CharSequenceView();
    private final CharSequenceView csview2 = new CharSequenceView();
    private final Long256Impl long256 = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private long page = -1L;
    private FilesFacade ff;
    private long fd = -1L;
    private long size = 0L;
    private long absolutePointer;

    public OnePageMemory(FilesFacade ff, LPSZ name, long size) {
        this.of(ff, name, 0L, size);
    }

    public long addressOf(long offset) {
        assert (offset < this.size) : "offset=" + offset + ", size=" + this.size + ", fd=" + this.fd;
        return this.absolutePointer + offset;
    }

    @Override
    public void close() {
        if (this.page != -1L) {
            this.ff.munmap(this.page, this.size);
        }
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
            this.size = 0L;
        }
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.close();
        this.ff = ff;
        boolean exists = ff.exists(name);
        if (!exists) {
            throw CairoException.instance(0).put("File not found: ").put(name);
        }
        this.fd = ff.openRO(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open file: ").put(name);
        }
        this.size = size;
        this.absolutePointer = this.page = ff.mmap(this.fd, size, 0L, 1);
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(", pageSize=").$(size).$(", size=").$(this.size).$(']').$();
    }

    @Override
    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len == -1L) {
            return null;
        }
        return this.bsview.of(offset + 8L, len);
    }

    @Override
    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    @Override
    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    @Override
    public final byte getByte(long offset) {
        return Unsafe.getUnsafe().getByte(this.addressOf(offset));
    }

    @Override
    public final double getDouble(long offset) {
        return Unsafe.getUnsafe().getDouble(this.addressOf(offset));
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public final float getFloat(long offset) {
        return Unsafe.getUnsafe().getFloat(this.addressOf(offset));
    }

    @Override
    public final int getInt(long offset) {
        return Unsafe.getUnsafe().getInt(this.addressOf(offset));
    }

    @Override
    public long getLong(long offset) {
        return Unsafe.getUnsafe().getLong(this.addressOf(offset));
    }

    @Override
    public final short getShort(long offset) {
        return Unsafe.getUnsafe().getShort(this.absolutePointer + offset);
    }

    @Override
    public final CharSequence getStr(long offset) {
        return this.getStr0(offset, this.csview);
    }

    @Override
    public final CharSequence getStr2(long offset) {
        return this.getStr0(offset, this.csview2);
    }

    @Override
    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256);
        return this.long256;
    }

    @Override
    public void getLong256(long offset, CharSink sink) {
        long a = Unsafe.getUnsafe().getLong(this.addressOf(offset));
        long b = Unsafe.getUnsafe().getLong(this.addressOf(offset + 8L));
        long c = Unsafe.getUnsafe().getLong(this.addressOf(offset + 16L));
        long d = Unsafe.getUnsafe().getLong(this.addressOf(offset + 24L));
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    @Override
    public final char getChar(long offset) {
        return Unsafe.getUnsafe().getChar(this.addressOf(offset));
    }

    @Override
    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    @Override
    public void grow(long size) {
    }

    @Override
    public boolean isDeleted() {
        return !this.ff.exists(this.fd);
    }

    @Override
    public int getPageCount() {
        return 1;
    }

    @Override
    public long getPageSize(int pageIndex) {
        return this.size;
    }

    @Override
    public long getPageAddress(int pageIndex) {
        return this.absolutePointer;
    }

    public void getLong256(long offset, Long256Sink sink) {
        sink.setLong0(Unsafe.getUnsafe().getLong(this.addressOf(offset)));
        sink.setLong1(Unsafe.getUnsafe().getLong(this.addressOf(offset + 8L)));
        sink.setLong2(Unsafe.getUnsafe().getLong(this.addressOf(offset + 16L)));
        sink.setLong3(Unsafe.getUnsafe().getLong(this.addressOf(offset + 24L)));
    }

    public final CharSequence getStr0(long offset, CharSequenceView view) {
        int len = this.getInt(offset);
        if (offset + (long)len + 4L < this.size) {
            if (len == -1) {
                return null;
            }
            if (len == 0) {
                return "";
            }
            return view.of(offset + 4L, len);
        }
        throw CairoException.instance(0).put("String is outside of file boundary [offset=").put(offset).put(", len=").put(len).put(']');
    }

    public long size() {
        return this.size;
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long offset;
        private long len = -1L;
        private long readAddress;

        private ByteSequenceView() {
        }

        @Override
        public byte byteAt(long index) {
            return Unsafe.getUnsafe().getByte(this.readAddress++);
        }

        @Override
        public void copyTo(long address, long start, long length) {
            long bytesRemaining = Math.min(length, this.len - start);
            long offset = this.offset + start;
            Unsafe.getUnsafe().copyMemory(OnePageMemory.this.page + offset, address, bytesRemaining);
        }

        @Override
        public long length() {
            return this.len;
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            this.readAddress = OnePageMemory.this.page + offset;
            return this;
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long offset;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return OnePageMemory.this.getChar(this.offset + (long)index * 2L);
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }
}

