/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.VirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class ReadOnlyMemory
extends VirtualMemory
implements ReadOnlyColumn {
    private static final Log LOG = LogFactory.getLog(ReadOnlyMemory.class);
    private FilesFacade ff;
    private long fd = -1L;
    private long size = 0L;
    private long lastPageSize;
    private int lastPageIndex;
    private long pageSize;
    private long userSize = 0L;

    public ReadOnlyMemory(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.of(ff, name, pageSize, size);
    }

    public ReadOnlyMemory() {
    }

    @Override
    public void close() {
        super.close();
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            LOG.info().$("closed [fd=").$(this.fd).$(']').$();
            this.fd = -1L;
            this.size = 0L;
            this.userSize = 0L;
        }
    }

    @Override
    public long getPageAddress(int page) {
        long address = super.getPageAddress(page);
        if (address != 0L) {
            return address;
        }
        return this.mapPage(page);
    }

    @Override
    public int getPageCount() {
        return this.pageIndex(this.userSize) + 1;
    }

    @Override
    public long getPageSize(int page) {
        if (page == this.lastPageIndex) {
            return this.lastPageSize;
        }
        return super.getPageSize(page);
    }

    @Override
    protected long mapWritePage(int page) {
        throw new UnsupportedOperationException("Cannot jump() read-only memory. Use grow() instead.");
    }

    @Override
    protected void release(int page, long address) {
        if (address != 0L) {
            this.ff.munmap(address, this.getPageSize(page));
            if (page == this.lastPageIndex) {
                this.lastPageSize = this.getMapPageSize();
            }
        }
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public void grow(long size) {
        if (size > this.userSize) {
            this.userSize = size;
        }
        if (size > this.size) {
            long fileSize = this.ff.length(this.fd);
            this.grow0(Math.max(size, fileSize));
        }
    }

    @Override
    public boolean isDeleted() {
        return !this.ff.exists(this.fd);
    }

    @Override
    public void of(FilesFacade ff, LPSZ name, long pageSize, long size) {
        this.close();
        this.ff = ff;
        boolean exists = ff.exists(name);
        if (!exists) {
            throw CairoException.instance(0).put("File not found: ").put(name);
        }
        this.fd = ff.openRO(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open file: ").put(name);
        }
        this.pageSize = pageSize;
        this.grow(size);
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(", pageSize=").$(pageSize).$(", size=").$(this.size).$(']').$();
    }

    public long size() {
        return this.size;
    }

    private long computePageSize(long memorySize) {
        if (memorySize < this.pageSize) {
            return Math.max(this.ff.getPageSize(), memorySize / this.ff.getPageSize() * this.ff.getPageSize());
        }
        return this.pageSize;
    }

    private void grow0(long size) {
        long targetPageSize = this.computePageSize(size);
        if (targetPageSize != this.getMapPageSize()) {
            this.setPageSize(targetPageSize);
            this.ensurePagesListCapacity(size);
            this.lastPageSize = Math.min(targetPageSize, size);
        } else {
            this.ensurePagesListCapacity(size);
            if (this.lastPageSize < this.getMapPageSize()) {
                int lastIndex = this.pages.size() - 1;
                if (lastIndex > -1) {
                    long address = this.pages.getQuick(lastIndex);
                    if (address != 0L) {
                        this.release(lastIndex, address);
                        this.pages.setQuick(lastIndex, 0L);
                    }
                    this.clearHotPage();
                }
                this.lastPageIndex = 0;
                this.lastPageSize = this.getMapPageSize();
            }
        }
        this.size = size;
    }

    private long mapPage(int page) {
        long offset = this.pageOffset(page);
        long sz = this.size - offset;
        if (sz > 0L) {
            if (sz < this.getMapPageSize()) {
                this.lastPageSize = sz;
                this.lastPageIndex = page;
            } else {
                sz = this.getMapPageSize();
            }
            long address = this.ff.mmap(this.fd, sz, offset, 1);
            return address == -1L ? this.recoverPageMapOrFail(page, offset, sz) : this.cachePageAddress(page, address);
        }
        throw CairoException.instance(this.ff.errno()).put("Trying to map read-only page outside of file boundary. fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.size).put(", page=").put(sz);
    }

    private long recoverPageMapOrFail(int page, long offset, long sz) {
        if (this.ff.isRestrictedFileSystem() && this.ff.errno() == 8) {
            this.size = Math.min(this.userSize, this.ff.length(this.fd));
            this.lastPageSize = sz = this.size - offset;
            this.lastPageIndex = page;
            long address = this.ff.mmap(this.fd, sz, offset, 1);
            if (address != -1L) {
                return this.cachePageAddress(page, address);
            }
        }
        throw CairoException.instance(this.ff.errno()).put("Cannot mmap read-only fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(this.size).put(", page=").put(sz);
    }
}

