/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.VirtualMemory;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.str.LPSZ;

public class ReadWriteMemory
extends VirtualMemory {
    private static final Log LOG = LogFactory.getLog(ReadWriteMemory.class);
    private FilesFacade ff;
    private long fd = -1L;

    public ReadWriteMemory(FilesFacade ff, LPSZ name, long maxPageSize) {
        this.of(ff, name, maxPageSize);
    }

    public ReadWriteMemory() {
    }

    @Override
    public void close() {
        long size = this.getAppendOffset();
        super.close();
        if (this.isOpen()) {
            try {
                AppendMemory.bestEffortClose(this.ff, LOG, this.fd, true, size, this.getMapPageSize());
            }
            finally {
                this.fd = -1L;
            }
        }
    }

    @Override
    protected long allocateNextPage(int page) {
        long address;
        long offset = this.pageOffset(page);
        long pageSize = this.getMapPageSize();
        if (this.ff.length(this.fd) < offset + pageSize) {
            this.ff.truncate(this.fd, offset + pageSize);
        }
        if ((address = this.ff.mmap(this.fd, pageSize, offset, 2)) == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot mmap read-write fd=").put(this.fd).put(", offset=").put(offset).put(", size=").put(pageSize);
        }
        return address;
    }

    @Override
    protected long getPageAddress(int page) {
        return this.mapWritePage(page);
    }

    @Override
    protected void release(int page, long address) {
        this.ff.munmap(address, this.getPageSize(page));
    }

    public long getFd() {
        return this.fd;
    }

    public boolean isOpen() {
        return this.fd != -1L;
    }

    public final void of(FilesFacade ff, LPSZ name, long pageSize) {
        this.close();
        this.ff = ff;
        this.fd = ff.openRW(name);
        if (this.fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open file: ").put(name);
        }
        long size = ff.length(this.fd);
        this.setPageSize(pageSize);
        this.ensurePagesListCapacity(size);
        LOG.info().$("open ").$(name).$(" [fd=").$(this.fd).$(']').$();
        try {
            this.jumpTo(size);
        }
        catch (CairoException e) {
            ff.close(this.fd);
            this.fd = -1L;
            throw e;
        }
    }

    public void sync(boolean async) {
        int n = this.pages.size();
        for (int i = 0; i < n; ++i) {
            this.sync(i, async);
        }
    }

    public void sync(int pageIndex, boolean async) {
        if (this.ff.msync(this.pages.getQuick(pageIndex), this.getMapPageSize(), async) != 0) {
            LOG.error().$("could not msync [fd=").$(this.fd).$(']').$();
        }
    }
}

