/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.SlidingWindowMemory;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.VirtualMemory;
import io.questdb.std.Misc;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

class SymbolColumnIndexer
implements ColumnIndexer,
Closeable {
    private static final long SEQUENCE_OFFSET = Unsafe.getFieldOffset(SymbolColumnIndexer.class, "sequence");
    private final BitmapIndexWriter writer = new BitmapIndexWriter();
    private final SlidingWindowMemory mem = new SlidingWindowMemory();
    private long columnTop;
    private volatile long sequence = 0L;
    private volatile boolean distressed = false;

    SymbolColumnIndexer() {
    }

    @Override
    public void close() {
        Misc.free(this.writer);
        Misc.free(this.mem);
    }

    @Override
    public void distress() {
        this.distressed = true;
    }

    @Override
    public long getFd() {
        return this.mem.getFd();
    }

    @Override
    public long getSequence() {
        return this.sequence;
    }

    @Override
    public void refreshSourceAndIndex(long loRow, long hiRow) {
        this.mem.updateSize();
        this.index(this.mem, loRow, hiRow);
    }

    @Override
    public void index(VirtualMemory mem, long loRow, long hiRow) {
        for (long lo = loRow - this.columnTop; lo < hiRow; ++lo) {
            this.writer.add(TableUtils.toIndexKey(mem.getInt(lo * 4L)), lo + this.columnTop);
        }
    }

    @Override
    public boolean isDistressed() {
        return this.distressed;
    }

    @Override
    public void configureFollowerAndWriter(CairoConfiguration configuration, Path path, CharSequence name, AppendMemory columnMem, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name);
            this.mem.of(columnMem);
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void configureWriter(CairoConfiguration configuration, Path path, CharSequence name, long columnTop) {
        this.columnTop = columnTop;
        try {
            this.writer.of(configuration, path, name);
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void rollback(long maxRow) {
        this.writer.rollbackValues(maxRow);
    }

    @Override
    public boolean tryLock(long expectedSequence) {
        return Unsafe.cas((Object)this, SEQUENCE_OFFSET, expectedSequence, expectedSequence + 1L);
    }
}

