/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ReadWriteMemory;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.VirtualMemory;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.Hash;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class SymbolMapWriter
implements Closeable {
    public static final int HEADER_SIZE = 64;
    private static final Log LOG = LogFactory.getLog(SymbolMapWriter.class);
    public static final int HEADER_CAPACITY = 0;
    public static final int HEADER_CACHE_ENABLED = 4;
    public static final int HEADER_NULL_FLAG = 8;
    private final BitmapIndexWriter indexWriter;
    private final ReadWriteMemory charMem;
    private final ReadWriteMemory offsetMem;
    private final CharSequenceIntHashMap cache;
    private final int maxHash;
    private boolean nullValue = false;

    public SymbolMapWriter(CairoConfiguration configuration, Path path, CharSequence name, int symbolCount) {
        int plen = path.length();
        try {
            FilesFacade ff = configuration.getFilesFacade();
            long mapPageSize = ff.getMapPageSize();
            SymbolMapWriter.offsetFileName(path.trimTo(plen), name);
            if (!ff.exists(path)) {
                LOG.error().$(path).$(" is not found").$();
                throw CairoException.instance(0).put("SymbolMap does not exist: ").put(path);
            }
            long len = ff.length(path);
            if (len < 64L) {
                LOG.error().$(path).$(" is too short [len=").$(len).$(']').$();
                throw CairoException.instance(0).put("SymbolMap is too short: ").put(path);
            }
            this.offsetMem = new ReadWriteMemory(ff, path, mapPageSize);
            int symbolCapacity = this.offsetMem.getInt(0L);
            boolean useCache = this.offsetMem.getBool(4L);
            this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount));
            this.indexWriter = new BitmapIndexWriter(configuration, path.trimTo(plen), name);
            this.charMem = new ReadWriteMemory(ff, SymbolMapWriter.charFileName(path.trimTo(plen), name), mapPageSize);
            this.jumpCharMemToSymbolCount(symbolCount);
            this.maxHash = Numbers.ceilPow2(symbolCapacity / 2) - 1;
            this.cache = useCache ? new CharSequenceIntHashMap(symbolCapacity) : null;
            LOG.info().$("open [name=").$(path.trimTo(plen).concat(name).$()).$(", fd=").$(this.offsetMem.getFd()).$(", cache=").$(this.cache != null).$(", capacity=").$(symbolCapacity).$(']').$();
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
        finally {
            path.trimTo(plen);
        }
    }

    public static Path charFileName(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".c").$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSymbolMapFiles(FilesFacade ff, AppendMemory mem, Path path, CharSequence columnName, int symbolCapacity, boolean symbolCacheFlag) {
        int plen = path.length();
        try {
            mem.of(ff, SymbolMapWriter.offsetFileName(path.trimTo(plen), columnName), ff.getPageSize());
            mem.putInt(symbolCapacity);
            mem.putBool(symbolCacheFlag);
            mem.jumpTo(64L);
            mem.close();
            if (!ff.touch(SymbolMapWriter.charFileName(path.trimTo(plen), columnName))) {
                throw CairoException.instance(ff.errno()).put("Cannot create ").put(path);
            }
            mem.of(ff, BitmapIndexUtils.keyFileName(path.trimTo(plen), columnName), ff.getPageSize());
            BitmapIndexWriter.initKeyMemory(mem, TableUtils.MIN_INDEX_VALUE_BLOCK_SIZE);
            ff.touch(BitmapIndexUtils.valueFileName(path.trimTo(plen), columnName));
        }
        finally {
            path.trimTo(plen);
            mem.close();
        }
    }

    public static Path offsetFileName(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".o").$();
    }

    public int put(CharSequence symbol) {
        if (symbol == null) {
            if (!this.nullValue) {
                this.nullValue = true;
                this.updateNullFlag(true);
            }
            return Integer.MIN_VALUE;
        }
        if (this.cache != null) {
            int index = this.cache.keyIndex(symbol);
            return index < 0 ? this.cache.valueAt(index) : this.lookupPutAndCache(index, symbol);
        }
        return this.lookupAndPut(symbol);
    }

    static int offsetToKey(long offset) {
        return (int)((offset - 64L) / 8L);
    }

    static long keyToOffset(int key) {
        return 64L + (long)key * 8L;
    }

    @Override
    public void close() {
        Misc.free(this.indexWriter);
        Misc.free(this.charMem);
        if (this.offsetMem != null) {
            long fd = this.offsetMem.getFd();
            Misc.free(this.offsetMem);
            LOG.info().$("closed [fd=").$(fd).$(']').$();
        }
        this.nullValue = false;
    }

    public int getSymbolCount() {
        return SymbolMapWriter.offsetToKey(this.offsetMem.getAppendOffset());
    }

    public void updateNullFlag(boolean flag) {
        this.offsetMem.putBool(8L, flag);
    }

    public void rollback(int symbolCount) {
        this.indexWriter.rollbackValues(SymbolMapWriter.keyToOffset(symbolCount));
        this.offsetMem.jumpTo(SymbolMapWriter.keyToOffset(symbolCount));
        this.jumpCharMemToSymbolCount(symbolCount);
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    boolean isCached() {
        return this.cache != null;
    }

    private void jumpCharMemToSymbolCount(int symbolCount) {
        if (symbolCount > 0) {
            long lastSymbolOffset = this.offsetMem.getLong(SymbolMapWriter.keyToOffset(symbolCount - 1));
            int l = VirtualMemory.getStorageLength(this.charMem.getStr(lastSymbolOffset));
            this.charMem.jumpTo(lastSymbolOffset + (long)l);
        } else {
            this.charMem.jumpTo(0L);
        }
    }

    private int lookupAndPut(CharSequence symbol) {
        int hash = Hash.boundedHash(symbol, this.maxHash);
        RowCursor cursor = this.indexWriter.getCursor(hash);
        while (cursor.hasNext()) {
            long offsetOffset = cursor.next();
            if (!Chars.equals(symbol, this.charMem.getStr(this.offsetMem.getLong(offsetOffset)))) continue;
            return SymbolMapWriter.offsetToKey(offsetOffset);
        }
        return this.put0(symbol, hash);
    }

    private int lookupPutAndCache(int index, CharSequence symbol) {
        int result = this.lookupAndPut(symbol);
        this.cache.putAt(index, symbol.toString(), result);
        return result;
    }

    private int put0(CharSequence symbol, int hash) {
        long offsetOffset = this.offsetMem.getAppendOffset();
        this.offsetMem.putLong(this.charMem.putStr(symbol));
        this.indexWriter.add(hash, offsetOffset);
        return SymbolMapWriter.offsetToKey(offsetOffset);
    }
}

