/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexBwdNullReader;
import io.questdb.cairo.BitmapIndexBwdReader;
import io.questdb.cairo.BitmapIndexFwdNullReader;
import io.questdb.cairo.BitmapIndexFwdReader;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.EmptySymbolMapReader;
import io.questdb.cairo.NullColumn;
import io.questdb.cairo.OnePageMemory;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.ReadOnlyMemory;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableReaderRecordCursor;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.LongHashSet;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.microtime.TimestampLocaleFactory;
import io.questdb.std.microtime.Timestamps;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.util.concurrent.locks.LockSupport;

public class TableReader
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableReader.class);
    private static final PartitionPathGenerator YEAR_GEN = TableReader::pathGenYear;
    private static final PartitionPathGenerator MONTH_GEN = TableReader::pathGenMonth;
    private static final PartitionPathGenerator DAY_GEN = TableReader::pathGenDay;
    private static final PartitionPathGenerator DEFAULT_GEN = (reader, partitionIndex) -> reader.pathGenDefault();
    private static final ReloadMethod FIRST_TIME_NON_PARTITIONED_RELOAD_METHOD = TableReader::reloadInitialNonPartitioned;
    private static final ReloadMethod FIRST_TIME_PARTITIONED_RELOAD_METHOD = TableReader::reloadInitialPartitioned;
    private static final ReloadMethod PARTITIONED_RELOAD_METHOD = TableReader::reloadPartitioned;
    private static final ReloadMethod NON_PARTITIONED_RELOAD_METHOD = TableReader::reloadNonPartitioned;
    private static final Timestamps.TimestampFloorMethod ENTITY_FLOOR_METHOD = timestamp -> timestamp;
    private final ColumnCopyStruct tempCopyStruct = new ColumnCopyStruct();
    private final FilesFacade ff;
    private final Path path;
    private final int rootLen;
    private final ReadOnlyColumn txMem;
    private final TableReaderMetadata metadata;
    private final LongList partitionRowCounts;
    private final PartitionPathGenerator partitionPathGenerator;
    private final TableReaderRecordCursor recordCursor = new TableReaderRecordCursor();
    private final Timestamps.TimestampFloorMethod timestampFloorMethod;
    private final IntervalLengthMethod intervalLengthMethod;
    private final Timestamps.TimestampAddMethod timestampAddMethod;
    private final String tableName;
    private final ObjList<SymbolMapReader> symbolMapReaders = new ObjList();
    private final CairoConfiguration configuration;
    private final IntList symbolCountSnapshot = new IntList();
    private final LongHashSet removedPartitions = new LongHashSet();
    private LongList columnTops;
    private ObjList<ReadOnlyColumn> columns;
    private ObjList<BitmapIndexReader> bitmapIndexes;
    private int columnCount;
    private int columnCountBits;
    private long transientRowCount;
    private long structVersion;
    private long dataVersion;
    private long prevStructVersion;
    private long partitionTableVersion;
    private long prevPartitionTableVersion;
    private long rowCount;
    private long txn = 0L;
    private long maxTimestamp = Long.MIN_VALUE;
    private int partitionCount;
    private long minTimestamp = Long.MAX_VALUE;
    private long prevMinTimestamp = Long.MAX_VALUE;
    private ReloadMethod reloadMethod;
    private long tempMem8b = Unsafe.malloc(8L);

    public TableReader(CairoConfiguration configuration, CharSequence tableName) {
        LOG.info().$("open '").utf8(tableName).$('\'').$();
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.tableName = Chars.toString(tableName);
        this.path = new Path().of(configuration.getRoot()).concat(tableName);
        this.rootLen = this.path.length();
        try {
            this.failOnPendingTodo();
            this.txMem = this.openTxnFile();
            this.metadata = this.openMetaFile();
            this.columnCount = this.metadata.getColumnCount();
            this.columnCountBits = TableReader.getColumnBits(this.columnCount);
            switch (this.metadata.getPartitionBy()) {
                case 0: {
                    this.partitionPathGenerator = DAY_GEN;
                    this.reloadMethod = FIRST_TIME_PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Timestamps::floorDD;
                    this.intervalLengthMethod = Timestamps::getDaysBetween;
                    this.timestampAddMethod = Timestamps::addDays;
                    break;
                }
                case 1: {
                    this.partitionPathGenerator = MONTH_GEN;
                    this.reloadMethod = FIRST_TIME_PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Timestamps::floorMM;
                    this.intervalLengthMethod = Timestamps::getMonthsBetween;
                    this.timestampAddMethod = Timestamps::addMonths;
                    break;
                }
                case 2: {
                    this.partitionPathGenerator = YEAR_GEN;
                    this.reloadMethod = FIRST_TIME_PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = Timestamps::floorYYYY;
                    this.intervalLengthMethod = Timestamps::getYearsBetween;
                    this.timestampAddMethod = Timestamps::addYear;
                    break;
                }
                default: {
                    this.partitionPathGenerator = DEFAULT_GEN;
                    this.reloadMethod = FIRST_TIME_NON_PARTITIONED_RELOAD_METHOD;
                    this.timestampFloorMethod = ENTITY_FLOOR_METHOD;
                    this.intervalLengthMethod = null;
                    this.timestampAddMethod = null;
                }
            }
            this.readTxn();
            this.openSymbolMaps();
            this.prevStructVersion = this.structVersion;
            this.prevPartitionTableVersion = this.partitionTableVersion;
            if (this.metadata.getPartitionBy() == 3) {
                this.checkDefaultPartitionExistsAndUpdatePartitionCount();
            } else {
                this.partitionCount = this.calculatePartitionCount();
            }
            int capacity = this.getColumnBase(this.partitionCount);
            this.columns = new ObjList(capacity);
            this.columns.setPos(capacity);
            this.bitmapIndexes = new ObjList(capacity);
            this.bitmapIndexes.setPos(capacity);
            this.partitionRowCounts = new LongList(this.partitionCount);
            this.partitionRowCounts.seed(this.partitionCount, -1L);
            this.columnTops = new LongList(capacity / 2);
            this.columnTops.setPos(capacity / 2);
            this.recordCursor.of(this);
        }
        catch (CairoException e) {
            this.close();
            throw e;
        }
    }

    public static int getPrimaryColumnIndex(int base, int index) {
        return base + index * 2;
    }

    public double avgDouble(int columnIndex) {
        double result = 0.0;
        long countTotal = 0L;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyColumn column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long a = column.getPageAddress(pageIndex);
                long count = column.getPageSize(pageIndex) / 8L;
                result += Vect.avgDouble(a, count);
                ++countTotal;
            }
        }
        if (countTotal == 0L) {
            return 0.0;
        }
        return result / (double)countTotal;
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.freeSymbolMapReaders();
            this.freeBitmapIndexCache();
            Misc.free(this.path);
            Misc.free(this.metadata);
            Misc.free(this.txMem);
            this.freeColumns();
            this.freeTempMem();
            LOG.info().$("closed '").utf8(this.tableName).$('\'').$();
        }
    }

    public void closeColumnForRemove(int columnIndex) {
        assert (columnIndex > -1 && columnIndex < this.columnCount);
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            this.closeColumn(this.getColumnBase(partitionIndex), columnIndex);
        }
        if (this.metadata.getColumnType(columnIndex) == 11) {
            Misc.free(this.symbolMapReaders.getAndSetQuick(columnIndex, EmptySymbolMapReader.INSTANCE));
        }
    }

    public void closeColumnForRemove(CharSequence columnName) {
        this.closeColumnForRemove(this.metadata.getColumnIndex(columnName));
    }

    public long floorToPartitionTimestamp(long timestamp) {
        return this.timestampFloorMethod.floor(timestamp);
    }

    public BitmapIndexReader getBitmapIndexReader(int columnBase, int columnIndex, int direction) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        BitmapIndexReader reader = this.bitmapIndexes.getQuick(direction == 2 ? index : index + 1);
        return reader == null ? this.createBitmapIndexReaderAt(index, columnBase, columnIndex, direction) : reader;
    }

    public int getColumnBase(int partitionIndex) {
        return partitionIndex << this.columnCountBits;
    }

    public TableReaderRecordCursor getCursor() {
        this.recordCursor.toTop();
        return this.recordCursor;
    }

    public long getDataVersion() {
        return this.dataVersion;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    public long getPageAddressAt(int partitionIndex, long row, int columnIndex) {
        int base = this.getColumnBase(partitionIndex);
        int column = TableReader.getPrimaryColumnIndex(base, columnIndex);
        long r = row - this.getColumnTop(base, columnIndex);
        int columnType = this.metadata.getColumnType(columnIndex);
        switch (columnType) {
            case 10: 
            case 13: {
                return this.getColumn(column + 1).getLong(r * 8L);
            }
        }
        return r * (long)ColumnType.sizeOf(columnType);
    }

    public long getPageValueCount(int partitionIndex, long rowLo, long rowHi, int columnIndex) {
        return rowHi - rowLo - this.getColumnTop(this.getColumnBase(partitionIndex), columnIndex);
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }

    public int getPartitionCountBetweenTimestamps(long partitionTimestamp1, long partitionTimestamp2) {
        return (int)this.intervalLengthMethod.calculate(partitionTimestamp1, partitionTimestamp2);
    }

    public int getPartitionedBy() {
        return this.metadata.getPartitionBy();
    }

    public SymbolMapReader getSymbolMapReader(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex);
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getVersion() {
        return this.structVersion;
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public double maxDouble(int columnIndex) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyColumn column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                double x = Vect.maxDouble(a, count = column.getPageSize(pageIndex) / 8L);
                if (!(x > max)) continue;
                max = x;
            }
        }
        return max;
    }

    public double minDouble(int columnIndex) {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyColumn column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                double x = Vect.minDouble(a, count = column.getPageSize(pageIndex) / 8L);
                if (!(x < min)) continue;
                min = x;
            }
        }
        return min;
    }

    public boolean reload() {
        return this.reloadMethod.reload(this);
    }

    public void reshuffleSymbolMapReaders(long pTransitionIndex) {
        int i;
        int columnCount = Unsafe.getUnsafe().getInt(pTransitionIndex + 4L);
        long index = pTransitionIndex + 8L;
        long stateAddress = index + (long)(columnCount * 8);
        if (columnCount > this.columnCount) {
            this.symbolMapReaders.setPos(columnCount);
        }
        Unsafe.getUnsafe().setMemory(stateAddress, columnCount, (byte)0);
        for (i = 0; i < columnCount; ++i) {
            if (Unsafe.getUnsafe().getByte(stateAddress + (long)i) == -1) continue;
            Unsafe.getUnsafe().putByte(stateAddress + (long)i, (byte)-1);
            int copyFrom = Unsafe.getUnsafe().getInt(index + (long)(i * 8));
            if (copyFrom == i + 1 && copyFrom < columnCount) {
                SymbolMapReader reader = this.symbolMapReaders.getQuick(copyFrom);
                if (reader == null || !reader.isDeleted()) continue;
                this.symbolMapReaders.setQuick(copyFrom, this.reloadSymbolMapReader(copyFrom, reader));
                continue;
            }
            if (copyFrom > 0) {
                SymbolMapReader tmp = this.copyOrRenewSymbolMapReader(this.symbolMapReaders.getAndSetQuick(copyFrom - 1, null), i);
                int copyTo = Unsafe.getUnsafe().getInt(index + (long)(i * 8) + 4L);
                while (copyTo > 0 && Unsafe.getUnsafe().getByte(stateAddress + (long)copyTo - 1L) != -1) {
                    Unsafe.getUnsafe().putByte(stateAddress + (long)copyTo - 1L, (byte)-1);
                    tmp = this.copyOrRenewSymbolMapReader(tmp, copyTo - 1);
                    copyTo = Unsafe.getUnsafe().getInt(index + (long)((copyTo - 1) * 8) + 4L);
                }
                Misc.free(tmp);
                continue;
            }
            Misc.free(this.symbolMapReaders.getAndSetQuick(i, this.reloadSymbolMapReader(i, null)));
        }
        if (columnCount < this.columnCount) {
            for (i = columnCount; i < this.columnCount; ++i) {
                Misc.free(this.symbolMapReaders.getQuick(i));
            }
            this.symbolMapReaders.setPos(columnCount);
        }
    }

    public long size() {
        return this.rowCount;
    }

    public double sumDouble(int columnIndex) {
        double result = 0.0;
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyColumn column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long a = column.getPageAddress(pageIndex);
                long count = column.getPageSize(pageIndex) / 8L;
                result += Vect.sumDouble(a, count);
            }
        }
        return result;
    }

    private static int getColumnBits(int columnCount) {
        return Numbers.msb(Numbers.ceilPow2(columnCount) * 2);
    }

    private static boolean isEntryToBeProcessed(long address, int index) {
        if (Unsafe.getUnsafe().getByte(address + (long)index) == -1) {
            return false;
        }
        Unsafe.getUnsafe().putByte(address + (long)index, (byte)-1);
        return true;
    }

    private static void growColumn(ReadOnlyColumn mem1, ReadOnlyColumn mem2, int type, long rowCount) {
        if (rowCount > 0L) {
            switch (type) {
                case 13: {
                    TableReader.growBin(mem1, mem2, rowCount);
                    break;
                }
                case 10: {
                    TableReader.growStr(mem1, mem2, rowCount);
                    break;
                }
                default: {
                    mem1.grow(rowCount << ColumnType.pow2SizeOf(type));
                }
            }
        }
    }

    private static void growStr(ReadOnlyColumn mem1, ReadOnlyColumn mem2, long rowCount) {
        assert (mem2 != null);
        mem2.grow(rowCount * 8L);
        long offset = mem2.getLong((rowCount - 1L) * 8L);
        mem1.grow(offset + 4L);
        long len = mem1.getInt(offset);
        if (len > 0L) {
            mem1.grow(offset + len * 2L + 4L);
        }
    }

    private static void growBin(ReadOnlyColumn mem1, ReadOnlyColumn mem2, long rowCount) {
        assert (mem2 != null);
        mem2.grow(rowCount * 8L);
        long offset = mem2.getLong((rowCount - 1L) * 8L);
        mem1.grow(offset + 8L);
        long len = mem1.getLong(offset);
        if (len > 0L) {
            mem1.grow(offset + len + 8L);
        }
    }

    private void applyTruncate() {
        LOG.info().$("truncate detected").$();
        int n = this.partitionCount;
        for (int i = 0; i < n; ++i) {
            long size = this.openPartition0(i);
            if (size != -1L) continue;
            int base = this.getColumnBase(i);
            for (int k = 0; k < this.columnCount; ++k) {
                int index = TableReader.getPrimaryColumnIndex(base, k);
                Misc.free(this.columns.getAndSetQuick(index, null));
                Misc.free(this.columns.getAndSetQuick(index + 1, null));
                Misc.free(this.bitmapIndexes.getAndSetQuick(index, null));
                Misc.free(this.bitmapIndexes.getAndSetQuick(index + 1, null));
            }
            this.partitionRowCounts.setQuick(i, -1L);
        }
        this.reloadSymbolMapCounts();
        this.partitionCount = this.calculatePartitionCount();
        if (this.partitionCount > 0) {
            this.updateCapacities();
        }
    }

    private int calculatePartitionCount() {
        if (this.minTimestamp == Long.MAX_VALUE) {
            return 0;
        }
        return this.maxTimestamp == Long.MIN_VALUE ? 1 : this.getPartitionCountBetweenTimestamps(this.minTimestamp, this.floorToPartitionTimestamp(this.maxTimestamp)) + 1;
    }

    private void checkDefaultPartitionExistsAndUpdatePartitionCount() {
        if (this.maxTimestamp == Long.MIN_VALUE) {
            this.partitionCount = 0;
        } else {
            Path path = this.pathGenDefault();
            this.partitionCount = this.ff.exists(path) ? 1 : 0;
            path.trimTo(this.rootLen);
        }
    }

    private void closeColumn(int columnBase, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        Misc.free(this.columns.getAndSetQuick(index, ForceNullColumn.INSTANCE));
        Misc.free(this.columns.getAndSetQuick(index + 1, ForceNullColumn.INSTANCE));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index, null));
        Misc.free(this.bitmapIndexes.getAndSetQuick(index + 1, null));
    }

    private void closeRemovedPartitions() {
        int n = this.removedPartitions.size();
        for (int i = 0; i < n; ++i) {
            long timestamp = this.removedPartitions.get(i);
            int partitionIndex = this.getPartitionCountBetweenTimestamps(this.prevMinTimestamp, timestamp);
            if (partitionIndex <= -1) continue;
            if (partitionIndex < this.partitionCount) {
                if (this.getPartitionRowCount(partitionIndex) == -1L) continue;
                int base = this.getColumnBase(partitionIndex);
                for (int k = 0; k < this.columnCount; ++k) {
                    this.closeColumn(base, k);
                }
                this.partitionRowCounts.setQuick(partitionIndex, -1L);
                continue;
            }
            LOG.error().$("partition index is out of range [partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(", timestamp=").$ts(timestamp).$(']').$();
        }
        if (this.prevMinTimestamp != this.minTimestamp) {
            assert (this.prevMinTimestamp < this.minTimestamp);
            int delta = this.getPartitionCountBetweenTimestamps(this.prevMinTimestamp, this.minTimestamp);
            this.columns.remove(0, this.getColumnBase(delta) - 1);
            this.prevMinTimestamp = this.minTimestamp;
            this.partitionCount -= delta;
        }
    }

    private void copyColumnsTo(ObjList<ReadOnlyColumn> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount, boolean lastPartition) {
        ReadOnlyColumn mem1 = this.tempCopyStruct.mem1;
        boolean reload = (mem1 instanceof ReadOnlyMemory || mem1 instanceof ForceNullColumn) && mem1.isDeleted();
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        this.tempCopyStruct.mem1 = columns.getAndSetQuick(index, mem1);
        this.tempCopyStruct.mem2 = columns.getAndSetQuick(index + 1, this.tempCopyStruct.mem2);
        this.tempCopyStruct.top = columnTops.getAndSetQuick(columnBase / 2 + columnIndex, this.tempCopyStruct.top);
        this.tempCopyStruct.backwardReader = indexReaders.getAndSetQuick(index, this.tempCopyStruct.backwardReader);
        this.tempCopyStruct.forwardReader = indexReaders.getAndSetQuick(index + 1, this.tempCopyStruct.forwardReader);
        if (reload) {
            this.reloadColumnAt(this.path, columns, columnTops, indexReaders, columnBase, columnIndex, partitionRowCount, lastPartition);
        }
    }

    private SymbolMapReader copyOrRenewSymbolMapReader(SymbolMapReader reader, int columnIndex) {
        if (reader != null && reader.isDeleted()) {
            reader = this.reloadSymbolMapReader(columnIndex, reader);
        }
        return this.symbolMapReaders.getAndSetQuick(columnIndex, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BitmapIndexReader createBitmapIndexReaderAt(int globalIndex, int columnBase, int columnIndex, int direction) {
        BitmapIndexReader reader;
        if (!this.metadata.isColumnIndexed(columnIndex)) {
            throw CairoException.instance(0).put("Not indexed: ").put(this.metadata.getColumnName(columnIndex));
        }
        ReadOnlyColumn col = this.columns.getQuick(globalIndex);
        if (col instanceof NullColumn) {
            if (direction == 2) {
                reader = new BitmapIndexBwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex, reader);
            } else {
                reader = new BitmapIndexFwdNullReader();
                this.bitmapIndexes.setQuick(globalIndex + 1, reader);
            }
        } else {
            Path path = this.partitionPathGenerator.generate(this, this.getPartitionIndex(columnBase));
            try {
                if (direction == 2) {
                    reader = new BitmapIndexBwdReader(this.configuration, path.chopZ(), this.metadata.getColumnName(columnIndex), this.getColumnTop(columnBase, columnIndex));
                    this.bitmapIndexes.setQuick(globalIndex, reader);
                } else {
                    reader = new BitmapIndexFwdReader(this.configuration, path.chopZ(), this.metadata.getColumnName(columnIndex), this.getColumnTop(columnBase, columnIndex));
                    this.bitmapIndexes.setQuick(globalIndex + 1, reader);
                }
            }
            finally {
                path.trimTo(this.rootLen);
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewColumnList(int columnCount, long pTransitionIndex, int columnBits) {
        int capacity = this.partitionCount << columnBits;
        ObjList<ReadOnlyColumn> columns = new ObjList<ReadOnlyColumn>(capacity);
        LongList columnTops = new LongList(capacity / 2);
        ObjList<BitmapIndexReader> indexReaders = new ObjList<BitmapIndexReader>(capacity);
        columns.setPos(capacity);
        columnTops.setPos(capacity / 2);
        indexReaders.setPos(capacity);
        long pIndexBase = pTransitionIndex + 8L;
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = partitionIndex << columnBits;
            int oldBase = partitionIndex << this.columnCountBits;
            try {
                int i;
                Path path = this.partitionPathGenerator.generate(this, partitionIndex);
                long partitionRowCount = this.partitionRowCounts.getQuick(partitionIndex);
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                for (i = 0; i < columnCount; ++i) {
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)(i * 8)) - 1;
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, this.bitmapIndexes, oldBase, copyFrom);
                        this.copyColumnsTo(columns, columnTops, indexReaders, base, i, partitionRowCount, lastPartition);
                        continue;
                    }
                    this.reloadColumnAt(path, columns, columnTops, indexReaders, base, i, partitionRowCount, lastPartition);
                }
                for (i = 0; i < this.columnCount; ++i) {
                    int index = TableReader.getPrimaryColumnIndex(oldBase, i);
                    Misc.free(this.columns.getQuick(index));
                    Misc.free(this.columns.getQuick(index + 1));
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        this.columns = columns;
        this.columnTops = columnTops;
        this.columnCountBits = columnBits;
        this.bitmapIndexes = indexReaders;
    }

    private void failOnPendingTodo() {
        try {
            if (this.ff.exists(this.path.concat("_todo").$())) {
                throw CairoException.instance(0).put("Table ").put(this.path.$()).put(" is pending recovery.");
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void fetchColumnsFrom(ObjList<ReadOnlyColumn> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex) {
        int index = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
        this.tempCopyStruct.mem1 = columns.getAndSetQuick(index, null);
        this.tempCopyStruct.mem2 = columns.getAndSetQuick(index + 1, null);
        this.tempCopyStruct.top = columnTops.getQuick(columnBase / 2 + columnIndex);
        this.tempCopyStruct.backwardReader = indexReaders.getAndSetQuick(index, null);
        this.tempCopyStruct.forwardReader = indexReaders.getAndSetQuick(index + 1, null);
    }

    private void freeBitmapIndexCache() {
        Misc.freeObjList(this.bitmapIndexes);
    }

    private void freeColumns() {
        Misc.freeObjList(this.columns);
    }

    private void freeSymbolMapReaders() {
        int n = this.symbolMapReaders.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.symbolMapReaders.getQuick(i));
        }
        this.symbolMapReaders.clear();
    }

    private void freeTempMem() {
        if (this.tempMem8b != 0L) {
            Unsafe.free(this.tempMem8b, 8L);
            this.tempMem8b = 0L;
        }
    }

    ReadOnlyColumn getColumn(int absoluteIndex) {
        return this.columns.getQuick(absoluteIndex);
    }

    int getColumnCount() {
        return this.columnCount;
    }

    long getColumnTop(int base, int columnIndex) {
        return this.columnTops.getQuick(base / 2 + columnIndex);
    }

    int getPartitionIndex(int columnBase) {
        return columnBase >>> this.columnCountBits;
    }

    long getPartitionRowCount(int partitionIndex) {
        assert (this.partitionRowCounts.size() > 0);
        return this.partitionRowCounts.getQuick(partitionIndex);
    }

    long getTransientRowCount() {
        return this.transientRowCount;
    }

    long getTxn() {
        return this.txn;
    }

    boolean hasNull(int columnIndex) {
        for (int i = 0; i < this.partitionCount; ++i) {
            this.openPartition(i);
            int base = this.getColumnBase(i);
            int index = TableReader.getPrimaryColumnIndex(base, columnIndex);
            ReadOnlyColumn column = this.columns.getQuick(index);
            if (column == null) continue;
            int pageCount = column.getPageCount();
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                long count;
                long a = column.getPageAddress(pageIndex);
                if (!Vect.hasNull(a, count = column.getPageSize(pageIndex) / 4L)) continue;
                return true;
            }
        }
        return false;
    }

    private void incrementPartitionCountBy(int delta) {
        this.partitionRowCounts.seed(this.partitionCount, delta, -1L);
        this.partitionCount += delta;
        this.updateCapacities();
    }

    boolean isColumnCached(int columnIndex) {
        return this.symbolMapReaders.getQuick(columnIndex).isCached();
    }

    private TableReaderMetadata openMetaFile() {
        try {
            TableReaderMetadata tableReaderMetadata = new TableReaderMetadata(this.ff, this.path.concat("_meta").$());
            return tableReaderMetadata;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    long openPartition(int partitionIndex) {
        long size = this.getPartitionRowCount(partitionIndex);
        if (size != -1L) {
            return size;
        }
        return this.openPartition0(partitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long openPartition0(int partitionIndex) {
        if (this.timestampAddMethod != null && this.removedPartitions.contains(this.timestampAddMethod.calculate(this.minTimestamp, partitionIndex))) {
            return -1L;
        }
        if (this.maxTimestamp == Long.MIN_VALUE) {
            return -1L;
        }
        try {
            Path path = this.partitionPathGenerator.generate(this, partitionIndex);
            if (this.ff.exists(path)) {
                path.chopZ();
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                long partitionSize = lastPartition ? this.transientRowCount : TableUtils.readPartitionSize(this.ff, path, this.tempMem8b);
                LOG.info().$("open partition ").utf8(path.$()).$(" [rowCount=").$(partitionSize).$(", transientRowCount=").$(this.transientRowCount).$(", partitionIndex=").$(partitionIndex).$(", partitionCount=").$(this.partitionCount).$(']').$();
                if (partitionSize > 0L) {
                    this.openPartitionColumns(path, this.getColumnBase(partitionIndex), partitionSize, lastPartition);
                    this.partitionRowCounts.setQuick(partitionIndex, partitionSize);
                    if (this.maxTimestamp != Long.MIN_VALUE) {
                        if (this.reloadMethod == FIRST_TIME_PARTITIONED_RELOAD_METHOD) {
                            this.reloadMethod = PARTITIONED_RELOAD_METHOD;
                        } else if (this.reloadMethod == FIRST_TIME_NON_PARTITIONED_RELOAD_METHOD) {
                            this.reloadMethod = NON_PARTITIONED_RELOAD_METHOD;
                        }
                    }
                }
                long l = partitionSize;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void openPartitionColumns(Path path, int columnBase, long partitionRowCount, boolean lastPartition) {
        for (int i = 0; i < this.columnCount; ++i) {
            this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, columnBase, i, partitionRowCount, lastPartition);
        }
    }

    private void openSymbolMaps() {
        int symbolColumnIndex = 0;
        int columnCount = this.metadata.getColumnCount();
        this.symbolMapReaders.setPos(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            if (this.metadata.getColumnType(i) != 11) continue;
            SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(i), this.symbolCountSnapshot.getQuick(symbolColumnIndex++));
            this.symbolMapReaders.extendAndSet(i, symbolMapReader);
        }
    }

    private ReadOnlyColumn openTxnFile() {
        try {
            ReadOnlyMemory readOnlyMemory = new ReadOnlyMemory(this.ff, this.path.concat("_txn").$(), this.ff.getPageSize(), TableUtils.getSymbolWriterIndexOffset(0));
            return readOnlyMemory;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private Path pathGenDay(int partitionIndex) {
        TableUtils.fmtDay.format(Timestamps.addDays(this.minTimestamp, partitionIndex), TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale(), null, this.path.put(Files.SEPARATOR));
        return this.path.$();
    }

    private Path pathGenDefault() {
        return this.path.concat("default").$();
    }

    private Path pathGenMonth(int partitionIndex) {
        TableUtils.fmtMonth.format(Timestamps.addMonths(this.minTimestamp, partitionIndex), TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale(), null, this.path.put(Files.SEPARATOR));
        return this.path.$();
    }

    private Path pathGenYear(int partitionIndex) {
        TableUtils.fmtYear.format(Timestamps.addYear(this.minTimestamp, partitionIndex), TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale(), null, this.path.put(Files.SEPARATOR));
        return this.path.$();
    }

    private boolean readTxn() {
        int count = 0;
        long deadline = this.configuration.getMicrosecondClock().getTicks() + this.configuration.getSpinLockTimeoutUs();
        long txn;
        while ((txn = this.txMem.getLong(0L)) != this.txn) {
            Unsafe.getUnsafe().loadFence();
            if (txn == this.txMem.getLong(64L)) {
                Unsafe.getUnsafe().loadFence();
                long transientRowCount = this.txMem.getLong(8L);
                long fixedRowCount = this.txMem.getLong(16L);
                long minTimestamp = this.txMem.getLong(24L);
                long maxTimestamp = this.txMem.getLong(32L);
                long structVersion = this.txMem.getLong(40L);
                long dataVersion = this.txMem.getLong(48L);
                long partitionTableVersion = this.txMem.getLong(56L);
                this.symbolCountSnapshot.clear();
                int symbolMapCount = this.txMem.getInt(72L);
                if (symbolMapCount > 0) {
                    this.txMem.grow(TableUtils.getSymbolWriterIndexOffset(symbolMapCount));
                    for (int i = 0; i < symbolMapCount; ++i) {
                        this.symbolCountSnapshot.add(this.txMem.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
                    }
                }
                this.txMem.grow(TableUtils.getPartitionTableIndexOffset(symbolMapCount, 0));
                this.removedPartitions.clear();
                int partitionTableSize = this.txMem.getInt(TableUtils.getPartitionTableSizeOffset(symbolMapCount));
                if (partitionTableSize > 0) {
                    this.txMem.grow(TableUtils.getPartitionTableIndexOffset(symbolMapCount, partitionTableSize));
                    for (int i = 0; i < partitionTableSize; ++i) {
                        this.removedPartitions.add(this.txMem.getLong(TableUtils.getPartitionTableIndexOffset(symbolMapCount, i)));
                    }
                }
                Unsafe.getUnsafe().loadFence();
                if (txn == this.txMem.getLong(0L)) {
                    this.txn = txn;
                    this.transientRowCount = transientRowCount;
                    this.rowCount = fixedRowCount + transientRowCount;
                    this.prevMinTimestamp = this.minTimestamp;
                    this.minTimestamp = minTimestamp == Long.MAX_VALUE ? Long.MAX_VALUE : this.timestampFloorMethod.floor(minTimestamp);
                    this.maxTimestamp = maxTimestamp;
                    this.structVersion = structVersion;
                    this.dataVersion = dataVersion;
                    this.partitionTableVersion = partitionTableVersion;
                    LOG.info().$("new transaction [txn=").$(txn).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(fixedRowCount).$(", maxTimestamp=").$(maxTimestamp).$(", attempts=").$(count).$(']').$();
                    return true;
                }
            }
            ++count;
            if (this.configuration.getMicrosecondClock().getTicks() > deadline) {
                LOG.error().$("tx read timeout [timeout=").$(this.configuration.getSpinLockTimeoutUs()).utf8("\u03bcs]").$();
                throw CairoException.instance(0).put("Transaction read timeout");
            }
            LockSupport.parkNanos(1L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnAt(Path path, ObjList<ReadOnlyColumn> columns, LongList columnTops, ObjList<BitmapIndexReader> indexReaders, int columnBase, int columnIndex, long partitionRowCount, boolean lastPartition) {
        int plen = path.length();
        try {
            String name = this.metadata.getColumnName(columnIndex);
            int primaryIndex = TableReader.getPrimaryColumnIndex(columnBase, columnIndex);
            int secondaryIndex = primaryIndex + 1;
            ReadOnlyColumn mem1 = columns.getQuick(primaryIndex);
            ReadOnlyColumn mem2 = columns.getQuick(secondaryIndex);
            if (this.ff.exists(TableUtils.dFile(path.trimTo(plen), name))) {
                if (mem1 != null && mem1 != ForceNullColumn.INSTANCE) {
                    mem1.of(this.ff, path, this.ff.getMapPageSize(), this.ff.length(path));
                } else {
                    mem1 = lastPartition ? new ReadOnlyMemory(this.ff, path, this.ff.getMapPageSize(), 0L) : new OnePageMemory(this.ff, path, this.ff.length(path));
                    columns.setQuick(primaryIndex, mem1);
                }
                long columnTop = TableUtils.readColumnTop(this.ff, path.trimTo(plen), name, plen, this.tempMem8b);
                int type = this.metadata.getColumnType(columnIndex);
                switch (type) {
                    case 10: 
                    case 13: {
                        TableUtils.iFile(path.trimTo(plen), name);
                        if (mem2 != null && mem2 != ForceNullColumn.INSTANCE) {
                            mem2.of(this.ff, path, this.ff.getMapPageSize(), this.ff.length(path));
                        } else {
                            mem2 = lastPartition ? new ReadOnlyMemory(this.ff, path, this.ff.getMapPageSize(), 0L) : new OnePageMemory(this.ff, path, this.ff.length(path));
                            columns.setQuick(secondaryIndex, mem2);
                        }
                        TableReader.growColumn(mem1, mem2, type, partitionRowCount - columnTop);
                        break;
                    }
                    default: {
                        Misc.free(columns.getAndSetQuick(secondaryIndex, null));
                        TableReader.growColumn(mem1, null, type, partitionRowCount - columnTop);
                    }
                }
                columnTops.setQuick(columnBase / 2 + columnIndex, columnTop);
                if (this.metadata.isColumnIndexed(columnIndex)) {
                    BitmapIndexReader indexReader = indexReaders.getQuick(primaryIndex);
                    if (indexReader instanceof BitmapIndexBwdReader) {
                        ((BitmapIndexBwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTop);
                    }
                    if ((indexReader = indexReaders.getQuick(secondaryIndex)) instanceof BitmapIndexFwdReader) {
                        ((BitmapIndexFwdReader)indexReader).of(this.configuration, path.trimTo(plen), name, columnTop);
                    }
                } else {
                    Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                    Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
                }
            } else {
                Misc.free(columns.getAndSetQuick(primaryIndex, NullColumn.INSTANCE));
                Misc.free(columns.getAndSetQuick(secondaryIndex, NullColumn.INSTANCE));
                Misc.free(indexReaders.getAndSetQuick(primaryIndex, null));
                Misc.free(indexReaders.getAndSetQuick(secondaryIndex, null));
            }
        }
        finally {
            path.trimTo(plen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadColumnChanges() {
        long pTransitionIndex = this.metadata.createTransitionIndex();
        try {
            this.metadata.applyTransitionIndex(pTransitionIndex);
            int columnCount = Unsafe.getUnsafe().getInt(pTransitionIndex + 4L);
            int columnCountBits = TableReader.getColumnBits(columnCount);
            if (columnCountBits > this.columnCountBits) {
                this.createNewColumnList(columnCount, pTransitionIndex, columnCountBits);
            } else {
                this.reshuffleColumns(columnCount, pTransitionIndex);
            }
            this.reshuffleSymbolMapReaders(pTransitionIndex);
            this.columnCount = columnCount;
        }
        finally {
            TableReaderMetadata.freeTransitionIndex(pTransitionIndex);
        }
    }

    private boolean reloadInitialNonPartitioned() {
        long dataVersion = this.dataVersion;
        if (this.readTxn()) {
            this.reloadStruct();
            this.reloadSymbolMapCounts();
            this.checkDefaultPartitionExistsAndUpdatePartitionCount();
            if (this.partitionCount > 0) {
                this.updateCapacities();
                this.reloadMethod = NON_PARTITIONED_RELOAD_METHOD;
                return true;
            }
        }
        return dataVersion != this.dataVersion;
    }

    private boolean reloadInitialPartitioned() {
        if (this.readTxn()) {
            this.reloadStruct();
            return this.reloadInitialPartitioned0();
        }
        return false;
    }

    private boolean reloadInitialPartitioned0() {
        this.reloadSymbolMapCounts();
        this.partitionCount = this.calculatePartitionCount();
        if (this.partitionCount > 0) {
            this.updateCapacities();
            if (this.maxTimestamp != Long.MIN_VALUE) {
                this.reloadMethod = PARTITIONED_RELOAD_METHOD;
            }
        }
        return true;
    }

    private boolean reloadNonPartitioned() {
        if (this.readTxn()) {
            this.reloadStruct();
            if (this.getPartitionRowCount(0) == -1L) {
                this.openPartition0(0);
            } else {
                this.reloadPartition(0, this.rowCount);
            }
            return true;
        }
        return false;
    }

    private void reloadPartition(int partitionIndex, long rowCount) {
        int symbolMapIndex = 0;
        int columnBase = this.getColumnBase(partitionIndex);
        for (int i = 0; i < this.columnCount; ++i) {
            int index = TableReader.getPrimaryColumnIndex(columnBase, i);
            TableReader.growColumn(this.columns.getQuick(index), this.columns.getQuick(index + 1), this.metadata.getColumnType(i), rowCount - this.getColumnTop(columnBase, i));
            SymbolMapReader reader = this.symbolMapReaders.getQuick(i);
            if (reader == null) continue;
            reader.updateSymbolCount(this.symbolCountSnapshot.getQuick(symbolMapIndex++));
        }
        this.partitionRowCounts.setQuick(partitionIndex, rowCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reloadPartitioned() {
        assert (this.timestampFloorMethod != null);
        long currentPartitionTimestamp = this.maxTimestamp == Long.MIN_VALUE ? this.maxTimestamp : this.floorToPartitionTimestamp(this.maxTimestamp);
        long dataVersion = this.dataVersion;
        if (this.readTxn()) {
            this.reloadStruct();
            if (this.dataVersion != dataVersion) {
                this.applyTruncate();
                return true;
            }
            if (this.partitionCount == 0) {
                this.incrementPartitionCountBy(this.calculatePartitionCount());
                return true;
            }
            assert (this.intervalLengthMethod != null);
            int delta = this.getPartitionCountBetweenTimestamps(currentPartitionTimestamp, this.floorToPartitionTimestamp(this.maxTimestamp));
            int partitionIndex = this.partitionCount - 1;
            if (this.getPartitionRowCount(partitionIndex) > -1L) {
                if (delta > 0) {
                    this.incrementPartitionCountBy(delta);
                    Path path = this.partitionPathGenerator.generate(this, partitionIndex);
                    try {
                        this.reloadPartition(partitionIndex, TableUtils.readPartitionSize(this.ff, path.chopZ(), this.tempMem8b));
                    }
                    finally {
                        path.trimTo(this.rootLen);
                    }
                } else {
                    this.reloadPartition(partitionIndex, this.transientRowCount);
                }
            } else if (delta > 0) {
                this.incrementPartitionCountBy(delta);
            }
            return true;
        }
        return false;
    }

    private void reloadStruct() {
        if (this.prevStructVersion != this.structVersion) {
            this.reloadColumnChanges();
            this.prevStructVersion = this.structVersion;
        }
        if (this.prevPartitionTableVersion != this.partitionTableVersion) {
            this.closeRemovedPartitions();
            this.prevPartitionTableVersion = this.partitionTableVersion;
        }
    }

    private void reloadSymbolMapCounts() {
        int symbolMapIndex = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.metadata.getColumnType(i) != 11) continue;
            this.symbolMapReaders.getQuick(i).updateSymbolCount(this.symbolCountSnapshot.getQuick(symbolMapIndex++));
        }
    }

    private SymbolMapReader reloadSymbolMapReader(int columnIndex, SymbolMapReader reader) {
        if (this.metadata.getColumnType(columnIndex) == 11) {
            if (reader instanceof SymbolMapReaderImpl) {
                ((SymbolMapReaderImpl)reader).of(this.configuration, this.path, this.metadata.getColumnName(columnIndex), 0);
                return reader;
            }
            return new SymbolMapReaderImpl(this.configuration, this.path, this.metadata.getColumnName(columnIndex), 0);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reshuffleColumns(int columnCount, long pTransitionIndex) {
        long pIndexBase = pTransitionIndex + 8L;
        long pState = pIndexBase + (long)columnCount * 8L;
        for (int partitionIndex = 0; partitionIndex < this.partitionCount; ++partitionIndex) {
            int base = this.getColumnBase(partitionIndex);
            try {
                int i;
                Path path = this.partitionPathGenerator.generate(this, partitionIndex);
                long partitionRowCount = this.partitionRowCounts.getQuick(partitionIndex);
                boolean lastPartition = partitionIndex == this.partitionCount - 1;
                Unsafe.getUnsafe().setMemory(pState, columnCount, (byte)0);
                for (i = 0; i < columnCount; ++i) {
                    if (!TableReader.isEntryToBeProcessed(pState, i)) continue;
                    int copyFrom = Unsafe.getUnsafe().getInt(pIndexBase + (long)(i * 8)) - 1;
                    if (copyFrom == i) {
                        ReadOnlyColumn col = this.columns.getQuick(TableReader.getPrimaryColumnIndex(base, i));
                        if ((!(col instanceof ReadOnlyMemory) || !col.isDeleted()) && !(col instanceof ForceNullColumn)) continue;
                        this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                        continue;
                    }
                    if (copyFrom > -1) {
                        this.fetchColumnsFrom(this.columns, this.columnTops, this.bitmapIndexes, base, copyFrom);
                        this.copyColumnsTo(this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                        int copyTo = Unsafe.getUnsafe().getInt(pIndexBase + (long)(i * 8) + 4L) - 1;
                        while (copyTo > -1 && TableReader.isEntryToBeProcessed(pState, copyTo)) {
                            this.copyColumnsTo(this.columns, this.columnTops, this.bitmapIndexes, base, copyTo, partitionRowCount, lastPartition);
                            copyTo = Unsafe.getUnsafe().getInt(pIndexBase + (long)((copyTo - 1) * 8) + 4L);
                        }
                        Misc.free(this.tempCopyStruct.mem1);
                        Misc.free(this.tempCopyStruct.mem2);
                        Misc.free(this.tempCopyStruct.backwardReader);
                        Misc.free(this.tempCopyStruct.forwardReader);
                        continue;
                    }
                    this.reloadColumnAt(path, this.columns, this.columnTops, this.bitmapIndexes, base, i, partitionRowCount, lastPartition);
                }
                for (i = columnCount; i < this.columnCount; ++i) {
                    int index = TableReader.getPrimaryColumnIndex(base, i);
                    Misc.free(this.columns.getQuick(index));
                    Misc.free(this.columns.getQuick(index + 1));
                }
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void updateCapacities() {
        int capacity = this.getColumnBase(this.partitionCount);
        this.columns.setPos(capacity);
        this.bitmapIndexes.setPos(capacity);
        this.partitionRowCounts.seed(this.partitionCount, -1L);
        this.columnTops.setPos(capacity / 2);
    }

    private static class ColumnCopyStruct {
        ReadOnlyColumn mem1;
        ReadOnlyColumn mem2;
        BitmapIndexReader backwardReader;
        BitmapIndexReader forwardReader;
        long top;

        private ColumnCopyStruct() {
        }
    }

    private static class ForceNullColumn
    extends NullColumn {
        private static final ForceNullColumn INSTANCE = new ForceNullColumn();

        private ForceNullColumn() {
        }
    }

    @FunctionalInterface
    private static interface PartitionPathGenerator {
        public Path generate(TableReader var1, int var2);
    }

    @FunctionalInterface
    private static interface ReloadMethod {
        public boolean reload(TableReader var1);
    }

    @FunctionalInterface
    private static interface IntervalLengthMethod {
        public long calculate(long var1, long var3);
    }
}

