/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Rows;
import io.questdb.std.str.CharSink;

public class TableReaderRecord
implements Record {
    private int columnBase;
    private long recordIndex = 0L;
    private TableReader reader;

    @Override
    public BinarySequence getBin(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.colA(col).getBin(this.colB(col).getLong(index * 8L));
    }

    @Override
    public long getBinLen(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return -1L;
        }
        return this.colA(col).getBinLen(this.colB(col).getLong(index * 8L));
    }

    @Override
    public boolean getBool(int col) {
        long index = this.getIndex(col);
        return index > -1L && this.colA(col).getBool(index);
    }

    @Override
    public byte getByte(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return 0;
        }
        return this.colA(col).getByte(index);
    }

    @Override
    public double getDouble(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return Double.NaN;
        }
        return this.colA(col).getDouble(index * 8L);
    }

    @Override
    public float getFloat(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return Float.NaN;
        }
        return this.colA(col).getFloat(index * 4L);
    }

    @Override
    public int getInt(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return Integer.MIN_VALUE;
        }
        return this.colA(col).getInt(index * 4L);
    }

    @Override
    public long getLong(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return Long.MIN_VALUE;
        }
        return this.colA(col).getLong(index * 8L);
    }

    @Override
    public short getShort(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return 0;
        }
        return this.colA(col).getShort(index * 2L);
    }

    @Override
    public char getChar(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return '\u0000';
        }
        return this.colA(col).getChar(index * 2L);
    }

    @Override
    public CharSequence getStr(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.colA(col).getStr(this.colB(col).getLong(index * 8L));
    }

    @Override
    public void getLong256(int col, CharSink sink) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return;
        }
        this.colA(col).getLong256(index * 32L, sink);
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(this.reader.getPartitionIndex(this.columnBase), this.recordIndex);
    }

    @Override
    public Long256 getLong256A(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.colA(col).getLong256A(index * 32L);
    }

    @Override
    public Long256 getLong256B(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.colA(col).getLong256B(index * 32L);
    }

    @Override
    public CharSequence getStrB(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.colA(col).getStr2(this.colB(col).getLong(index * 8L));
    }

    @Override
    public int getStrLen(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return -1;
        }
        return this.colA(col).getStrLen(this.colB(col).getLong(index * 8L));
    }

    @Override
    public CharSequence getSym(int col) {
        long index = this.getIndex(col);
        if (index < 0L) {
            return null;
        }
        return this.reader.getSymbolMapReader(col).valueOf(this.colA(col).getInt(index * 4L));
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(long recordIndex) {
        this.recordIndex = recordIndex;
    }

    public void of(TableReader reader) {
        this.reader = reader;
    }

    public void incrementRecordIndex() {
        ++this.recordIndex;
    }

    public void jumpTo(int partitionIndex, long recordIndex) {
        this.columnBase = this.reader.getColumnBase(partitionIndex);
        this.recordIndex = recordIndex;
    }

    private ReadOnlyColumn colA(int col) {
        return this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, col));
    }

    private ReadOnlyColumn colB(int col) {
        return this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, col) + 1);
    }

    private long getIndex(int col) {
        assert (col > -1 && col < this.reader.getColumnCount()) : "Column index out of bounds: " + col + " >= " + this.reader.getColumnCount();
        long top = this.reader.getColumnTop(this.columnBase, col);
        return top > 0L ? this.recordIndex - top : this.recordIndex;
    }
}

