/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableReaderSelectedColumnRecordCursor;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableReaderRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final TableReaderSelectedColumnRecordCursor cursor;
    private final CairoEngine engine;
    private final String tableName;
    private final long tableVersion;
    private final IntList columnIndexes;
    private final IntList columnSizes;
    private TableReaderPageFrameCursor pageFrameCursor = null;
    private final boolean framingSupported;

    public TableReaderRecordCursorFactory(RecordMetadata metadata, CairoEngine engine, String tableName, long tableVersion, @NotNull IntList columnIndexes, @NotNull IntList columnSizes, boolean framingSupported) {
        super(metadata);
        this.cursor = new TableReaderSelectedColumnRecordCursor(columnIndexes);
        this.engine = engine;
        this.tableName = tableName;
        this.tableVersion = tableVersion;
        this.columnIndexes = columnIndexes;
        this.columnSizes = columnSizes;
        this.framingSupported = framingSupported;
    }

    @Override
    public void close() {
        Misc.free(this.cursor);
        Misc.free(this.pageFrameCursor);
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) {
        this.cursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName, this.tableVersion));
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public PageFrameCursor getPageFrameCursor(SqlExecutionContext executionContext) {
        if (this.pageFrameCursor != null) {
            return this.pageFrameCursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName));
        }
        if (this.framingSupported) {
            this.pageFrameCursor = new TableReaderPageFrameCursor(this.columnIndexes, this.columnSizes);
            return this.pageFrameCursor.of(this.engine.getReader(executionContext.getCairoSecurityContext(), this.tableName));
        }
        return null;
    }

    @Override
    public boolean supportPageFrameCursor() {
        return this.columnIndexes != null;
    }

    private static class TableReaderPageFrameCursor
    implements PageFrameCursor {
        private final LongList columnPageNextAddress = new LongList();
        private final LongList columnPageAddress = new LongList();
        private final TableReaderPageFrame frame = new TableReaderPageFrame();
        private final LongList topsRemaining = new LongList();
        private final IntList pages = new IntList();
        private final int columnCount;
        private TableReader reader;
        private IntList columnIndexes;
        private IntList columnSizes;
        private int partitionIndex;
        private int partitionCount;
        private LongList pageSizes = new LongList();
        private long pageValueCount;
        private long partitionRemaining = 0L;

        public TableReaderPageFrameCursor(IntList columnIndexes, IntList columnSizes) {
            this.columnIndexes = columnIndexes;
            this.columnSizes = columnSizes;
            this.columnCount = columnIndexes.size();
        }

        @Override
        public void close() {
            this.reader = Misc.free(this.reader);
        }

        @Override
        public SymbolTable getSymbolTable(int columnIndex) {
            return this.reader.getSymbolMapReader(columnIndex);
        }

        @Override
        @Nullable
        public PageFrame next() {
            long m;
            if (this.partitionIndex > -1 && (m = this.computePageMin(this.reader.getColumnBase(this.partitionIndex))) < Long.MAX_VALUE) {
                return this.computeFrame(m);
            }
            while (++this.partitionIndex < this.partitionCount) {
                this.partitionRemaining = this.reader.openPartition(this.partitionIndex);
                if (this.partitionRemaining <= 0L) continue;
                int base = this.reader.getColumnBase(this.partitionIndex);
                int n = this.columnIndexes.size();
                for (int i = 0; i < n; ++i) {
                    int columnIndex = this.columnIndexes.getQuick(i);
                    this.topsRemaining.setQuick(i, this.reader.getColumnTop(base, columnIndex));
                    this.pages.setQuick(i, 0);
                    this.pageSizes.setQuick(i, -1L);
                }
                return this.computeFrame(this.computePageMin(base));
            }
            return null;
        }

        @Override
        public void toTop() {
            this.partitionIndex = -1;
            this.partitionCount = this.reader.getPartitionCount();
            this.pages.setAll(this.columnCount, 0);
            this.topsRemaining.setAll(this.columnCount, 0L);
            this.columnPageAddress.setAll(this.columnCount, 0L);
            this.columnPageNextAddress.setAll(this.columnCount, 0L);
            this.pageSizes.setAll(this.columnCount, -1L);
            this.pageValueCount = 0L;
        }

        @Override
        public long size() {
            return this.reader.size();
        }

        public TableReaderPageFrameCursor of(TableReader reader) {
            this.reader = reader;
            this.toTop();
            return this;
        }

        private PageFrame computeFrame(long min) {
            for (int i = 0; i < this.columnCount; ++i) {
                int columnIndex = this.columnIndexes.getQuick(i);
                long top = this.topsRemaining.getQuick(i);
                if (top > 0L) {
                    this.topsRemaining.setQuick(i, top - min);
                    this.columnPageAddress.setQuick(columnIndex, 0L);
                    continue;
                }
                long addr = this.columnPageNextAddress.getQuick(i);
                long psz = this.pageSizes.getQuick(i);
                this.pageSizes.setQuick(i, psz - min);
                this.columnPageAddress.setQuick(i, addr);
                this.columnPageNextAddress.setQuick(i, addr + (min << this.columnSizes.getQuick(i)));
            }
            this.pageValueCount = min;
            this.partitionRemaining -= min;
            return this.frame;
        }

        private long computePageMin(int base) {
            long min = Long.MAX_VALUE;
            for (int i = 0; i < this.columnCount; ++i) {
                long top = this.topsRemaining.getQuick(i);
                if (top > 0L) {
                    if (min <= top) continue;
                    min = top;
                    continue;
                }
                long psz = this.pageSizes.getQuick(i);
                if (psz > 0L) {
                    if (min <= psz) continue;
                    min = psz;
                    continue;
                }
                if (this.partitionRemaining <= 0L) continue;
                int page = this.pages.getQuick(i);
                this.pages.setQuick(i, page + 1);
                ReadOnlyColumn col = this.reader.getColumn(TableReader.getPrimaryColumnIndex(base, this.columnIndexes.getQuick(i)));
                this.columnPageNextAddress.setQuick(i, col.getPageAddress(page));
                psz = col.getPageSize(page);
                long m = Math.min(psz >> this.columnSizes.getQuick(i), this.partitionRemaining);
                this.pageSizes.setQuick(i, m);
                if (min <= m) continue;
                min = m;
            }
            return min;
        }

        private class TableReaderPageFrame
        implements PageFrame {
            private TableReaderPageFrame() {
            }

            @Override
            public long getPageAddress(int columnIndex) {
                return TableReaderPageFrameCursor.this.columnPageAddress.getQuick(columnIndex);
            }

            @Override
            public long getPageValueCount(int columnIndex) {
                return TableReaderPageFrameCursor.this.pageValueCount;
            }
        }
    }
}

