/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Rows;
import io.questdb.std.str.CharSink;

public class TableReaderSelectedColumnRecord
implements Record {
    private final IntList columnIndexes;
    private int columnBase;
    private long recordIndex = 0L;
    private TableReader reader;

    public TableReaderSelectedColumnRecord(IntList columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.colA(col).getBin(this.colB(col).getLong(recordIndex * 8L));
    }

    @Override
    public long getBinLen(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return -1L;
        }
        return this.colA(col).getBinLen(this.colB(col).getLong(recordIndex * 8L));
    }

    @Override
    public boolean getBool(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        return recordIndex > -1L && this.colA(col).getBool(recordIndex);
    }

    @Override
    public byte getByte(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return 0;
        }
        return this.colA(col).getByte(recordIndex);
    }

    @Override
    public double getDouble(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return Double.NaN;
        }
        return this.colA(col).getDouble(recordIndex * 8L);
    }

    @Override
    public float getFloat(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return Float.NaN;
        }
        return this.colA(col).getFloat(recordIndex * 4L);
    }

    @Override
    public int getInt(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return Integer.MIN_VALUE;
        }
        return this.colA(col).getInt(recordIndex * 4L);
    }

    @Override
    public long getLong(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return Long.MIN_VALUE;
        }
        return this.colA(col).getLong(recordIndex * 8L);
    }

    @Override
    public long getRowId() {
        return Rows.toRowID(this.reader.getPartitionIndex(this.columnBase), this.recordIndex);
    }

    @Override
    public short getShort(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return 0;
        }
        return this.colA(col).getShort(recordIndex * 2L);
    }

    @Override
    public char getChar(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return '\u0000';
        }
        return this.colA(col).getChar(recordIndex * 2L);
    }

    @Override
    public CharSequence getStr(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.colA(col).getStr(this.colB(col).getLong(recordIndex * 8L));
    }

    @Override
    public void getLong256(int columnIndex, CharSink sink) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return;
        }
        this.colA(col).getLong256(recordIndex * 32L, sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.colA(col).getLong256A(recordIndex * 32L);
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.colA(col).getLong256B(recordIndex * 32L);
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.colA(col).getStr2(this.colB(col).getLong(recordIndex * 8L));
    }

    @Override
    public int getStrLen(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return -1;
        }
        return this.colA(col).getStrLen(this.colB(col).getLong(recordIndex * 8L));
    }

    @Override
    public CharSequence getSym(int columnIndex) {
        int col = this.deferenceColumn(columnIndex);
        long recordIndex = this.getRecordIndex(col);
        if (recordIndex < 0L) {
            return null;
        }
        return this.reader.getSymbolMapReader(col).valueOf(this.colA(col).getInt(recordIndex * 4L));
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }

    public void setRecordIndex(long recordIndex) {
        this.recordIndex = recordIndex;
    }

    public void incrementRecordIndex() {
        ++this.recordIndex;
    }

    public void jumpTo(int partitionIndex, long recordIndex) {
        this.columnBase = this.reader.getColumnBase(partitionIndex);
        this.recordIndex = recordIndex;
    }

    public void of(TableReader reader) {
        this.reader = reader;
    }

    private ReadOnlyColumn colA(int col) {
        return this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, col));
    }

    private ReadOnlyColumn colB(int col) {
        return this.reader.getColumn(TableReader.getPrimaryColumnIndex(this.columnBase, col) + 1);
    }

    private int deferenceColumn(int columnIndex) {
        return this.columnIndexes.getQuick(columnIndex);
    }

    private long getRecordIndex(int col) {
        assert (col > -1 && col < this.reader.getColumnCount()) : "Column index out of bounds: " + col + " >= " + this.reader.getColumnCount();
        long top = this.reader.getColumnTop(this.columnBase, col);
        return top > 0L ? this.recordIndex - top : this.recordIndex;
    }
}

