/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ReadOnlyColumn;
import io.questdb.cairo.ReadOnlyMemory;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.VirtualMemory;
import io.questdb.griffin.SqlException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Numbers;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.microtime.DateFormatCompiler;
import io.questdb.std.microtime.TimestampFormat;
import io.questdb.std.microtime.Timestamps;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;

public final class TableUtils {
    public static final int TABLE_EXISTS = 0;
    public static final int TABLE_DOES_NOT_EXIST = 1;
    public static final int TABLE_RESERVED = 2;
    public static final String META_FILE_NAME = "_meta";
    public static final String TXN_FILE_NAME = "_txn";
    public static final int INITIAL_TXN = 0;
    public static final int NULL_LEN = -1;
    public static final int ANY_TABLE_VERSION = -1;
    static final int MIN_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(4);
    static final byte TODO_RESTORE_META = 2;
    static final byte TODO_TRUNCATE = 1;
    static final TimestampFormat fmtDay;
    static final TimestampFormat fmtMonth;
    static final TimestampFormat fmtYear;
    static final String ARCHIVE_FILE_NAME = "_archive";
    static final String DEFAULT_PARTITION_NAME = "default";
    static final long TX_OFFSET_TXN = 0L;
    static final long TX_OFFSET_TRANSIENT_ROW_COUNT = 8L;
    static final long TX_OFFSET_FIXED_ROW_COUNT = 16L;
    static final long TX_OFFSET_MIN_TIMESTAMP = 24L;
    static final long TX_OFFSET_MAX_TIMESTAMP = 32L;
    static final long TX_OFFSET_STRUCT_VERSION = 40L;
    static final long TX_OFFSET_DATA_VERSION = 48L;
    static final long TX_OFFSET_PARTITION_TABLE_VERSION = 56L;
    static final long TX_OFFSET_TXN_CHECK = 64L;
    static final long TX_OFFSET_MAP_WRITER_COUNT = 72L;
    static final String META_SWAP_FILE_NAME = "_meta.swp";
    static final String META_PREV_FILE_NAME = "_meta.prev";
    static final long META_OFFSET_COUNT = 0L;
    static final long META_OFFSET_PARTITION_BY = 4L;
    static final long META_OFFSET_TIMESTAMP_INDEX = 8L;
    static final long META_OFFSET_VERSION = 12L;
    static final long META_COLUMN_DATA_SIZE = 16L;
    static final long META_COLUMN_DATA_RESERVED = 3L;
    static final long META_OFFSET_COLUMN_TYPES = 128L;
    static final int META_FLAG_BIT_INDEXED = 1;
    static final int META_FLAG_BIT_SEQUENTIAL = 2;
    static final String TODO_FILE_NAME = "_todo";
    private static final int MIN_SYMBOL_CAPACITY = 2;
    private static final int MAX_SYMBOL_CAPACITY;
    private static final int MAX_SYMBOL_CAPACITY_CACHED;
    private static final int MAX_INDEX_VALUE_BLOCK_SIZE;
    private static final Log LOG;

    public static void createTable(FilesFacade ff, AppendMemory memory, Path path, CharSequence root, TableStructure structure, int mkDirMode) {
        TableUtils.createTable(ff, memory, path, root, structure, mkDirMode, 416);
    }

    public static void createTable(FilesFacade ff, AppendMemory memory, Path path, CharSequence root, TableStructure structure, int mkDirMode, int tableVersion) {
        path.of(root).concat(structure.getTableName());
        if (ff.mkdirs(path.put(Files.SEPARATOR).$(), mkDirMode) != 0) {
            throw CairoException.instance(ff.errno()).put("could not create [dir=").put(path).put(']');
        }
        int rootLen = path.length();
        try (AppendMemory mem = memory;){
            int i;
            mem.of(ff, path.trimTo(rootLen).concat(META_FILE_NAME).$(), ff.getPageSize());
            int count = structure.getColumnCount();
            mem.putInt(count);
            mem.putInt(structure.getPartitionBy());
            mem.putInt(structure.getTimestampIndex());
            mem.putInt(tableVersion);
            mem.jumpTo(128L);
            for (i = 0; i < count; ++i) {
                mem.putByte((byte)structure.getColumnType(i));
                long flags = 0L;
                if (structure.isIndexed(i)) {
                    flags |= 1L;
                }
                if (structure.isSequential(i)) {
                    flags |= 2L;
                }
                mem.putLong(flags);
                mem.putInt(structure.getIndexBlockCapacity(i));
                mem.skip(3L);
            }
            for (i = 0; i < count; ++i) {
                mem.putStr(structure.getColumnName(i));
            }
            int symbolMapCount = 0;
            for (int i2 = 0; i2 < count; ++i2) {
                if (structure.getColumnType(i2) != 11) continue;
                SymbolMapWriter.createSymbolMapFiles(ff, mem, path.trimTo(rootLen), structure.getColumnName(i2), structure.getSymbolCapacity(i2), structure.getSymbolCacheFlag(i2));
                ++symbolMapCount;
            }
            mem.of(ff, path.trimTo(rootLen).concat(TXN_FILE_NAME).$(), ff.getPageSize());
            TableUtils.resetTxn(mem, symbolMapCount, 0L, 0L);
        }
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name) {
        return TableUtils.exists(ff, path, root, name, 0, name.length());
    }

    public static int exists(FilesFacade ff, Path path, CharSequence root, CharSequence name, int lo, int hi) {
        path.of(root).concat(name, lo, hi).$();
        if (ff.exists(path)) {
            if (ff.exists(path.chopZ().concat(TXN_FILE_NAME).$())) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    public static long getColumnNameOffset(int columnCount) {
        return 128L + (long)columnCount * 16L;
    }

    public static long getPartitionTableIndexOffset(int symbolWriterCount, int index) {
        return TableUtils.getPartitionTableSizeOffset(symbolWriterCount) + 4L + (long)(index * 8);
    }

    public static long getPartitionTableSizeOffset(int symbolWriterCount) {
        return TableUtils.getSymbolWriterIndexOffset(symbolWriterCount);
    }

    public static long getSymbolWriterIndexOffset(int index) {
        return 76L + (long)index * 4L;
    }

    public static long getTxMemSize(int symbolWriterCount, int removedPartitionsCount) {
        return TableUtils.getPartitionTableIndexOffset(symbolWriterCount, removedPartitionsCount);
    }

    public static long lock(FilesFacade ff, Path path) {
        long fd = ff.openRW(path);
        if (fd == -1L) {
            LOG.error().$("cannot open '").$(path).$("' to lock [errno=").$(ff.errno()).$(']').$();
            return -1L;
        }
        if (ff.lock(fd) != 0) {
            LOG.error().$("cannot lock '").$(path).$("' [errno=").$(ff.errno()).$(", fd=").$(fd).$(']').$();
            ff.close(fd);
            return -1L;
        }
        return fd;
    }

    public static void lockName(Path path) {
        path.put(".lock").$();
    }

    public static void resetTxn(VirtualMemory txMem, int symbolMapCount, long txn, long dataVersion) {
        txMem.putLong(0L, txn);
        Unsafe.getUnsafe().storeFence();
        txMem.putLong(8L, 0L);
        txMem.putLong(16L, 0L);
        txMem.putLong(24L, Long.MAX_VALUE);
        txMem.putLong(32L, Long.MIN_VALUE);
        txMem.putLong(40L, 0L);
        txMem.putLong(48L, dataVersion);
        txMem.putInt(72L, symbolMapCount);
        for (int i = 0; i < symbolMapCount; ++i) {
            txMem.putInt(TableUtils.getSymbolWriterIndexOffset(i), 0);
        }
        Unsafe.getUnsafe().storeFence();
        txMem.putLong(64L, txn);
        txMem.putInt(TableUtils.getPartitionTableSizeOffset(symbolMapCount), 0);
        txMem.jumpTo(TableUtils.getPartitionTableIndexOffset(symbolMapCount, 0));
    }

    public static int toIndexKey(int symbolKey) {
        return symbolKey == Integer.MIN_VALUE ? 0 : symbolKey + 1;
    }

    public static void validate(FilesFacade ff, ReadOnlyColumn metaMem, CharSequenceIntHashMap nameIndex) {
        try {
            int i;
            int timestampType;
            int metaVersion = metaMem.getInt(12L);
            if (416 != metaVersion && metaVersion != 404) {
                throw TableUtils.validationException(metaMem).put("Metadata version does not match runtime version");
            }
            int columnCount = metaMem.getInt(0L);
            long offset = TableUtils.getColumnNameOffset(columnCount);
            if (offset < (long)columnCount || columnCount > 0 && (offset < 0L || offset >= ff.length(metaMem.getFd()))) {
                throw TableUtils.validationException(metaMem).put("Incorrect columnCount: ").put(columnCount);
            }
            int timestampIndex = metaMem.getInt(8L);
            if (timestampIndex < -1 || timestampIndex >= columnCount) {
                throw TableUtils.validationException(metaMem).put("Timestamp index is outside of columnCount");
            }
            if (timestampIndex != -1 && (timestampType = TableUtils.getColumnType(metaMem, timestampIndex)) != 7) {
                throw TableUtils.validationException(metaMem).put("Timestamp column must be TIMESTAMP, but found ").put(ColumnType.nameOf(timestampType));
            }
            for (i = 0; i < columnCount; ++i) {
                int type = TableUtils.getColumnType(metaMem, i);
                if (ColumnType.sizeOf(type) == -1) {
                    throw TableUtils.validationException(metaMem).put("Invalid column type ").put(type).put(" at [").put(i).put(']');
                }
                if (!TableUtils.isColumnIndexed(metaMem, i)) continue;
                if (type != 11) {
                    throw TableUtils.validationException(metaMem).put("Index flag is only supported for SYMBOL").put(" at [").put(i).put(']');
                }
                if (TableUtils.getIndexBlockCapacity(metaMem, i) >= 2) continue;
                throw TableUtils.validationException(metaMem).put("Invalid index value block capacity ").put(TableUtils.getIndexBlockCapacity(metaMem, i)).put(" at [").put(i).put(']');
            }
            for (i = 0; i < columnCount; ++i) {
                CharSequence name = metaMem.getStr(offset);
                if (name == null || name.length() < 1) {
                    throw TableUtils.validationException(metaMem).put("NULL column name at [").put(i).put(']');
                }
                String s = name.toString();
                if (!nameIndex.put(s, i)) {
                    throw TableUtils.validationException(metaMem).put("Duplicate column: ").put(s).put(" at [").put(i).put(']');
                }
                offset += (long)ReadOnlyMemory.getStorageLength(name);
            }
        }
        catch (CairoException e) {
            nameIndex.clear();
            throw e;
        }
    }

    public static void validateIndexValueBlockSize(int position, int indexValueBlockSize) throws SqlException {
        if (indexValueBlockSize < MIN_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "min index block capacity is ").put(MIN_INDEX_VALUE_BLOCK_SIZE);
        }
        if (indexValueBlockSize > MAX_INDEX_VALUE_BLOCK_SIZE) {
            throw SqlException.$(position, "max index block capacity is ").put(MAX_INDEX_VALUE_BLOCK_SIZE);
        }
    }

    public static void validateSymbolCapacity(int position, int symbolCapacity) throws SqlException {
        if (symbolCapacity < 2) {
            throw SqlException.$(position, "min symbol capacity is ").put(2);
        }
        if (symbolCapacity > MAX_SYMBOL_CAPACITY) {
            throw SqlException.$(position, "max symbol capacity is ").put(MAX_SYMBOL_CAPACITY);
        }
    }

    public static void validateSymbolCapacityCached(boolean cache, int symbolCapacity, int cacheKeywordPosition) throws SqlException {
        if (cache && symbolCapacity > MAX_SYMBOL_CAPACITY_CACHED) {
            throw SqlException.$(cacheKeywordPosition, "max cached symbol capacity is ").put(MAX_SYMBOL_CAPACITY_CACHED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readLongAtOffset(FilesFacade ff, Path path, long tempMem8b, long offset) {
        long fd = ff.openRO(path);
        if (fd == -1L) {
            throw CairoException.instance(ff.errno()).put("Cannot open: ").put(path);
        }
        try {
            if (ff.read(fd, tempMem8b, 8L, offset) != 8L) {
                throw CairoException.instance(ff.errno()).put("Cannot read: ").put(path);
            }
            long l = Unsafe.getUnsafe().getLong(tempMem8b);
            return l;
        }
        finally {
            ff.close(fd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readColumnTop(FilesFacade ff, Path path, CharSequence name, int plen, long buf) {
        try {
            if (ff.exists(TableUtils.topFile(path.chopZ(), name))) {
                long fd = ff.openRO(path);
                try {
                    if (ff.read(fd, buf, 8L, 0L) != 8L) {
                        throw CairoException.instance(Os.errno()).put("Cannot read top of column ").put(path);
                    }
                    long l = Unsafe.getUnsafe().getLong(buf);
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            long l = 0L;
            return l;
        }
        finally {
            path.trimTo(plen);
        }
    }

    static LPSZ dFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".d").$();
    }

    static LPSZ topFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".top").$();
    }

    static LPSZ iFile(Path path, CharSequence columnName) {
        return path.concat(columnName).put(".i").$();
    }

    static int getColumnType(ReadOnlyColumn metaMem, int columnIndex) {
        return metaMem.getByte(128L + (long)columnIndex * 16L);
    }

    static long getColumnFlags(ReadOnlyColumn metaMem, int columnIndex) {
        return metaMem.getLong(128L + (long)columnIndex * 16L + 1L);
    }

    static boolean isColumnIndexed(ReadOnlyColumn metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 1L) != 0L;
    }

    static boolean isSequential(ReadOnlyColumn metaMem, int columnIndex) {
        return (TableUtils.getColumnFlags(metaMem, columnIndex) & 2L) != 0L;
    }

    static int getIndexBlockCapacity(ReadOnlyColumn metaMem, int columnIndex) {
        return metaMem.getInt(128L + (long)columnIndex * 16L + 9L);
    }

    static int openMetaSwapFile(FilesFacade ff, AppendMemory mem, Path path, int rootLen, int retryCount) {
        try {
            path.concat(META_SWAP_FILE_NAME).$();
            int l = path.length();
            int index = 0;
            while (true) {
                if (index > 0) {
                    path.trimTo(l).put('.').put(index);
                    path.$();
                }
                if (!ff.exists(path) || ff.remove(path)) {
                    try {
                        mem.of(ff, path, ff.getPageSize());
                        int n = index;
                        return n;
                    }
                    catch (CairoException e) {
                        LOG.error().$("Cannot open file: ").$(path).$('[').$(Os.errno()).$(']').$();
                        continue;
                    }
                }
                LOG.error().$("Cannot remove file: ").$(path).$('[').$(Os.errno()).$(']').$();
                {
                    if (++index < retryCount) continue;
                    throw CairoException.instance(0).put("Cannot open indexed file. Max number of attempts reached [").put(index).put("]. Last file tried: ").put(path);
                }
                break;
            }
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    static String getTodoText(long code) {
        switch ((int)(code & 0xFFL)) {
            case 1: {
                return "truncate";
            }
            case 2: {
                return "restore meta";
            }
        }
        return "unknown";
    }

    private static CairoException validationException(ReadOnlyColumn mem) {
        return CairoException.instance(0).put("Invalid metadata at fd=").put(mem.getFd()).put(". ");
    }

    static boolean isSamePartition(long timestampA, long timestampB, int partitionBy) {
        switch (partitionBy) {
            case 3: {
                return true;
            }
            case 0: {
                return Timestamps.floorDD(timestampA) == Timestamps.floorDD(timestampB);
            }
            case 1: {
                return Timestamps.floorMM(timestampA) == Timestamps.floorMM(timestampB);
            }
            case 2: {
                return Timestamps.floorYYYY(timestampA) == Timestamps.floorYYYY(timestampB);
            }
        }
        throw CairoException.instance(0).put("Cannot compare timestamps for unsupported partition type: [").put(partitionBy).put(']');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long readPartitionSize(FilesFacade ff, Path path, long tempMem8b) {
        int plen = path.length();
        try {
            if (ff.exists(path.concat(ARCHIVE_FILE_NAME).$())) {
                long fd = ff.openRO(path);
                if (fd == -1L) {
                    throw CairoException.instance(Os.errno()).put("Cannot open: ").put(path);
                }
                try {
                    if (ff.read(fd, tempMem8b, 8L, 0L) != 8L) {
                        throw CairoException.instance(Os.errno()).put("Cannot read: ").put(path);
                    }
                    long l = Unsafe.getUnsafe().getLong(tempMem8b);
                    return l;
                }
                finally {
                    ff.close(fd);
                }
            }
            throw CairoException.instance(0).put("Doesn't exist: ").put(path);
        }
        finally {
            path.trimTo(plen);
        }
    }

    static {
        MAX_SYMBOL_CAPACITY = Numbers.ceilPow2(Integer.MAX_VALUE);
        MAX_SYMBOL_CAPACITY_CACHED = Numbers.ceilPow2(1000000);
        MAX_INDEX_VALUE_BLOCK_SIZE = Numbers.ceilPow2(0x800000);
        LOG = LogFactory.getLog(TableUtils.class);
        DateFormatCompiler compiler = new DateFormatCompiler();
        fmtDay = compiler.compile("yyyy-MM-dd");
        fmtMonth = compiler.compile("yyyy-MM");
        fmtYear = compiler.compile("yyyy");
    }
}

