/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.AppendMemory;
import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnIndexer;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.ReadOnlyMemory;
import io.questdb.cairo.ReadWriteMemory;
import io.questdb.cairo.RowFunction;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.SymbolMapWriter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriterMetadata;
import io.questdb.cairo.VirtualMemory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.BinarySequence;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.Long256;
import io.questdb.std.LongHashSet;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.microtime.DateFormatUtils;
import io.questdb.std.microtime.TimestampFormat;
import io.questdb.std.microtime.TimestampLocaleFactory;
import io.questdb.std.microtime.Timestamps;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.tasks.ColumnIndexerTask;
import java.io.Closeable;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableWriter.class);
    private static final CharSequenceHashSet IGNORED_FILES = new CharSequenceHashSet();
    private static final Runnable NOOP = () -> {};
    private static final RemoveFileLambda REMOVE_OR_LOG = TableWriter::removeFileAndOrLog;
    private static final RemoveFileLambda REMOVE_OR_EXCEPTION = TableWriter::removeOrException;
    final ObjList<AppendMemory> columns;
    private final ObjList<SymbolMapWriter> symbolMapWriters;
    private final ObjList<SymbolMapWriter> denseSymbolMapWriters;
    private final ObjList<ColumnIndexer> indexers;
    private final ObjList<ColumnIndexer> denseIndexers = new ObjList();
    private final Path path;
    private final Path other;
    private final LongList refs = new LongList();
    private final Row row = new Row();
    private final int rootLen;
    private final ReadWriteMemory txMem;
    private final ReadOnlyMemory metaMem;
    private final VirtualMemory txPendingPartitionSizes;
    private final int partitionBy;
    private final RowFunction switchPartitionFunction = new SwitchPartitionRowFunction();
    private final RowFunction openPartitionFunction = new OpenPartitionRowFunction();
    private final RowFunction noPartitionFunction = new NoPartitionFunction();
    private final NativeLPSZ nativeLPSZ = new NativeLPSZ();
    private final LongList columnTops;
    private final FilesFacade ff;
    private final TimestampFormat partitionDirFmt;
    private final AppendMemory ddlMem;
    private final int mkDirMode;
    private final int fileOperationRetryCount;
    private final CharSequence name;
    private final TableWriterMetadata metadata;
    private final CairoConfiguration configuration;
    private final CharSequenceIntHashMap validationMap = new CharSequenceIntHashMap();
    private final FragileCode RECOVER_FROM_META_RENAME_FAILURE = this::recoverFromMetaRenameFailure;
    private final SOCountDownLatch indexLatch = new SOCountDownLatch();
    private final LongList indexSequences = new LongList();
    private final MessageBus messageBus;
    private final boolean parallelIndexerEnabled;
    private final LongHashSet removedPartitions = new LongHashSet();
    private final Timestamps.TimestampFloorMethod timestampFloorMethod;
    private final Timestamps.TimestampAddMethod timestampAddMethod;
    private final int defaultCommitMode;
    private final FindVisitor removePartitionDirectories = this::removePartitionDirectories0;
    private int txPartitionCount = 0;
    private long lockFd;
    private LongConsumer timestampSetter;
    private int columnCount;
    private ObjList<Runnable> nullers;
    private long fixedRowCount = 0L;
    private long txn;
    private long structureVersion;
    private long dataVersion;
    private RowFunction rowFunction = this.openPartitionFunction;
    private long prevMaxTimestamp;
    private long txPrevTransientRowCount;
    private long maxTimestamp;
    private long minTimestamp;
    private long prevMinTimestamp;
    private long partitionHi;
    private long transientRowCount = 0L;
    private long masterRef = 0L;
    private boolean removeDirOnCancelRow = true;
    private long tempMem8b = Unsafe.malloc(8L);
    private int metaSwapIndex;
    private int metaPrevIndex;
    private final FragileCode RECOVER_FROM_TODO_WRITE_FAILURE = this::recoverFrommTodoWriteFailure;
    private final FragileCode RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE = this::recoverFromSymbolMapWriterFailure;
    private final FragileCode RECOVER_FROM_SWAP_RENAME_FAILURE = this::recoverFromSwapRenameFailure;
    private final FragileCode RECOVER_FROM_COLUMN_OPEN_FAILURE = this::recoverOpenColumnFailure;
    private int indexCount;
    private boolean performRecovery;
    private boolean distressed = false;
    private LifecycleManager lifecycleManager;

    public TableWriter(CairoConfiguration configuration, CharSequence name) {
        this(configuration, name, null);
    }

    public TableWriter(CairoConfiguration configuration, CharSequence name, MessageBus messageBus) {
        this(configuration, name, messageBus, true, DefaultLifecycleManager.INSTANCE);
    }

    public TableWriter(CairoConfiguration configuration, CharSequence name, @Nullable MessageBus messageBus, boolean lock, LifecycleManager lifecycleManager) {
        LOG.info().$("open '").utf8(name).$('\'').$();
        this.configuration = configuration;
        this.messageBus = messageBus;
        this.defaultCommitMode = configuration.getCommitMode();
        this.lifecycleManager = lifecycleManager;
        this.parallelIndexerEnabled = messageBus != null && configuration.isParallelIndexingEnabled();
        this.ff = configuration.getFilesFacade();
        this.mkDirMode = configuration.getMkDirMode();
        this.fileOperationRetryCount = configuration.getFileOperationRetryCount();
        this.path = new Path().of(configuration.getRoot()).concat(name);
        this.other = new Path().of(configuration.getRoot()).concat(name);
        this.name = Chars.toString(name);
        this.rootLen = this.path.length();
        try {
            if (lock) {
                this.lock();
            } else {
                this.lockFd = -1L;
            }
            this.txMem = this.openTxnFile();
            long todo = this.readTodoTaskCode();
            if (todo != -1L && (int)(todo & 0xFFL) == 2) {
                this.repairMetaRename((int)(todo >> 8));
            }
            this.ddlMem = new AppendMemory();
            this.metaMem = new ReadOnlyMemory();
            this.openMetaFile();
            this.metadata = new TableWriterMetadata(this.ff, this.metaMem);
            if (todo != -1L) {
                switch ((int)(todo & 0xFFL)) {
                    case 1: {
                        this.repairTruncate();
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        LOG.error().$("ignoring unknown *todo* [code=").$(todo).$(']').$();
                    }
                }
            }
            this.columnCount = this.metadata.getColumnCount();
            this.partitionBy = this.metaMem.getInt(4L);
            this.txPendingPartitionSizes = new VirtualMemory(this.ff.getPageSize());
            this.refs.extendAndSet(this.columnCount, 0L);
            this.columns = new ObjList(this.columnCount * 2);
            this.symbolMapWriters = new ObjList(this.columnCount);
            this.indexers = new ObjList(this.columnCount);
            this.denseSymbolMapWriters = new ObjList(this.metadata.getSymbolMapCount());
            this.nullers = new ObjList(this.columnCount);
            this.columnTops = new LongList(this.columnCount);
            switch (this.partitionBy) {
                case 0: {
                    this.timestampFloorMethod = Timestamps.FLOOR_DD;
                    this.timestampAddMethod = Timestamps.ADD_DD;
                    this.partitionDirFmt = TableUtils.fmtDay;
                    break;
                }
                case 1: {
                    this.timestampFloorMethod = Timestamps.FLOOR_MM;
                    this.timestampAddMethod = Timestamps.ADD_MM;
                    this.partitionDirFmt = TableUtils.fmtMonth;
                    break;
                }
                case 2: {
                    this.timestampFloorMethod = Timestamps.FLOOR_YYYY;
                    this.timestampAddMethod = Timestamps.ADD_YYYY;
                    this.partitionDirFmt = TableUtils.fmtYear;
                    break;
                }
                default: {
                    this.timestampFloorMethod = null;
                    this.timestampAddMethod = null;
                    this.partitionDirFmt = null;
                }
            }
            this.configureColumnMemory();
            this.timestampSetter = this.configureTimestampSetter();
            this.configureAppendPosition();
            this.purgeUnusedPartitions();
            this.loadRemovedPartitions();
        }
        catch (CairoException e) {
            LOG.error().$("cannot open '").$(this.path).$("' and this is why: {").$(e).$('}').$();
            this.doClose(false);
            throw e;
        }
    }

    public static TimestampFormat selectPartitionDirFmt(int partitionBy) {
        switch (partitionBy) {
            case 0: {
                return TableUtils.fmtDay;
            }
            case 1: {
                return TableUtils.fmtMonth;
            }
            case 2: {
                return TableUtils.fmtYear;
            }
        }
        return null;
    }

    public void addColumn(CharSequence name, int type) {
        this.addColumn(name, type, this.configuration.getDefaultSymbolCapacity(), this.configuration.getDefaultSymbolCacheFlag(), false, 0, false);
    }

    public void addColumn(CharSequence name, int type, int symbolCapacity, boolean symbolCacheFlag, boolean isIndexed, int indexValueBlockCapacity, boolean isSequential) {
        assert (indexValueBlockCapacity == Numbers.ceilPow2(indexValueBlockCapacity)) : "power of 2 expected";
        assert (symbolCapacity == Numbers.ceilPow2(symbolCapacity)) : "power of 2 expected";
        this.checkDistressed();
        if (TableWriter.getColumnIndexQuiet(this.metaMem, name, this.columnCount) != -1) {
            throw CairoException.instance(0).put("Duplicate column name: ").put(name);
        }
        LOG.info().$("adding column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
        this.commit();
        this.removeColumnFiles(name, type, REMOVE_OR_EXCEPTION);
        this.metaSwapIndex = this.addColumnToMeta(name, type, isIndexed, indexValueBlockCapacity, isSequential);
        this.metaMem.close();
        this.validateSwapMeta(name);
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        if (type == 11) {
            try {
                this.createSymbolMapWriter(name, symbolCapacity, symbolCacheFlag);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_SYMBOL_MAP_WRITER_FAILURE, name, e);
            }
        } else {
            this.symbolMapWriters.extendAndSet(this.columnCount, null);
        }
        this.configureColumn(type, isIndexed);
        ++this.columnCount;
        this.columnTops.extendAndSet(this.columnCount - 1, this.transientRowCount);
        if (this.transientRowCount > 0L || this.partitionBy == 3) {
            try {
                this.openNewColumnFiles(name, isIndexed, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                this.runFragile(this.RECOVER_FROM_COLUMN_OPEN_FAILURE, name, e);
            }
        }
        try {
            this.openMetaFile();
            this.removeTodoFile();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.addColumn(name, type, isIndexed, indexValueBlockCapacity);
        LOG.info().$("ADDED column '").utf8(name).$('[').$(ColumnType.nameOf(type)).$("]' to ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(CharSequence columnName, int indexValueBlockSize) {
        assert (indexValueBlockSize == Numbers.ceilPow2(indexValueBlockSize)) : "power of 2 expected";
        this.checkDistressed();
        int columnIndex = TableWriter.getColumnIndexQuiet(this.metaMem, columnName, this.columnCount);
        if (columnIndex == -1) {
            throw CairoException.instance(0).put("Invalid column name: ").put(columnName);
        }
        this.commit();
        if (TableUtils.isColumnIndexed(this.metaMem, columnIndex)) {
            throw CairoException.instance(0).put("already indexed [column=").put(columnName).put(']');
        }
        int existingType = TableUtils.getColumnType(this.metaMem, columnIndex);
        LOG.info().$("adding index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).$(']').$();
        if (existingType != 11) {
            LOG.error().$("cannot create index for [column='").utf8(columnName).$(", type=").$(ColumnType.nameOf(existingType)).$(", path=").$(this.path).$(']').$();
            throw CairoException.instance(0).put("cannot create index for [column='").put(columnName).put(", type=").put(ColumnType.nameOf(existingType)).put(", path=").put(this.path).put(']');
        }
        SymbolColumnIndexer indexer = new SymbolColumnIndexer();
        try {
            try {
                if (this.partitionBy != 3) {
                    long timestamp = this.indexHistoricPartitions(indexer, columnName, indexValueBlockSize);
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(timestamp, true);
                } else {
                    this.setStateForTimestamp(0L, false);
                }
                this.indexLastPartition(indexer, columnName, columnIndex, indexValueBlockSize);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        catch (CairoError | CairoException e) {
            LOG.error().$("rolling back index created so far [path=").$(this.path).$(']').$();
            this.removeIndexFiles(columnName);
            throw e;
        }
        this.metaSwapIndex = this.copyMetadataAndSetIndexed(columnIndex, indexValueBlockSize);
        this.metaMem.close();
        this.validateSwapMeta(columnName);
        this.renameMetaToMetaPrev(columnName);
        this.writeRestoreMetaTodo(columnName);
        this.renameSwapMetaToMeta(columnName);
        try {
            this.openMetaFile();
            this.removeTodoFile();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.indexers.extendAndSet(columnIndex / 2, indexer);
        this.populateDenseIndexerList();
        TableColumnMetadata columnMetadata = this.metadata.getColumnQuick(columnIndex);
        columnMetadata.setIndexed(true);
        columnMetadata.setIndexValueBlockCapacity(indexValueBlockSize);
        LOG.info().$("ADDED index to '").utf8(columnName).$('[').$(ColumnType.nameOf(existingType)).$("]' to ").$(this.path).$();
    }

    @Override
    public void close() {
        if (this.isOpen() && this.lifecycleManager.close()) {
            this.doClose(true);
        }
    }

    public void commit() {
        this.commit(this.defaultCommitMode);
    }

    public void commit(int commitMode) {
        this.checkDistressed();
        if ((this.masterRef & 1L) != 0L) {
            this.cancelRow();
        }
        if (this.inTransaction()) {
            if (commitMode != 2) {
                this.syncColumns(commitMode);
            }
            this.updateIndexes();
            this.txMem.putLong(0L, ++this.txn);
            Unsafe.getUnsafe().storeFence();
            this.txMem.putLong(8L, this.transientRowCount);
            if (this.txPartitionCount > 1) {
                this.commitPendingPartitions();
                this.txMem.putLong(16L, this.fixedRowCount);
                this.txPendingPartitionSizes.jumpTo(0L);
                this.txPartitionCount = 1;
            }
            this.txMem.putLong(24L, this.minTimestamp);
            this.txMem.putLong(32L, this.maxTimestamp);
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                this.txMem.putInt(TableUtils.getSymbolWriterIndexOffset(i), this.denseSymbolMapWriters.getQuick(i).getSymbolCount());
            }
            Unsafe.getUnsafe().storeFence();
            this.txMem.putLong(64L, this.txn);
            if (commitMode != 2) {
                this.txMem.sync(0, commitMode == 0);
            }
            this.txPrevTransientRowCount = this.transientRowCount;
        }
    }

    public int getColumnIndex(CharSequence name) {
        int index = this.metadata.getColumnIndexQuiet(name);
        if (index == -1) {
            throw CairoException.instance(0).put("Invalid column name: ").put(name);
        }
        return index;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    public CharSequence getName() {
        return this.name;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public long getStructureVersion() {
        return this.structureVersion;
    }

    public boolean inTransaction() {
        return this.txPartitionCount > 1 || this.transientRowCount != this.txPrevTransientRowCount;
    }

    public boolean isOpen() {
        return this.tempMem8b != 0L;
    }

    public Row newRow(long timestamp) {
        return this.rowFunction.newRow(timestamp);
    }

    public Row newRow() {
        return this.newRow(0L);
    }

    public long partitionNameToTimestamp(CharSequence partitionName) {
        if (this.partitionDirFmt == null) {
            throw CairoException.instance(0).put("table is not partitioned");
        }
        try {
            return this.partitionDirFmt.parse(partitionName, TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale());
        }
        catch (NumericException e) {
            CairoException ee = CairoException.instance(0);
            switch (this.partitionBy) {
                case 0: {
                    ee.put("'YYYY-MM-DD'");
                    break;
                }
                case 1: {
                    ee.put("'YYYY-MM'");
                    break;
                }
                default: {
                    ee.put("'YYYY'");
                }
            }
            ee.put(" expected");
            throw ee;
        }
    }

    public void removeColumn(CharSequence name) {
        boolean timestamp;
        this.checkDistressed();
        int index = this.getColumnIndex(name);
        int type = this.metadata.getColumnType(index);
        LOG.info().$("removing column '").utf8(name).$("' from ").$(this.path).$();
        boolean bl = timestamp = index == this.metaMem.getInt(8L);
        if (timestamp && this.partitionBy != 3) {
            throw CairoException.instance(0).put("Cannot remove timestamp from partitioned table");
        }
        this.commit();
        this.metaSwapIndex = this.removeColumnFromMeta(index);
        this.metaMem.close();
        this.renameMetaToMetaPrev(name);
        this.writeRestoreMetaTodo(name);
        this.renameSwapMetaToMeta(name);
        this.removeColumn(index);
        this.removeSymbolMapWriter(index);
        --this.columnCount;
        if (timestamp) {
            this.prevMaxTimestamp = Long.MIN_VALUE;
            this.maxTimestamp = Long.MIN_VALUE;
            this.prevMinTimestamp = Long.MAX_VALUE;
            this.minTimestamp = Long.MAX_VALUE;
            this.timestampSetter = value -> {};
        }
        try {
            this.openMetaFile();
            this.removeTodoFile();
            this.removeColumnFiles(name, type, REMOVE_OR_LOG);
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.removeColumn(name);
        LOG.info().$("REMOVED column '").utf8(name).$("' from ").$(this.path).$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePartition(long timestamp) {
        if (this.partitionBy == 3 || timestamp < this.timestampFloorMethod.floor(this.minTimestamp) || timestamp > this.maxTimestamp) {
            return false;
        }
        if (this.timestampFloorMethod.floor(timestamp) == this.timestampFloorMethod.floor(this.maxTimestamp)) {
            LOG.error().$("cannot remove active partition [path=").$(this.path).$(", maxTimestamp=").$ts(this.maxTimestamp).$(']').$();
            return false;
        }
        if (this.removedPartitions.contains(timestamp)) {
            LOG.error().$("partition is already marked for delete [path=").$(this.path).$(']').$();
            return false;
        }
        try {
            long nextMinTimestamp = this.timestampFloorMethod.floor(timestamp) == this.timestampFloorMethod.floor(this.minTimestamp) ? this.getNextMinTimestamp(this.timestampFloorMethod, this.timestampAddMethod) : this.minTimestamp;
            this.setStateForTimestamp(timestamp, false);
            if (this.ff.exists(this.path)) {
                long partitionSize = TableUtils.readPartitionSize(this.ff, this.path, this.tempMem8b);
                int symbolWriterCount = this.denseSymbolMapWriters.size();
                int partitionTableSize = this.txMem.getInt(TableUtils.getPartitionTableSizeOffset(symbolWriterCount));
                long txn = this.txMem.getLong(0L) + 1L;
                this.txMem.putLong(0L, txn);
                Unsafe.getUnsafe().storeFence();
                long partitionVersion = this.txMem.getLong(56L) + 1L;
                this.txMem.jumpTo(TableUtils.getPartitionTableIndexOffset(symbolWriterCount, partitionTableSize));
                this.txMem.putLong(timestamp);
                this.txMem.putLong(56L, partitionVersion);
                this.txMem.putInt(TableUtils.getPartitionTableSizeOffset(symbolWriterCount), partitionTableSize + 1);
                if (nextMinTimestamp != this.minTimestamp) {
                    this.txMem.putLong(24L, nextMinTimestamp);
                    this.minTimestamp = nextMinTimestamp;
                }
                this.txMem.putLong(16L, this.txMem.getLong(16L) - partitionSize);
                Unsafe.getUnsafe().storeFence();
                this.txMem.putLong(64L, txn);
                if (!this.ff.rmdir(this.path.chopZ().put(Files.SEPARATOR).$())) {
                    LOG.info().$("partition directory delete is postponed [path=").$(this.path).$(']').$();
                }
                this.removedPartitions.add(timestamp);
                this.fixedRowCount -= partitionSize;
                LOG.info().$("partition marked for delete [path=").$(this.path).$(']').$();
                boolean bl = true;
                return bl;
            }
            LOG.error().$("cannot remove already missing partition [path=").$(this.path).$(']').$();
            boolean bl = false;
            return bl;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    public void rollback() {
        this.checkDistressed();
        if (this.inTransaction()) {
            LOG.info().$("tx rollback [name=").$(this.name).$(']').$();
            this.freeColumns(false);
            this.txPendingPartitionSizes.jumpTo(0L);
            this.configureAppendPosition();
            this.rollbackIndexes();
            this.purgeUnusedPartitions();
            LOG.info().$("tx rollback complete [name=").$(this.name).$(']').$();
        }
    }

    public void setLifecycleManager(LifecycleManager lifecycleManager) {
        this.lifecycleManager = lifecycleManager;
    }

    public long size() {
        return this.fixedRowCount + this.transientRowCount;
    }

    public String toString() {
        return "TableWriter{name=" + this.name + '}';
    }

    public void transferLock(long lockFd) {
        assert (lockFd != -1L);
        this.lockFd = lockFd;
    }

    public final void truncate() {
        int i;
        if (this.size() == 0L) {
            return;
        }
        this.writeTodo(1L);
        for (i = 0; i < this.columnCount; ++i) {
            this.getPrimaryColumn(i).truncate();
            AppendMemory mem = this.getSecondaryColumn(i);
            if (mem == null) continue;
            mem.truncate();
        }
        if (this.partitionBy != 3) {
            this.freeColumns(false);
            if (this.indexers != null) {
                int n = this.indexers.size();
                for (i = 0; i < n; ++i) {
                    Misc.free(this.indexers.getQuick(i));
                }
            }
            this.removePartitionDirectories();
            this.rowFunction = this.openPartitionFunction;
        }
        this.prevMaxTimestamp = Long.MIN_VALUE;
        this.maxTimestamp = Long.MIN_VALUE;
        this.prevMinTimestamp = Long.MAX_VALUE;
        this.minTimestamp = Long.MAX_VALUE;
        this.txPrevTransientRowCount = 0L;
        this.transientRowCount = 0L;
        this.fixedRowCount = 0L;
        ++this.txn;
        this.txPartitionCount = 1;
        TableUtils.resetTxn(this.txMem, this.metadata.getSymbolMapCount(), this.txn, ++this.dataVersion);
        try {
            this.removeTodoFile();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        LOG.info().$("truncated [name=").$(this.name).$(']').$();
    }

    public void updateMetadataVersion() {
        this.checkDistressed();
        this.commit();
        this.metaSwapIndex = this.copyMetadataAndUpdateVersion();
        this.metaMem.close();
        this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        try {
            this.openMetaFile();
        }
        catch (CairoException err) {
            this.throwDistressException(err);
        }
        this.bumpStructureVersion();
        this.metadata.setTableVersion();
    }

    public void warmUp() {
        Row r = this.newRow(this.maxTimestamp);
        try {
            for (int i = 0; i < this.columnCount; ++i) {
                r.putByte(i, (byte)0);
            }
        }
        finally {
            r.cancel();
        }
    }

    private static void removeOrException(FilesFacade ff, LPSZ path) {
        if (ff.exists(path) && !ff.remove(path)) {
            throw CairoException.instance(ff.errno()).put("Cannot remove ").put(path);
        }
    }

    private static int getPrimaryColumnIndex(int index) {
        return index * 2;
    }

    private static int getSecondaryColumnIndex(int index) {
        return TableWriter.getPrimaryColumnIndex(index) + 1;
    }

    private static void setColumnSize(FilesFacade ff, AppendMemory mem1, AppendMemory mem2, int type, long actualPosition, long buf) {
        if (actualPosition > 0L) {
            switch (type) {
                case 13: {
                    assert (mem2 != null);
                    TableWriter.readOffsetBytes(ff, mem2, actualPosition, buf);
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    TableWriter.readBytes(ff, mem1, buf, 8, offset, "Cannot read length, fd=");
                    long len = Unsafe.getUnsafe().getLong(buf);
                    mem1.setSize(len == -1L ? offset + 8L : offset + len + 8L);
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                case 10: {
                    assert (mem2 != null);
                    TableWriter.readOffsetBytes(ff, mem2, actualPosition, buf);
                    long offset = Unsafe.getUnsafe().getLong(buf);
                    TableWriter.readBytes(ff, mem1, buf, 4, offset, "Cannot read length, fd=");
                    long len = Unsafe.getUnsafe().getInt(buf);
                    mem1.setSize(len == -1L ? offset + 4L : offset + len * 2L + 4L);
                    mem2.setSize(actualPosition * 8L);
                    break;
                }
                default: {
                    mem1.setSize(actualPosition << ColumnType.pow2SizeOf(type));
                    break;
                }
            }
        } else {
            mem1.setSize(0L);
            if (mem2 != null) {
                mem2.setSize(0L);
            }
        }
    }

    private static void readOffsetBytes(FilesFacade ff, AppendMemory mem, long position, long buf) {
        TableWriter.readBytes(ff, mem, buf, 8, (position - 1L) * 8L, "Cannot read offset, fd=");
    }

    private static void readBytes(FilesFacade ff, AppendMemory mem, long buf, int byteCount, long offset, CharSequence errorMsg) {
        if (ff.read(mem.getFd(), buf, byteCount, offset) != (long)byteCount) {
            throw CairoException.instance(ff.errno()).put(errorMsg).put(mem.getFd()).put(", offset=").put(offset);
        }
    }

    private static int getColumnIndexQuiet(ReadOnlyMemory metaMem, CharSequence name, int columnCount) {
        long nameOffset = TableUtils.getColumnNameOffset(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            CharSequence col = metaMem.getStr(nameOffset);
            if (Chars.equalsIgnoreCase(col, name)) {
                return i;
            }
            nameOffset += (long)VirtualMemory.getStorageLength(col);
        }
        return -1;
    }

    private static void removeFileAndOrLog(FilesFacade ff, LPSZ name) {
        if (ff.exists(name)) {
            if (ff.remove(name)) {
                LOG.info().$("removed: ").$(name).$();
            } else {
                LOG.error().$("cannot remove: ").utf8(name).$(" [errno=").$(ff.errno()).$(']').$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexAndCountDown(ColumnIndexer indexer, long lo, long hi, SOCountDownLatch latch) {
        try {
            indexer.refreshSourceAndIndex(lo, hi);
        }
        catch (CairoException e) {
            indexer.distress();
            LOG.error().$("index error [fd=").$(indexer.getFd()).$(']').$('{').$(e).$('}').$();
        }
        finally {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addColumnToMeta(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity, boolean sequentialFlag) {
        int index;
        try {
            index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount + 1);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.ddlMem.putInt(416);
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i);
            }
            this.ddlMem.putByte((byte)type);
            long flags = 0L;
            if (indexFlag) {
                flags |= 1L;
            }
            if (sequentialFlag) {
                flags |= 2L;
            }
            this.ddlMem.putLong(flags);
            this.ddlMem.putInt(indexValueBlockCapacity);
            this.ddlMem.skip(3L);
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            this.ddlMem.putStr(name);
        }
        finally {
            this.ddlMem.close();
        }
        return index;
    }

    private void bumpMasterRef() {
        if ((this.masterRef & 1L) != 0L) {
            this.cancelRow();
        }
        ++this.masterRef;
    }

    private void bumpStructureVersion() {
        this.txMem.putLong(0L, ++this.txn);
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(40L, ++this.structureVersion);
        int count = this.denseSymbolMapWriters.size();
        int oldCount = this.txMem.getInt(72L);
        this.txMem.putInt(72L, count);
        for (int i = 0; i < count; ++i) {
            this.txMem.putInt(TableUtils.getSymbolWriterIndexOffset(i), this.denseSymbolMapWriters.getQuick(i).getSymbolCount());
        }
        if (oldCount != count) {
            int n = this.removedPartitions.size();
            this.txMem.putInt(TableUtils.getPartitionTableSizeOffset(count), n);
            for (int i = 0; i < n; ++i) {
                this.txMem.putLong(TableUtils.getPartitionTableIndexOffset(count, i), this.removedPartitions.get(i));
            }
        }
        Unsafe.getUnsafe().storeFence();
        this.txMem.putLong(64L, this.txn);
    }

    private void cancelRow() {
        if ((this.masterRef & 1L) == 0L) {
            return;
        }
        if (this.transientRowCount == 0L) {
            if (this.partitionBy != 3) {
                this.freeColumns(false);
                if (this.removeDirOnCancelRow) {
                    try {
                        this.setStateForTimestamp(this.maxTimestamp, false);
                        if (!this.ff.rmdir(this.path.$())) {
                            throw CairoException.instance(this.ff.errno()).put("Cannot remove directory: ").put(this.path);
                        }
                        this.removeDirOnCancelRow = false;
                    }
                    finally {
                        this.path.trimTo(this.rootLen);
                    }
                }
                if (this.prevMaxTimestamp > Long.MIN_VALUE) {
                    try {
                        this.txPendingPartitionSizes.jumpTo((this.txPartitionCount - 2) * 16);
                        this.openPartition(this.prevMaxTimestamp);
                        this.setAppendPosition(this.txPrevTransientRowCount);
                        --this.txPartitionCount;
                    }
                    catch (CairoException e) {
                        this.freeColumns(false);
                        throw e;
                    }
                } else {
                    this.rowFunction = this.openPartitionFunction;
                }
                this.transientRowCount = this.txPrevTransientRowCount;
                this.fixedRowCount -= this.txPrevTransientRowCount;
                this.maxTimestamp = this.prevMaxTimestamp;
                this.minTimestamp = this.prevMinTimestamp;
                this.removeDirOnCancelRow = true;
            } else {
                this.maxTimestamp = this.prevMaxTimestamp;
                this.minTimestamp = this.prevMinTimestamp;
                for (int i = 0; i < this.columnCount; ++i) {
                    this.getPrimaryColumn(i).setSize(0L);
                    AppendMemory mem = this.getSecondaryColumn(i);
                    if (mem == null) continue;
                    mem.setSize(0L);
                }
            }
        } else {
            this.maxTimestamp = this.prevMaxTimestamp;
            this.minTimestamp = this.prevMinTimestamp;
            boolean rowChanged = false;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.refs.getQuick(i) != this.masterRef) continue;
                rowChanged = true;
                break;
            }
            if (rowChanged) {
                this.setAppendPosition(this.transientRowCount);
            }
        }
        this.refs.fill(0, this.columnCount, --this.masterRef);
    }

    private void checkDistressed() {
        if (this.distressed) {
            throw new CairoError("Table '" + this.name.toString() + "' is distressed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitPendingPartitions() {
        long offset = 0L;
        for (int i = 0; i < this.txPartitionCount - 1; ++i) {
            try {
                long partitionTimestamp = this.txPendingPartitionSizes.getLong(offset + 8L);
                this.setStateForTimestamp(partitionTimestamp, false);
                long fd = this.openAppend(this.path.concat("_archive").$());
                try {
                    int len = 8;
                    long o = offset;
                    while (len > 0) {
                        long l = Math.min((long)len, this.txPendingPartitionSizes.pageRemaining(o));
                        if (this.ff.write(fd, this.txPendingPartitionSizes.addressOf(o), l, 0L) != l) {
                            throw CairoException.instance(this.ff.errno()).put("Commit failed, file=").put(this.path);
                        }
                        len = (int)((long)len - l);
                        o += l;
                    }
                }
                finally {
                    this.ff.close(fd);
                }
                offset += 16L;
                continue;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void configureAppendPosition() {
        this.txn = this.txMem.getLong(0L);
        this.txPrevTransientRowCount = this.transientRowCount = this.txMem.getLong(8L);
        this.fixedRowCount = this.txMem.getLong(16L);
        this.minTimestamp = this.txMem.getLong(24L);
        this.maxTimestamp = this.txMem.getLong(32L);
        this.dataVersion = this.txMem.getLong(48L);
        this.structureVersion = this.txMem.getLong(40L);
        this.prevMaxTimestamp = this.maxTimestamp;
        this.prevMinTimestamp = this.minTimestamp;
        if (this.maxTimestamp > Long.MIN_VALUE || this.partitionBy == 3) {
            this.openFirstPartition(this.maxTimestamp);
            this.rowFunction = this.partitionBy == 3 ? this.noPartitionFunction : this.switchPartitionFunction;
        } else {
            this.rowFunction = this.openPartitionFunction;
        }
    }

    private void configureColumn(int type, boolean indexFlag) {
        AppendMemory secondary;
        AppendMemory primary = new AppendMemory();
        switch (type) {
            case 10: 
            case 13: {
                secondary = new AppendMemory();
                break;
            }
            default: {
                secondary = null;
            }
        }
        this.columns.add(primary);
        this.columns.add(secondary);
        this.configureNuller(type, primary, secondary);
        if (indexFlag) {
            this.indexers.extendAndSet((this.columns.size() - 1) / 2, new SymbolColumnIndexer());
            this.populateDenseIndexerList();
        }
        this.refs.add(0L);
    }

    private void configureColumnMemory() {
        int expectedMapWriters = this.txMem.getInt(72L);
        long nextSymbolCountOffset = TableUtils.getSymbolWriterIndexOffset(0);
        this.symbolMapWriters.setPos(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.metadata.getColumnType(i);
            this.configureColumn(type, this.metadata.isColumnIndexed(i));
            if (type == 11) {
                assert (nextSymbolCountOffset < TableUtils.getSymbolWriterIndexOffset(expectedMapWriters));
                SymbolMapWriter symbolMapWriter = new SymbolMapWriter(this.configuration, this.path.trimTo(this.rootLen), this.metadata.getColumnName(i), this.txMem.getInt(nextSymbolCountOffset));
                this.symbolMapWriters.extendAndSet(i, symbolMapWriter);
                this.denseSymbolMapWriters.add(symbolMapWriter);
                nextSymbolCountOffset += 4L;
            }
            if (!this.metadata.isColumnIndexed(i)) continue;
            this.indexers.extendAndSet(i, new SymbolColumnIndexer());
        }
        this.populateDenseIndexerList();
    }

    private void configureNuller(int type, AppendMemory mem1, AppendMemory mem2) {
        switch (type) {
            case 0: 
            case 1: {
                this.nullers.add(() -> mem1.putByte((byte)0));
                break;
            }
            case 9: {
                this.nullers.add(() -> mem1.putDouble(Double.NaN));
                break;
            }
            case 8: {
                this.nullers.add(() -> mem1.putFloat(Float.NaN));
                break;
            }
            case 4: {
                this.nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.nullers.add(() -> mem1.putLong(Long.MIN_VALUE));
                break;
            }
            case 12: {
                this.nullers.add(() -> mem1.putLong256(Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE));
                break;
            }
            case 2: {
                this.nullers.add(() -> mem1.putShort((short)0));
                break;
            }
            case 3: {
                this.nullers.add(() -> mem1.putChar('\u0000'));
                break;
            }
            case 10: {
                this.nullers.add(() -> mem2.putLong(mem1.putNullStr()));
                break;
            }
            case 11: {
                this.nullers.add(() -> mem1.putInt(Integer.MIN_VALUE));
                break;
            }
            case 13: {
                this.nullers.add(() -> mem2.putLong(mem1.putNullBin()));
                break;
            }
        }
    }

    private LongConsumer configureTimestampSetter() {
        int index = this.metadata.getTimestampIndex();
        if (index == -1) {
            return value -> {};
        }
        this.nullers.setQuick(index, NOOP);
        return this.getPrimaryColumn(index)::putLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyMetadataAndSetIndexed(int columnIndex, int indexValueBlockSize) {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.ddlMem.putInt(416);
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                if (i != columnIndex) {
                    this.writeColumnEntry(i);
                    continue;
                }
                this.ddlMem.putByte((byte)TableUtils.getColumnType(this.metaMem, i));
                long flags = 1L;
                if (TableUtils.isSequential(this.metaMem, i)) {
                    flags |= 2L;
                }
                this.ddlMem.putLong(flags);
                this.ddlMem.putInt(indexValueBlockSize);
                this.ddlMem.skip(3L);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            int n = index;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int copyMetadataAndUpdateVersion() {
        try {
            int index = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.configuration.getMaxSwapFileCount());
            int columnCount = this.metaMem.getInt(0L);
            this.ddlMem.putInt(columnCount);
            this.ddlMem.putInt(this.metaMem.getInt(4L));
            this.ddlMem.putInt(this.metaMem.getInt(8L));
            this.ddlMem.putInt(416);
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < columnCount; ++i) {
                this.writeColumnEntry(i);
            }
            long nameOffset = TableUtils.getColumnNameOffset(columnCount);
            for (int i = 0; i < columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                this.ddlMem.putStr(columnName);
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            int n = index;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(CharSequence columnName, int indexValueBlockCapacity, int plen, boolean force) {
        try {
            BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName);
            if (!force && this.ff.exists(this.path)) {
                return;
            }
            try {
                this.ddlMem.of(this.ff, this.path, this.ff.getPageSize());
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").utf8(this.path).$(']').$();
                if (!this.ff.remove(this.path)) {
                    LOG.error().$("could not remove '").utf8(this.path).$("'. Please remove MANUALLY.").$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!this.ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName))) {
                LOG.error().$("could not create index [name=").$(this.path).$(']').$();
                throw CairoException.instance(this.ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void createSymbolMapWriter(CharSequence name, int symbolCapacity, boolean symbolCacheFlag) {
        SymbolMapWriter.createSymbolMapFiles(this.ff, this.ddlMem, this.path, name, symbolCapacity, symbolCacheFlag);
        SymbolMapWriter w = new SymbolMapWriter(this.configuration, this.path, name, 0);
        this.denseSymbolMapWriters.add(w);
        this.symbolMapWriters.extendAndSet(this.columnCount, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean truncate) {
        boolean tx = this.inTransaction();
        this.freeColumns(truncate);
        this.freeSymbolMapWriters();
        this.freeIndexers();
        try {
            this.freeTxMem();
        }
        catch (Throwable throwable) {
            Misc.free(this.metaMem);
            Misc.free(this.txPendingPartitionSizes);
            Misc.free(this.ddlMem);
            Misc.free(this.other);
            try {
                this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
            }
            finally {
                Misc.free(this.path);
                this.freeTempMem();
                LOG.info().$("closed '").utf8(this.name).$('\'').$();
            }
            throw throwable;
        }
        Misc.free(this.metaMem);
        Misc.free(this.txPendingPartitionSizes);
        Misc.free(this.ddlMem);
        Misc.free(this.other);
        try {
            this.releaseLock(!truncate | tx | this.performRecovery | this.distressed);
        }
        finally {
            Misc.free(this.path);
            this.freeTempMem();
            LOG.info().$("closed '").utf8(this.name).$('\'').$();
        }
    }

    private void freeColumns(boolean truncate) {
        if (this.columns != null) {
            int n = this.columns.size();
            for (int i = 0; i < n; ++i) {
                AppendMemory m = this.columns.getQuick(i);
                if (m == null) continue;
                m.close(truncate);
            }
        }
    }

    private void freeIndexers() {
        if (this.indexers != null) {
            int n = this.indexers.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.indexers.getQuick(i));
            }
            this.indexers.clear();
            this.denseIndexers.clear();
        }
    }

    private void freeSymbolMapWriters() {
        if (this.denseSymbolMapWriters != null) {
            int n = this.denseSymbolMapWriters.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.denseSymbolMapWriters.getQuick(i));
            }
            this.symbolMapWriters.clear();
        }
        if (this.symbolMapWriters != null) {
            this.symbolMapWriters.clear();
        }
    }

    private void freeTempMem() {
        if (this.tempMem8b != 0L) {
            Unsafe.free(this.tempMem8b, 8L);
            this.tempMem8b = 0L;
        }
    }

    private void freeTxMem() {
        if (this.txMem != null) {
            try {
                this.txMem.jumpTo(this.getTxEofOffset());
            }
            finally {
                this.txMem.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextMinTimestamp(Timestamps.TimestampFloorMethod timestampFloorMethod, Timestamps.TimestampAddMethod timestampAddMethod) {
        long nextMinTimestamp = this.minTimestamp;
        while (nextMinTimestamp < this.maxTimestamp) {
            long nextTimestamp = timestampFloorMethod.floor(timestampAddMethod.calculate(nextMinTimestamp, 1));
            this.setStateForTimestamp(nextTimestamp, false);
            try {
                TableUtils.dFile(this.path, this.metadata.getColumnName(this.metadata.getTimestampIndex()));
                if (this.ff.exists(this.path)) {
                    long fd = this.ff.openRO(this.path);
                    if (fd == -1L) {
                        throw CairoException.instance(Os.errno()).put("could not open [file=").put(this.path).put(']');
                    }
                    try {
                        long buf = Unsafe.malloc(8L);
                        try {
                            long n = this.ff.read(fd, buf, 8L, 0L);
                            if (n != 8L) {
                                throw CairoException.instance(Os.errno()).put("could not read timestamp value");
                            }
                            nextMinTimestamp = Unsafe.getUnsafe().getLong(buf);
                            break;
                        }
                        finally {
                            Unsafe.free(buf, 8L);
                        }
                    }
                    finally {
                        this.ff.close(fd);
                    }
                }
                nextMinTimestamp = nextTimestamp;
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
        assert (nextMinTimestamp > this.minTimestamp);
        return nextMinTimestamp;
    }

    private AppendMemory getPrimaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getPrimaryColumnIndex(column));
    }

    private AppendMemory getSecondaryColumn(int column) {
        assert (column < this.columnCount) : "Column index is out of bounds: " + column + " >= " + this.columnCount;
        return this.columns.getQuick(TableWriter.getSecondaryColumnIndex(column));
    }

    SymbolMapWriter getSymbolMapWriter(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex);
    }

    private long getTxEofOffset() {
        if (this.metadata != null) {
            return TableUtils.getTxMemSize(this.metadata.getSymbolMapCount(), this.removedPartitions.size());
        }
        return this.ff.length(this.txMem.getFd());
    }

    int getTxPartitionCount() {
        return this.txPartitionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long indexHistoricPartitions(SymbolColumnIndexer indexer, CharSequence columnName, int indexValueBlockSize) {
        long maxTimestamp = this.timestampFloorMethod.floor(this.maxTimestamp);
        long timestamp = this.minTimestamp;
        try (ReadOnlyMemory roMem = new ReadOnlyMemory();){
            while (timestamp < maxTimestamp) {
                this.path.trimTo(this.rootLen);
                this.setStateForTimestamp(timestamp, true);
                if (this.ff.exists(this.path.$())) {
                    int plen = this.path.length();
                    TableUtils.dFile(this.path.trimTo(plen), columnName);
                    if (this.ff.exists(this.path)) {
                        this.path.trimTo(plen);
                        LOG.info().$("indexing [path=").$(this.path).$(']').$();
                        this.createIndexFiles(columnName, indexValueBlockSize, plen, true);
                        long partitionSize = TableUtils.readPartitionSize(this.ff, this.path.trimTo(plen), this.tempMem8b);
                        long columnTop = TableUtils.readColumnTop(this.ff, this.path.trimTo(plen), columnName, plen, this.tempMem8b);
                        if (partitionSize > columnTop) {
                            TableUtils.dFile(this.path.trimTo(plen), columnName);
                            roMem.of(this.ff, this.path, this.ff.getPageSize(), 0L);
                            roMem.grow(partitionSize - columnTop << ColumnType.pow2SizeOf(4));
                            indexer.configureWriter(this.configuration, this.path.trimTo(plen), columnName, columnTop);
                            indexer.index(roMem, columnTop, partitionSize);
                        }
                    }
                }
                timestamp = this.timestampAddMethod.calculate(timestamp, 1);
            }
        }
        finally {
            indexer.close();
        }
        return timestamp;
    }

    private void indexLastPartition(SymbolColumnIndexer indexer, CharSequence columnName, int columnIndex, int indexValueBlockSize) {
        int plen = this.path.length();
        this.createIndexFiles(columnName, indexValueBlockSize, plen, true);
        long columnTop = TableUtils.readColumnTop(this.ff, this.path.trimTo(plen), columnName, plen, this.tempMem8b);
        indexer.configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), columnName, this.getPrimaryColumn(columnIndex), columnTop);
        indexer.refreshSourceAndIndex(0L, this.transientRowCount);
    }

    boolean isSymbolMapWriterCached(int columnIndex) {
        return this.symbolMapWriters.getQuick(columnIndex).isCached();
    }

    private void loadRemovedPartitions() {
        int symbolWriterCount = this.denseSymbolMapWriters.size();
        int partitionTableSize = this.txMem.getInt(TableUtils.getPartitionTableSizeOffset(symbolWriterCount));
        if (partitionTableSize > 0) {
            for (int i = 0; i < partitionTableSize; ++i) {
                this.removedPartitions.add(this.txMem.getLong(TableUtils.getPartitionTableIndexOffset(symbolWriterCount, i)));
            }
        }
    }

    private void lock() {
        try {
            this.path.trimTo(this.rootLen);
            TableUtils.lockName(this.path);
            this.performRecovery = this.ff.exists(this.path);
            this.lockFd = TableUtils.lock(this.ff, this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
        if (this.lockFd == -1L) {
            throw CairoException.instance(this.ff.errno()).put("Cannot lock table: ").put(this.path.$());
        }
    }

    private long openAppend(LPSZ name) {
        long fd = this.ff.openAppend(name);
        if (fd == -1L) {
            throw CairoException.instance(Os.errno()).put("Cannot open for append: ").put(name);
        }
        return fd;
    }

    private void openColumnFiles(CharSequence name, int i, int plen) {
        AppendMemory mem1 = this.getPrimaryColumn(i);
        AppendMemory mem2 = this.getSecondaryColumn(i);
        mem1.of(this.ff, TableUtils.dFile(this.path.trimTo(plen), name), this.ff.getMapPageSize());
        if (mem2 != null) {
            mem2.of(this.ff, TableUtils.iFile(this.path.trimTo(plen), name), this.ff.getMapPageSize());
        }
        this.path.trimTo(plen);
    }

    private void openFirstPartition(long timestamp) {
        this.openPartition(this.repairDataGaps(timestamp));
        this.setAppendPosition(this.transientRowCount);
        if (this.performRecovery) {
            this.performRecovery();
        }
        this.txPartitionCount = 1;
    }

    private void openMetaFile() {
        this.path.concat("_meta").$();
        try {
            this.metaMem.of(this.ff, this.path, this.ff.getPageSize(), this.ff.length(this.path));
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewColumnFiles(CharSequence name, boolean indexFlag, int indexValueBlockCapacity) {
        try {
            this.setStateForTimestamp(this.maxTimestamp, false);
            int plen = this.path.length();
            int columnIndex = this.columnCount - 1;
            if (indexFlag) {
                this.createIndexFiles(name, indexValueBlockCapacity, plen, true);
            }
            this.openColumnFiles(name, columnIndex, plen);
            if (this.transientRowCount > 0L) {
                this.writeColumnTop(name);
            }
            if (indexFlag) {
                ColumnIndexer indexer = this.indexers.getQuick(columnIndex);
                assert (indexer != null);
                this.indexers.getQuick(columnIndex).configureFollowerAndWriter(this.configuration, this.path.trimTo(plen), name, this.getPrimaryColumn(columnIndex), this.transientRowCount);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPartition(long timestamp) {
        try {
            this.setStateForTimestamp(timestamp, true);
            int plen = this.path.length();
            if (this.ff.mkdirs(this.path.put(Files.SEPARATOR).$(), this.mkDirMode) != 0) {
                throw CairoException.instance(this.ff.errno()).put("Cannot create directory: ").put(this.path);
            }
            assert (this.columnCount > 0);
            for (int i = 0; i < this.columnCount; ++i) {
                String name = this.metadata.getColumnName(i);
                boolean indexed = this.metadata.isColumnIndexed(i);
                if (indexed) {
                    this.createIndexFiles(name, this.metadata.getIndexValueBlockCapacity(i), plen, this.transientRowCount < 1L);
                }
                this.openColumnFiles(name, i, plen);
                long columnTop = TableUtils.readColumnTop(this.ff, this.path, name, plen, this.tempMem8b);
                this.columnTops.extendAndSet(i, columnTop);
                if (!indexed) continue;
                ColumnIndexer indexer = this.indexers.getQuick(i);
                assert (indexer != null);
                indexer.configureFollowerAndWriter(this.configuration, this.path, name, this.getPrimaryColumn(i), columnTop);
            }
            LOG.info().$("switched partition to '").$(this.path).$('\'').$();
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private ReadWriteMemory openTxnFile() {
        try {
            if (this.ff.exists(this.path.concat("_txn").$())) {
                ReadWriteMemory readWriteMemory = new ReadWriteMemory(this.ff, this.path, this.ff.getPageSize());
                return readWriteMemory;
            }
            throw CairoException.instance(this.ff.errno()).put("Cannot append. File does not exist: ").put(this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void performRecovery() {
        this.rollbackIndexes();
        this.rollbackSymbolTables();
        this.performRecovery = false;
    }

    private void populateDenseIndexerList() {
        this.denseIndexers.clear();
        int n = this.indexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.indexers.getQuick(i);
            if (indexer == null) continue;
            this.denseIndexers.add(indexer);
        }
        this.indexCount = this.denseIndexers.size();
    }

    private void purgeUnusedPartitions() {
        if (this.partitionBy != 3) {
            this.removePartitionDirsNewerThan(this.maxTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTodoTaskCode() {
        try {
            if (this.ff.exists(this.path.concat("_todo").$())) {
                long todoFd = this.ff.openRO(this.path);
                if (todoFd == -1L) {
                    throw CairoException.instance(Os.errno()).put("Cannot open *todo*: ").put(this.path);
                }
                long len = this.ff.read(todoFd, this.tempMem8b, 8L, 0L);
                this.ff.close(todoFd);
                if (len != 8L) {
                    LOG.info().$("Cannot read *todo* code. File seems to be truncated. Ignoring. [file=").$(this.path).$(']').$();
                    long l = -1L;
                    return l;
                }
                long l = Unsafe.getUnsafe().getLong(this.tempMem8b);
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void recoverFromMetaRenameFailure(CharSequence columnName) {
        this.openMetaFile();
    }

    private void recoverFromSwapRenameFailure(CharSequence columnName) {
        this.recoverFrommTodoWriteFailure(columnName);
        this.removeTodoFile();
    }

    private void recoverFromSymbolMapWriterFailure(CharSequence columnName) {
        this.removeSymbolMapFilesQuiet(columnName);
        this.removeMetaFile();
        this.recoverFromSwapRenameFailure(columnName);
    }

    private void recoverFrommTodoWriteFailure(CharSequence columnName) {
        this.restoreMetaFrom("_meta.prev", this.metaPrevIndex);
        this.openMetaFile();
    }

    private void recoverOpenColumnFailure(CharSequence columnName) {
        this.removeMetaFile();
        this.removeLastColumn();
        this.recoverFromSwapRenameFailure(columnName);
    }

    private void releaseLock(boolean distressed) {
        if (this.lockFd != -1L) {
            this.ff.close(this.lockFd);
            if (distressed) {
                return;
            }
            try {
                TableUtils.lockName(this.path);
                TableWriter.removeOrException(this.ff, this.path);
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
        }
    }

    private void removeColumn(int columnIndex) {
        Misc.free(this.getPrimaryColumn(columnIndex));
        Misc.free(this.getSecondaryColumn(columnIndex));
        this.columns.remove(TableWriter.getSecondaryColumnIndex(columnIndex));
        this.columns.remove(TableWriter.getPrimaryColumnIndex(columnIndex));
        this.columnTops.removeIndex(columnIndex);
        this.nullers.remove(columnIndex);
        if (columnIndex < this.indexers.size()) {
            Misc.free(this.indexers.getQuick(columnIndex));
            this.indexers.remove(columnIndex);
            this.populateDenseIndexerList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColumnFiles(CharSequence columnName, int columnType, RemoveFileLambda removeLambda) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && IGNORED_FILES.excludes(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    removeLambda.remove(this.ff, TableUtils.dFile(this.path, columnName));
                    removeLambda.remove(this.ff, TableUtils.iFile(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, TableUtils.topFile(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName));
                    removeLambda.remove(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName));
                }
            });
            if (columnType == 11) {
                removeLambda.remove(this.ff, SymbolMapWriter.offsetFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, SymbolMapWriter.charFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), columnName));
                removeLambda.remove(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), columnName));
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeColumnFromMeta(int index) {
        try {
            int metaSwapIndex = TableUtils.openMetaSwapFile(this.ff, this.ddlMem, this.path, this.rootLen, this.fileOperationRetryCount);
            int timestampIndex = this.metaMem.getInt(8L);
            this.ddlMem.putInt(this.columnCount - 1);
            this.ddlMem.putInt(this.partitionBy);
            if (timestampIndex == index) {
                this.ddlMem.putInt(-1);
            } else if (index < timestampIndex) {
                this.ddlMem.putInt(timestampIndex - 1);
            } else {
                this.ddlMem.putInt(timestampIndex);
            }
            this.ddlMem.putInt(416);
            this.ddlMem.jumpTo(128L);
            for (int i = 0; i < this.columnCount; ++i) {
                if (i == index) continue;
                this.writeColumnEntry(i);
            }
            long nameOffset = TableUtils.getColumnNameOffset(this.columnCount);
            for (int i = 0; i < this.columnCount; ++i) {
                CharSequence columnName = this.metaMem.getStr(nameOffset);
                if (i != index) {
                    this.ddlMem.putStr(columnName);
                }
                nameOffset += (long)VirtualMemory.getStorageLength(columnName);
            }
            int n = metaSwapIndex;
            return n;
        }
        finally {
            this.ddlMem.close();
        }
    }

    private void removeIndexFiles(CharSequence columnName) {
        try {
            this.ff.iterateDir(this.path.$(), (file, type) -> {
                this.nativeLPSZ.of(file);
                if (type == 4 && IGNORED_FILES.excludes(this.nativeLPSZ)) {
                    this.path.trimTo(this.rootLen);
                    this.path.concat(this.nativeLPSZ);
                    int plen = this.path.length();
                    TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName));
                    TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName));
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeLastColumn() {
        this.removeColumn(this.columnCount - 1);
        --this.columnCount;
    }

    private void removeMetaFile() {
        try {
            this.path.concat("_meta").$();
            if (this.ff.exists(this.path) && !this.ff.remove(this.path)) {
                throw CairoException.instance(this.ff.errno()).put("Recovery failed. Cannot remove: ").put(this.path);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories() {
        try {
            this.ff.iterateDir(this.path.$(), this.removePartitionDirectories);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removePartitionDirectories0(long name, int type) {
        this.path.trimTo(this.rootLen);
        this.path.concat(name).$();
        this.nativeLPSZ.of(name);
        if (IGNORED_FILES.excludes(this.nativeLPSZ) && type == 4 && !this.ff.rmdir(this.path)) {
            LOG.info().$("could not remove [path=").$(this.path).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    private void removePartitionDirsNewerThan(long timestamp) {
        if (timestamp > Long.MIN_VALUE) {
            LOG.info().$("purging [newerThen=").$ts(timestamp).$(", path=").$(this.path.$()).$(']').$();
        } else {
            LOG.info().$("cleaning [path=").$(this.path.$()).$(']').$();
        }
        try {
            this.ff.iterateDir(this.path.$(), (pName, type) -> {
                this.path.trimTo(this.rootLen);
                this.path.concat(pName).$();
                this.nativeLPSZ.of(pName);
                if (IGNORED_FILES.excludes(this.nativeLPSZ) && type == 4) {
                    try {
                        long dirTimestamp = this.partitionDirFmt.parse(this.nativeLPSZ, TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale());
                        if (dirTimestamp <= timestamp) {
                            return;
                        }
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                    if (this.ff.rmdir(this.path)) {
                        LOG.info().$("removing partition dir: ").$(this.path).$();
                    } else {
                        LOG.error().$("cannot remove: ").$(this.path).$(" [errno=").$(this.ff.errno()).$(']').$();
                    }
                }
            });
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeSymbolMapFilesQuiet(CharSequence name) {
        try {
            TableWriter.removeFileAndOrLog(this.ff, SymbolMapWriter.offsetFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, SymbolMapWriter.charFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.keyFileName(this.path.trimTo(this.rootLen), name));
            TableWriter.removeFileAndOrLog(this.ff, BitmapIndexUtils.valueFileName(this.path.trimTo(this.rootLen), name));
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private void removeSymbolMapWriter(int index) {
        SymbolMapWriter writer = this.symbolMapWriters.getQuick(index);
        this.symbolMapWriters.remove(index);
        if (writer != null) {
            this.denseSymbolMapWriters.remove(writer);
            Misc.free(writer);
        }
    }

    private void removeTodoFile() {
        try {
            if (!this.ff.remove(this.path.concat("_todo").$())) {
                throw CairoException.instance(Os.errno()).put("Recovery operation completed successfully but I cannot remove todo file: ").put(this.path).put(". Please remove manually before opening table again,");
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    private int rename(int retries) {
        try {
            int index = 0;
            this.other.concat("_meta.prev").$();
            this.path.concat("_meta").$();
            int l = this.other.length();
            do {
                if (index > 0) {
                    this.other.trimTo(l);
                    this.other.put('.').put(index);
                    this.other.$();
                }
                if (this.ff.exists(this.other) && !this.ff.remove(this.other)) {
                    LOG.info().$("cannot remove target of rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                if (!this.ff.rename(this.path, this.other)) {
                    LOG.info().$("cannot rename '").$(this.path).$("' to '").$(this.other).$(" [errno=").$(this.ff.errno()).$(']').$();
                    ++index;
                    continue;
                }
                int n = index;
                return n;
            } while (index < retries);
            throw CairoException.instance(0).put("Cannot rename ").put(this.path).put(". Max number of attempts reached [").put(index).put("]. Last target was: ").put(this.other);
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void renameMetaToMetaPrev(CharSequence columnName) {
        try {
            this.metaPrevIndex = this.rename(this.fileOperationRetryCount);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void renameSwapMetaToMeta(CharSequence columnName) {
        try {
            this.restoreMetaFrom("_meta.swp", this.metaSwapIndex);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_SWAP_RENAME_FAILURE, columnName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long repairDataGaps(long timestamp) {
        if (this.maxTimestamp != Long.MIN_VALUE && this.partitionBy != 3) {
            long actualSize = 0L;
            long lastTimestamp = -1L;
            long transientRowCount = this.transientRowCount;
            long maxTimestamp = this.maxTimestamp;
            try {
                long tsLimit = this.timestampFloorMethod.floor(this.maxTimestamp);
                long ts = this.minTimestamp;
                while (ts < tsLimit) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(ts, false);
                    int p = this.path.length();
                    if (this.ff.exists(this.path.concat("_archive").$())) {
                        actualSize += TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem8b, 0L);
                        lastTimestamp = ts;
                    } else if (this.removedPartitions.excludes(ts)) {
                        LOG.info().$("missing partition [name=").$(this.path.trimTo(p).$()).$(']').$();
                    }
                    ts = this.timestampAddMethod.calculate(ts, 1);
                }
                if (lastTimestamp > -1L) {
                    this.path.trimTo(this.rootLen);
                    this.setStateForTimestamp(tsLimit, false);
                    if (!this.ff.exists(this.path.$())) {
                        LOG.error().$("last partition does not exist [name=").$(this.path).$(']').$();
                        this.path.trimTo(this.rootLen);
                        this.setStateForTimestamp(lastTimestamp, false);
                        int p = this.path.length();
                        transientRowCount = TableUtils.readLongAtOffset(this.ff, this.path.concat("_archive").$(), this.tempMem8b, 0L);
                        TableUtils.dFile(this.path.trimTo(p), this.metadata.getColumnName(this.metadata.getTimestampIndex()));
                        maxTimestamp = TableUtils.readLongAtOffset(this.ff, this.path, this.tempMem8b, (transientRowCount - 1L) * 8L);
                        actualSize -= transientRowCount;
                        LOG.info().$("updated active partition [name=").$(this.path.trimTo(p).$()).$(", maxTimestamp=").$ts(maxTimestamp).$(", transientRowCount=").$(transientRowCount).$(", fixedRowCount=").$(this.fixedRowCount).$(']').$();
                    }
                }
            }
            finally {
                this.path.trimTo(this.rootLen);
            }
            long expectedSize = this.txMem.getLong(16L);
            if (expectedSize != actualSize || maxTimestamp != this.maxTimestamp) {
                LOG.info().$("actual table size has been adjusted [name=`").utf8(this.name).$('`').$(", expectedFixedSize=").$(expectedSize).$(", actualFixedSize=").$(actualSize).$(']').$();
                long txn = this.txMem.getLong(0L) + 1L;
                this.txMem.putLong(0L, txn);
                Unsafe.getUnsafe().storeFence();
                this.txMem.putLong(16L, actualSize);
                if (this.maxTimestamp != maxTimestamp) {
                    this.txMem.putLong(32L, maxTimestamp);
                    this.txMem.putLong(8L, transientRowCount);
                }
                Unsafe.getUnsafe().storeFence();
                this.txMem.putLong(64L, txn);
                this.fixedRowCount = actualSize;
                this.maxTimestamp = maxTimestamp;
                this.transientRowCount = transientRowCount;
                this.txn = txn;
                return this.maxTimestamp;
            }
        }
        return timestamp;
    }

    private void repairMetaRename(int index) {
        try {
            this.path.concat("_meta.prev");
            if (index > 0) {
                this.path.put('.').put(index);
            }
            this.path.$();
            if (this.ff.exists(this.path)) {
                LOG.info().$("Repairing metadata from: ").$(this.path).$();
                if (this.ff.exists(this.other.concat("_meta").$()) && !this.ff.remove(this.other)) {
                    throw CairoException.instance(Os.errno()).put("Repair failed. Cannot replace ").put(this.other);
                }
                if (!this.ff.rename(this.path, this.other)) {
                    throw CairoException.instance(Os.errno()).put("Repair failed. Cannot rename ").put(this.path).put(" -> ").put(this.other);
                }
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
        this.removeTodoFile();
    }

    private void repairTruncate() {
        LOG.info().$("repairing abnormally terminated truncate on ").$(this.path).$();
        if (this.partitionBy != 3) {
            this.removePartitionDirectories();
        }
        TableUtils.resetTxn(this.txMem, this.metadata.getSymbolMapCount(), this.txMem.getLong(0L) + 1L, this.txMem.getLong(48L) + 1L);
        this.removeTodoFile();
    }

    private void restoreMetaFrom(CharSequence fromBase, int fromIndex) {
        try {
            this.path.concat(fromBase);
            if (fromIndex > 0) {
                this.path.put('.').put(fromIndex);
            }
            this.path.$();
            if (!this.ff.rename(this.path, this.other.concat("_meta").$())) {
                throw CairoException.instance(this.ff.errno()).put("Cannot rename ").put(this.path).put(" -> ").put(this.other);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private void rollbackIndexes() {
        long maxRow = this.transientRowCount - 1L;
        int n = this.denseIndexers.size();
        for (int i = 0; i < n; ++i) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            LOG.info().$("recovering index [fd=").$(indexer.getFd()).$(']').$();
            indexer.rollback(maxRow);
        }
    }

    private void rollbackSymbolTables() {
        int expectedMapWriters = this.txMem.getInt(72L);
        for (int i = 0; i < expectedMapWriters; ++i) {
            this.denseSymbolMapWriters.getQuick(i).rollback(this.txMem.getInt(TableUtils.getSymbolWriterIndexOffset(i)));
        }
    }

    private void runFragile(FragileCode fragile, CharSequence columnName, CairoException e) {
        try {
            fragile.run(columnName);
        }
        catch (CairoException err) {
            LOG.error().$("DOUBLE ERROR: 1st: '").$(e).$('\'').$();
            this.throwDistressException(err);
        }
        throw e;
    }

    private void setAppendPosition(long position) {
        for (int i = 0; i < this.columnCount; ++i) {
            TableWriter.setColumnSize(this.ff, this.getPrimaryColumn(i), this.getSecondaryColumn(i), TableUtils.getColumnType(this.metaMem, i), position - this.columnTops.getQuick(i), this.tempMem8b);
        }
    }

    private void setStateForTimestamp(long timestamp, boolean updatePartitionInterval) {
        this.path.put(Files.SEPARATOR);
        switch (this.partitionBy) {
            case 0: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                int d = Timestamps.getDayOfMonth(timestamp, y, m, leap);
                DateFormatUtils.append000(this.path, y);
                this.path.put('-');
                DateFormatUtils.append0(this.path, m);
                this.path.put('-');
                DateFormatUtils.append0(this.path, d);
                if (!updatePartitionInterval) break;
                this.partitionHi = Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)(d - 1) * 86400000000L + 86400000000L - 1L;
                break;
            }
            case 1: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                int m = Timestamps.getMonthOfYear(timestamp, y, leap);
                DateFormatUtils.append000(this.path, y);
                this.path.put('-');
                DateFormatUtils.append0(this.path, m);
                if (!updatePartitionInterval) break;
                this.partitionHi = Timestamps.yearMicros(y, leap) + Timestamps.monthOfYearMicros(m, leap) + (long)Timestamps.getDaysPerMonth(m, leap) * 24L * 3600000000L - 1L;
                break;
            }
            case 2: {
                int y = Timestamps.getYear(timestamp);
                boolean leap = Timestamps.isLeapYear(y);
                DateFormatUtils.append000(this.path, y);
                if (!updatePartitionInterval) break;
                this.partitionHi = Timestamps.addYear(Timestamps.yearMicros(y, leap), 1) - 1L;
                break;
            }
            default: {
                this.path.put("default");
                this.partitionHi = Long.MAX_VALUE;
            }
        }
    }

    private void switchPartition(long timestamp) {
        this.updateIndexes();
        if (this.txPartitionCount++ > 0) {
            this.txPendingPartitionSizes.putLong128(this.transientRowCount, this.maxTimestamp);
        }
        this.fixedRowCount += this.transientRowCount;
        this.txPrevTransientRowCount = this.transientRowCount;
        this.transientRowCount = 0L;
        this.openPartition(timestamp);
        this.setAppendPosition(0L);
    }

    private void syncColumns(int commitMode) {
        boolean async = commitMode == 0;
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns.getQuick(i * 2).sync(async);
            AppendMemory m2 = this.columns.getQuick(i * 2 + 1);
            if (m2 == null) continue;
            m2.sync(false);
        }
    }

    private void throwDistressException(Throwable cause) {
        this.distressed = true;
        throw new CairoError(cause);
    }

    private void updateIndexes() {
        if (this.indexCount > 0) {
            long lo = this.txPartitionCount == 1 ? this.txPrevTransientRowCount : 0L;
            long hi = this.transientRowCount;
            if (this.indexCount > 1 && this.parallelIndexerEnabled && hi - lo > (long)this.configuration.getParallelIndexThreshold()) {
                this.updateIndexesParallel(lo, hi);
            } else {
                this.updateIndexesSerially(lo, hi);
            }
        }
    }

    private void updateIndexesParallel(long lo, long hi) {
        int i;
        this.indexSequences.clear();
        this.indexLatch.setCount(this.indexCount);
        int nParallelIndexes = this.indexCount - 1;
        Sequence indexPubSequence = this.messageBus.getIndexerPubSequence();
        RingQueue<ColumnIndexerTask> indexerQueue = this.messageBus.getIndexerQueue();
        LOG.info().$("parallel indexing [indexCount=").$(this.indexCount).$(']').$();
        int serialIndexCount = 0;
        block0: for (i = 0; i < nParallelIndexes; ++i) {
            long cursor = indexPubSequence.next();
            if (cursor == -1L) {
                TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                ++serialIndexCount;
                continue;
            }
            if (cursor == -2L) {
                do {
                    if ((cursor = indexPubSequence.next()) != -1L) continue;
                    TableWriter.indexAndCountDown(this.denseIndexers.getQuick(i), lo, hi, this.indexLatch);
                    ++serialIndexCount;
                    continue block0;
                } while (cursor < 0L);
            }
            ColumnIndexerTask queueItem = indexerQueue.get(cursor);
            ColumnIndexer indexer = this.denseIndexers.getQuick(i);
            long sequence = indexer.getSequence();
            queueItem.indexer = indexer;
            queueItem.lo = lo;
            queueItem.hi = hi;
            queueItem.countDownLatch = this.indexLatch;
            queueItem.sequence = sequence;
            this.indexSequences.add(sequence);
            indexPubSequence.done(cursor);
        }
        TableWriter.indexAndCountDown(this.denseIndexers.getQuick(this.indexCount - 1), lo, hi, this.indexLatch);
        ++serialIndexCount;
        if (!this.indexLatch.await(this.configuration.getWorkStealTimeoutNanos())) {
            for (i = 0; i < nParallelIndexes; ++i) {
                ColumnIndexer indexer = this.denseIndexers.getQuick(i);
                if (!indexer.tryLock(this.indexSequences.getQuick(i))) continue;
                TableWriter.indexAndCountDown(indexer, lo, hi, this.indexLatch);
                ++serialIndexCount;
            }
            this.indexLatch.await();
        }
        boolean distressed = false;
        for (int i2 = 0; i2 < this.indexCount; ++i2) {
            ColumnIndexer indexer = this.denseIndexers.getQuick(i2);
            distressed |= indexer.isDistressed();
        }
        if (distressed) {
            this.throwDistressException(null);
        }
        LOG.info().$("parallel indexing done [serialCount=").$(serialIndexCount).$(']').$();
    }

    private void updateIndexesSerially(long lo, long hi) {
        LOG.info().$("serial indexing [indexCount=").$(this.indexCount).$(']').$();
        int n = this.indexCount;
        for (int i = 0; i < n; ++i) {
            try {
                this.denseIndexers.getQuick(i).refreshSourceAndIndex(lo, hi);
                continue;
            }
            catch (CairoException e) {
                LOG.error().$("index error {").$(e).$('}').$();
                this.throwDistressException(e);
            }
        }
        LOG.info().$("serial indexing done [indexCount=").$(this.indexCount).$(']').$();
    }

    private void updateMaxTimestamp(long timestamp) {
        this.prevMaxTimestamp = this.maxTimestamp;
        this.maxTimestamp = timestamp;
        this.timestampSetter.accept(timestamp);
    }

    private void validateSwapMeta(CharSequence columnName) {
        try {
            try {
                this.path.concat("_meta.swp");
                if (this.metaSwapIndex > 0) {
                    this.path.put('.').put(this.metaSwapIndex);
                }
                this.metaMem.of(this.ff, this.path.$(), this.ff.getPageSize(), this.ff.length(this.path));
                this.validationMap.clear();
                TableUtils.validate(this.ff, this.metaMem, this.validationMap);
            }
            finally {
                this.metaMem.close();
                this.path.trimTo(this.rootLen);
            }
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_META_RENAME_FAILURE, columnName, e);
        }
    }

    private void writeColumnEntry(int i) {
        this.ddlMem.putByte((byte)TableUtils.getColumnType(this.metaMem, i));
        long flags = 0L;
        if (TableUtils.isColumnIndexed(this.metaMem, i)) {
            flags |= 1L;
        }
        if (TableUtils.isSequential(this.metaMem, i)) {
            flags |= 2L;
        }
        this.ddlMem.putLong(flags);
        this.ddlMem.putInt(TableUtils.getIndexBlockCapacity(this.metaMem, i));
        this.ddlMem.skip(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeColumnTop(CharSequence name) {
        long fd = this.openAppend(this.path.concat(name).put(".top").$());
        try {
            Unsafe.getUnsafe().putLong(this.tempMem8b, this.transientRowCount);
            if (this.ff.append(fd, this.tempMem8b, 8) != 8L) {
                throw CairoException.instance(Os.errno()).put("Cannot append ").put(this.path);
            }
        }
        finally {
            this.ff.close(fd);
        }
    }

    private void writeRestoreMetaTodo(CharSequence columnName) {
        try {
            this.writeTodo((long)this.metaPrevIndex << 8 | 2L);
        }
        catch (CairoException e) {
            this.runFragile(this.RECOVER_FROM_TODO_WRITE_FAILURE, columnName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTodo(long code) {
        try {
            long fd = this.openAppend(this.path.concat("_todo").$());
            try {
                Unsafe.getUnsafe().putLong(this.tempMem8b, code);
                if (this.ff.append(fd, this.tempMem8b, 8) != 8L) {
                    throw CairoException.instance(Os.errno()).put("Cannot write ").put(TableUtils.getTodoText(code)).put(" *todo*: ").put(this.path);
                }
            }
            finally {
                this.ff.close(fd);
            }
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    static {
        IGNORED_FILES.add("..");
        IGNORED_FILES.add(".");
        IGNORED_FILES.add("_meta");
        IGNORED_FILES.add("_txn");
        IGNORED_FILES.add("_todo");
    }

    public class Row {
        public void append() {
            if ((TableWriter.this.masterRef & 1L) == 0L) {
                return;
            }
            for (int i = 0; i < TableWriter.this.columnCount; ++i) {
                if (TableWriter.this.refs.getQuick(i) >= TableWriter.this.masterRef) continue;
                ((Runnable)TableWriter.this.nullers.getQuick(i)).run();
            }
            TableWriter.this.transientRowCount++;
            TableWriter.this.masterRef++;
            if (TableWriter.this.prevMinTimestamp == Long.MAX_VALUE) {
                TableWriter.this.prevMinTimestamp = TableWriter.this.minTimestamp;
            }
        }

        public void cancel() {
            TableWriter.this.cancelRow();
        }

        public void putBin(int index, long address, long len) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putBin(address, len));
            this.notNull(index);
        }

        public void putBin(int index, BinarySequence sequence) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putBin(sequence));
            this.notNull(index);
        }

        public void putBool(int index, boolean value) {
            TableWriter.this.getPrimaryColumn(index).putBool(value);
            this.notNull(index);
        }

        public void putByte(int index, byte value) {
            TableWriter.this.getPrimaryColumn(index).putByte(value);
            this.notNull(index);
        }

        public void putChar(int index, char value) {
            TableWriter.this.getPrimaryColumn(index).putChar(value);
            this.notNull(index);
        }

        public void putDate(int index, long value) {
            this.putLong(index, value);
        }

        public void putDouble(int index, double value) {
            TableWriter.this.getPrimaryColumn(index).putDouble(value);
            this.notNull(index);
        }

        public void putFloat(int index, float value) {
            TableWriter.this.getPrimaryColumn(index).putFloat(value);
            this.notNull(index);
        }

        public void putInt(int index, int value) {
            TableWriter.this.getPrimaryColumn(index).putInt(value);
            this.notNull(index);
        }

        public void putLong(int index, long value) {
            TableWriter.this.getPrimaryColumn(index).putLong(value);
            this.notNull(index);
        }

        public void putLong256(int index, long l0, long l1, long l2, long l3) {
            TableWriter.this.getPrimaryColumn(index).putLong256(l0, l1, l2, l3);
            this.notNull(index);
        }

        public void putLong256(int index, Long256 value) {
            TableWriter.this.getPrimaryColumn(index).putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
            this.notNull(index);
        }

        public void putLong256(int index, CharSequence hexString) {
            TableWriter.this.getPrimaryColumn(index).putLong256(hexString);
            this.notNull(index);
        }

        public void putShort(int index, short value) {
            TableWriter.this.getPrimaryColumn(index).putShort(value);
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putStr(value));
            this.notNull(index);
        }

        public void putStr(int index, char value) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putStr(value));
            this.notNull(index);
        }

        public void putStr(int index, CharSequence value, int pos, int len) {
            TableWriter.this.getSecondaryColumn(index).putLong(TableWriter.this.getPrimaryColumn(index).putStr(value, pos, len));
            this.notNull(index);
        }

        public void putSym(int index, CharSequence value) {
            TableWriter.this.getPrimaryColumn(index).putInt(((SymbolMapWriter)TableWriter.this.symbolMapWriters.getQuick(index)).put(value));
            this.notNull(index);
        }

        public void putTimestamp(int index, long value) {
            this.putLong(index, value);
        }

        private void notNull(int index) {
            TableWriter.this.refs.setQuick(index, TableWriter.this.masterRef);
        }
    }

    private class SwitchPartitionRowFunction
    implements RowFunction {
        private SwitchPartitionRowFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            if (timestamp > TableWriter.this.partitionHi || timestamp < TableWriter.this.maxTimestamp) {
                return this.newRow0(timestamp);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            return TableWriter.this.row;
        }

        @NotNull
        private Row newRow0(long timestamp) {
            if (timestamp < TableWriter.this.maxTimestamp) {
                throw CairoException.instance(TableWriter.this.ff.errno()).put("Cannot insert rows out of order. Table=").put(TableWriter.this.path);
            }
            if (timestamp > TableWriter.this.partitionHi && TableWriter.this.partitionBy != 3) {
                TableWriter.this.switchPartition(timestamp);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            return TableWriter.this.row;
        }
    }

    private class NoPartitionFunction
    implements RowFunction {
        private NoPartitionFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            TableWriter.this.bumpMasterRef();
            if (timestamp < TableWriter.this.maxTimestamp) {
                throw CairoException.instance(TableWriter.this.ff.errno()).put("Cannot insert rows out of order. Table=").put(TableWriter.this.path);
            }
            TableWriter.this.updateMaxTimestamp(timestamp);
            return TableWriter.this.row;
        }
    }

    private class OpenPartitionRowFunction
    implements RowFunction {
        private OpenPartitionRowFunction() {
        }

        @Override
        public Row newRow(long timestamp) {
            if (TableWriter.this.maxTimestamp == Long.MIN_VALUE) {
                TableWriter.this.minTimestamp = timestamp;
                TableWriter.this.openFirstPartition(timestamp);
            }
            return (TableWriter.this.rowFunction = TableWriter.this.switchPartitionFunction).newRow(timestamp);
        }
    }

    @FunctionalInterface
    private static interface FragileCode {
        public void run(CharSequence var1);
    }

    @FunctionalInterface
    private static interface RemoveFileLambda {
        public void remove(FilesFacade var1, LPSZ var2);
    }
}

