/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.ReadOnlyMemory;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjList;

public class TableWriterMetadata
extends BaseRecordMetadata {
    private int symbolMapCount;
    private int version;

    public TableWriterMetadata(FilesFacade ff, ReadOnlyMemory metaMem) {
        this.columnCount = metaMem.getInt(0L);
        this.columnNameIndexMap = new CharSequenceIntHashMap(this.columnCount);
        this.version = metaMem.getInt(12L);
        TableUtils.validate(ff, metaMem, this.columnNameIndexMap);
        this.timestampIndex = metaMem.getInt(8L);
        this.columnMetadata = new ObjList(this.columnCount);
        long offset = TableUtils.getColumnNameOffset(this.columnCount);
        this.symbolMapCount = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            CharSequence name = metaMem.getStr(offset);
            assert (name != null);
            int type = TableUtils.getColumnType(metaMem, i);
            this.columnMetadata.add(new TableColumnMetadata(Chars.toString(name), type, TableUtils.isColumnIndexed(metaMem, i), TableUtils.getIndexBlockCapacity(metaMem, i), true));
            if (type == 11) {
                ++this.symbolMapCount;
            }
            offset += (long)ReadOnlyMemory.getStorageLength(name);
        }
    }

    public int getSymbolMapCount() {
        return this.symbolMapCount;
    }

    void addColumn(CharSequence name, int type, boolean indexFlag, int indexValueBlockCapacity) {
        String str = name.toString();
        this.columnNameIndexMap.put(str, this.columnMetadata.size());
        this.columnMetadata.add(new TableColumnMetadata(str, type, indexFlag, indexValueBlockCapacity, true));
        ++this.columnCount;
        if (type == 11) {
            ++this.symbolMapCount;
        }
    }

    void removeColumn(CharSequence name) {
        int index = this.columnNameIndexMap.keyIndex(name);
        int columnIndex = this.columnNameIndexMap.valueAt(index);
        if (((TableColumnMetadata)this.columnMetadata.getQuick(columnIndex)).getType() == 11) {
            --this.symbolMapCount;
        }
        this.columnMetadata.remove(columnIndex);
        this.columnNameIndexMap.removeAt(index);
        --this.columnCount;
        for (int i = columnIndex; i < this.columnCount; ++i) {
            this.columnNameIndexMap.put(((TableColumnMetadata)this.columnMetadata.getQuick(i)).getName(), i);
        }
    }

    public int getTableVersion() {
        return this.version;
    }

    public void setTableVersion() {
        this.version = 416;
    }
}

