/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Sink;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSequence;
import io.questdb.std.str.CharSink;
import java.io.Closeable;

public class VirtualMemory
implements Closeable {
    static final int STRING_LENGTH_BYTES = 4;
    private static final Log LOG = LogFactory.getLog(VirtualMemory.class);
    protected final LongList pages = new LongList(4, 0L);
    private final ByteSequenceView bsview = new ByteSequenceView();
    private final CharSequenceView csview = new CharSequenceView();
    private final CharSequenceView csview2 = new CharSequenceView();
    private final Long256Impl long256 = new Long256Impl();
    private final Long256Impl long256B = new Long256Impl();
    private long pageSize;
    private int bits;
    private long mod;
    private long appendPointer = -1L;
    private long pageHi = -1L;
    private long pageLo = -1L;
    private long baseOffset = 1L;
    private long roOffsetLo = 0L;
    private long roOffsetHi = 0L;
    private long absolutePointer;

    public VirtualMemory(long pageSize) {
        this();
        this.setPageSize(pageSize);
    }

    protected VirtualMemory() {
    }

    public static int getStorageLength(CharSequence s) {
        if (s == null) {
            return 4;
        }
        return 4 + s.length() * 2;
    }

    private static void copyStrChars(CharSequence value, int pos, int len, long address) {
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i + pos);
            Unsafe.getUnsafe().putChar(address + (long)(2 * i), c);
        }
    }

    public long addressOf(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi) {
            return this.absolutePointer + offset;
        }
        return this.addressOf0(offset);
    }

    public void clearHotPage() {
        this.roOffsetHi = 0L;
        this.roOffsetLo = 0L;
    }

    @Override
    public void close() {
        this.clearPages();
        this.appendPointer = -1L;
        this.pageHi = -1L;
        this.pageLo = -1L;
        this.baseOffset = 1L;
        this.clearHotPage();
    }

    public final long getAppendOffset() {
        return this.baseOffset + this.appendPointer;
    }

    public final BinarySequence getBin(long offset) {
        long len = this.getLong(offset);
        if (len == -1L) {
            return null;
        }
        return this.bsview.of(offset + 8L, len);
    }

    public final long getBinLen(long offset) {
        return this.getLong(offset);
    }

    public boolean getBool(long offset) {
        return this.getByte(offset) == 1;
    }

    public final byte getByte(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 1L) {
            return Unsafe.getUnsafe().getByte(this.absolutePointer + offset);
        }
        return this.getByte0(offset);
    }

    public final char getChar(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            return Unsafe.getUnsafe().getChar(this.absolutePointer + offset);
        }
        return this.getChar0(offset);
    }

    public final double getDouble(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getDouble(this.absolutePointer + offset);
        }
        return this.getDouble0(offset);
    }

    public final float getFloat(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getFloat(this.absolutePointer + offset);
        }
        return this.getFloat0(offset);
    }

    public final int getInt(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            return Unsafe.getUnsafe().getInt(this.absolutePointer + offset);
        }
        return this.getInt0(offset);
    }

    public long getLong(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            return Unsafe.getUnsafe().getLong(this.absolutePointer + offset);
        }
        return this.getLong0(offset);
    }

    public void getLong256(long offset, CharSink sink) {
        long d;
        long c;
        long b;
        long a;
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            a = Unsafe.getUnsafe().getLong(this.absolutePointer + offset);
            b = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 8L);
            c = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 16L);
            d = Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 24L);
        } else {
            a = this.getLong(offset);
            b = this.getLong(offset + 8L);
            c = this.getLong(offset + 16L);
            d = this.getLong(offset + 24L);
        }
        Numbers.appendLong256(a, b, c, d, sink);
    }

    public void getLong256(long offset, Long256Sink sink) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            sink.setLong0(Unsafe.getUnsafe().getLong(this.absolutePointer + offset));
            sink.setLong1(Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 8L));
            sink.setLong2(Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 16L));
            sink.setLong3(Unsafe.getUnsafe().getLong(this.absolutePointer + offset + 24L));
        } else {
            sink.setLong0(this.getLong(offset));
            sink.setLong1(this.getLong(offset + 8L));
            sink.setLong2(this.getLong(offset + 16L));
            sink.setLong3(this.getLong(offset + 24L));
        }
    }

    public Long256 getLong256A(long offset) {
        this.getLong256(offset, this.long256);
        return this.long256;
    }

    public Long256 getLong256B(long offset) {
        this.getLong256(offset, this.long256B);
        return this.long256B;
    }

    public final short getShort(long offset) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            return Unsafe.getUnsafe().getShort(this.absolutePointer + offset);
        }
        return this.getShort0(offset);
    }

    public final CharSequence getStr(long offset) {
        return this.getStr0(offset, this.csview);
    }

    public final CharSequence getStr0(long offset, CharSequenceView view) {
        int len = this.getInt(offset);
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return view.of(offset + 4L, len);
    }

    public final CharSequence getStr2(long offset) {
        return this.getStr0(offset, this.csview2);
    }

    public final int getStrLen(long offset) {
        return this.getInt(offset);
    }

    public long hash(long offset, long size) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - size) {
            long n = size - size % 8L;
            long address = this.absolutePointer + offset;
            long h = 179426491L;
            for (long i = 0L; i < n; i += 8L) {
                h = (h << 5) - h + Unsafe.getUnsafe().getLong(address + i);
            }
            while (n < size) {
                h = (h << 5) - h + (long)Unsafe.getUnsafe().getByte(address + n);
                ++n;
            }
            return h;
        }
        return this.hashSlow(offset, size);
    }

    public void jumpTo(long offset) {
        assert (offset > -1L);
        long p = offset - this.baseOffset;
        if (p > this.pageLo && p < this.pageHi) {
            this.appendPointer = p;
        } else {
            this.jumpTo0(offset);
        }
    }

    public long pageRemaining(long offset) {
        return this.getPageSize(this.pageIndex(offset)) - this.offsetInPage(offset);
    }

    public final long putBin(BinarySequence value) {
        long offset = this.getAppendOffset();
        if (value == null) {
            this.putLong(-1L);
        } else {
            long len = value.length();
            this.putLong(len);
            long remaining = this.pageHi - this.appendPointer;
            if (len < remaining) {
                this.putBinSequence(value, 0L, len);
                this.appendPointer += len;
            } else {
                this.putBin0(value, len, remaining);
            }
        }
        return offset;
    }

    public final long putBin(long from, long len) {
        long offset = this.getAppendOffset();
        this.putLong(len > 0L ? len : -1L);
        if (len < 1L) {
            return offset;
        }
        if (len < this.pageHi - this.appendPointer) {
            Unsafe.getUnsafe().copyMemory(from, this.appendPointer, len);
            this.appendPointer += len;
        } else {
            this.putBinSlit(from, len);
        }
        return offset;
    }

    public void putBool(boolean value) {
        this.putByte((byte)(value ? 1 : 0));
    }

    public void putBool(long offset, boolean value) {
        this.putByte(offset, (byte)(value ? 1 : 0));
    }

    public final void putByte(long offset, byte value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 1L) {
            Unsafe.getUnsafe().putByte(this.absolutePointer + offset, value);
        } else {
            this.putByteRnd(offset, value);
        }
    }

    public void putByte(byte b) {
        if (this.pageHi == this.appendPointer) {
            this.pageAt(this.getAppendOffset() + 1L);
        }
        Unsafe.getUnsafe().putByte(this.appendPointer++, b);
    }

    public void putChar(long offset, char value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            Unsafe.getUnsafe().putChar(this.absolutePointer + offset, value);
        } else {
            this.putCharBytes(offset, value);
        }
    }

    public final void putChar(char value) {
        if (this.pageHi - this.appendPointer > 1L) {
            Unsafe.getUnsafe().putChar(this.appendPointer, value);
            this.appendPointer += 2L;
        } else {
            this.putCharBytes(value);
        }
    }

    public void putDouble(long offset, double value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            Unsafe.getUnsafe().putDouble(this.absolutePointer + offset, value);
        } else {
            this.putDoubleBytes(offset, value);
        }
    }

    public final void putDouble(double value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putDouble(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putDoubleBytes(value);
        }
    }

    public void putFloat(long offset, float value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            Unsafe.getUnsafe().putFloat(this.absolutePointer + offset, value);
        } else {
            this.putFloatBytes(offset, value);
        }
    }

    public final void putFloat(float value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putFloat(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putFloatBytes(value);
        }
    }

    public void putInt(long offset, int value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 4L) {
            Unsafe.getUnsafe().putInt(this.absolutePointer + offset, value);
        } else {
            this.putIntBytes(offset, value);
        }
    }

    public final void putInt(int value) {
        if (this.pageHi - this.appendPointer > 3L) {
            Unsafe.getUnsafe().putInt(this.appendPointer, value);
            this.appendPointer += 4L;
        } else {
            this.putIntBytes(value);
        }
    }

    public void putLong(long offset, long value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 8L) {
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset, value);
        } else {
            this.putLongBytes(offset, value);
        }
    }

    public final void putLong(long value) {
        if (this.pageHi - this.appendPointer > 7L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, value);
            this.appendPointer += 8L;
        } else {
            this.putLongBytes(value);
        }
    }

    public final void putLong128(long l1, long l2) {
        if (this.pageHi - this.appendPointer > 15L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, l1);
            Unsafe.getUnsafe().putLong(this.appendPointer + 8L, l2);
            this.appendPointer += 16L;
        } else {
            this.putLong(l1);
            this.putLong(l2);
        }
    }

    public void putLong256(long offset, Long256 value) {
        this.putLong256(offset, value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    public void putLong256(long offset, long l0, long l1, long l2, long l3) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 32L) {
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset, l0);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 8L, l1);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 16L, l2);
            Unsafe.getUnsafe().putLong(this.absolutePointer + offset + 24L, l3);
        } else {
            this.putLong(offset, l0);
            this.putLong(offset + 8L, l1);
            this.putLong(offset + 16L, l2);
            this.putLong(offset + 24L, l3);
        }
    }

    public final void putLong256(long l0, long l1, long l2, long l3) {
        if (this.pageHi - this.appendPointer > 31L) {
            Unsafe.getUnsafe().putLong(this.appendPointer, l0);
            Unsafe.getUnsafe().putLong(this.appendPointer + 8L, l1);
            Unsafe.getUnsafe().putLong(this.appendPointer + 16L, l2);
            Unsafe.getUnsafe().putLong(this.appendPointer + 24L, l3);
            this.appendPointer += 32L;
        } else {
            this.putLong(l0);
            this.putLong(l1);
            this.putLong(l2);
            this.putLong(l3);
        }
    }

    public final void putLong256(Long256 value) {
        this.putLong256(value.getLong0(), value.getLong1(), value.getLong2(), value.getLong3());
    }

    public final void putLong256(CharSequence hexString) {
        if (this.pageHi - this.appendPointer < 32L) {
            this.putLong256Bytes(hexString);
        } else {
            int len;
            if (hexString == null || (len = hexString.length()) == 0) {
                this.putLong256Null();
            } else {
                Unsafe.getUnsafe().putLong(this.appendPointer, 0L);
                Unsafe.getUnsafe().putLong(this.appendPointer + 8L, 0L);
                Unsafe.getUnsafe().putLong(this.appendPointer + 16L, 0L);
                Unsafe.getUnsafe().putLong(this.appendPointer + 24L, 0L);
                long o = 0L;
                for (int i = len / 2 - 1; i > 0; --i) {
                    int d1 = Numbers.hexNumbers[hexString.charAt(i * 2)];
                    int d2 = Numbers.hexNumbers[hexString.charAt(i * 2 + 1)];
                    Unsafe.getUnsafe().putByte(this.appendPointer + o++, (byte)((d1 << 4) + d2));
                }
            }
            this.appendPointer += 32L;
        }
    }

    public final long putNullBin() {
        long offset = this.getAppendOffset();
        this.putLong(-1L);
        return offset;
    }

    public final long putNullStr() {
        long offset = this.getAppendOffset();
        this.putInt(-1);
        return offset;
    }

    public final void putNullStr(long offset) {
        this.putInt(offset, -1);
    }

    public void putShort(long offset, short value) {
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - 2L) {
            Unsafe.getUnsafe().putShort(this.absolutePointer + offset, value);
        } else {
            this.putShortBytes(offset, value);
        }
    }

    public final void putShort(short value) {
        if (this.pageHi - this.appendPointer > 1L) {
            Unsafe.getUnsafe().putShort(this.appendPointer, value);
            this.appendPointer += 2L;
        } else {
            this.putShortBytes(value);
        }
    }

    public final long putStr(CharSequence value) {
        return value == null ? this.putNullStr() : this.putStr0(value, 0, value.length());
    }

    public final long putStr(char value) {
        if (value == '\u0000') {
            return this.putNullStr();
        }
        long offset = this.getAppendOffset();
        this.putInt(1);
        if (this.pageHi - this.appendPointer < 2L) {
            this.putSplitChar(value);
        } else {
            Unsafe.getUnsafe().putChar(this.appendPointer, value);
            this.appendPointer += 2L;
        }
        return offset;
    }

    public final long putStr(CharSequence value, int pos, int len) {
        if (value == null) {
            return this.putNullStr();
        }
        return this.putStr0(value, pos, len);
    }

    public void putStr(long offset, CharSequence value) {
        if (value == null) {
            this.putNullStr(offset);
        } else {
            this.putStr(offset, value, 0, value.length());
        }
    }

    public void putStr(long offset, CharSequence value, int pos, int len) {
        this.putInt(offset, len);
        if (this.roOffsetLo < offset && offset < this.roOffsetHi - (long)len * 2L - 4L) {
            VirtualMemory.copyStrChars(value, pos, len, this.absolutePointer + offset + 4L);
        } else {
            this.putStrSplit(offset + 4L, value, pos, len);
        }
    }

    public void skip(long bytes) {
        assert (bytes >= 0L);
        if (this.pageHi - this.appendPointer > bytes) {
            this.appendPointer += bytes;
        } else {
            this.skip0(bytes);
        }
    }

    public void zero() {
        int n = this.pages.size();
        for (int i = 0; i < n; ++i) {
            long address = this.pages.getQuick(i);
            if (address == 0L) {
                address = this.allocateNextPage(i);
                this.pages.setQuick(i, address);
            }
            Unsafe.getUnsafe().setMemory(address, this.pageSize, (byte)0);
        }
    }

    private long addressOf0(long offset) {
        return this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset);
    }

    protected long allocateNextPage(int page) {
        LOG.info().$("new page [size=").$(this.getMapPageSize()).$(']').$();
        return Unsafe.malloc(this.getMapPageSize());
    }

    protected long cachePageAddress(int index, long address) {
        this.pages.extendAndSet(index, address);
        return address;
    }

    private void clearPages() {
        int n = this.pages.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.release(i, this.pages.getQuick(i));
            }
        }
        this.pages.erase();
    }

    private long computeHotPage(int page) {
        long pageAddress = this.getPageAddress(page);
        assert (pageAddress != 0L);
        this.roOffsetLo = this.pageOffset(page) - 1L;
        this.roOffsetHi = this.roOffsetLo + this.getPageSize(page) + 1L;
        this.absolutePointer = pageAddress - this.roOffsetLo - 1L;
        return pageAddress;
    }

    protected void ensurePagesListCapacity(long size) {
        this.pages.ensureCapacity(this.pageIndex(size) + 1);
    }

    private byte getByte0(long offset) {
        return Unsafe.getUnsafe().getByte(this.computeHotPage(this.pageIndex(offset)) + this.offsetInPage(offset));
    }

    private char getChar0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 1L) {
            return Unsafe.getUnsafe().getChar(this.computeHotPage(page) + pageOffset);
        }
        return this.getCharBytes(page, pageOffset, pageSize);
    }

    char getCharBytes(int page, long pageOffset, long pageSize) {
        char value = '\u0000';
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 2; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            char b = (char)Unsafe.getUnsafe().getByte(pageAddress + pageOffset++);
            value = (char)(b << 8 * i | value);
        }
        return value;
    }

    private double getDouble0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 7L) {
            return Unsafe.getUnsafe().getDouble(this.computeHotPage(page) + pageOffset);
        }
        return this.getDoubleBytes(page, pageOffset, pageSize);
    }

    double getDoubleBytes(int page, long pageOffset, long pageSize) {
        return Double.longBitsToDouble(this.getLongBytes(page, pageOffset, pageSize));
    }

    private float getFloat0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize(page) - pageOffset > 3L) {
            return Unsafe.getUnsafe().getFloat(this.computeHotPage(page) + pageOffset);
        }
        return this.getFloatBytes(page, pageOffset);
    }

    float getFloatBytes(int page, long pageOffset) {
        return Float.intBitsToFloat(this.getIntBytes(page, pageOffset));
    }

    private int getInt0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        if (this.getPageSize(page) - pageOffset > 3L) {
            return Unsafe.getUnsafe().getInt(this.computeHotPage(page) + pageOffset);
        }
        return this.getIntBytes(page, pageOffset);
    }

    int getIntBytes(int page, long pageOffset) {
        int value = 0;
        long pageAddress = this.getPageAddress(page);
        long pageSize = this.getPageSize(page);
        for (int i = 0; i < 4; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            int b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    private long getLong0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 7L) {
            return Unsafe.getUnsafe().getLong(this.computeHotPage(page) + pageOffset);
        }
        return this.getLongBytes(page, pageOffset, pageSize);
    }

    long getLongBytes(int page, long pageOffset, long pageSize) {
        long value = 0L;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 8; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                pageOffset = 0L;
            }
            long b = Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF;
            value = b << 8 * i | value;
        }
        return value;
    }

    protected long getMapPageSize() {
        return this.pageSize;
    }

    protected long getPageAddress(int page) {
        return this.pages.getQuick(page);
    }

    protected long getPageSize(int page) {
        return this.getMapPageSize();
    }

    private short getShort0(long offset) {
        int page = this.pageIndex(offset);
        long pageOffset = this.offsetInPage(offset);
        long pageSize = this.getPageSize(page);
        if (pageSize - pageOffset > 1L) {
            return Unsafe.getUnsafe().getShort(this.computeHotPage(page) + pageOffset);
        }
        return this.getShortBytes(page, pageOffset, pageSize);
    }

    short getShortBytes(int page, long pageOffset, long pageSize) {
        short value = 0;
        long pageAddress = this.getPageAddress(page);
        for (int i = 0; i < 2; ++i) {
            if (pageOffset == pageSize) {
                pageAddress = this.getPageAddress(++page);
                assert (pageAddress != 0L);
                pageOffset = 0L;
            }
            short b = (short)(Unsafe.getUnsafe().getByte(pageAddress + pageOffset++) & 0xFF);
            value = (short)(b << 8 * i | value);
        }
        return value;
    }

    private long hashSlow(long offset, long size) {
        long n = size - (size & 7L);
        long h = 179426491L;
        for (long i = 0L; i < n; i += 8L) {
            h = (h << 5) - h + this.getLong(offset + i);
        }
        while (n < size) {
            h = (h << 5) - h + (long)this.getByte(offset + n);
            ++n;
        }
        return h;
    }

    private void jumpTo0(long offset) {
        int page = this.pageIndex(offset);
        this.pageLo = this.mapWritePage(page);
        this.pageHi = this.pageLo + this.getPageSize(page);
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = this.pageLo + this.offsetInPage(offset);
        --this.pageLo;
    }

    private long mapRandomWritePage(long offset) {
        int page = this.pageIndex(offset);
        long pageAddress = this.mapWritePage(page);
        assert (pageAddress != 0L);
        this.roOffsetLo = this.pageOffset(page) - 1L;
        this.roOffsetHi = this.roOffsetLo + this.getPageSize(page) + 1L;
        this.absolutePointer = pageAddress - this.roOffsetLo - 1L;
        return pageAddress;
    }

    protected long mapWritePage(int page) {
        long address;
        if (page < this.pages.size() && (address = this.pages.getQuick(page)) != 0L) {
            return address;
        }
        return this.cachePageAddress(page, this.allocateNextPage(page));
    }

    long offsetInPage(long offset) {
        return offset & this.mod;
    }

    private void pageAt(long offset) {
        int page = this.pageIndex(offset);
        this.updateLimits(page, this.mapWritePage(page));
    }

    protected final int pageIndex(long offset) {
        return (int)(offset >> this.bits);
    }

    protected final long pageOffset(int page) {
        return (long)page << this.bits;
    }

    private void putBin0(BinarySequence value, long len, long remaining) {
        long pos = 0L;
        do {
            this.putBinSequence(value, pos, remaining);
            pos += remaining;
            this.pageAt(this.baseOffset + this.pageHi);
        } while ((len -= remaining) >= (remaining = this.pageHi - this.appendPointer));
        this.putBinSequence(value, pos, len);
        this.appendPointer += len;
    }

    private void putBinSequence(BinarySequence value, long pos, long len) {
        value.copyTo(this.appendPointer, pos, len);
    }

    private void putBinSlit(long start, long len) {
        while (true) {
            int half;
            if (len <= (long)(half = (int)(this.pageHi - this.appendPointer))) {
                Unsafe.getUnsafe().copyMemory(start, this.appendPointer, len);
                this.appendPointer += len;
                break;
            }
            Unsafe.getUnsafe().copyMemory(start, this.appendPointer, half);
            this.pageAt(this.getAppendOffset() + (long)half);
            len -= (long)half;
            start += (long)half;
        }
    }

    private void putByteRnd(long offset, byte value) {
        Unsafe.getUnsafe().putByte(this.mapRandomWritePage(offset) + this.offsetInPage(offset), value);
    }

    void putCharBytes(char value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
    }

    void putCharBytes(long offset, char value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
    }

    void putDoubleBytes(double value) {
        this.putLongBytes(Double.doubleToLongBits(value));
    }

    void putDoubleBytes(long offset, double value) {
        this.putLongBytes(offset, Double.doubleToLongBits(value));
    }

    void putFloatBytes(float value) {
        this.putIntBytes(Float.floatToIntBits(value));
    }

    void putFloatBytes(long offset, float value) {
        this.putIntBytes(offset, Float.floatToIntBits(value));
    }

    void putIntBytes(int value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
        this.putByte((byte)(value >> 16 & 0xFF));
        this.putByte((byte)(value >> 24 & 0xFF));
    }

    void putIntBytes(long offset, int value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
        this.putByte(offset + 2L, (byte)(value >> 16 & 0xFF));
        this.putByte(offset + 3L, (byte)(value >> 24 & 0xFF));
    }

    private void putLong256Bytes(CharSequence hexString) {
        int len;
        if (hexString == null || (len = hexString.length()) == 0) {
            this.putLong(Long256Impl.NULL_LONG256.getLong0());
            this.putLong(Long256Impl.NULL_LONG256.getLong1());
            this.putLong(Long256Impl.NULL_LONG256.getLong2());
            this.putLong(Long256Impl.NULL_LONG256.getLong3());
        } else {
            long offset = this.getAppendOffset();
            this.putLong(0L);
            this.putLong(0L);
            this.putLong(0L);
            this.putLong(0L);
            for (int i = len / 2 - 1; i > 0; --i) {
                int d1 = Numbers.hexNumbers[hexString.charAt(i * 2)];
                int d2 = Numbers.hexNumbers[hexString.charAt(i * 2 + 1)];
                this.putByte(offset++, (byte)((d1 << 4) + d2));
            }
        }
    }

    private void putLong256Null() {
        Unsafe.getUnsafe().putLong(this.appendPointer, Long256Impl.NULL_LONG256.getLong0());
        Unsafe.getUnsafe().putLong(this.appendPointer + 8L, Long256Impl.NULL_LONG256.getLong1());
        Unsafe.getUnsafe().putLong(this.appendPointer + 16L, Long256Impl.NULL_LONG256.getLong2());
        Unsafe.getUnsafe().putLong(this.appendPointer + 24L, Long256Impl.NULL_LONG256.getLong3());
    }

    void putLongBytes(long value) {
        this.putByte((byte)(value & 0xFFL));
        this.putByte((byte)(value >> 8 & 0xFFL));
        this.putByte((byte)(value >> 16 & 0xFFL));
        this.putByte((byte)(value >> 24 & 0xFFL));
        this.putByte((byte)(value >> 32 & 0xFFL));
        this.putByte((byte)(value >> 40 & 0xFFL));
        this.putByte((byte)(value >> 48 & 0xFFL));
        this.putByte((byte)(value >> 56 & 0xFFL));
    }

    void putLongBytes(long offset, long value) {
        this.putByte(offset, (byte)(value & 0xFFL));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFFL));
        this.putByte(offset + 2L, (byte)(value >> 16 & 0xFFL));
        this.putByte(offset + 3L, (byte)(value >> 24 & 0xFFL));
        this.putByte(offset + 4L, (byte)(value >> 32 & 0xFFL));
        this.putByte(offset + 5L, (byte)(value >> 40 & 0xFFL));
        this.putByte(offset + 6L, (byte)(value >> 48 & 0xFFL));
        this.putByte(offset + 7L, (byte)(value >> 56 & 0xFFL));
    }

    void putShortBytes(short value) {
        this.putByte((byte)(value & 0xFF));
        this.putByte((byte)(value >> 8 & 0xFF));
    }

    void putShortBytes(long offset, short value) {
        this.putByte(offset, (byte)(value & 0xFF));
        this.putByte(offset + 1L, (byte)(value >> 8 & 0xFF));
    }

    private void putSplitChar(char c) {
        Unsafe.getUnsafe().putByte(this.pageHi - 1L, (byte)c);
        this.pageAt(this.baseOffset + this.pageHi);
        Unsafe.getUnsafe().putByte(this.appendPointer++, (byte)(c >> 8));
    }

    private long putStr0(CharSequence value, int pos, int len) {
        long offset = this.getAppendOffset();
        this.putInt(len);
        if (this.pageHi - this.appendPointer < (long)len * 2L) {
            this.putStrSplit(value, pos, len);
        } else {
            VirtualMemory.copyStrChars(value, pos, len, this.appendPointer);
            this.appendPointer += (long)(len * 2);
        }
        return offset;
    }

    private void putStrSplit(long offset, CharSequence value, int pos, int len) {
        int start = pos;
        while (true) {
            int half;
            if (len <= (half = (int)((this.roOffsetHi - offset) / 2L))) break;
            VirtualMemory.copyStrChars(value, start, half, this.absolutePointer + offset);
            if ((offset += (long)(half * 2)) < this.roOffsetHi) {
                char c = value.charAt(start + half);
                this.putByte(offset, (byte)c);
                this.putByte(offset + 1L, (byte)(c >> 8));
                offset += 2L;
                ++half;
            } else {
                this.mapRandomWritePage(offset);
            }
            len -= half;
            start += half;
        }
        VirtualMemory.copyStrChars(value, start, len, this.absolutePointer + offset);
    }

    private void putStrSplit(CharSequence value, int pos, int len) {
        int start = pos;
        while (true) {
            int half;
            if (len <= (half = (int)((this.pageHi - this.appendPointer) / 2L))) {
                VirtualMemory.copyStrChars(value, start, len, this.appendPointer);
                this.appendPointer += (long)(len * 2);
                break;
            }
            VirtualMemory.copyStrChars(value, start, half, this.appendPointer);
            if ((long)(half * 2) < this.pageHi - this.appendPointer) {
                this.putSplitChar(value.charAt(start + half++));
            } else {
                this.pageAt(this.getAppendOffset() + (long)(half * 2));
            }
            len -= half;
            start += half;
        }
    }

    protected void release(int page, long address) {
        if (address != 0L) {
            Unsafe.free(address, this.getPageSize(page));
        }
    }

    protected final void setPageSize(long pageSize) {
        this.clearPages();
        this.pageSize = Numbers.ceilPow2(pageSize);
        this.bits = Numbers.msb(this.pageSize);
        this.mod = this.pageSize - 1L;
        this.clearHotPage();
    }

    private void skip0(long bytes) {
        this.jumpTo(this.getAppendOffset() + bytes);
    }

    protected final void updateLimits(int page, long pageAddress) {
        this.pageLo = pageAddress - 1L;
        this.pageHi = pageAddress + this.getPageSize(page);
        this.baseOffset = this.pageOffset(page + 1) - this.pageHi;
        this.appendPointer = pageAddress;
    }

    private class ByteSequenceView
    implements BinarySequence {
        private long offset;
        private long len = -1L;
        private long lastIndex = -1L;
        private long readAddress;
        private long readLimit;

        private ByteSequenceView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte byteAt(long index) {
            try {
                if (index == this.lastIndex + 1L && this.readAddress < this.readLimit) {
                    byte by = Unsafe.getUnsafe().getByte(this.readAddress++);
                    return by;
                }
                byte by = this.updatePosAndGet(index);
                return by;
            }
            finally {
                this.lastIndex = index;
            }
        }

        @Override
        public void copyTo(long address, long start, long length) {
            long bytesRemaining = Math.min(length, this.len - start);
            long offset = this.offset + start;
            while (bytesRemaining > 0L) {
                int page = VirtualMemory.this.pageIndex(offset);
                long pageSize = VirtualMemory.this.getPageSize(page);
                long pageAddress = VirtualMemory.this.getPageAddress(page);
                long offsetInPage = VirtualMemory.this.offsetInPage(offset);
                long bytesToCopy = Math.min(bytesRemaining, pageSize - offsetInPage);
                Unsafe.getUnsafe().copyMemory(pageAddress + offsetInPage, address, bytesToCopy);
                bytesRemaining -= bytesToCopy;
                offset += bytesToCopy;
                address += bytesToCopy;
            }
        }

        @Override
        public long length() {
            return this.len;
        }

        ByteSequenceView of(long offset, long len) {
            this.offset = offset;
            this.len = len;
            this.lastIndex = -1L;
            this.calculateBlobAddress(offset);
            return this;
        }

        private void calculateBlobAddress(long offset) {
            int page = VirtualMemory.this.pageIndex(offset);
            long pa = VirtualMemory.this.getPageAddress(page);
            this.readAddress = pa + VirtualMemory.this.offsetInPage(offset);
            this.readLimit = pa + VirtualMemory.this.getPageSize(page);
        }

        private byte updatePosAndGet(long index) {
            this.calculateBlobAddress(this.offset + index);
            return Unsafe.getUnsafe().getByte(this.readAddress++);
        }
    }

    public class CharSequenceView
    extends AbstractCharSequence {
        private int len;
        private long offset;

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public char charAt(int index) {
            return VirtualMemory.this.getChar(this.offset + (long)index * 2L);
        }

        CharSequenceView of(long offset, int len) {
            this.offset = offset;
            this.len = len;
            return this;
        }
    }
}

