/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.FastMapValue;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.BinarySequence;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectCharSequence;
import org.jetbrains.annotations.NotNull;

final class FastMapRecord
implements MapRecord {
    private final int split;
    private final int keyDataOffset;
    private final int keyBlockOffset;
    private final int[] valueOffsets;
    private final DirectCharSequence[] csA;
    private final DirectCharSequence[] csB;
    private final DirectBinarySequence[] bs;
    private final Long256Impl[] long256A;
    private final Long256Impl[] long256B;
    private final FastMapValue value;
    private long address0;
    private long address1;
    private long address2;
    private RecordCursor symbolTableResolver;
    private IntList symbolTableIndex;

    FastMapRecord(int[] valueOffsets, int split, int keyDataOffset, int keyBlockOffset, FastMapValue value, ColumnTypes keyTypes) {
        this.valueOffsets = valueOffsets;
        this.split = split;
        this.keyBlockOffset = keyBlockOffset;
        this.keyDataOffset = keyDataOffset;
        this.value = value;
        this.value.linkRecord(this);
        int n = keyTypes.getColumnCount();
        DirectCharSequence[] csA = null;
        DirectCharSequence[] csB = null;
        DirectBinarySequence[] bs = null;
        Long256Impl[] long256A = null;
        Long256Impl[] long256B = null;
        block5: for (int i = 0; i < n; ++i) {
            switch (keyTypes.getColumnType(i)) {
                case 10: {
                    if (csA == null) {
                        csA = new DirectCharSequence[n + split];
                        csB = new DirectCharSequence[n + split];
                    }
                    csA[i + split] = new DirectCharSequence();
                    csB[i + split] = new DirectCharSequence();
                    continue block5;
                }
                case 13: {
                    if (bs == null) {
                        bs = new DirectBinarySequence[n + split];
                    }
                    bs[i + split] = new DirectBinarySequence();
                    continue block5;
                }
                case 12: {
                    if (long256A == null) {
                        long256A = new Long256Impl[n + split];
                        long256B = new Long256Impl[n + split];
                    }
                    long256A[i + split] = new Long256Impl();
                    long256B[i + split] = new Long256Impl();
                    continue block5;
                }
            }
        }
        this.csA = csA;
        this.csB = csB;
        this.bs = bs;
        this.long256A = long256A;
        this.long256B = long256B;
    }

    private FastMapRecord(int[] valueOffsets, int split, int keyDataOffset, int keyBlockOffset, DirectCharSequence[] csA, DirectCharSequence[] csB, DirectBinarySequence[] bs, Long256Impl[] long256A, Long256Impl[] long256B) {
        this.valueOffsets = valueOffsets;
        this.split = split;
        this.keyBlockOffset = keyBlockOffset;
        this.keyDataOffset = keyDataOffset;
        this.value = new FastMapValue(valueOffsets);
        this.csA = csA;
        this.csB = csB;
        this.bs = bs;
        this.long256A = long256A;
        this.long256B = long256B;
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        DirectBinarySequence bs = this.bs[columnIndex];
        bs.of(address + 4L, len);
        return bs;
    }

    @Override
    public long getBinLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public boolean getBool(int columnIndex) {
        return Unsafe.getBool(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) {
        return Unsafe.getUnsafe().getByte(this.addressOfColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        return Unsafe.getUnsafe().getDouble(this.addressOfColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return Unsafe.getUnsafe().getFloat(this.addressOfColumn(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getRowId() {
        return this.address0;
    }

    @Override
    public short getShort(int columnIndex) {
        return Unsafe.getUnsafe().getShort(this.addressOfColumn(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return Unsafe.getUnsafe().getChar(this.addressOfColumn(columnIndex));
    }

    @Override
    public void getLong256(int columnIndex, CharSink sink) {
        long address = this.addressOfColumn(columnIndex);
        long a = Unsafe.getUnsafe().getLong(address);
        long b = Unsafe.getUnsafe().getLong(address + 8L);
        long c = Unsafe.getUnsafe().getLong(address + 16L);
        long d = Unsafe.getUnsafe().getLong(address + 24L);
        Numbers.appendLong256(a, b, c, d, sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        return this.getLong256Generic(this.long256A, columnIndex);
    }

    @NotNull
    private Long256 getLong256Generic(Long256Impl[] array, int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        Long256Impl long256 = array[columnIndex];
        long256.setLong0(Unsafe.getUnsafe().getLong(address));
        long256.setLong1(Unsafe.getUnsafe().getLong(address + 8L));
        long256.setLong2(Unsafe.getUnsafe().getLong(address + 16L));
        long256.setLong3(Unsafe.getUnsafe().getLong(address + 24L));
        return long256;
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        return this.getLong256Generic(this.long256B, columnIndex);
    }

    @Override
    public CharSequence getStr(int columnIndex) {
        assert (columnIndex < this.csA.length);
        return this.getStr0(columnIndex, this.csA[columnIndex]);
    }

    @Override
    public void getStr(int columnIndex, CharSink sink) {
        long address = this.addressOfColumn(columnIndex);
        int len = Unsafe.getUnsafe().getInt(address);
        address += 4L;
        for (int i = 0; i < len; ++i) {
            sink.put(Unsafe.getUnsafe().getChar(address));
            address += 2L;
        }
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        return this.getStr0(columnIndex, this.csB[columnIndex]);
    }

    @Override
    public int getStrLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getSym(int col) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(col)).valueOf(this.getInt(col));
    }

    @Override
    public MapValue getValue() {
        return this.value.of(this.address0, false);
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long addressOfColumn(int index) {
        if (index < this.split) {
            return this.address0 + (long)this.valueOffsets[index];
        }
        if (index == this.split) {
            return this.address1;
        }
        return (long)Unsafe.getUnsafe().getInt(this.address2 + (long)((index - this.split - 1) * 4)) + this.address0;
    }

    protected MapRecord clone() {
        Long256Impl[] long256B;
        Long256Impl[] long256A;
        DirectBinarySequence[] bs;
        int i;
        DirectCharSequence[] csB;
        DirectCharSequence[] csA;
        int n;
        if (this.csA != null) {
            n = this.csA.length;
            csA = new DirectCharSequence[n];
            csB = new DirectCharSequence[n];
            for (i = 0; i < n; ++i) {
                if (this.csA[i] == null) continue;
                csA[i] = new DirectCharSequence();
                csB[i] = new DirectCharSequence();
            }
        } else {
            csA = null;
            csB = null;
        }
        if (this.bs != null) {
            n = this.bs.length;
            bs = new DirectBinarySequence[n];
            for (i = 0; i < n; ++i) {
                if (this.bs[i] == null) continue;
                bs[i] = new DirectBinarySequence();
            }
        } else {
            bs = null;
        }
        if (this.long256A != null) {
            n = this.long256A.length;
            long256A = new Long256Impl[n];
            long256B = new Long256Impl[n];
            for (i = 0; i < n; ++i) {
                if (this.long256A[i] == null) continue;
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        } else {
            long256A = null;
            long256B = null;
        }
        return new FastMapRecord(this.valueOffsets, this.split, this.keyDataOffset, this.keyBlockOffset, csA, csB, bs, long256A, long256B);
    }

    private CharSequence getStr0(int index, DirectCharSequence cs) {
        long address = this.addressOfColumn(index);
        int len = Unsafe.getUnsafe().getInt(address);
        return len == -1 ? null : cs.of(address + 4L, address + 4L + (long)(len * 2));
    }

    void of(long address) {
        this.address0 = address;
        this.address1 = address + (long)this.keyDataOffset;
        this.address2 = address + (long)this.keyBlockOffset;
    }

    private static class DirectBinarySequence
    implements BinarySequence {
        private long address;
        private long len;

        private DirectBinarySequence() {
        }

        @Override
        public byte byteAt(long index) {
            return Unsafe.getUnsafe().getByte(this.address + index);
        }

        @Override
        public long length() {
            return this.len;
        }

        public void of(long address, long len) {
            this.address = address;
            this.len = len;
        }
    }
}

