/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.map.CompactMap;
import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.Map;
import io.questdb.std.Chars;
import org.jetbrains.annotations.NotNull;

public class MapFactory {
    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes, @NotNull ColumnTypes valueTypes) {
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(configuration.getSqlMapPageSize(), keyTypes, valueTypes, configuration.getSqlMapKeyCapacity(), configuration.getSqlFastMapLoadFactor());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(configuration.getSqlMapPageSize(), keyTypes, valueTypes, configuration.getSqlMapKeyCapacity(), configuration.getSqlCompactMapLoadFactor());
        }
        throw CairoException.instance(0).put("unknown map type: ").put(mapType);
    }

    public static Map createMap(CairoConfiguration configuration, @NotNull ColumnTypes keyTypes) {
        CharSequence mapType = configuration.getDefaultMapType();
        if (Chars.equalsLowerCaseAscii(mapType, "fast")) {
            return new FastMap(configuration.getSqlMapPageSize(), keyTypes, configuration.getSqlMapKeyCapacity(), configuration.getSqlFastMapLoadFactor());
        }
        if (Chars.equalsLowerCaseAscii(mapType, "compact")) {
            return new CompactMap(configuration.getSqlMapPageSize(), keyTypes, null, configuration.getSqlMapKeyCapacity(), configuration.getSqlCompactMapLoadFactor());
        }
        throw CairoException.instance(0).put("unknown map type: ").put(mapType);
    }
}

