/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.pool.PoolListener;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.microtime.MicrosecondClock;
import java.io.Closeable;

abstract class AbstractPool
implements Closeable {
    public static final long CLOSED = Unsafe.getFieldOffset(AbstractPool.class, "closed");
    protected static final long UNALLOCATED = -1L;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    protected final FilesFacade ff;
    protected final MicrosecondClock clock;
    private final long inactiveTtlUs;
    private final CairoConfiguration configuration;
    private PoolListener eventListener;
    private volatile int closed = 0;

    public AbstractPool(CairoConfiguration configuration, long inactiveTtlMillis) {
        this.configuration = configuration;
        this.ff = configuration.getFilesFacade();
        this.clock = configuration.getMicrosecondClock();
        this.inactiveTtlUs = inactiveTtlMillis * 1000L;
    }

    @Override
    public final void close() {
        if (Unsafe.getUnsafe().compareAndSwapInt(this, CLOSED, 0, 1)) {
            this.closePool();
        }
    }

    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    public PoolListener getPoolListener() {
        return this.eventListener;
    }

    public void setPoolListener(PoolListener eventListener) {
        this.eventListener = eventListener;
    }

    public boolean releaseAll() {
        return this.releaseAll(Long.MAX_VALUE);
    }

    public boolean releaseInactive() {
        return this.releaseAll(this.clock.getTicks() - this.inactiveTtlUs);
    }

    protected void closePool() {
        this.releaseAll(Long.MAX_VALUE);
        this.notifyListener(Thread.currentThread().getId(), null, (short)24);
    }

    protected boolean isClosed() {
        return this.closed == 1;
    }

    protected void notifyListener(long thread, CharSequence name, short event) {
        PoolListener listener = this.getPoolListener();
        if (listener != null) {
            listener.onEvent((byte)1, thread, name, event, (short)0, (short)0);
        }
    }

    protected abstract boolean releaseAll(long var1);
}

