/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.network.DefaultIODispatcherConfiguration;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Os;
import io.questdb.std.str.Path;
import io.questdb.std.time.MillisecondClock;
import io.questdb.std.time.MillisecondClockImpl;

class DefaultHttpServerConfiguration
implements HttpServerConfiguration {
    protected final MimeTypesCache mimeTypesCache;
    private final IODispatcherConfiguration dispatcherConfiguration = new DefaultIODispatcherConfiguration();
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new StaticContentProcessorConfiguration(){

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getIndexFileName() {
            return "index.html";
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return DefaultHttpServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return ".";
        }

        @Override
        public String getKeepAliveHeader() {
            return null;
        }
    };
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new JsonQueryProcessorConfiguration(){

        @Override
        public MillisecondClock getClock() {
            return DefaultHttpServerConfiguration.this.getClock();
        }

        @Override
        public int getConnectionCheckFrequency() {
            return 1000000;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatScale() {
            return 10;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return "Keep-Alive: timeout=5, max=10000\r\n";
        }
    };

    public DefaultHttpServerConfiguration() {
        String defaultFilePath = this.getClass().getResource("/site/conf/mime.types").getFile();
        if (Os.type == 3) {
            defaultFilePath = defaultFilePath.substring(1);
        }
        try (Path path = new Path().of(defaultFilePath).$();){
            this.mimeTypesCache = new MimeTypesCache(FilesFacadeImpl.INSTANCE, path);
        }
    }

    @Override
    public int getConnectionPoolInitialCapacity() {
        return 16;
    }

    @Override
    public int getConnectionStringPoolCapacity() {
        return 128;
    }

    @Override
    public int getMultipartHeaderBufferSize() {
        return 512;
    }

    @Override
    public long getMultipartIdleSpinCount() {
        return 10000L;
    }

    @Override
    public int getRecvBufferSize() {
        return 0x100000;
    }

    @Override
    public int getRequestHeaderBufferSize() {
        return 1024;
    }

    @Override
    public int getResponseHeaderBufferSize() {
        return 1024;
    }

    @Override
    public int getQueryCacheRows() {
        return 32;
    }

    @Override
    public int getQueryCacheBlocks() {
        return 16;
    }

    @Override
    public MillisecondClock getClock() {
        return MillisecondClockImpl.INSTANCE;
    }

    @Override
    public IODispatcherConfiguration getDispatcherConfiguration() {
        return this.dispatcherConfiguration;
    }

    @Override
    public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
        return this.staticContentProcessorConfiguration;
    }

    @Override
    public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
        return this.jsonQueryProcessorConfiguration;
    }

    @Override
    public int getSendBufferSize() {
        return 0x100000;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean getDumpNetworkTraffic() {
        return false;
    }

    @Override
    public boolean allowDeflateBeforeSend() {
        return false;
    }

    @Override
    public int[] getWorkerAffinity() {
        return new int[]{-1, -1};
    }

    @Override
    public int getWorkerCount() {
        return 2;
    }

    @Override
    public boolean haltOnError() {
        return false;
    }
}

