/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpHeaderParser;
import io.questdb.cutlass.http.HttpMultipartContentListener;
import io.questdb.cutlass.http.HttpMultipartContentParser;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpRequestHeader;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpResponseSink;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.LocalValueMap;
import io.questdb.cutlass.http.Locality;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.IOContext;
import io.questdb.network.IODispatcher;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.network.ServerDisconnectException;
import io.questdb.std.Chars;
import io.questdb.std.Mutable;
import io.questdb.std.ObjectPool;
import io.questdb.std.Unsafe;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.StdoutSink;

public class HttpConnectionContext
implements IOContext,
Locality,
Mutable {
    private static final Log LOG = LogFactory.getLog(HttpConnectionContext.class);
    private final HttpHeaderParser headerParser;
    private final long recvBuffer;
    private final int recvBufferSize;
    private final HttpMultipartContentParser multipartContentParser;
    private final HttpHeaderParser multipartContentHeaderParser;
    private final HttpResponseSink responseSink;
    private final ObjectPool<DirectByteCharSequence> csPool;
    private final long sendBuffer;
    private final HttpServerConfiguration configuration;
    private final LocalValueMap localValueMap = new LocalValueMap();
    private final NetworkFacade nf;
    private final long multipartIdleSpinCount;
    private final CairoSecurityContext cairoSecurityContext = AllowAllCairoSecurityContext.INSTANCE;
    private final boolean dumpNetworkTraffic;
    private final boolean allowDeflateBeforeSend;
    private long fd;
    private HttpRequestProcessor resumeProcessor = null;
    private IODispatcher<HttpConnectionContext> dispatcher;

    public HttpConnectionContext(HttpServerConfiguration configuration) {
        this.configuration = configuration;
        this.nf = configuration.getDispatcherConfiguration().getNetworkFacade();
        this.csPool = new ObjectPool<DirectByteCharSequence>(DirectByteCharSequence.FACTORY, configuration.getConnectionStringPoolCapacity());
        this.headerParser = new HttpHeaderParser(configuration.getRequestHeaderBufferSize(), this.csPool);
        this.multipartContentHeaderParser = new HttpHeaderParser(configuration.getMultipartHeaderBufferSize(), this.csPool);
        this.multipartContentParser = new HttpMultipartContentParser(this.multipartContentHeaderParser);
        this.recvBufferSize = configuration.getRecvBufferSize();
        this.recvBuffer = Unsafe.malloc(this.recvBufferSize);
        this.sendBuffer = Unsafe.malloc(configuration.getSendBufferSize());
        this.responseSink = new HttpResponseSink(configuration);
        this.multipartIdleSpinCount = configuration.getMultipartIdleSpinCount();
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
        this.allowDeflateBeforeSend = configuration.allowDeflateBeforeSend();
    }

    public IODispatcher<HttpConnectionContext> getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void clear() {
        LOG.debug().$("clear").$();
        this.headerParser.clear();
        this.multipartContentParser.clear();
        this.multipartContentHeaderParser.clear();
        this.csPool.clear();
        this.localValueMap.clear();
        this.responseSink.clear();
    }

    @Override
    public void close() {
        this.fd = -1L;
        this.csPool.clear();
        this.multipartContentParser.close();
        this.multipartContentHeaderParser.close();
        this.responseSink.close();
        this.headerParser.close();
        this.localValueMap.close();
        Unsafe.free(this.recvBuffer, this.recvBufferSize);
        Unsafe.free(this.sendBuffer, this.configuration.getSendBufferSize());
        LOG.debug().$("closed").$();
    }

    @Override
    public long getFd() {
        return this.fd;
    }

    @Override
    public boolean invalid() {
        return this.fd == -1L;
    }

    public CairoSecurityContext getCairoSecurityContext() {
        return this.cairoSecurityContext;
    }

    public HttpChunkedResponseSocket getChunkedResponseSocket() {
        return this.responseSink.getChunkedSocket();
    }

    @Override
    public LocalValueMap getMap() {
        return this.localValueMap;
    }

    public HttpRawSocket getRawResponseSocket() {
        return this.responseSink.getRawSocket();
    }

    public HttpRequestHeader getRequestHeader() {
        return this.headerParser;
    }

    public HttpResponseHeader getResponseHeader() {
        return this.responseSink.getHeader();
    }

    public void handleClientOperation(int operation, HttpRequestProcessorSelector selector) {
        switch (operation) {
            case 1: {
                try {
                    this.handleClientRecv(selector);
                }
                catch (PeerDisconnectedException ignore) {
                    LOG.debug().$("peer disconnected").$();
                    this.dispatcher.disconnect(this);
                }
                catch (PeerIsSlowToReadException ignore) {
                    LOG.debug().$("peer is slow writer").$();
                    this.dispatcher.registerChannel(this, 1);
                }
                catch (ServerDisconnectException ignore) {
                    LOG.info().$("kicked out [fd=").$(this.fd).$(']').$();
                    this.dispatcher.disconnect(this);
                }
                break;
            }
            case 4: {
                if (this.resumeProcessor != null) {
                    try {
                        this.responseSink.resumeSend();
                        this.resumeProcessor.resumeSend(this);
                        this.resumeProcessor = null;
                    }
                    catch (PeerIsSlowToReadException ignore) {
                        LOG.debug().$("peer is slow reader").$();
                        this.dispatcher.registerChannel(this, 4);
                    }
                    catch (PeerDisconnectedException ignore) {
                        this.dispatcher.disconnect(this);
                    }
                    catch (ServerDisconnectException ignore) {
                        LOG.info().$("kicked out [fd=").$(this.fd).$(']').$();
                        this.dispatcher.disconnect(this);
                    }
                    break;
                }
                assert (false);
                break;
            }
            default: {
                this.dispatcher.disconnect(this);
            }
        }
    }

    public HttpConnectionContext of(long fd, IODispatcher<HttpConnectionContext> dispatcher) {
        this.fd = fd;
        this.dispatcher = dispatcher;
        this.responseSink.of(fd);
        return this;
    }

    public HttpResponseSink.SimpleResponseImpl simpleResponse() {
        return this.responseSink.getSimple();
    }

    private void completeRequest(HttpRequestProcessor processor) {
        LOG.debug().$("complete [fd=").$(this.fd).$(']').$();
        try {
            processor.onRequestComplete(this);
        }
        catch (PeerDisconnectedException ignore) {
            this.dispatcher.disconnect(this);
        }
        catch (PeerIsSlowToReadException e) {
            this.dispatcher.registerChannel(this, 4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleClientRecv(HttpRequestProcessorSelector selector) throws PeerDisconnectedException, PeerIsSlowToReadException, ServerDisconnectException {
        try {
            int bufRemaining;
            long buf;
            long start;
            HttpMultipartContentListener multipartListener;
            HttpRequestProcessor processor;
            boolean readResume;
            long fd = this.fd;
            long headerEnd = this.recvBuffer;
            int read = 0;
            if (!this.headerParser.isIncomplete()) {
                readResume = true;
            } else {
                readResume = false;
                while (this.headerParser.isIncomplete()) {
                    read = this.nf.recv(fd, this.recvBuffer, this.recvBufferSize);
                    LOG.debug().$("recv [fd=").$(fd).$(", count=").$(read).$(']').$();
                    if (read < 0) {
                        LOG.debug().$("done [fd=").$(fd).$(']').$();
                        this.dispatcher.disconnect(this);
                        return;
                    }
                    if (read == 0) {
                        this.dispatcher.registerChannel(this, 1);
                        return;
                    }
                    this.dumpBuffer(this.recvBuffer, read);
                    headerEnd = this.headerParser.parse(this.recvBuffer, this.recvBuffer + (long)read, true);
                }
            }
            if ((processor = selector.select(this.headerParser.getUrl())) == null) {
                processor = selector.getDefaultProcessor();
            }
            boolean multipartRequest = Chars.equalsNc((CharSequence)"multipart/form-data", this.headerParser.getContentType());
            boolean multipartProcessor = processor instanceof HttpMultipartContentListener;
            if (this.allowDeflateBeforeSend && Chars.contains(this.headerParser.getHeader("Accept-Encoding"), "gzip")) {
                this.responseSink.setDeflateBeforeSend(true);
            }
            if (multipartRequest && !multipartProcessor) {
                this.headerParser.clear();
                LOG.error().$("bad request [multipart/non-multipart]").$();
                this.dispatcher.registerChannel(this, 1);
                return;
            }
            if (!multipartRequest && multipartProcessor) {
                LOG.error().$("bad request [non-multipart/multipart]").$();
                this.dispatcher.registerChannel(this, 1);
                return;
            }
            if (multipartProcessor) {
                if (!readResume) {
                    processor.onHeadersReady(this);
                    this.multipartContentParser.of(this.headerParser.getBoundary());
                }
                processor.resumeRecv(this);
                multipartListener = (HttpMultipartContentListener)((Object)processor);
                long bufferEnd = this.recvBuffer + (long)read;
                LOG.debug().$("multipart").$();
                if (headerEnd < bufferEnd) {
                    start = headerEnd;
                    buf = bufferEnd;
                    bufRemaining = (int)((long)this.recvBufferSize - (bufferEnd - this.recvBuffer));
                } else {
                    buf = start = this.recvBuffer;
                    bufRemaining = this.recvBufferSize;
                }
            } else {
                read = this.nf.recv(fd, this.recvBuffer, 1);
                if (read != 0) {
                    this.dumpBuffer(this.recvBuffer, read);
                    LOG.info().$("disconnect after request [fd=").$(fd).$(']').$();
                    this.dispatcher.disconnect(this);
                    return;
                }
                processor.onHeadersReady(this);
                LOG.debug().$("good [fd=").$(fd).$(']').$();
                try {
                    processor.onRequestComplete(this);
                    this.resumeProcessor = null;
                    return;
                }
                catch (PeerDisconnectedException ignore) {
                    this.dispatcher.disconnect(this);
                    return;
                }
                catch (PeerIsSlowToReadException ignore) {
                    LOG.debug().$("peer is slow reader [two]").$();
                    this.resumeProcessor = processor;
                    this.dispatcher.registerChannel(this, 4);
                    return;
                }
            }
            long spinsRemaining = this.multipartIdleSpinCount;
            while (true) {
                int n;
                if ((n = this.nf.recv(fd, buf, bufRemaining)) < 0) {
                    this.dispatcher.disconnect(this);
                    return;
                }
                if (n == 0) {
                    if (spinsRemaining-- > 0L) continue;
                    if (buf <= start) {
                        LOG.debug().$("peer is slow [multipart]").$();
                        this.dispatcher.registerChannel(this, 1);
                        return;
                    }
                    if (buf - start > 0L && this.multipartContentParser.parse(start, buf, multipartListener)) {
                        this.completeRequest(processor);
                        return;
                    }
                    buf = start = this.recvBuffer;
                    bufRemaining = this.recvBufferSize;
                    continue;
                }
                LOG.debug().$("multipart recv [len=").$(n).$(']').$();
                this.dumpBuffer(buf, n);
                buf += (long)n;
                if ((bufRemaining -= n) != 0) continue;
                if (buf - start > 1L && this.multipartContentParser.parse(start, buf, multipartListener)) {
                    this.completeRequest(processor);
                    return;
                }
                buf = start = this.recvBuffer;
                bufRemaining = this.recvBufferSize;
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
    }

    private void dumpBuffer(long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put('>');
            Net.dump(buffer, size);
        }
    }
}

