/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.std.Chars;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;

public class HttpRangeParser {
    private static final String BYTES = "bytes=";
    private long lo;
    private long hi;

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public boolean of(CharSequence range) {
        if (!Chars.startsWith(range, BYTES)) {
            return false;
        }
        int n = Chars.indexOf(range, BYTES.length(), '-');
        if (n == -1) {
            return false;
        }
        try {
            this.lo = Numbers.parseLong(range, BYTES.length(), n);
            this.hi = n == range.length() - 1 ? Long.MAX_VALUE : Numbers.parseLong(range, n + 1, range.length());
            return true;
        }
        catch (NumericException e) {
            return false;
        }
    }
}

