/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.cutlass.http.HttpChunkedResponseSocket;
import io.questdb.cutlass.http.HttpException;
import io.questdb.cutlass.http.HttpRawSocket;
import io.questdb.cutlass.http.HttpResponseHeader;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.Net;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NoSpaceLeftInResponseBufferException;
import io.questdb.network.PeerDisconnectedException;
import io.questdb.network.PeerIsSlowToReadException;
import io.questdb.std.Chars;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Zip;
import io.questdb.std.ex.ZLibException;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUnboundedByteSink;
import io.questdb.std.str.StdoutSink;
import io.questdb.std.time.DateFormatUtils;
import io.questdb.std.time.MillisecondClock;
import java.io.Closeable;

public class HttpResponseSink
implements Closeable,
Mutable {
    private static final Log LOG = LogFactory.getLog(HttpResponseSink.class);
    private static final int CHUNK_HEAD = 1;
    private static final int CHUNK_DATA = 2;
    private static final int FIN = 3;
    private static final int MULTI_CHUNK = 4;
    private static final int DEFLATE = 5;
    private static final int MULTI_BUF_CHUNK = 6;
    private static final int END_CHUNK = 7;
    private static final int DONE = 8;
    private static final int FLUSH = 9;
    private static final int SEND_DEFLATED_CONT = 10;
    private static final int SEND_DEFLATED_END = 11;
    private static final IntObjHashMap<String> httpStatusMap = new IntObjHashMap();
    private final long out;
    private final long outPtr;
    private final long limit;
    private final long chunkHeaderBuf;
    private final DirectUnboundedByteSink chunkSink;
    private final HttpResponseHeaderImpl headerImpl;
    private final SimpleResponseImpl simple = new SimpleResponseImpl();
    private final ResponseSinkImpl sink = new ResponseSinkImpl();
    private final ChunkedResponseImpl chunkedResponse = new ChunkedResponseImpl();
    private final HttpRawSocketImpl rawSocket = new HttpRawSocketImpl();
    private final NetworkFacade nf;
    private final int responseBufferSize;
    private long fd;
    private long _wPtr;
    private long flushBuf;
    private int flushBufSize;
    private int state;
    private long z_streamp = 0L;
    private boolean deflateBeforeSend = false;
    private long pzout = 0L;
    private int zpos;
    private int zlimit;
    private int crc = 0;
    private long total = 0L;
    private boolean header = true;
    private boolean dumpNetworkTraffic;

    public HttpResponseSink(HttpServerConfiguration configuration) {
        this.responseBufferSize = Numbers.ceilPow2(configuration.getSendBufferSize());
        this.nf = configuration.getDispatcherConfiguration().getNetworkFacade();
        this.out = Unsafe.calloc(this.responseBufferSize);
        this.headerImpl = new HttpResponseHeaderImpl(configuration.getResponseHeaderBufferSize(), configuration.getClock());
        this.chunkHeaderBuf = Unsafe.calloc(8L + 2L * (long)"\r\n".length());
        this.chunkSink = new DirectUnboundedByteSink(this.chunkHeaderBuf);
        this.chunkSink.put("\r\n");
        this.outPtr = this._wPtr = this.out;
        this.limit = this.outPtr + (long)this.responseBufferSize;
        this.dumpNetworkTraffic = configuration.getDumpNetworkTraffic();
    }

    public HttpChunkedResponseSocket getChunkedSocket() {
        return this.chunkedResponse;
    }

    @Override
    public void clear() {
        Unsafe.getUnsafe().setMemory(this.out, this.responseBufferSize, (byte)0);
        this.headerImpl.clear();
        this._wPtr = this.outPtr;
        this.zlimit = 0;
        this.zpos = 0;
        this.header = true;
        this.resetZip();
    }

    @Override
    public void close() {
        Unsafe.free(this.out, this.responseBufferSize);
        Unsafe.free(this.chunkHeaderBuf, 8L + 2L * (long)"\r\n".length());
        this.headerImpl.close();
        if (this.pzout != 0L) {
            Unsafe.free(this.pzout, this.responseBufferSize);
        }
        if (this.z_streamp != 0L) {
            Zip.deflateEnd(this.z_streamp);
            this.z_streamp = 0L;
        }
    }

    public void setDeflateBeforeSend(boolean deflateBeforeSend) {
        this.deflateBeforeSend = deflateBeforeSend;
    }

    public int getCode() {
        return this.headerImpl.getCode();
    }

    public SimpleResponseImpl getSimple() {
        return this.simple;
    }

    public void resumeSend() throws PeerDisconnectedException, PeerIsSlowToReadException {
        block13: while (true) {
            if (this.flushBufSize > 0) {
                this.send();
            }
            switch (this.state) {
                case 4: {
                    if (this.deflateBeforeSend) {
                        this.prepareCompressedBody();
                        this.state = 5;
                        continue block13;
                    }
                    this.prepareBody();
                    this.state = 8;
                    continue block13;
                }
                case 5: {
                    this.state = this.deflate(false);
                    continue block13;
                }
                case 11: {
                    this.flushBuf = this.pzout + (long)this.zpos;
                    this.flushBufSize = this.zlimit - this.zpos;
                    this.state = 7;
                    continue block13;
                }
                case 10: {
                    this.flushBuf = this.pzout + (long)this.zpos;
                    this.flushBufSize = this.zlimit - this.zpos;
                    this.state = 8;
                    continue block13;
                }
                case 6: {
                    this.flushBuf = this.out;
                    this.state = 8;
                    continue block13;
                }
                case 1: {
                    this.prepareChunk((int)(this._wPtr - this.outPtr));
                    this.state = 2;
                    continue block13;
                }
                case 2: {
                    this.prepareBody();
                    this.state = 7;
                    continue block13;
                }
                case 7: {
                    this.prepareChunk(0);
                    this.state = 3;
                    continue block13;
                }
                case 3: {
                    this.sink.put("\r\n");
                    this.prepareBody();
                    this.state = 8;
                    continue block13;
                }
                case 9: {
                    this.state = this.deflate(true);
                    continue block13;
                }
                case 8: {
                    return;
                }
            }
        }
    }

    private int deflate(boolean flush) {
        int ret;
        int availIn;
        int len;
        int sz = this.responseBufferSize - 8;
        long p = this.pzout + 10L;
        do {
            if ((ret = Zip.deflate(this.z_streamp, p, sz, flush)) < 0) {
                throw HttpException.instance("could not deflate [ret=").put(ret);
            }
            len = sz - Zip.availOut(this.z_streamp);
            availIn = Zip.availIn(this.z_streamp);
        } while (len == 0 && availIn > 0);
        if (len == 0) {
            return 8;
        }
        if (len < 0) {
            throw ZLibException.INSTANCE;
        }
        if (this.header) {
            Unsafe.getUnsafe().copyMemory(Zip.gzipHeader, this.pzout, 10L);
            this.header = false;
            this.zpos = 0;
        } else {
            this.zpos = 10;
        }
        if (flush && ret == 1) {
            Unsafe.getUnsafe().putInt(p + (long)len, this.crc);
            Unsafe.getUnsafe().putInt(p + (long)len + 4L, (int)this.total);
            this.zlimit = 10 + len + 8;
        } else {
            this.zlimit = 10 + len;
        }
        this.prepareChunk(this.zlimit - this.zpos);
        return flush && ret == 1 ? 11 : 10;
    }

    private void flushSingle() throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.state = 8;
        this.send();
    }

    HttpResponseHeader getHeader() {
        return this.headerImpl;
    }

    HttpRawSocket getRawSocket() {
        return this.rawSocket;
    }

    void of(long fd) {
        this.fd = fd;
    }

    private void prepareBody() {
        this.flushBuf = this.out;
        this.flushBufSize = (int)(this._wPtr - this.outPtr);
        this._wPtr = this.outPtr;
    }

    private void prepareChunk(int len) {
        this.chunkSink.clear("\r\n".length());
        Numbers.appendHex(this.chunkSink, len);
        this.chunkSink.put("\r\n");
        this.flushBuf = this.chunkHeaderBuf;
        this.flushBufSize = this.chunkSink.length();
    }

    private void prepareCompressedBody() {
        if (this.z_streamp == 0L) {
            this.z_streamp = Zip.deflateInit();
            this.pzout = Unsafe.malloc(this.responseBufferSize);
            this.zlimit = 0;
            this.zpos = 0;
        }
        int r = (int)(this._wPtr - this.outPtr);
        Zip.setInput(this.z_streamp, this.outPtr, r);
        this.crc = Zip.crc32(this.crc, this.outPtr, r);
        this.total += (long)r;
        this._wPtr = this.outPtr;
    }

    private void prepareHeaderSink() {
        this.headerImpl.prepareToSend();
    }

    private void resetZip() {
        if (this.z_streamp != 0L) {
            Zip.deflateReset(this.z_streamp);
        }
        this.crc = 0;
        this.total = 0L;
    }

    private void resumeSend(int nextState) throws PeerDisconnectedException, PeerIsSlowToReadException {
        this.state = nextState;
        this.resumeSend();
    }

    private void send() throws PeerDisconnectedException, PeerIsSlowToReadException {
        int n;
        for (int sent = 0; sent < this.flushBufSize; sent += n) {
            n = this.nf.send(this.fd, this.flushBuf + (long)sent, this.flushBufSize - sent);
            if (n < 0) {
                LOG.info().$("disconnected [errno=").$(this.nf.errno()).$(']').$();
                throw PeerDisconnectedException.INSTANCE;
            }
            if (n == 0) {
                this.flushBuf += (long)sent;
                this.flushBufSize -= sent;
                throw PeerIsSlowToReadException.INSTANCE;
            }
            this.dumpBuffer('<', this.flushBuf + (long)sent, n);
        }
    }

    private void dumpBuffer(char direction, long buffer, int size) {
        if (this.dumpNetworkTraffic && size > 0) {
            StdoutSink.INSTANCE.put(direction);
            Net.dump(buffer, size);
        }
    }

    static {
        httpStatusMap.put(200, "OK");
        httpStatusMap.put(206, "Partial content");
        httpStatusMap.put(304, "Not Modified");
        httpStatusMap.put(400, "Bad request");
        httpStatusMap.put(404, "Not Found");
        httpStatusMap.put(416, "Request range not satisfiable");
        httpStatusMap.put(431, "Headers too large");
        httpStatusMap.put(500, "Internal server error");
    }

    private class ChunkedResponseImpl
    extends ResponseSinkImpl
    implements HttpChunkedResponseSocket {
        private long bookmark;

        private ChunkedResponseImpl() {
            this.bookmark = HttpResponseSink.this.outPtr;
        }

        @Override
        public void bookmark() {
            this.bookmark = HttpResponseSink.this._wPtr;
        }

        @Override
        public void done() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.flushBufSize = 0;
            if (HttpResponseSink.this.deflateBeforeSend) {
                HttpResponseSink.this.resumeSend(9);
            } else {
                HttpResponseSink.this.resumeSend(7);
                LOG.debug().$("end chunk sent").$();
            }
        }

        @Override
        public HttpResponseHeader headers() {
            return HttpResponseSink.this.headerImpl;
        }

        @Override
        public boolean resetToBookmark() {
            HttpResponseSink.this._wPtr = this.bookmark;
            return this.bookmark != HttpResponseSink.this.outPtr;
        }

        @Override
        public void sendChunk() throws PeerDisconnectedException, PeerIsSlowToReadException {
            if (HttpResponseSink.this.outPtr != HttpResponseSink.this._wPtr) {
                if (HttpResponseSink.this.deflateBeforeSend) {
                    HttpResponseSink.this.flushBufSize = 0;
                } else {
                    HttpResponseSink.this.prepareChunk((int)(HttpResponseSink.this._wPtr - HttpResponseSink.this.outPtr));
                }
                HttpResponseSink.this.resumeSend(4);
            }
        }

        @Override
        public void sendHeader() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
        }

        @Override
        public void status(int status, CharSequence contentType) {
            super.status(status, contentType);
            if (HttpResponseSink.this.deflateBeforeSend) {
                HttpResponseSink.this.headerImpl.put("Content-Encoding: gzip").put("\r\n");
            }
        }
    }

    public class HttpRawSocketImpl
    implements HttpRawSocket {
        @Override
        public long getBufferAddress() {
            return HttpResponseSink.this.out;
        }

        @Override
        public int getBufferSize() {
            return HttpResponseSink.this.responseBufferSize;
        }

        @Override
        public void send(int size) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.flushBuf = HttpResponseSink.this.out;
            HttpResponseSink.this.flushBufSize = size;
            HttpResponseSink.this.flushSingle();
        }
    }

    private class ResponseSinkImpl
    extends AbstractCharSink {
        private ResponseSinkImpl() {
        }

        @Override
        public CharSink put(CharSequence seq) {
            int len = seq.length();
            long p = HttpResponseSink.this._wPtr;
            if (p + (long)len >= HttpResponseSink.this.limit) {
                throw NoSpaceLeftInResponseBufferException.INSTANCE;
            }
            Chars.asciiStrCpy(seq, len, p);
            HttpResponseSink.this._wPtr = p + (long)len;
            return this;
        }

        @Override
        public CharSink put(CharSequence cs, int lo, int hi) {
            int len = hi - lo;
            long p = HttpResponseSink.this._wPtr;
            if (p + (long)len >= HttpResponseSink.this.limit) {
                throw NoSpaceLeftInResponseBufferException.INSTANCE;
            }
            Chars.asciiStrCpy(cs, lo, len, p);
            HttpResponseSink.this._wPtr = p + (long)len;
            return this;
        }

        @Override
        public CharSink put(char c) {
            if (HttpResponseSink.this._wPtr < HttpResponseSink.this.limit) {
                Unsafe.getUnsafe().putByte(HttpResponseSink.this._wPtr++, (byte)c);
                return this;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            if (HttpResponseSink.this._wPtr + (long)len < HttpResponseSink.this.limit) {
                Chars.asciiCopyTo(chars, start, len, HttpResponseSink.this._wPtr);
                HttpResponseSink.this._wPtr = HttpResponseSink.this._wPtr + (long)len;
                return this;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        @Override
        public CharSink put(float value, int scale) {
            if (Float.isNaN(value)) {
                this.put("null");
                return this;
            }
            return super.put(value, scale);
        }

        @Override
        public CharSink put(double value) {
            if (Double.isNaN(value) || Double.isInfinite(value)) {
                this.put("null");
                return this;
            }
            return super.put(value);
        }

        @Override
        protected void putUtf8Special(char c) {
            if (c < ' ') {
                this.escapeSpace(c);
            } else {
                switch (c) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        this.put('\\');
                    }
                }
                this.put(c);
            }
        }

        public void status(int status, CharSequence contentType) {
            HttpResponseSink.this.headerImpl.status(status, contentType, -1L);
        }

        private void escapeSpace(char c) {
            switch (c) {
                case '\b': {
                    this.put("\\b");
                    break;
                }
                case '\f': {
                    this.put("\\f");
                    break;
                }
                case '\n': {
                    this.put("\\n");
                    break;
                }
                case '\r': {
                    this.put("\\r");
                    break;
                }
                case '\t': {
                    this.put("\\t");
                    break;
                }
                default: {
                    this.put(c);
                }
            }
        }
    }

    public class SimpleResponseImpl {
        public void sendStatus(int code, CharSequence message) throws PeerDisconnectedException, PeerIsSlowToReadException {
            String std = HttpResponseSink.this.headerImpl.status(code, "text/html; charset=utf-8", -1L);
            HttpResponseSink.this.sink.put(message == null ? std : message).put("\r\n");
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.resumeSend(1);
        }

        public void sendStatus(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headerImpl.status(code, "text/html; charset=utf-8", -2L);
            HttpResponseSink.this.prepareHeaderSink();
            HttpResponseSink.this.flushSingle();
        }

        public void sendStatusWithDefaultMessage(int code) throws PeerDisconnectedException, PeerIsSlowToReadException {
            this.sendStatus(code, null);
        }
    }

    public class HttpResponseHeaderImpl
    extends AbstractCharSink
    implements Closeable,
    Mutable,
    HttpResponseHeader {
        private final long headerPtr;
        private final long limit;
        private final MillisecondClock clock;
        private long _wptr;
        private boolean chunky;
        private int code;

        public HttpResponseHeaderImpl(int bufferSize, MillisecondClock clock) {
            this.clock = clock;
            int sz = Numbers.ceilPow2(bufferSize);
            this.headerPtr = this._wptr = Unsafe.calloc(sz);
            this.limit = this.headerPtr + (long)sz;
        }

        @Override
        public void clear() {
            Unsafe.getUnsafe().setMemory(this.headerPtr, this.limit - this.headerPtr, (byte)0);
            this._wptr = this.headerPtr;
            this.chunky = false;
        }

        @Override
        public void close() {
            Unsafe.free(this.headerPtr, this.limit - this.headerPtr);
        }

        public int getCode() {
            return this.code;
        }

        @Override
        public CharSink put(CharSequence cs) {
            long p = this._wptr;
            int len = cs.length();
            if (p + (long)len < this.limit) {
                Chars.asciiStrCpy(cs, len, p);
                this._wptr += (long)len;
            } else {
                throw NoSpaceLeftInResponseBufferException.INSTANCE;
            }
            return this;
        }

        @Override
        public CharSink put(char c) {
            if (this._wptr < this.limit) {
                Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
                return this;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        @Override
        public CharSink put(char[] chars, int start, int len) {
            if (HttpResponseSink.this._wPtr + (long)len < this.limit) {
                Chars.asciiCopyTo(chars, start, len, HttpResponseSink.this._wPtr);
                HttpResponseSink.this._wPtr = HttpResponseSink.this._wPtr + (long)len;
            }
            throw NoSpaceLeftInResponseBufferException.INSTANCE;
        }

        @Override
        public void send() throws PeerDisconnectedException, PeerIsSlowToReadException {
            HttpResponseSink.this.headerImpl.prepareToSend();
            HttpResponseSink.this.flushSingle();
        }

        @Override
        public String status(int code, CharSequence contentType, long contentLength) {
            this.code = code;
            String status = (String)httpStatusMap.get(code);
            if (status == null) {
                throw new IllegalArgumentException("Illegal status code: " + code);
            }
            this.put("HTTP/1.1 ").put(code).put(' ').put(status).put("\r\n");
            this.put("Server: ").put("questDB/1.0").put("\r\n");
            this.put("Date: ");
            DateFormatUtils.formatHTTP(this, this.clock.getTicks());
            this.put("\r\n");
            if (contentLength > -2L) {
                this.chunky = contentLength == -1L;
                if (this.chunky) {
                    this.put("Transfer-Encoding: ").put("chunked").put("\r\n");
                } else {
                    this.put("Content-Length: ").put(contentLength).put("\r\n");
                }
            }
            if (contentType != null) {
                this.put("Content-Type: ").put(contentType).put("\r\n");
            }
            return status;
        }

        private void prepareToSend() {
            if (!this.chunky) {
                this.put("\r\n");
            }
            HttpResponseSink.this.flushBuf = this.headerPtr;
            HttpResponseSink.this.flushBufSize = (int)(this._wptr - this.headerPtr);
        }
    }
}

