/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http;

import io.questdb.MessageBus;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnIndexerJob;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.HttpRequestProcessor;
import io.questdb.cutlass.http.HttpRequestProcessorFactory;
import io.questdb.cutlass.http.HttpRequestProcessorSelector;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessor;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.cutlass.http.processors.StaticContentProcessor;
import io.questdb.cutlass.http.processors.TableStatusCheckProcessor;
import io.questdb.cutlass.http.processors.TextImportProcessor;
import io.questdb.cutlass.http.processors.TextQueryProcessor;
import io.questdb.griffin.engine.groupby.vect.GroupByNotKeyedJob;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.WorkerPool;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcher;
import io.questdb.network.IODispatchers;
import io.questdb.network.IORequestProcessor;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.WeakObjectPool;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class HttpServer
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HttpServer.class);
    private static final WorkerPoolAwareConfiguration.ServerFactory<HttpServer, HttpServerConfiguration> CREATE0 = HttpServer::create0;
    private final ObjList<HttpRequestProcessorSelectorImpl> selectors;
    private final IODispatcher<HttpConnectionContext> dispatcher;
    private final int workerCount;
    private final HttpContextFactory httpContextFactory;
    private final WorkerPool workerPool;

    public HttpServer(HttpServerConfiguration configuration, WorkerPool pool, boolean localPool) {
        int i;
        this.workerCount = pool.getWorkerCount();
        this.selectors = new ObjList(this.workerCount);
        QueryCache.configure(configuration);
        this.workerPool = localPool ? pool : null;
        for (i = 0; i < this.workerCount; ++i) {
            this.selectors.add(new HttpRequestProcessorSelectorImpl());
        }
        this.httpContextFactory = new HttpContextFactory(configuration);
        this.dispatcher = IODispatchers.create(configuration.getDispatcherConfiguration(), this.httpContextFactory);
        pool.assign(this.dispatcher);
        int n = pool.getWorkerCount();
        for (i = 0; i < n; ++i) {
            final int index = i;
            pool.assign(i, new Job(){
                private final HttpRequestProcessorSelector selector;
                private final IORequestProcessor<HttpConnectionContext> processor;
                {
                    this.selector = (HttpRequestProcessorSelector)HttpServer.this.selectors.getQuick(index);
                    this.processor = (operation, context) -> context.handleClientOperation(operation, this.selector);
                }

                @Override
                public boolean run() {
                    return HttpServer.this.dispatcher.processIOQueue(this.processor);
                }
            });
            pool.assign(i, () -> {
                Misc.free(this.selectors.getQuick(index));
                this.httpContextFactory.closeContextPool();
                Misc.free(QueryCache.getInstance());
            });
        }
    }

    @Nullable
    public static HttpServer create(HttpServerConfiguration configuration, WorkerPool sharedWorkerPool, Log workerPoolLog, CairoEngine cairoEngine, MessageBus messageBus) {
        return WorkerPoolAwareConfiguration.create(configuration, sharedWorkerPool, workerPoolLog, cairoEngine, CREATE0, messageBus);
    }

    public void bind(HttpRequestProcessorFactory factory) {
        String url = factory.getUrl();
        assert (url != null);
        for (int i = 0; i < this.workerCount; ++i) {
            HttpRequestProcessorSelectorImpl selector = this.selectors.getQuick(i);
            if ("*".equals(url)) {
                selector.defaultRequestProcessor = factory.newInstance();
                continue;
            }
            selector.processorMap.put(url, factory.newInstance());
        }
    }

    @Override
    public void close() {
        if (this.workerPool != null) {
            this.workerPool.halt();
        }
        Misc.free(this.httpContextFactory);
        Misc.free(this.dispatcher);
    }

    private static HttpServer create0(final HttpServerConfiguration configuration, final CairoEngine cairoEngine, WorkerPool workerPool, boolean localPool, final MessageBus messageBus) {
        HttpServer s = new HttpServer(configuration, workerPool, localPool);
        QueryCache.configure(configuration);
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new JsonQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, messageBus);
            }

            @Override
            public String getUrl() {
                return "/exec";
            }
        });
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextImportProcessor(cairoEngine);
            }

            @Override
            public String getUrl() {
                return "/imp";
            }
        });
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TextQueryProcessor(configuration.getJsonQueryProcessorConfiguration(), cairoEngine, messageBus);
            }

            @Override
            public String getUrl() {
                return "/exp";
            }
        });
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new TableStatusCheckProcessor(cairoEngine, configuration.getJsonQueryProcessorConfiguration());
            }

            @Override
            public String getUrl() {
                return "/chk";
            }
        });
        s.bind(new HttpRequestProcessorFactory(){

            @Override
            public HttpRequestProcessor newInstance() {
                return new StaticContentProcessor(configuration.getStaticContentProcessorConfiguration());
            }

            @Override
            public String getUrl() {
                return "*";
            }
        });
        workerPool.assign(new ColumnIndexerJob(messageBus));
        workerPool.assign(new GroupByNotKeyedJob(messageBus));
        return s;
    }

    private static class HttpContextFactory
    implements IOContextFactory<HttpConnectionContext>,
    Closeable,
    EagerThreadSetup {
        private final ThreadLocal<WeakObjectPool<HttpConnectionContext>> contextPool = new ThreadLocal<WeakObjectPool>(() -> new WeakObjectPool<HttpConnectionContext>(() -> new HttpConnectionContext(configuration), configuration.getConnectionPoolInitialCapacity()));
        private boolean closed = false;

        public HttpContextFactory(HttpServerConfiguration configuration) {
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public HttpConnectionContext newInstance(long fd, IODispatcher<HttpConnectionContext> dispatcher) {
            return ((HttpConnectionContext)((WeakObjectPool)this.contextPool.get()).pop()).of(fd, dispatcher);
        }

        @Override
        public void done(HttpConnectionContext context) {
            if (this.closed) {
                Misc.free(context);
            } else {
                context.of(-1L, null);
                ((WeakObjectPool)this.contextPool.get()).push(context);
                LOG.info().$("pushed").$();
            }
        }

        @Override
        public void setup() {
            this.contextPool.get();
        }

        private void closeContextPool() {
            Misc.free(this.contextPool.get());
            LOG.info().$("closed").$();
        }
    }

    private static class HttpRequestProcessorSelectorImpl
    implements HttpRequestProcessorSelector {
        private final CharSequenceObjHashMap<HttpRequestProcessor> processorMap = new CharSequenceObjHashMap();
        private HttpRequestProcessor defaultRequestProcessor = null;

        private HttpRequestProcessorSelectorImpl() {
        }

        @Override
        public HttpRequestProcessor select(CharSequence url) {
            return this.processorMap.get(url);
        }

        @Override
        public HttpRequestProcessor getDefaultProcessor() {
            return this.defaultRequestProcessor;
        }

        @Override
        public void close() {
            Misc.free(this.defaultRequestProcessor);
            ObjList<CharSequence> processorKeys = this.processorMap.keys();
            int n = processorKeys.size();
            for (int i = 0; i < n; ++i) {
                Misc.free(this.processorMap.get(processorKeys.getQuick(i)));
            }
        }
    }
}

