/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.AssociativeCache;
import io.questdb.std.ThreadLocal;
import java.io.Closeable;

public final class QueryCache
implements Closeable {
    private static final Log LOG = LogFactory.getLog(QueryCache.class);
    private static ThreadLocal<QueryCache> TL_QUERY_CACHE;
    private final AssociativeCache<RecordCursorFactory> cache;

    public QueryCache(int blocks, int rows) {
        this.cache = new AssociativeCache(blocks, rows);
    }

    public static void configure(HttpServerConfiguration configuration) {
        TL_QUERY_CACHE = new ThreadLocal<QueryCache>(() -> new QueryCache(configuration.getQueryCacheBlocks(), configuration.getQueryCacheRows()));
    }

    public static QueryCache getInstance() {
        return (QueryCache)TL_QUERY_CACHE.get();
    }

    @Override
    public void close() {
        this.cache.close();
        LOG.info().$("closed").$();
    }

    public RecordCursorFactory poll(CharSequence sql) {
        RecordCursorFactory factory = this.cache.poll(sql);
        this.log(factory == null ? "miss" : "hit", sql);
        return factory;
    }

    public void push(CharSequence sql, RecordCursorFactory factory) {
        if (factory != null) {
            this.cache.put(sql, factory);
            this.log("push", sql);
        }
    }

    public void remove(CharSequence sql) {
        this.cache.put(sql, null);
        this.log("remove", sql);
    }

    private void log(CharSequence action, CharSequence sql) {
        LOG.info().$(action).$(" [thread=").$(Thread.currentThread().getName()).$(", sql=").$(sql).$(']').$();
    }
}

